/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CleanPycAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiElement[] elements;
        if (e == null) {
            CleanPycAction.$$$reportNull$$$0(0);
        }
        if ((elements = (PsiElement[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY)) == null) {
            return;
        }
        ArrayList pycFiles = new ArrayList();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            for (PsiElement element : elements) {
                PsiDirectory dir = (PsiDirectory)element;
                CleanPycAction.collectPycFiles(new File(dir.getVirtualFile().getPath()), pycFiles);
            }
            FileUtil.asyncDelete((Collection)pycFiles);
        }, PyBundle.message("action.CleanPyc.progress.title.cleaning.up.pyc.files", new Object[0]), false, e.getProject());
        StatusBar statusBar = WindowManager.getInstance().getIdeFrame(e.getProject()).getStatusBar();
        statusBar.setInfo(PyBundle.message("action.CleanPyc.status.bar.text.deleted.bytecode.files", pycFiles.size()));
    }

    private static void collectPycFiles(File directory, List<File> pycFiles) {
        FileUtil.processFilesRecursively((File)directory, file -> {
            if (file.getParentFile().getName().equals("__pycache__") || FileUtilRt.extensionEquals((String)file.getName(), (String)"pyc") || FileUtilRt.extensionEquals((String)file.getName(), (String)"pyo") || file.getName().endsWith("$py.class")) {
                pycFiles.add((File)file);
            }
            return true;
        });
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CleanPycAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CleanPycAction.$$$reportNull$$$0(2);
        }
        PsiElement[] elements = (PsiElement[])e.getData(PlatformCoreDataKeys.PSI_ELEMENT_ARRAY);
        if (e.isFromContextMenu()) {
            e.getPresentation().setEnabledAndVisible(CleanPycAction.isAllDirectories(elements));
        } else {
            e.getPresentation().setEnabled(CleanPycAction.isAllDirectories(elements));
        }
    }

    private static boolean isAllDirectories(PsiElement @Nullable [] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        for (PsiElement element : elements) {
            if (element instanceof PsiDirectory && !FileIndexFacade.getInstance((Project)element.getProject()).isInLibraryClasses(((PsiDirectory)element).getVirtualFile())) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/actions/CleanPycAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/actions/CleanPycAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

