/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.codeInsight.imports.PyRelativeImportData;
import com.jetbrains.python.codeInsight.intentions.PyConvertImportIntentionAction;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J!\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0094\u0002\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/codeInsight/intentions/PyAbsoluteToRelativeImportIntention;", "Lcom/jetbrains/python/codeInsight/intentions/PyConvertImportIntentionAction;", "<init>", "()V", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.python.psi.impl"})
public final class PyAbsoluteToRelativeImportIntention
extends PyConvertImportIntentionAction {
    public PyAbsoluteToRelativeImportIntention() {
        super("INTN.convert.absolute.to.relative");
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(context.file() instanceof PyFile)) {
            return null;
        }
        PyFromImportStatement pyFromImportStatement = this.findStatement(element);
        if (pyFromImportStatement == null) {
            return null;
        }
        PyFromImportStatement statement = pyFromImportStatement;
        if (statement.getRelativeLevel() != 0) {
            return null;
        }
        QualifiedName qualifiedName = statement.getImportSourceQName();
        if (qualifiedName == null) {
            return null;
        }
        QualifiedName targetPath = qualifiedName;
        QualifiedName qualifiedName2 = QualifiedNameFinder.findCanonicalImportPath((PsiElement)context.file(), null);
        if (qualifiedName2 == null) {
            return null;
        }
        QualifiedName filePath = qualifiedName2;
        return Intrinsics.areEqual((Object)targetPath.getFirstComponent(), (Object)filePath.getFirstComponent()) ? super.getPresentation(context, element) : null;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        PyFromImportStatement pyFromImportStatement = this.findStatement(element);
        if (pyFromImportStatement == null) {
            return;
        }
        PyFromImportStatement statement = pyFromImportStatement;
        QualifiedName qualifiedName = statement.getImportSourceQName();
        if (qualifiedName == null) {
            return;
        }
        QualifiedName targetPath = qualifiedName;
        String string = targetPath.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        PsiFile psiFile = context.file();
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PyFile");
        PyRelativeImportData pyRelativeImportData = PyRelativeImportData.Companion.fromString(string, (PyFile)psiFile);
        if (pyRelativeImportData == null) {
            return;
        }
        PyRelativeImportData importData = pyRelativeImportData;
        PsiFile psiFile2 = context.file();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"file(...)");
        this.replaceImportStatement(statement, psiFile2, importData.getLocationWithDots());
    }
}

