/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.google.common.collect.ImmutableMap;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.sdk.PythonSdkUtilKtKt;
import com.jetbrains.python.sdk.WinAppxToolsKt;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PyFlavorData;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.WinRegistryService;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WinPythonSdkFlavor
extends CPythonSdkFlavor<PyFlavorData.Empty> {
    @NotNull
    private static final String[] REG_ROOTS = new String[]{"HKEY_LOCAL_MACHINE", "HKEY_CURRENT_USER"};
    private static final Regex PYTHON_EXE = new Regex("^python[0-9.]*?.exe$");
    private static final String APPX_PRODUCT = "Python";
    private static final Map<String, String> REGISTRY_MAP = ImmutableMap.of((Object)"Python", (Object)"python.exe", (Object)"IronPython", (Object)"ipy.exe");
    @NotNull
    private final SynchronizedClearableLazy<Set<String>> myRegistryCache = new SynchronizedClearableLazy(() -> WinPythonSdkFlavor.findInRegistry(this.getWinRegistryService()));
    @NotNull
    private final SynchronizedClearableLazy<Set<String>> myAppxCache = new SynchronizedClearableLazy(WinPythonSdkFlavor::getPythonsFromStore);

    public static WinPythonSdkFlavor getInstance() {
        return (WinPythonSdkFlavor)PythonSdkFlavor.EP_NAME.findExtension(WinPythonSdkFlavor.class);
    }

    @Override
    public boolean isApplicable() {
        return SystemInfo.isWindows;
    }

    @Override
    @NotNull
    public Class<PyFlavorData.Empty> getFlavorDataClass() {
        return PyFlavorData.Empty.class;
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull Path> suggestLocalHomePaths(@Nullable Module module, @Nullable UserDataHolder context) {
        TreeSet<String> candidates = new TreeSet<String>();
        this.findInCandidatePaths(candidates, "python.exe", "jython.bat", "pypy.exe");
        WinPythonSdkFlavor.findInstallations(candidates, "python.exe", PythonHelpersLocator.getCommunityHelpersRoot().getParent().toString());
        List list = ContainerUtil.map(candidates, x$0 -> Path.of(x$0, new String[0]));
        if (list == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(0);
        }
        return list;
    }

    private void findInCandidatePaths(Set<String> candidates, String ... exe_names) {
        for (String name2 : exe_names) {
            WinPythonSdkFlavor.findInstallations(candidates, name2, "C:\\", "C:\\Program Files\\");
            WinPythonSdkFlavor.findInPath(candidates, name2);
        }
        this.findInRegistry(candidates);
        candidates.addAll((Collection)this.myAppxCache.getValue());
    }

    @Override
    public final void resetHomePathCache() {
        this.myRegistryCache.drop();
    }

    @Override
    public boolean sdkSeemsValid(@NotNull Sdk sdk2,  @NotNull PyFlavorData.Empty flavorData, @Nullable TargetEnvironmentConfiguration targetConfig) {
        if (sdk2 == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(1);
        }
        if (flavorData == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(2);
        }
        if (super.sdkSeemsValid(sdk2, flavorData, targetConfig) || targetConfig != null) {
            return true;
        }
        Path path2 = PythonSdkUtilKtKt.tryResolvePath(sdk2.getHomePath());
        return path2 != null && this.isLocalPathValidPython(path2);
    }

    @Override
    public boolean isValidSdkPath(@NotNull String pathStr2) {
        if (pathStr2 == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(3);
        }
        if (super.isValidSdkPath(pathStr2)) {
            return true;
        }
        Path path2 = PythonSdkUtilKtKt.tryResolvePath(pathStr2);
        return path2 != null && this.isLocalPathValidPython(path2);
    }

    private boolean isLocalPathValidPython(@NotNull Path path2) {
        if (path2 == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(4);
        }
        String pathStr2 = path2.toString();
        if (((Set)this.myAppxCache.getValue()).contains(pathStr2)) {
            return true;
        }
        String product = WinAppxToolsKt.getAppxProduct(path2);
        return product != null && product.contains(APPX_PRODUCT) && this.isValidSdkPath(pathStr2);
    }

    @Override
    public void dropCaches() {
        this.myRegistryCache.drop();
        this.myAppxCache.drop();
    }

    void findInRegistry(@NotNull Collection<String> candidates) {
        if (candidates == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(5);
        }
        candidates.addAll((Collection)this.myRegistryCache.getValue());
    }

    @NotNull
    protected WinRegistryService getWinRegistryService() {
        WinRegistryService winRegistryService = (WinRegistryService)ApplicationManager.getApplication().getService(WinRegistryService.class);
        if (winRegistryService == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(6);
        }
        return winRegistryService;
    }

    private static void findInstallations(Set<String> candidates, String exe_name, String ... roots) {
        for (String root : roots) {
            WinPythonSdkFlavor.findSubdirInstallations(candidates, root, FileUtilRt.getNameWithoutExtension((String)exe_name), exe_name);
        }
    }

    public static void findInPath(Collection<? super String> candidates, String exeName) {
        String path2 = System.getenv("PATH");
        if (path2 == null) {
            return;
        }
        for (String pathEntry : StringUtil.split((String)path2, (String)";")) {
            File f;
            if (pathEntry.startsWith("\"") && pathEntry.endsWith("\"")) {
                if (pathEntry.length() < 2) continue;
                pathEntry = pathEntry.substring(1, pathEntry.length() - 1);
            }
            if (!(f = new File(pathEntry, exeName)).exists()) continue;
            candidates.add(FileUtil.toSystemDependentName((String)f.getPath()));
        }
    }

    @NotNull
    private static Set<String> getPythonsFromStore() {
        Set set = ContainerUtil.map2Set(WinAppxToolsKt.getAppxFiles(APPX_PRODUCT, PYTHON_EXE), file -> file.toAbsolutePath().toString());
        if (set == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    private static Set<String> findInRegistry(@NotNull WinRegistryService registryService) {
        if (registryService == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(8);
        }
        HashSet<String> result2 = new HashSet<String>();
        for (String regRoot : REG_ROOTS) {
            for (Map.Entry<String, String> entry : REGISTRY_MAP.entrySet()) {
                String productId = entry.getKey();
                String exePath = entry.getValue();
                String companiesPath = String.format("%s\\SOFTWARE\\%s", regRoot, productId);
                String companiesPathWow = String.format("%s\\SOFTWARE\\Wow6432Node\\%s", regRoot, productId);
                for (String path2 : new String[]{companiesPath, companiesPathWow}) {
                    List<String> companies = registryService.listBranches(path2);
                    for (String company : companies) {
                        String pathToCompany = path2 + "\\" + company;
                        List<String> versions2 = registryService.listBranches(pathToCompany);
                        for (String version2 : versions2) {
                            File interpreter;
                            String folder = registryService.getDefaultKey(pathToCompany + "\\" + version2 + "\\InstallPath");
                            if (folder == null || !(interpreter = new File(folder, exePath)).exists()) continue;
                            result2.add(FileUtil.toSystemDependentName((String)interpreter.getPath()));
                        }
                    }
                }
            }
        }
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    private static void findSubdirInstallations(Collection<String> candidates, String rootDir, String dir_prefix, String exe_name) {
        VirtualFile rootVDir = LocalFileSystem.getInstance().findFileByPath(rootDir);
        if (rootVDir != null) {
            if (rootVDir instanceof NewVirtualFile) {
                ((NewVirtualFile)rootVDir).markDirty();
            }
            rootVDir.refresh(true, false);
            for (VirtualFile dir : rootVDir.getChildren()) {
                VirtualFile python_exe;
                if (!dir.isDirectory() || !StringUtil.toLowerCase((String)dir.getName()).startsWith(dir_prefix) || (python_exe = dir.findChild(exe_name)) == null) continue;
                candidates.add(FileUtil.toSystemDependentName((String)python_exe.getPath()));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/flavors/WinPythonSdkFlavor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavorData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathStr";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registryService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestLocalHomePaths";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/flavors/WinPythonSdkFlavor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWinRegistryService";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonsFromStore";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findInRegistry";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "sdkSeemsValid";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isLocalPathValidPython";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findInRegistry";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 8 -> new IllegalArgumentException(string);
        };
    }
}

