/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.comms.common.netty.channels;

import com.intellij.station.comms.common.netty.channels.NioDomainSocketChannel;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.SocketChannelConfig;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.SocketChannel;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\rH\u0017J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\rH\u0016J\u0012\u0010\u0012\u001a\u00020\u00022\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\u00022\b\u0010\u0013\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\nH\u0016J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\nH\u0016J\u0012\u0010\u001b\u001a\u00020\u00022\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0012\u0010\u001e\u001a\u00020\u00022\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\b\u0010!\u001a\u00020\nH\u0016J\u0010\u0010\"\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010#\u001a\u00020\nH\u0016J\u0010\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\nH\u0016J\b\u0010&\u001a\u00020\rH\u0016J\u0010\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\rH\u0016J\b\u0010)\u001a\u00020\rH\u0016J\u0010\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\rH\u0016J\b\u0010,\u001a\u00020\rH\u0016J\u0010\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020\rH\u0016J\b\u0010/\u001a\u00020\nH\u0016J\u0010\u00100\u001a\u00020\u00022\u0006\u00101\u001a\u00020\nH\u0016J\b\u00102\u001a\u00020\rH\u0016J\u0010\u00103\u001a\u00020\u00022\u0006\u00104\u001a\u00020\rH\u0016J\b\u00105\u001a\u00020\nH\u0016J\u0010\u00106\u001a\u00020\u00022\u0006\u00107\u001a\u00020\nH\u0016J \u00108\u001a\u00020\u00022\u0006\u00109\u001a\u00020\r2\u0006\u0010:\u001a\u00020\r2\u0006\u0010;\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/intellij/station/comms/common/netty/channels/NioDomainSocketChannelConfig;", "Lio/netty/channel/DefaultChannelConfig;", "Lio/netty/channel/socket/SocketChannelConfig;", "ch", "Lcom/intellij/station/comms/common/netty/channels/NioDomainSocketChannel;", "socketChannel", "Ljava/nio/channels/SocketChannel;", "<init>", "(Lcom/intellij/station/comms/common/netty/channels/NioDomainSocketChannel;Ljava/nio/channels/SocketChannel;)V", "allowHalfClosure", "", "setConnectTimeoutMillis", "connectTimeoutMillis", "", "setMaxMessagesPerRead", "maxMessagesPerRead", "setWriteSpinCount", "writeSpinCount", "setAllocator", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "setRecvByteBufAllocator", "Lio/netty/channel/RecvByteBufAllocator;", "setAutoRead", "autoRead", "setAutoClose", "autoClose", "setMessageSizeEstimator", "estimator", "Lio/netty/channel/MessageSizeEstimator;", "setWriteBufferWaterMark", "writeBufferWaterMark", "Lio/netty/channel/WriteBufferWaterMark;", "isAllowHalfClosure", "setAllowHalfClosure", "isTcpNoDelay", "setTcpNoDelay", "tcpNoDelay", "getSoLinger", "setSoLinger", "soLinger", "getSendBufferSize", "setSendBufferSize", "sendBufferSize", "getReceiveBufferSize", "setReceiveBufferSize", "receiveBufferSize", "isKeepAlive", "setKeepAlive", "keepAlive", "getTrafficClass", "setTrafficClass", "trafficClass", "isReuseAddress", "setReuseAddress", "reuseAddress", "setPerformancePreferences", "connectionTime", "latency", "bandwidth", "intellij.station.comms.common"})
public final class NioDomainSocketChannelConfig
extends DefaultChannelConfig
implements SocketChannelConfig {
    @NotNull
    private final SocketChannel socketChannel;
    private boolean allowHalfClosure;

    public NioDomainSocketChannelConfig(@NotNull NioDomainSocketChannel ch, @NotNull SocketChannel socketChannel) {
        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
        Intrinsics.checkNotNullParameter((Object)socketChannel, (String)"socketChannel");
        super((Channel)ch);
        this.socketChannel = socketChannel;
    }

    @NotNull
    public SocketChannelConfig setConnectTimeoutMillis(int connectTimeoutMillis) {
        super.setConnectTimeoutMillis(connectTimeoutMillis);
        return this;
    }

    @Deprecated(message="Deprecated in Java")
    @NotNull
    public SocketChannelConfig setMaxMessagesPerRead(int maxMessagesPerRead) {
        super.setMaxMessagesPerRead(maxMessagesPerRead);
        return this;
    }

    @NotNull
    public SocketChannelConfig setWriteSpinCount(int writeSpinCount) {
        super.setWriteSpinCount(writeSpinCount);
        return this;
    }

    @NotNull
    public SocketChannelConfig setAllocator(@Nullable ByteBufAllocator allocator) {
        super.setAllocator(allocator);
        return this;
    }

    @NotNull
    public SocketChannelConfig setRecvByteBufAllocator(@Nullable RecvByteBufAllocator allocator) {
        super.setRecvByteBufAllocator(allocator);
        return this;
    }

    @NotNull
    public SocketChannelConfig setAutoRead(boolean autoRead) {
        super.setAutoRead(autoRead);
        return this;
    }

    @NotNull
    public SocketChannelConfig setAutoClose(boolean autoClose) {
        super.setAutoClose(autoClose);
        return this;
    }

    @NotNull
    public SocketChannelConfig setMessageSizeEstimator(@Nullable MessageSizeEstimator estimator) {
        super.setMessageSizeEstimator(estimator);
        return this;
    }

    @NotNull
    public SocketChannelConfig setWriteBufferWaterMark(@Nullable WriteBufferWaterMark writeBufferWaterMark) {
        super.setWriteBufferWaterMark(writeBufferWaterMark);
        return this;
    }

    public boolean isAllowHalfClosure() {
        return this.allowHalfClosure;
    }

    @NotNull
    public SocketChannelConfig setAllowHalfClosure(boolean allowHalfClosure) {
        this.allowHalfClosure = allowHalfClosure;
        return this;
    }

    public boolean isTcpNoDelay() {
        Boolean bl = this.socketChannel.getOption(StandardSocketOptions.TCP_NODELAY);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getOption(...)");
        return bl;
    }

    @NotNull
    public SocketChannelConfig setTcpNoDelay(boolean tcpNoDelay) {
        this.socketChannel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)tcpNoDelay);
        return this;
    }

    public int getSoLinger() {
        Integer n = this.socketChannel.getOption(StandardSocketOptions.SO_LINGER);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getOption(...)");
        return ((Number)n).intValue();
    }

    @NotNull
    public SocketChannelConfig setSoLinger(int soLinger) {
        this.socketChannel.setOption((SocketOption)StandardSocketOptions.SO_LINGER, (Object)soLinger);
        return this;
    }

    public int getSendBufferSize() {
        Integer n = this.socketChannel.getOption(StandardSocketOptions.SO_SNDBUF);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getOption(...)");
        return ((Number)n).intValue();
    }

    @NotNull
    public SocketChannelConfig setSendBufferSize(int sendBufferSize) {
        this.socketChannel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)sendBufferSize);
        return this;
    }

    public int getReceiveBufferSize() {
        Integer n = this.socketChannel.getOption(StandardSocketOptions.SO_RCVBUF);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getOption(...)");
        return ((Number)n).intValue();
    }

    @NotNull
    public SocketChannelConfig setReceiveBufferSize(int receiveBufferSize) {
        this.socketChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)receiveBufferSize);
        return this;
    }

    public boolean isKeepAlive() {
        Boolean bl = this.socketChannel.getOption(StandardSocketOptions.SO_KEEPALIVE);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getOption(...)");
        return bl;
    }

    @NotNull
    public SocketChannelConfig setKeepAlive(boolean keepAlive) {
        this.socketChannel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)keepAlive);
        return this;
    }

    public int getTrafficClass() {
        Integer n = this.socketChannel.getOption(StandardSocketOptions.IP_TOS);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getOption(...)");
        return ((Number)n).intValue();
    }

    @NotNull
    public SocketChannelConfig setTrafficClass(int trafficClass) {
        this.socketChannel.setOption((SocketOption)StandardSocketOptions.IP_TOS, (Object)trafficClass);
        return this;
    }

    public boolean isReuseAddress() {
        Boolean bl = this.socketChannel.getOption(StandardSocketOptions.SO_REUSEADDR);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getOption(...)");
        return bl;
    }

    @NotNull
    public SocketChannelConfig setReuseAddress(boolean reuseAddress) {
        this.socketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)reuseAddress);
        return this;
    }

    @NotNull
    public SocketChannelConfig setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }
}

