# Upgrading from `v0.13.x` to `v0.14.x`

## Binary installation

- Stop Stalwart in **every single node of your cluster**. If you are using the systemd service, you can do this with the following command:

  ```bash
  $ sudo systemctl stop stalwart
  ```

- Backup your data following your database system's instructions. For example, if you are using RocksDB or SQLite, you can simply copy the `data` directory to a backup location. If you are using PostgreSQL or MySQL, you can use the `pg_dump` or `mysqldump` commands to create a backup of your database. If your database does not support backups, you can use the [built-in migration utility](https://stalw.art/docs/management/migration) to export your data to a file. For example:

  ```bash
  $ sudo /opt/stalwart/bin/stalwart --config /opt/stalwart/etc/config.toml --export /opt/stalwart/export
  $ sudo chown -R stalwart:stalwart /opt/stalwart/export
  ```

- Download the latest binary for your platform from the [releases page](https://github.com/stalwartlabs/stalwart/releases/latest/) and replace the binary in `/opt/stalwart/bin`. 

- Start the service. In a cluster, you can speed up the migration process by starting all nodes at once. 
  ```bash
  $ sudo systemctl start stalwart
  ```

- Upgrade the webadmin by clicking on `Manage` > `Maintenance` > `Update Webadmin`.

## Containerized

- Stop the Stalwart container in **every single node of your cluster**. If you are using Docker, you can do this with the following command:

  ```bash
  $ docker stop stalwart
  ```

- Backup your data following your database system's instructions. For example, if you are using RocksDB or SQLite, you can simply copy the `data` directory to a backup location. If you are using PostgreSQL or MySQL, you can use the `pg_dump` or `mysqldump` commands to create a backup of your database. If your database does not support backups, you can use the `--export` command to export your data to a file. For example:

  ```bash
  $ docker run --rm -v <STALWART_DIR>:/opt/stalwart -it stalwart /usr/local/bin/stalwart --config /opt/stalwart/etc/config.toml --export /opt/stalwart/export
  ```

- Pull the latest image and restart the container:

  ```bash
  $ docker pull stalwartlabs/stalwart:latest
  $ docker start stalwart
  ```
  
- Upgrade the webadmin by clicking on `Manage` > `Maintenance` > `Update Webadmin`.
