/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.remoteworkspace.server;

import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import aQute.bnd.build.Run;
import aQute.bnd.build.Workspace;
import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.About;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.remoteworkspace.client.RemoteWorkspaceClientFactory;
import aQute.bnd.service.Strategy;
import aQute.bnd.service.remoteworkspace.RemoteWorkspace;
import aQute.bnd.service.remoteworkspace.RemoteWorkspaceClient;
import aQute.bnd.service.specifications.BuilderSpecification;
import aQute.bnd.service.specifications.RunSpecification;
import aQute.bnd.version.Version;
import aQute.bnd.version.VersionRange;
import aQute.lib.aspects.Aspects;
import aQute.lib.io.IO;
import aQute.lib.link.Link;
import aQute.lib.utf8properties.UTF8Properties;
import aQute.libg.glob.Glob;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteWorkspaceServer
implements Closeable {
    final Logger logger = LoggerFactory.getLogger(RemoteWorkspaceServer.class);
    final Closeable server;
    final File remotewsPort;
    final Workspace workspace;
    final ScheduledFuture<?> registerPort;
    private final long startingTime;

    public RemoteWorkspaceServer(Workspace workspace) throws UnknownHostException, IOException {
        this.workspace = workspace;
        ServerSocket server = new ServerSocket(0, 10, InetAddress.getLoopbackAddress());
        RemoteWorkspace workspaceLocker = Aspects.intercept(RemoteWorkspace.class, new Instance()).around((inv, c) -> workspace.readLocked(() -> {
            try {
                return c.call();
            }
            catch (Throwable e) {
                throw Exceptions.duck(e);
            }
        })).build();
        this.server = Link.server("remotews", RemoteWorkspaceClient.class, server, l -> workspaceLocker, true, Processor.getExecutor());
        File remotews = RemoteWorkspaceClientFactory.getPortDirectory(workspace.getBase(), workspace.getBase());
        remotews.mkdirs();
        if (!remotews.isDirectory()) {
            throw new IllegalStateException("Cannot create the remote workspace directory with port numbers " + remotews);
        }
        this.remotewsPort = new File(remotews, server.getLocalPort() + "");
        this.remotewsPort.deleteOnExit();
        this.startingTime = System.currentTimeMillis();
        this.register();
        this.registerPort = Processor.getScheduledExecutor().scheduleAtFixedRate(this::register, 2L, 5L, TimeUnit.SECONDS);
    }

    void register() {
        if (this.remotewsPort.isFile() && Math.abs(this.startingTime - this.remotewsPort.lastModified()) < 1000L) {
            return;
        }
        try {
            IO.delete(this.remotewsPort);
            IO.mkdirs(this.remotewsPort.getParentFile());
            IO.store((Object)this.remotewsPort.getName(), this.remotewsPort);
            this.remotewsPort.setLastModified(this.startingTime);
            this.logger.info("Registering remote workspace server {}", (Object)this.remotewsPort);
        }
        catch (IOException e) {
            this.logger.warn("Cannot open remote workspace server {} {}", (Object)this.remotewsPort, (Object)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.logger.info("Closing remote workspace server {}", (Object)this.remotewsPort);
        this.registerPort.cancel(false);
        IO.delete(this.remotewsPort);
        this.server.close();
    }

    class Instance
    implements RemoteWorkspace {
        Instance() {
        }

        @Override
        public String getBndVersion() {
            return About.CURRENT.toString();
        }

        @Override
        public RunSpecification getRun(String pathToBndOrBndrun) {
            RunSpecification runSpecification;
            block10: {
                File file = new File(pathToBndOrBndrun);
                if (file.isDirectory()) {
                    Project project = RemoteWorkspaceServer.this.workspace.getProjectFromFile(file);
                    if (project == null) {
                        throw new IllegalArgumentException("No such project " + pathToBndOrBndrun + " in workspace " + RemoteWorkspaceServer.this.workspace);
                    }
                    return project.getSpecification();
                }
                Run run = Run.createRun(RemoteWorkspaceServer.this.workspace, file);
                try {
                    runSpecification = run.getSpecification();
                    if (run == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (run != null) {
                            try {
                                run.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw Exceptions.duck(e);
                    }
                }
                run.close();
            }
            return runSpecification;
        }

        @Override
        public List<String> getLatestBundles(String projectDir, String specification) {
            try {
                Project project = this.getProject(projectDir);
                return Container.toPaths(null, project.getBundles(Strategy.HIGHEST, specification, "remote"));
            }
            catch (Exception e) {
                throw Exceptions.duck(e);
            }
        }

        @Override
        public RunSpecification analyzeTestSetup(String projectDir) {
            RunSpecification runSpecification;
            Project project = this.getProject(projectDir);
            RunSpecification r = project.getSpecification();
            Builder a = new Builder();
            try {
                a.setJar(project.getTestOutput());
                a.setConditionalPackage("!java.*,*");
                a.setProperty("-exportcontents", "*");
                a.addClasspath(project.getOutput());
                for (Container c : project.getTestpath()) {
                    if (c.getError() != null) {
                        r.errors.add("Not a valid testpath entry " + c + " " + c.getError());
                        continue;
                    }
                    a.addClasspath(c.getFile());
                }
                for (Container c : project.getBuildpath()) {
                    if (c.getError() != null) {
                        r.errors.add("Not a valid buildpath entry " + c + " " + c.getError());
                        continue;
                    }
                    a.addClasspath(c.getFile());
                }
                a.build();
                r.errors.addAll(a.getErrors());
                String clauses = Processor.printClauses(a.getExports());
                Parameters extraPackages = new Parameters(clauses);
                r.extraSystemPackages.putAll(extraPackages.toBasic());
                runSpecification = r;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        a.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    throw Exceptions.duck(e);
                }
            }
            a.close();
            return runSpecification;
        }

        @Override
        public byte[] build(String projectPath, BuilderSpecification spec) {
            byte[] byArray;
            block13: {
                File projectDir = new File(projectPath);
                Project project = RemoteWorkspaceServer.this.workspace.getProjectFromFile(projectDir);
                if (project == null) {
                    throw new IllegalArgumentException("No such project " + projectPath);
                }
                Builder builder = this.getBuilder(project, spec.parent);
                try {
                    builder.setBase(project.getBase());
                    Jar build = builder.from(spec).build();
                    if (!builder.isOk()) {
                        throw new IllegalStateException(builder.getErrors().stream().collect(Collectors.joining("\n")));
                    }
                    if (spec.testBundle != null) {
                        File[] buildFiles = project.getBuildFiles(false);
                        if (buildFiles == null) {
                            throw new IllegalStateException(projectPath + ": merge requested but has no build JAR");
                        }
                        Glob glob = new Glob(spec.testBundle);
                        boolean found = false;
                        for (File f : buildFiles) {
                            if (!glob.matches(f.getName())) continue;
                            found = true;
                            Jar jar = new Jar(buildFiles[0]);
                            builder.addClose(jar);
                            jar.addAll(build);
                            Manifest manifest = jar.getManifest();
                            manifest.getMainAttributes().putValue("DynamicImport-Package", "*");
                            this.merge(manifest, build.getManifest(), "Service-Component");
                            jar.setManifest(manifest);
                            build = jar;
                            break;
                        }
                    }
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    build.write(bout);
                    byArray = bout.toByteArray();
                    if (builder == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (builder != null) {
                            try {
                                builder.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw Exceptions.duck(e);
                    }
                }
                builder.close();
            }
            return byArray;
        }

        private void merge(Manifest a, Manifest b, String hdr) {
            if (a == null) {
                return;
            }
            if (b == null) {
                return;
            }
            String aa = a.getMainAttributes().getValue(hdr);
            String bb = b.getMainAttributes().getValue(hdr);
            if (aa == null && bb == null) {
                return;
            }
            if (bb == null) {
                return;
            }
            if (aa == null) {
                a.getMainAttributes().putValue(hdr, bb);
                return;
            }
            String cc = aa + "," + bb;
            a.getMainAttributes().putValue(hdr, cc);
        }

        private Builder getBuilder(Project project, List<String> parent) throws Exception {
            if (parent == null || parent.isEmpty()) {
                return new Builder();
            }
            Builder builder = new Builder();
            builder.setBase(project.getBase());
            ArrayList<String> paths = new ArrayList<String>(parent);
            String last = (String)paths.get(paths.size() - 1);
            boolean workspaceParent = "WORKSPACE".equals(last);
            boolean projectParent = "PROJECT".equals(last);
            if (workspaceParent || projectParent) {
                paths.remove(paths.size() - 1);
                if (projectParent) {
                    builder.setParent(project);
                } else if (workspaceParent) {
                    builder.setParent(project.getWorkspace());
                }
            }
            workspaceParent = paths.remove("WORKSPACE");
            projectParent = paths.remove("PROJECT");
            if (workspaceParent || projectParent) {
                builder.error("PROJECT or WORKSPACE parent can only be specified as the last entry", new Object[0]);
            }
            Collections.reverse(paths);
            paths.forEach(path -> {
                File file = new File((String)path);
                try {
                    if (file.isFile()) {
                        UTF8Properties p = new UTF8Properties();
                        p.load(file, builder);
                        builder.setProperties(p);
                    } else {
                        builder.error("specified file %s as parent for build but no such file exist", file.toString());
                    }
                }
                catch (Exception e) {
                    builder.exception(e, "Reading properties %s", file);
                }
            });
            return builder;
        }

        void doPackage(Parameters extraPackages, Descriptors.PackageRef p, Attrs a) {
            Attrs attrs = new Attrs(a);
            String v = attrs.getVersion();
            if (v != null) {
                VersionRange vr = VersionRange.parseOSGiVersionRange(v);
                Version version = vr.getLow();
                attrs.put("version", version.toString());
            }
            extraPackages.put(p.getFQN(), attrs);
        }

        Project getProject(String projectDir) {
            File dir = new File(projectDir);
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException("Not a directory " + projectDir);
            }
            Project project = RemoteWorkspaceServer.this.workspace.getProjectFromFile(dir);
            if (project == null || !project.isValid()) {
                throw new IllegalArgumentException("Not a valid project directory " + projectDir);
            }
            return project;
        }

        @Override
        public List<String> getProjects() {
            try {
                return RemoteWorkspaceServer.this.workspace.getAllProjects().stream().map(Project::toString).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw Exceptions.duck(e);
            }
        }

        @Override
        public void close() throws IOException {
        }
    }
}

