/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_kk_Arab extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "001", "الەم" },
            { "002", "افريكا" },
            { "003", "سولتۇستىك امەريكا" },
            { "005", "وڭتۇستىك امەريكا" },
            { "009", "وكەانيا" },
            { "011", "باتىس افريكا" },
            { "013", "ورتالىق امەريكا" },
            { "014", "شىعىس افريكا" },
            { "015", "سولتۇستىك افريكا" },
            { "017", "ورتالىق افريكا" },
            { "018", "وڭتۇستىك افريكا ايماعى" },
            { "019", "امەريكا" },
            { "021", "سولتۇستىك امەريكا (ايماق)" },
            { "029", "كاريب" },
            { "030", "شىعىس ازيا" },
            { "034", "وڭتۇستىك ازيا" },
            { "035", "وڭتۇستىك-شىعىس ازيا" },
            { "039", "وڭتۇستىك ەۋروپا" },
            { "053", "اۋسترالازيا" },
            { "054", "مەلانەزيا" },
            { "057", "ميكرونەزيا ايماعى" },
            { "061", "پولينەزىا" },
            { "142", "ازيا" },
            { "143", "ورتالىق ازيا" },
            { "145", "باتىس ازيا" },
            { "150", "ەۋروپا" },
            { "151", "شىعىس ەۋروپا" },
            { "154", "سولتۇستىك ەۋروپا" },
            { "155", "باتىس ەۋروپا" },
            { "202", "سۋبساحارالىق افريكا" },
            { "419", "لاتىن امەريكا" },
            { "AC", "اسكەنجىن ارالى" },
            { "AD", "اندوررا" },
            { "AE", "بىرىككەن اراب امىرلىكتەرى" },
            { "AF", "اۋعانستان" },
            { "AG", "انتيگۋا جانە باربۋدا" },
            { "AI", "انگيليا" },
            { "AL", "البانيا" },
            { "AM", "ارمەنيا" },
            { "AO", "انگولا" },
            { "AQ", "انتاركتيدا" },
            { "AR", "ارگەنتينا" },
            { "AS", "امەريكالىق ساموا" },
            { "AT", "اۋستريا" },
            { "AU", "اۋستراليا" },
            { "AW", "ارۋبا" },
            { "AX", "الاند ارالدارى" },
            { "AZ", "ءازىربايجان" },
            { "BA", "بوسنيا جانە گەرتسەگوۆينا" },
            { "BB", "باربادوس" },
            { "BD", "بانگلادەش" },
            { "BE", "بەلگيا" },
            { "BF", "بۋركينا-فاسو" },
            { "BG", "بولگاريا" },
            { "BH", "باحرەين" },
            { "BI", "بۋرۋندي" },
            { "BJ", "بەنين" },
            { "BL", "سان-بارتەمەلي" },
            { "BM", "بەرمۋد ارالدارى" },
            { "BN", "برۋنەي" },
            { "BO", "بوليۆيا" },
            { "BQ", "بونەير، سينت-ەستاتيۋس جانە سابا" },
            { "BR", "برازيليا" },
            { "BS", "باگام ارالدارى" },
            { "BT", "بۋتان" },
            { "BV", "بۋۆە ارالى" },
            { "BW", "بوتسۆانا" },
            { "BY", "بەلارۋس" },
            { "BZ", "بەليز" },
            { "CA", "كانادا" },
            { "CC", "كوكوس (كيليڭ) ارالدارى" },
            { "CD", "كونگو" },
            { "CF", "ورتالىق افريكا رەسپۋبليكاسى" },
            { "CG", "كونگو-براززاۆيل رەسپۋبليكاسى" },
            { "CH", "شۆەيساريا" },
            { "CI", "كوت-ديۆۋار" },
            { "CK", "كۋك ارالدارى" },
            { "CL", "چيلي" },
            { "CM", "كامەرۋن" },
            { "CN", "قىتاي" },
            { "CO", "كولۋمبيا" },
            { "CP", "كليپپەرتون ارالى" },
            { "CQ", "سارك" },
            { "CR", "كوستا-ريكا" },
            { "CU", "كۋبا" },
            { "CV", "كابو-ۆەردە" },
            { "CW", "كيۋراساو" },
            { "CX", "حريستماس ارالى" },
            { "CY", "كيپر" },
            { "CZ", "چەحيا" },
            { "DE", "گەرمانيا" },
            { "DG", "ديەگو-گارسيا" },
            { "DJ", "دجيبۋتي" },
            { "DK", "دانيا" },
            { "DM", "دومينيكا" },
            { "DO", "دومينيكان رەسپۋبليكاسى" },
            { "DZ", "الجىر" },
            { "EA", "سەۋتا جانە مەليليا" },
            { "EC", "ەكۆادور" },
            { "EE", "ەستونيا" },
            { "EG", "مىسىر" },
            { "EH", "باتىس ساحارا" },
            { "ER", "ەريترەيا" },
            { "ES", "يسپانيا" },
            { "ET", "ەفيوپيا" },
            { "EU", "ەۋروپالىق وداق" },
            { "EZ", "ەۋرو ايماق" },
            { "FI", "فينليانديا" },
            { "FJ", "فيجي" },
            { "FK", "فولكلەند ارالدارى" },
            { "FM", "ميكرونەزيا" },
            { "FO", "فارەر ارالدارى" },
            { "FR", "فرانسيا" },
            { "GA", "گابون" },
            { "GB", "ۇلىبريتانيا" },
            { "GD", "گرەنادا" },
            { "GE", "گرۋزيا" },
            { "GF", "فرانسۋز گۆياناسى" },
            { "GG", "گەرنسي" },
            { "GH", "گانا" },
            { "GI", "گيبرالتار" },
            { "GL", "گرەنلانديا" },
            { "GM", "گامبيا" },
            { "GN", "گۆەنيا" },
            { "GP", "گۆادەلۋپا" },
            { "GQ", "ەكۆاتورلىق گۆينەيا" },
            { "GR", "گرەكيا" },
            { "GS", "وڭتۇستىك گەورگيا جانە وڭتۇستىك ساندۆيچ ارالدارى" },
            { "GT", "گۆاتەمالا" },
            { "GU", "گۋان" },
            { "GW", "گۆەنيا-بيساۋ" },
            { "GY", "گايانا" },
            { "HK", "حوڭكوڭ" },
            { "HM", "حەرد ارالى جانە ماكدونالد ارالدارى" },
            { "HN", "گوندۋراس" },
            { "HR", "حورۆاتيا" },
            { "HT", "گايتي" },
            { "HU", "ماجارستان" },
            { "IC", "كانار ارالدارى" },
            { "ID", "يندونەزيا" },
            { "IE", "يرلانديا" },
            { "IL", "يزرايل" },
            { "IM", "مەن ارالى" },
            { "IN", "ءۇندىستان" },
            { "IO", "ءۇندى مۇحيتىنداعى بريتان ايماعى" },
            { "IQ", "يراك" },
            { "IR", "يران" },
            { "IS", "يسلانديا" },
            { "IT", "يتاليا" },
            { "JE", "جەرسي" },
            { "JM", "يامايكا" },
            { "JO", "يوردانيا" },
            { "JP", "جاپونيا" },
            { "KE", "كەنيا" },
            { "KG", "قىرعىزستان" },
            { "KH", "كامباجا" },
            { "KI", "كيريباتي" },
            { "KM", "كومور ارالدارى" },
            { "KN", "سەنت-كيتس جانە نەۆيس" },
            { "KP", "سولتۇستىك كورەيا" },
            { "KR", "وڭتۇستىك كورەيا" },
            { "KW", "كۋۆەيت" },
            { "KY", "كايمان ارالدارى" },
            { "KZ", "قازاق ەلى" },
            { "LA", "لاوس" },
            { "LB", "ليۆان" },
            { "LC", "سەنت-ليۋسيا" },
            { "LI", "ليحتەنشتەين" },
            { "LK", "شري-لانكا" },
            { "LR", "ليبەريا" },
            { "LS", "لەسوتو" },
            { "LT", "ليتۆا" },
            { "LU", "ليۋكسەمبۋرگ" },
            { "LV", "لاتۆيا" },
            { "LY", "ليۆيا" },
            { "MA", "ماروككو" },
            { "MC", "موناكو" },
            { "MD", "مولدوۆا" },
            { "ME", "چەرنوگوريا" },
            { "MF", "سەن-مارتەن" },
            { "MG", "ماداگاسكار" },
            { "MH", "مارشال ارالدارى" },
            { "MK", "سولتۇستىك ماكەدونيا" },
            { "ML", "مالي" },
            { "MM", "ميانما (بيرما)" },
            { "MN", "موڭعوليا" },
            { "MO", "ماكاو" },
            { "MP", "سولتۇستىك ماريانا ارالدارى" },
            { "MQ", "مارتينيكا" },
            { "MR", "ماۆريتانيا" },
            { "MS", "مونتسەررات" },
            { "MT", "مالتا" },
            { "MU", "ماۆريكي" },
            { "MV", "مالديۆ ارالدارى" },
            { "MW", "مالاۆي" },
            { "MX", "مەكسيكا" },
            { "MY", "مالايزيا" },
            { "MZ", "موزامبيك" },
            { "NA", "ناميبيا" },
            { "NC", "جاڭا كالەدونيا" },
            { "NE", "نيگەر" },
            { "NF", "نورفولك ارالى" },
            { "NG", "نيگەريا" },
            { "NI", "نيكاراگۋا" },
            { "NL", "نيدەرلاند" },
            { "NO", "نورۆەگيا" },
            { "NP", "نەپال" },
            { "NR", "ناۋرۋ" },
            { "NU", "نيۋە" },
            { "NZ", "جاڭا زەلانديا" },
            { "OM", "ومان" },
            { "PA", "پاناما" },
            { "PE", "پەرۋ" },
            { "PF", "فرانتسۋز پولينەزياسى" },
            { "PG", "پاپۋا — جاڭا گۆينەيا" },
            { "PH", "فيليپين ارالدارى" },
            { "PK", "پاكىستان" },
            { "PL", "پولشا" },
            { "PM", "سەن-پەر جانە ميكەلون" },
            { "PN", "پيتكەرن ارالدارى" },
            { "PR", "پۋەرتو-ريكو" },
            { "PS", "پالەستينا ايماقتارى" },
            { "PT", "پورتۋگاليا" },
            { "PW", "پالاۋ" },
            { "PY", "پاراگۆاي" },
            { "QA", "كاتار" },
            { "QO", "سىرتقى وكەانيا" },
            { "RE", "رەيۋنيون" },
            { "RO", "رۋمىنيا" },
            { "RS", "سەربيا" },
            { "RU", "حەسەي" },
            { "RW", "رۋاندا" },
            { "SA", "ساۋد ارابياسى" },
            { "SB", "سولومون ارالدارى" },
            { "SC", "سەيشەل ارالدارى" },
            { "SD", "سۋدان" },
            { "SE", "شۆەسيا" },
            { "SG", "سينگاپۋر" },
            { "SH", "اۋليە ەلەنا ارالى" },
            { "SI", "سلوۆەنيا" },
            { "SJ", "شپيتسبەرگەن جانە يان-مايەن" },
            { "SK", "سلوۆاكيا" },
            { "SL", "سەررا-لەونە" },
            { "SM", "سان-مارينو" },
            { "SN", "سەنەگال" },
            { "SO", "سومالي" },
            { "SR", "سۋرينام" },
            { "SS", "وڭتۇستىك سۋدان" },
            { "ST", "سان-تومە جانە پرينسيپي" },
            { "SV", "سالۆادور" },
            { "SX", "سينت-مارتەن" },
            { "SY", "سيريا" },
            { "SZ", "ەسۆاتيني" },
            { "TA", "تريستان-دا-كۋنيا" },
            { "TC", "تەركس جانە كايكوس ارالدارى" },
            { "TD", "چاد" },
            { "TF", "فرانتسيانىڭ وڭتۇستىك ايماقتارى" },
            { "TG", "توگو" },
            { "TH", "تايلاند" },
            { "TJ", "تاجىكستان" },
            { "TK", "توكەلاۋ" },
            { "TL", "تيمور-لەستە" },
            { "TM", "تۇرىكمەنستان" },
            { "TN", "تۋنيس" },
            { "TO", "تونگا" },
            { "TR", "تۇركيا" },
            { "TT", "ترينيداد جانە توباگو" },
            { "TV", "تۋۆالۋ" },
            { "TW", "تايۋان" },
            { "TZ", "تانزانيا" },
            { "UA", "ۋكراينا" },
            { "UG", "ۋگاندا" },
            { "UM", "ا ق ش-تىڭ سىرتقى كىشى ارالدارى" },
            { "UN", "بىرىككەن ۇلتتار ۇيىمى" },
            { "US", "امەريكا قۇراما شتاتتارى" },
            { "UY", "ۋرۋگۆاي" },
            { "UZ", "وزبەكستان" },
            { "VA", "ۆاتيكان" },
            { "VC", "سەنت-ۆينسەنت جانە گرەنادين ارالدارى" },
            { "VE", "ۆەنەسۋەلا" },
            { "VG", "بريتاندىق ۆيرگين ارالدارى" },
            { "VI", "ا ق ش-تىڭ ۆيرگين ارالدارى" },
            { "VN", "ۆيەتنام" },
            { "VU", "ۆانۋاتۋ" },
            { "WF", "ۋولليس جانە فۋتۋنا" },
            { "WS", "ساموا" },
            { "XA", "جالعان اكسەنت" },
            { "XB", "بالعان بيدي" },
            { "XK", "كوسوۆو" },
            { "YE", "يەمەن" },
            { "YT", "مايوتتا" },
            { "ZA", "وڭتۇستىك افريكا" },
            { "ZM", "زامبيا" },
            { "ZW", "زيمبابۆە" },
            { "ZZ", "بەلگىسىز ايماق" },
            { "aa", "افار ءتىلى" },
            { "ab", "ابحاز ءتىلى" },
            { "af", "افريكاانس ءتىلى" },
            { "ak", "اكان ءتىلى" },
            { "am", "امحار ءتىلى" },
            { "an", "اراگون ءتىلى" },
            { "ar", "اراب ءتىلى" },
            { "as", "اسسام ءتىلى" },
            { "az", "ءازىربايجان ءتىلى" },
            { "ba", "باشقۇرت ءتىلى" },
            { "be", "بەلارۋس ءتىلى" },
            { "bg", "بولگار ءتىلى" },
            { "bm", "بامبارا ءتىلى" },
            { "bn", "بەنگال ءتىلى" },
            { "bo", "تيبەت ءتىلى" },
            { "br", "برەتون ءتىلى" },
            { "bs", "بوسنيا ءتىلى" },
            { "ca", "كاتالان ءتىلى" },
            { "ce", "شەشەن ءتىلى" },
            { "co", "كورسيكا ءتىلى" },
            { "cs", "چەح ءتىلى" },
            { "cu", "شىركەۋلىك سلاۆيان ءتىلى" },
            { "cv", "چۋۆاش ءتىلى" },
            { "cy", "ۆاللي ءتىلى" },
            { "da", "دات ءتىلى" },
            { "de", "نەمىس ءتىلى" },
            { "dv", "ديۆەحي ءتىلى" },
            { "dz", "جوڭكا ءتىلى" },
            { "ee", "ەۆە ءتىلى" },
            { "el", "گرەك ءتىلى" },
            { "en", "اعىلشىن ءتىلى" },
            { "eo", "ەسپەرانتو ءتىلى" },
            { "es", "يسپان ءتىلى" },
            { "et", "ەستون ءتىلى" },
            { "eu", "باسك ءتىلى" },
            { "fa", "پارسى ءتىلى" },
            { "ff", "فۋلا ءتىلى" },
            { "fi", "فين ءتىلى" },
            { "fo", "فارەر ءتىلى" },
            { "fr", "فرانسۋز ءتىلى" },
            { "fy", "باتىس فريز ءتىلى" },
            { "ga", "يرلاند ءتىلى" },
            { "gd", "شوتلانديالىق گەل ءتىلى" },
            { "gl", "گاليسيا ءتىلى" },
            { "gn", "گۋاريني ءتىلى" },
            { "gu", "گۋجاراتي ءتىلى" },
            { "gv", "مەن ءتىلى" },
            { "ha", "حاۋسا ءتىلى" },
            { "he", "يۆريت ءتىلى" },
            { "hi", "حيندي ءتىلى" },
            { "hr", "حورۆات ءتىلى" },
            { "ht", "گايتيان كىرەول ءتىلى" },
            { "hu", "ماجار ءتىلى" },
            { "hy", "ارميان ءتىلى" },
            { "ia", "ينتەرلينگۆا ءتىلى" },
            { "id", "يندونەزيا ءتىلى" },
            { "ie", "ينتەرلينگۆە ءتىلى" },
            { "ig", "يگبو ءتىلى" },
            { "ii", "سىچۋان ي ءتىلى" },
            { "io", "يدو ءتىلى" },
            { "is", "يسلاند ءتىلى" },
            { "it", "يتاليان ءتىلى" },
            { "iu", "ينۋكتيتۋت ءتىلى" },
            { "ja", "جاپون ءتىلى" },
            { "jv", "ياۆا ءتىلى" },
            { "ka", "گرۋزين ءتىلى" },
            { "ki", "كيكۋيۋ ءتىلى" },
            { "kk", "قازاق ءتىلى" },
            { "kl", "كالاليسۋت ءتىلى" },
            { "km", "كحمەر ءتىلى" },
            { "kn", "كاننادا ءتىلى" },
            { "ko", "كورەي ءتىلى" },
            { "ks", "كاشمير ءتىلى" },
            { "ku", "كۇرمانجى" },
            { "kw", "كورن ءتىلى" },
            { "ky", "قىرعىز ءتىلى" },
            { "la", "لاتىن ءتىلى" },
            { "lb", "ليۋكسەمبۋرگ ءتىلى" },
            { "lg", "گاندا ءتىلى" },
            { "ln", "لينگالا ءتىلى" },
            { "lo", "لاوس ءتىلى" },
            { "lt", "ليتۆا ءتىلى" },
            { "lu", "لۋبا-كاتاڭا ءتىلى" },
            { "lv", "لاتىش ءتىلى" },
            { "mg", "مالاگاسي ءتىلى" },
            { "mi", "ماوري ءتىلى" },
            { "mk", "ماكەدون ءتىلى" },
            { "ml", "مالايالام ءتىلى" },
            { "mn", "موڭعول ءتىلى" },
            { "mr", "ماراتحي ءتىلى" },
            { "ms", "مالاي ءتىلى" },
            { "mt", "مالتا ءتىلى" },
            { "my", "بيرما ءتىلى" },
            { "nb", "نورۆەگيالىق بۋكمول ءتىلى" },
            { "nd", "سولتۇستىك ندەبەلە ءتىلى" },
            { "ne", "نەپال ءتىلى" },
            { "nl", "نيدەرلاند ءتىلى" },
            { "nn", "نورۆەگيالىق نيۋنورسك ءتىلى" },
            { "no", "نورۆەگ ءتىلى" },
            { "nr", "وڭتۇستىك ندەبەلە ءتىلى" },
            { "nv", "ناۆاحو ءتىلى" },
            { "ny", "نيانجا ءتىلى" },
            { "oc", "وكسيتان ءتىلى" },
            { "om", "ورومو ءتىلى" },
            { "or", "وريا ءتىلى" },
            { "os", "وسەتين ءتىلى" },
            { "pa", "پەنجاب ءتىلى" },
            { "pi", "پالي ءتىلى" },
            { "pl", "پولياك ءتىلى" },
            { "ps", "پۋشتۋ ءتىلى" },
            { "pt", "پورتۋگال ءتىلى" },
            { "qu", "كەچۋا ءتىلى" },
            { "rm", "رومانش ءتىلى" },
            { "rn", "رۋندي ءتىلى" },
            { "ro", "رۋمىن ءتىلى" },
            { "ru", "ورىس ءتىلى" },
            { "rw", "كينيارۋاندا ءتىلى" },
            { "sa", "سانسكريت ءتىلى" },
            { "sc", "ساردين ءتىلى" },
            { "sd", "سيندحي ءتىلى" },
            { "se", "سولتۇستىك سامي ءتىلى" },
            { "sg", "ساڭو ءتىلى" },
            { "si", "سينگال ءتىلى" },
            { "sk", "سلوۆاك ءتىلى" },
            { "sl", "سلوۆەن ءتىلى" },
            { "sn", "شونا ءتىلى" },
            { "so", "سومالي ءتىلى" },
            { "sq", "البان ءتىلى" },
            { "sr", "سەرب ءتىلى" },
            { "ss", "سۋاتي ءتىلى" },
            { "st", "وڭتۇستىك سوتو ءتىلى" },
            { "su", "سۋدان ءتىلى" },
            { "sv", "شۆەد ءتىلى" },
            { "sw", "سۋاحيلي ءتىلى" },
            { "ta", "تاميل ءتىلى" },
            { "te", "تەلۋگۋ ءتىلى" },
            { "tg", "تاجىك ءتىلى" },
            { "th", "تاي ءتىلى" },
            { "ti", "تيگرينيا ءتىلى" },
            { "tk", "تۇرىكمەن ءتىلى" },
            { "tn", "سۋانا ءتىلى" },
            { "to", "تونگان ءتىلى" },
            { "tr", "تۇرىك ءتىلى" },
            { "ts", "سونگا ءتىلى" },
            { "tt", "تاتار ءتىلى" },
            { "ug", "ۇيعىر ءتىلى" },
            { "uk", "ۋكراين ءتىلى" },
            { "ur", "ۋردۋ ءتىلى" },
            { "uz", "وزبەك ءتىلى" },
            { "ve", "ۆەندا ءتىلى" },
            { "vi", "ۆيەتنام ءتىلى" },
            { "vo", "ۆولاپيۋك ءتىلى" },
            { "wa", "ۋالون ءتىلى" },
            { "wo", "ۆولوف ءتىلى" },
            { "xh", "كحوسا ءتىلى" },
            { "yi", "يديش ءتىلى" },
            { "yo", "يورۋبا ءتىلى" },
            { "za", "جۋاڭ ءتىلى" },
            { "zh", "قىتاي ءتىلى" },
            { "zu", "زۋلۋ ءتىلى" },
            { "agq", "اگەم ءتىلى" },
            { "ann", "وبولو ءتىلى" },
            { "apc", "شامي ءتىلى" },
            { "arn", "ماپۋچە ءتىلى" },
            { "asa", "اسۋ ءتىلى" },
            { "ast", "استرۋيا ءتىلى" },
            { "bal", "بالۋچي ءتىلى" },
            { "bas", "باسا ءتىلى" },
            { "bem", "بەمبا ءتىلى" },
            { "bew", "بەياۋي ءتىلى" },
            { "bez", "بەنا ءتىلى" },
            { "bgc", "حارياني ءتىلى" },
            { "bgn", "باتىس بالۋچي ءتىلى" },
            { "bho", "بحودجپۋري ءتىلى" },
            { "blo", "اني ءتىلى" },
            { "blt", "تاي دام ءتىلى" },
            { "bqi", "باحتيار ءتىلى" },
            { "brx", "بودو ءتىلى" },
            { "bss", "اكوسە ءتىلى" },
            { "bua", "بۋريات ءتىلى" },
            { "byn", "بلين ءتىلى" },
            { "cad", "كاددو ءتىلى" },
            { "cch", "اتسام ءتىلى" },
            { "ccp", "چاكما ءتىلى" },
            { "ceb", "سەبۋانو ءتىلى" },
            { "cgg", "كيگا ءتىلى" },
            { "cho", "چوكتو ءتىلى" },
            { "chr", "چەروكي ءتىلى" },
            { "cic", "چيكاساۋ ءتىلى" },
            { "ckb", "سوراني ءتىلى" },
            { "cop", "كوپىت ءتىلى" },
            { "csw", "باتپاقتى جەردىڭ كري ءتىلى" },
            { "dav", "تايتا ءتىلى" },
            { "dje", "زارما ءتىلى" },
            { "doi", "دوگري ءتىلى" },
            { "dsb", "تومەنگى سوربيان ءتىلى" },
            { "dua", "دۋالا ءتىلى" },
            { "dyo", "ديولا ءتىلى" },
            { "ebu", "ەمبۋ ءتىلى" },
            { "ewo", "ەۆوندو ءتىلى" },
            { "fil", "فيليپين ءتىلى" },
            { "frc", "كاجۋن ءتىلى" },
            { "frr", "سولتۇستىك-شىعىس كري ءتىلى" },
            { "fur", "فريۋل ءتىلى" },
            { "gaa", "گا ءتىلى" },
            { "gez", "گەەز ءتىلى" },
            { "gsw", "شۆەيساريالىق نەمىس ءتىلى" },
            { "guz", "گۋسي ءتىلى" },
            { "haw", "حاۋاي ءتىلى" },
            { "hnj", "حموڭ نيۋا ءتىلى" },
            { "hsb", "جوعارعى سوربيان ءتىلى" },
            { "jbo", "لاجبان ءتىلى" },
            { "jgo", "نگومبا ءتىلى" },
            { "jmc", "ماچامە ءتىلى" },
            { "kaa", "قاراقالپاق ءتىلى" },
            { "kab", "كابيل ءتىلى" },
            { "kaj", "كاجي ءتىلى" },
            { "kam", "كامبا ءتىلى" },
            { "kcg", "تياپ ءتىلى" },
            { "kde", "ماكوندە ءتىلى" },
            { "kea", "كابۋۆەرديانۋ ءتىلى" },
            { "kek", "كەكچي ءتىلى" },
            { "ken", "كەنياڭ ءتىلى" },
            { "kgp", "كاينگاڭ ءتىلى" },
            { "khq", "كويرا چيني ءتىلى" },
            { "kkj", "كاكو ءتىلى" },
            { "kln", "كالەنجين ءتىلى" },
            { "kok", "كونكاني ءتىلى" },
            { "kpe", "كپەلە ءتىلى" },
            { "ksb", "شامبالا ءتىلى" },
            { "ksf", "بافيا ءتىلى" },
            { "ksh", "كولونيان ءتىلى" },
            { "kxv", "كۋۆي ءتىلى" },
            { "lag", "لانگي ءتىلى" },
            { "lij", "ليگۋر ءتىلى" },
            { "lkt", "لاكوتا ءتىلى" },
            { "lld", "لادينو ءتىلى" },
            { "lmo", "لومبارد ءتىلى" },
            { "lou", "كىرەول ءتىلى" },
            { "lrc", "سولتۇستىك فريز ءتىلى" },
            { "ltg", "لاتگاليان ءتىلى" },
            { "luo", "لۋو ءتىلى" },
            { "luy", "لۋحيا ءتىلى" },
            { "lzz", "لاز ءتىلى" },
            { "mai", "مايتحيلي ءتىلى" },
            { "mas", "ماساي ءتىلى" },
            { "mdf", "موكشا ءتىلى" },
            { "mer", "مەرۋ ءتىلى" },
            { "mfe", "موريسيەن ءتىلى" },
            { "mgh", "ماكۋا-مەتتو ءتىلى" },
            { "mgo", "مەتا ءتىلى" },
            { "mhn", "موكەنو ءتىلى" },
            { "mic", "ميكماۋ ءتىلى" },
            { "mni", "مانيپۋري ءتىلى" },
            { "moh", "موحاۋك ءتىلى" },
            { "mua", "مۋنداڭ ءتىلى" },
            { "mul", "بىرنەشە ءتىلى" },
            { "mus", "كريك ءتىلى" },
            { "myv", "ەرزيا ءتىلى" },
            { "mzn", "مازاندەران ءتىلى" },
            { "naq", "ناما ءتىلى" },
            { "nds", "تومەنگى نەمىس ءتىلى" },
            { "nmg", "كۋاسيو ءتىلى" },
            { "nnh", "نگيەمبۋن ءتىلى" },
            { "nqo", "نكو ءتىلى" },
            { "nso", "سولتۇستىك سوتو ءتىلى" },
            { "nus", "نۋەر ءتىلى" },
            { "nyn", "نيانكولە ءتىلى" },
            { "osa", "وسەيج ءتىلى" },
            { "pap", "پاپيامەنتو ءتىلى" },
            { "pcm", "نيگەريالىق پيدجين ءتىلى" },
            { "pis", "پيجين ءتىلى" },
            { "pms", "پيەمونت ءتىلى" },
            { "prg", "پرۋسسيا ءتىلى" },
            { "quc", "كيچە ءتىلى" },
            { "raj", "راجاستاني ءتىلى" },
            { "rhg", "روحينجا ءتىلى" },
            { "rif", "ريفيان ءتىلى" },
            { "rof", "رومبو ءتىلى" },
            { "rwk", "رۋا ءتىلى" },
            { "sah", "ساحا ءتىلى" },
            { "saq", "سامبۋرۋ ءتىلى" },
            { "sat", "سانتالي ءتىلى" },
            { "sbp", "ساڭۋ ءتىلى" },
            { "scn", "سيسيليا ءتىلى" },
            { "sdh", "وڭتۇستىك كۇرد ءتىلى" },
            { "seh", "سەنا ءتىلى" },
            { "ses", "كويرابورو سەنني ءتىلى" },
            { "sgs", "ساموگيتيان ءتىلى" },
            { "shi", "تاشەلحيت ءتىلى" },
            { "shn", "شان ءتىلى" },
            { "sid", "سيدامو ءتىلى" },
            { "skr", "سارايكي ءتىلى" },
            { "sma", "وڭتۇستىك سامي ءتىلى" },
            { "smj", "لۋلە-سامي ءتىلى" },
            { "smn", "يناري سامي ءتىلى" },
            { "sms", "كولتا سامي ءتىلى" },
            { "ssy", "ساحو ءتىلى" },
            { "syr", "سيريا ءتىلى" },
            { "szl", "سيلەز ءتىلى" },
            { "teo", "تەسو ءتىلى" },
            { "tig", "تيگرە ءتىلى" },
            { "tok", "توكي-پونا ءتىلى" },
            { "tpi", "توك-پيسين ءتىلى" },
            { "trv", "تاروكو ءتىلى" },
            { "trw", "توۋالي ءتىلى" },
            { "twq", "تاساۋاك ءتىلى" },
            { "tyv", "تۋۆين ءتىلى" },
            { "tzm", "ورتالىق اتلاس تامازيگحت ءتىلى" },
            { "und", "بەلگىسىز ءتىل" },
            { "vai", "ۆاي ءتىلى" },
            { "vec", "ۆەنەسيا ءتىلى" },
            { "vmw", "ماكۋا ءتىلى" },
            { "vun", "ۆۋنجو ءتىلى" },
            { "wae", "ۋالسەر ءتىلى" },
            { "wal", "ۋولايتا ءتىلى" },
            { "wbp", "ۋالبيري ءتىلى" },
            { "xnr", "كاڭري ءتىلى" },
            { "xog", "سوگا ءتىلى" },
            { "yav", "ياڭبەن ءتىلى" },
            { "yrl", "نەنگاتۋ ءتىلى" },
            { "yue", "گۋاڭدۇڭ ءتىلى" },
            { "zgh", "ماروككولىق ستاندارتتى تامازيگحت ءتىلى" },
            { "zxx", "تىلدىك مازمۇنى جوق" },
            { "Adlm", "ادلام جازۋى" },
            { "Aghb", "اگۆان جازۋى" },
            { "Ahom", "احوم جازۋى" },
            { "Arab", "اراب جازۋى" },
            { "Aran", "ناستاليك جازۋى" },
            { "Armi", "ارامەي جازۋى" },
            { "Armn", "ارميان جازۋى" },
            { "Avst", "اۆەستا جازۋى" },
            { "Bali", "بالي جازۋى" },
            { "Bamu", "بامۋم جازۋى" },
            { "Bass", "باسسا جازۋى" },
            { "Batk", "باتاك جازۋى" },
            { "Beng", "بەنگال جازۋى" },
            { "Berf", "زاگاۋا جازۋى" },
            { "Bhks", "بحايسۋكى جازۋى" },
            { "Bopo", "بوپوموفو جازۋى" },
            { "Brah", "براحمي جازۋى" },
            { "Brai", "برايل جازۋى" },
            { "Bugi", "بۋگي جازۋى" },
            { "Buhd", "بۋحيد جازۋى" },
            { "Cakm", "چاكما جازۋى" },
            { "Cans", "كانادالىق بۋىن جۇيەلى جازۋ" },
            { "Cari", "كاري جازۋى" },
            { "Cham", "چام جازۋى" },
            { "Cher", "چەروكي جازۋى" },
            { "Chrs", "حورەزم جازۋى" },
            { "Copt", "كوپت جازۋى" },
            { "Cpmn", "كيپر-مينوي جازۋى" },
            { "Cprt", "كيپر جازۋى" },
            { "Cyrl", "كيريل جازۋى" },
            { "Cyrs", "كونە ورىس جازۋى" },
            { "Deva", "دەۆاناگاري جازۋى" },
            { "Diak", "ديۆەحي اكۋرۋ جازۋى" },
            { "Dogr", "دوگرا جازۋى" },
            { "Dsrt", "دەسەرەت جازۋى" },
            { "Dupl", "دۋپلويە جازۋى" },
            { "Egyp", "مىسىر جازۋى" },
            { "Elba", "ەلباسان جازۋى" },
            { "Elym", "ەليماي جازۋى" },
            { "Ethi", "ەفيوپيالىق جازۋ" },
            { "Gara", "گاراي جازۋى" },
            { "Geor", "گرۋزين جازۋى" },
            { "Glag", "گلاگول جازۋى" },
            { "Gong", "گۋنجالا گوندي جازۋى" },
            { "Gonm", "ماسارام گوندي جازۋى" },
            { "Goth", "گوت جازۋى" },
            { "Gran", "گرانتحا جازۋى" },
            { "Grek", "گرەك جازۋى" },
            { "Gujr", "گۋجاراتي جازۋى" },
            { "Gukh", "گۋرۋڭ كحەما جازۋى" },
            { "Guru", "گۋرمۋكحي جازۋى" },
            { "Hanb", "حانب جازۋى" },
            { "Hang", "حانگىل جازۋى" },
            { "Hani", "قىتاي جازۋى" },
            { "Hano", "حانۋنۋ جازۋى" },
            { "Hans", "جەڭىلدەتىلگەن جازۋ" },
            { "Hant", "ءداستۇرلى جازۋ" },
            { "Hatr", "حاترا جازۋى" },
            { "Hebr", "يۆريت جازۋى" },
            { "Hira", "حيراگانا جازۋى" },
            { "Hluw", "انادولى جازۋى" },
            { "Hmng", "پاحاۋ جازۋى" },
            { "Hmnp", "نياكەڭ پۋاچۋە حموڭ جازۋى" },
            { "Hrkt", "حيراگانا نەمەسە كاتاكانا" },
            { "Hung", "ماجار رۋناسى" },
            { "Ital", "ەسكى يتالياجازۋى" },
            { "Jamo", "جامو جازۋى" },
            { "Java", "ياۆا جازۋى" },
            { "Jpan", "جاپون جازۋى" },
            { "Kali", "كايا-لي جازۋى" },
            { "Kana", "كاتاكانا جازۋى" },
            { "Kawi", "كاۋي جازۋى" },
            { "Khar", "كحاروشتحي جازۋى" },
            { "Khmr", "كحمەر جازۋى" },
            { "Khoj", "حوجيكي جازۋى" },
            { "Kits", "شاعىن كيدان جازۋى" },
            { "Knda", "كاننادا جازۋى" },
            { "Kore", "كورەي جازۋى" },
            { "Krai", "كيرات راي جازۋى" },
            { "Kthi", "كايتحي جازۋى" },
            { "Lana", "لاننا جازۋى" },
            { "Laoo", "لاوس جازۋى" },
            { "Latf", "فراكتۋر لاتىن جازۋى" },
            { "Latg", "گاەل لاتىن جازۋى" },
            { "Latn", "لاتىن جازۋى" },
            { "Lepc", "لەپچا جازۋى" },
            { "Limb", "ليمبۋ جازۋى" },
            { "Lina", "سىزىقتىق A جازۋى" },
            { "Linb", "سىزىقتىق B جازۋى" },
            { "Lisu", "فرايسەر جازۋى" },
            { "Lyci", "ليكي جازۋى" },
            { "Lydi", "ليدي جازۋى" },
            { "Mahj", "ماحاجاني جازۋى" },
            { "Maka", "ماكاسار جازۋى" },
            { "Mand", "ماندەي جازۋى" },
            { "Mani", "مانيحەي جازۋى" },
            { "Marc", "مارچەن جازۋى" },
            { "Medf", "مەدەفايدرين جازۋى" },
            { "Mend", "مەندە جازۋى" },
            { "Merc", "مەرويت قيعاش جازۋى" },
            { "Mero", "مەرويت جازۋى" },
            { "Mlym", "مالايالام جازۋى" },
            { "Modi", "مودي جازۋى" },
            { "Mong", "موڭعول جازۋى" },
            { "Mroo", "مرو جازۋى" },
            { "Mtei", "مەيتەي جازۋى" },
            { "Mult", "مۋلتاني جازۋى" },
            { "Mymr", "ميانما جازۋى" },
            { "Nagm", "ناگ مۋنداري جازۋى" },
            { "Nand", "نانديناگاري جازۋى" },
            { "Narb", "كونە سولتۇستىك اراب جازۋى" },
            { "Nbat", "ناباتەي جازۋى" },
            { "Newa", "نيۋا جازۋى" },
            { "Nkoo", "نكو جازۋى" },
            { "Nshu", "نيۋ-شۋ جازۋى" },
            { "Ogam", "وگام جازۋى" },
            { "Olck", "ول-چيكي جازۋى" },
            { "Onao", "ول-ونال جازۋى" },
            { "Orkh", "كونە تۇركى جازۋى" },
            { "Orya", "وريا جازۋى" },
            { "Osge", "وسەيج جازۋى" },
            { "Osma", "يسمانيا جازۋى" },
            { "Ougr", "كونە ۇيعىر جازۋى" },
            { "Palm", "پالمير جازۋى" },
            { "Pauc", "پاۋ سين حاۋ جازۋى" },
            { "Perm", "كونە پەرم جازۋى" },
            { "Phag", "تيبەر-موڭعول جازۋى" },
            { "Phli", "جازبا پاحلاۆي" },
            { "Phlp", "پاحلاۆي جازۋى" },
            { "Phnx", "فينيكيا جازۋى" },
            { "Plrd", "پوللارد فونەتيكالىق جازۋى" },
            { "Prti", "جازبا پارفيا" },
            { "Qaag", "زوجي جازۋى" },
            { "Rjng", "رەجاڭ جازۋى" },
            { "Rohg", "حانيفي جازۋى" },
            { "Runr", "رۋنا" },
            { "Samr", "ساماريا جازۋى" },
            { "Sarb", "وڭتۇستىك اراب جازۋى" },
            { "Saur", "ساۋراشترا جازۋى" },
            { "Sgnw", "جازۋ" },
            { "Shaw", "شوۋ جازۋى" },
            { "Shrd", "شارادا جازۋى" },
            { "Sidd", "سيدحام جازۋى" },
            { "Sidt", "سيدەت جازۋى" },
            { "Sind", "كحۋداۋادي جازۋى" },
            { "Sinh", "سينگال جازۋى" },
            { "Sogd", "سوعدى جازۋى" },
            { "Sogo", "كونە سوعدى جازۋى" },
            { "Sora", "سورا سومپەڭ جازۋى" },
            { "Soyo", "سويومبو جازۋى" },
            { "Sund", "سۋند جازۋى" },
            { "Sunu", "سۋنۋار جازۋى" },
            { "Sylo", "سيلحەت ناگاري جازۋى" },
            { "Syrc", "سيريا جازۋى" },
            { "Syre", "ەسترانگەلو سيري جازۋى" },
            { "Syrj", "باتىس سيري جازۋى" },
            { "Syrn", "شىعىس سيري جازۋى" },
            { "Tagb", "تاگبانۋا جازۋى" },
            { "Takr", "تاكري جازۋى" },
            { "Tale", "تاي لى جازۋى" },
            { "Talu", "جاڭا تاي لى جازۋى" },
            { "Taml", "تاميل جازۋى" },
            { "Tang", "تانعۇت جازۋى" },
            { "Tavt", "تاي ۆيەت جازۋى" },
            { "Tayo", "لاي تاي جازۋى" },
            { "Telu", "تەلۋگۋ جازۋى" },
            { "Tfng", "تيفيناگ جازۋى" },
            { "Tglg", "بايبايىن جازۋى" },
            { "Thaa", "تانا جازۋى" },
            { "Thai", "تاي جازۋى" },
            { "Tibt", "تيبەت جازۋى" },
            { "Tirh", "تيرحۋتا جازۋى" },
            { "Tnsa", "تاڭسا جازۋى" },
            { "Todr", "تودحري جازۋى" },
            { "Tols", "تولوڭ سيكي جازۋى" },
            { "Toto", "توتو جازۋى" },
            { "Tutg", "تۋلۋ-تيگالاري جازۋى" },
            { "Ugar", "ۋگاريت جازۋى" },
            { "Vaii", "ۆاي جازۋى" },
            { "Vith", "ۆيتكۋتي جازۋى" },
            { "Wara", "ۆاراڭ كشيتي جازۋى" },
            { "Wcho", "ۋانچو جازۋى" },
            { "Xpeo", "كونە پارسى جازۋو" },
            { "Xsux", "شۋمەر-اككاد سىنا جازۋى" },
            { "Yezi", "ەزيد جازۋى" },
            { "Yiii", "ي جازۋى" },
            { "Zanb", "زانابازار شارشى جازۋى" },
            { "Zinh", "مۇرا ەتىلگەن" },
            { "Zmth", "ماتەماتيكالىق جازۋ" },
            { "Zsye", "ەموجي" },
            { "Zsym", "تاڭبالار" },
            { "Zxxx", "جازۋسىز" },
            { "Zyyy", "جالپى" },
            { "Zzzz", "بەلگىسىز جازۋ" },
            { "fa_AF", "داري ءتىلى" },
            { "nl_BE", "فلاماند ءتىلى" },
            { "pt_BR", "برازيليالىق پورتۋگال ءتىلى" },
            { "pt_PT", "ەۋروپالىق پورتۋگال ءتىلى" },
            { "ro_MD", "مولدوۆان ءتىلى" },
            { "sw_CD", "كونگو سۋاحيلي ءتىلى" },
            { "%%1901", "ءداستۇرلى نەمىس جازۋى" },
            { "%%1994", "ستاندارتتى رەزيا جازۋى" },
            { "%%1996", "1996 جىلعا دەيىنگى نەمىس جازۋى" },
            { "ar_001", "قازىرگى ستاندارتتى اراب ءتىلى" },
            { "key.ca", "كۇنتىزبە" },
            { "key.cf", "اقشا ءپىشىمى" },
            { "key.co", "سۇرىپتاۋ رەتى" },
            { "key.cu", "اقشا" },
            { "key.em", "ەمودجي كورسەتىلىمى" },
            { "key.hc", "ۋاقىت فورماتى (12 نە 24)" },
            { "key.lb", "جولدى تاسىمالداۋ ءستيلى" },
            { "key.lw", "سوزدەردەگى جول بولىنىستەرى" },
            { "key.ms", "ولشەمدەر جۇيەسى" },
            { "key.nu", "ساندار" },
            { "key.ss", "قىسقارعان سوزدەن كەيىنگى سويلەم ءبولىنىسى" },
            { "nds_NL", "تومەنگى ساكسون ءتىلى" },
            { "%%ALUKU", "الۋكۋ ديالەكتىسى" },
            { "%%BARLA", "كابۋۆەرديانۋ بارلاۆەنتو ديالەكت توبى" },
            { "%%BCIAV", "بسياۆ" },
            { "%%BISKE", "سان-جورجو/ديلا ديالەكتىسى" },
            { "%%BLASL", "بلاسل" },
            { "%%BOONT", "بۋنتلينگ" },
            { "%%CORNU", "كورنۋ" },
            { "%%FODOM", "فودوم" },
            { "%%GALLO", "گاللو" },
            { "%%GHERD", "گحەرد" },
            { "%%JAUER", "ياۋەر" },
            { "%%KKCOR", "جالپى جازۋ" },
            { "%%KSCOR", "ستاندارتتى جازۋ" },
            { "%%LIPAW", "رەزيا ءتىلىنىڭ ليپوۆاز ديالەكتىسى" },
            { "%%NEDIS", "ناتيسون ديالەكتىسى" },
            { "%%NJIVA", "گنيۆا/نجيۆا ديالەكتىسى" },
            { "%%NULIK", "زاماناۋي ۆولاپيۋك" },
            { "%%OSOJS", "وسەاككو/وسوجانە ديالەكتىسى" },
            { "%%PEANO", "پەانو" },
            { "%%POSIX", "كومپيۋتەر" },
            { "%%PUTER", "پۋتەر" },
            { "%%RIGIK", "كلاسسيكالىق ۆولاپيۋك" },
            { "%%ROZAJ", "رەزيا" },
            { "%%RUMGR", "رۋمگر" },
            { "%%SAAHO", "ساحو" },
            { "%%SOLBA", "ستولۆيتسا/سولبيكا ديالەكتىسى" },
            { "%%SOTAV", "كابۋۆەرديانۋدىڭ سوتاۆەنتو ديالەكت توبى" },
            { "%%TAILO", "تايلو" },
            { "%%UCCOR", "بىرىڭعاي جازۋ" },
            { "kk_Arab", "قازاق ءتىلى (توتە)" },
            { "zh_Hans", "جەڭىلدەتىلگەن قىتاي ءتىلى" },
            { "zh_Hant", "ءداستۇرلى قىتاي ءتىلى" },
            { "%%ANPEZO", "انپەزو" },
            { "%%AO1990", "پورتۋگال ءتىلىنىڭ 1990 جىلعى جازۋ كەلىسىمى" },
            { "%%ARANES", "اران" },
            { "%%ASANTE", "باتىس ارميان" },
            { "%%AUVERN", "وۆەرن" },
            { "%%BCIZBL", "بسيزبل" },
            { "%%CISAUP", "سيزاۋپ" },
            { "%%CREISS", "كرەيس" },
            { "%%DAJNKO", "داينكو ءالىپبيى" },
            { "%%EKAVSK", "سەرب ءتىلىنىڭ ەكاۆ ايتىلىمى" },
            { "%%FASCIA", "فاسكيا" },
            { "%%FONIPA", "حالىقارالىق فونەتيكالىق ءالىپبي" },
            { "%%FONUPA", "ورال فونەتيكالىق ءالىپبي" },
            { "%%GASCON", "گاسكون" },
            { "%%GRITAL", "گريتال" },
            { "%%NDYUKA", "نديۋكا" },
            { "%%NICARD", "نيكارد" },
            { "%%PAMAKA", "پاماكا ديالەكتىسى" },
            { "%%PINYIN", "پينين رومانيزاسياسى" },
            { "%%SCOUSE", "سكاۋس" },
            { "%%SIMPLE", "قاراپايىم" },
            { "%%TARASK", "تاراشكەۆيتسا" },
            { "%%UCRCOR", "بىرىڭعاي قايتا قارالعان جازۋ" },
            { "%%ULSTER", "ولستەر" },
            { "%%UNIFON", "يۋنيفون فونەتيكالىق ءالىپبيى" },
            { "%%ABL1943", "1943 جىلعى جازۋدىڭ قالىپتاسۋى" },
            { "%%AKUAPEM", "اكۋاپەم" },
            { "%%ALALC97", "ALA-LC رومانيزاتسياسى، 1997 جىلعى نۇسقا" },
            { "%%ARKAIKA", "شىعىس ارميان" },
            { "%%BALANKA", "انيي بالانكا ديالەكتىسى" },
            { "%%BAUDDHA", "باددا" },
            { "%%BOHORIC", "بوحوريچا ءالىپبيى" },
            { "%%EMODENG", "ەرتە ورتا اعىلشىن ءتىلى" },
            { "%%FONNAPA", "فونناپا" },
            { "%%GRCLASS", "گ ر ك ل ا س س" },
            { "%%GRMISTR", "گ ر م ي س ت ر" },
            { "%%HEPBURN", "حەپبيورن جۇيەسى" },
            { "%%ITIHASA", "يتيحاسا" },
            { "%%LAUKIKA", "لاۋكيكا" },
            { "%%LEMOSIN", "ليمۋزەن" },
            { "%%LTG1929", "لتگ1929" },
            { "%%LTG2007", "لتگ2007" },
            { "%%METELKO", "مەتەلكو" },
            { "%%MONOTON", "مونوتوندى" },
            { "%%PAHAWH2", "پاحاۋح2" },
            { "%%PAHAWH3", "پاحاۋح3" },
            { "%%PAHAWH4", "پاحاۋح4" },
            { "%%PEHOEJI", "پەحوەيي" },
            { "%%POLYTON", "پوليتوندى" },
            { "%%PROVENC", "پروۆانس" },
            { "%%REVISED", "قايتا قارالعان جازۋ" },
            { "%%SURSILV", "سۋرسيلۆ" },
            { "%%SUTSILV", "سۋتسيلۆ" },
            { "%%VAIDIKA", "ۆايديكا" },
            { "%%1606NICT", "1606 جىلعا دەيىنگى بەرگى ورتا فرانتسۋز ءتىلى" },
            { "%%1694ACAD", "ەرتە ورتا فرانتسۋز ءتىلى" },
            { "%%1959ACAD", "اكادەميالىق" },
            { "%%BAKU1926", "جالپى تۇركى ءالىپبيى" },
            { "%%BASICENG", "بەيسيك-ەنگليش" },
            { "%%BISCAYAN", "بيسكاي" },
            { "%%BORNHOLM", "بورنحولم" },
            { "%%COLB1945", "1945 جىلعى برازيليالىق پورتۋگال ءتىلى كونۆەنتسياسى" },
            { "%%FONKIRSH", "فونكيرش" },
            { "%%FONXSAMP", "فونكسامپ" },
            { "%%HOGNORSK", "حەگنورسك" },
            { "%%HSISTEMO", "ح جۇيەسى" },
            { "%%IJEKAVSK", "سەرب ءتىلىنىڭ يەكاۆ ايتىلىمى" },
            { "%%IVANCHOV", "يۆانچوۆ" },
            { "%%JYUTPING", "يۋتپيڭ" },
            { "%%KOCIEWIE", "كوچەۋە" },
            { "%%LENGADOC", "لانگەدوك" },
            { "%%LUNA1918", "لۋنا1998" },
            { "%%NEWFOUND", "نيۋفاۋند" },
            { "%%OXENDICT", "اعىلشىن ءتىلىنىڭ وكسفورد سوزدىگىندەگى ەملەسى" },
            { "%%PETR1708", "پەتر1708" },
            { "%%SCOTLAND", "شوتلانديانىڭ ستاندارتتى اعىلشىن ءتىلى" },
            { "%%SPANGLIS", "سپانگليش" },
            { "%%SURMIRAN", "سۋرميران" },
            { "%%SYNNEJYL", "سيننەجيل" },
            { "%%TONGYONG", "توڭيوڭ" },
            { "%%TUNUMIIT", "تۋنۋمييت" },
            { "%%VALBADIA", "ۆالباديا" },
            { "%%VALENCIA", "ۆالەنسيا" },
            { "%%VALLADER", "ۆاللادەر" },
            { "%%VECDRUKA", "ۆەچدرۋكا" },
            { "%%VIVARAUP", "ۆيۆارو-ءالپى" },
            { "%%WADEGILE", "ۋەيد-جايىلس جۇيەسى" },
            { "%%XSISTEMO", "X جۇيەسى" },
            { "type.ca.roc", "مينگۋو كۇنتىزبەسى" },
            { "type.co.eor", "ەۋروپالىق رەتتەۋ ەرەجەلەرى" },
            { "type.hc.h11", "12 ساعاتتىق جۇيە (0–11)" },
            { "type.hc.h12", "12 ساعاتتىق جۇيە (0–12)" },
            { "type.hc.h23", "24 ساعاتتىق جۇيە (0–23)" },
            { "type.hc.h24", "24 ساعاتتىق جۇيە (0–24)" },
            { "type.nu.ahom", "احوم تسيفرلارى" },
            { "type.nu.arab", "ءۇندى-اراب ساندارى" },
            { "type.nu.armn", "ارميان ساندارى" },
            { "type.nu.bali", "بالي ساندارى" },
            { "type.nu.beng", "بەنگال ساندارى" },
            { "type.nu.brah", "براحمي ساندارى" },
            { "type.nu.cakm", "چاكما ساندارى" },
            { "type.nu.cham", "چام ساندارى" },
            { "type.nu.cyrl", "كيريل ساندارى" },
            { "type.nu.deva", "دەۆاناگاري ساندارى" },
            { "type.nu.diak", "دەۆيس اكۋرۋ ساندارى" },
            { "type.nu.ethi", "ەفيوپيا ساندارى" },
            { "type.nu.gara", "گاراي ساندارى" },
            { "type.nu.geor", "گرۋزين ساندارى" },
            { "type.nu.gong", "گۋنجالا گوندي ساندارى" },
            { "type.nu.gonm", "ماساراما گوندي ساندارى" },
            { "type.nu.grek", "گرەك ساندارى" },
            { "type.nu.gujr", "گۋجاراتي ساندارى" },
            { "type.nu.gukh", "گۋرۋڭ حەما ساندارى" },
            { "type.nu.guru", "گۋرمۋكحي ساندارى" },
            { "type.nu.hans", "جەڭىلدەتىلگەن قىتاي ساندارى" },
            { "type.nu.hant", "ءداستۇرلى قىتاي ساندارى" },
            { "type.nu.hebr", "يۆريت ساندارى" },
            { "type.nu.hmng", "پاحاۋ ساندارى" },
            { "type.nu.hmnp", "نياكەڭ پۋاچۋە حموڭ ساندارى" },
            { "type.nu.java", "ياۆا ساندارى" },
            { "type.nu.jpan", "جاپون ساندارى" },
            { "type.nu.kali", "كاياح لي ساندارى" },
            { "type.nu.kawi", "كاۋي ساندارى" },
            { "type.nu.khmr", "كحمەر ساندارى" },
            { "type.nu.knda", "كاننادا ساندارى" },
            { "type.nu.krai", "كيرات راي ساندارى" },
            { "type.nu.lana", "تاي تحام حورا ساندارى" },
            { "type.nu.laoo", "لاوس ساندارى" },
            { "type.nu.latn", "باتىس ساندارى" },
            { "type.nu.lepc", "لەپچا ساندارى" },
            { "type.nu.limb", "ليمبۋ ساندارى" },
            { "type.nu.mlym", "مالايالام ساندارى" },
            { "type.nu.modi", "مودي ساندارى" },
            { "type.nu.mong", "موڭعول ساندارى" },
            { "type.nu.mroo", "مرو ساندارى" },
            { "type.nu.mtei", "مەيتەي-مايەك ساندارى" },
            { "type.nu.mymr", "ميانمار ساندارى" },
            { "type.nu.nagm", "ناگ مۋنداري ساندارى" },
            { "type.nu.nkoo", "نكو ساندارى" },
            { "type.nu.olck", "ول-چيكي ساندارى" },
            { "type.nu.onao", "ول-ونال ساندارى" },
            { "type.nu.orya", "وريا ساندارى" },
            { "type.nu.osma", "يسمانيا ساندارى" },
            { "type.nu.rohg", "حانيفي ساندارى" },
            { "type.nu.saur", "ساۋراشترا ساندارى" },
            { "type.nu.shrd", "شارادا ساندارى" },
            { "type.nu.sind", "كحۋدابادي ساندارى" },
            { "type.nu.sinh", "سينگالا ليت ساندارى" },
            { "type.nu.sora", "سورا سومپەڭ ساندارى" },
            { "type.nu.sund", "سۋندا ساندارى" },
            { "type.nu.sunu", "سۋنۋار ساندارى" },
            { "type.nu.takr", "تاكري ساندارى" },
            { "type.nu.talu", "جاڭا لۋ جازۋىنىڭ ساندارى" },
            { "type.nu.taml", "ءداستۇرلى تاميل ساندارى" },
            { "type.nu.telu", "تەلۋگۋ ساندارى" },
            { "type.nu.thai", "تاي ساندارى" },
            { "type.nu.tibt", "تيبەر ساندارى" },
            { "type.nu.tirh", "تيرحۋتا ساندارى" },
            { "type.nu.tnsa", "تاڭسا ساندارى" },
            { "type.nu.vaii", "ۆاي ساندارى" },
            { "type.nu.wara", "ۋاراڭ سيتي ساندارى" },
            { "type.nu.wcho", "ۋانچو ساندارى" },
            { "type.ca.dangi", "دانگي كۇنتىزبەسى" },
            { "type.co.ducet", "ادەپكى ۋنيكود سۇرىپتاۋ رەتى" },
            { "type.co.emoji", "ەموجي سۇرىپتاۋ رەتى" },
            { "type.lb.loose", "جولدى تاسىمالداۋدىڭ ەركىن ءستيلى" },
            { "type.nu.roman", "ريم ساندارى" },
            { "type.ca.coptic", "كوپت كۇنتىزبەسى" },
            { "type.ca.hebrew", "كونە ەۆرەي كۇنتىزبەسى" },
            { "type.ca.indian", "ءۇندىستاننىڭ ۇلتتىق كۇنتىزبەسى" },
            { "type.co.compat", "سايكەستىككە ارنالعان الدىڭعى سۇرىپتاۋ رەتى" },
            { "type.co.pinyin", "پينين سۇرىپتاۋ رەتى" },
            { "type.co.search", "جالپى ماقساتتاعى ىزدەۋ" },
            { "type.co.stroke", "يەروگليفتەر سىزىقتارىن سۇرىپتاۋ رەتى" },
            { "type.co.unihan", "يەروگليفتەر سىزىقتارىن تۇبەگەيلى سۇرىپتاۋ رەتى" },
            { "type.co.zhuyin", "جۋين سۇرىپتاۋ رەتى" },
            { "type.lb.normal", "جولدى تاسىمالداۋدىڭ قالىپتى ءستيلى" },
            { "type.lb.strict", "جولدى تاسىمالداۋدىڭ قاتاڭ ءستيلى" },
            { "type.ms.metric", "مەترلىك جۇيە" },
            { "type.ca.chinese", "قىتاي كۇنتىزبەسى" },
            { "type.ca.islamic", "يسلام كۇنتىزبەسى" },
            { "type.ca.iso8601", "ISO-8601 كۇنتىزبەسى" },
            { "type.ca.persian", "پارسى كۇنتىزبەسى" },
            { "type.cf.account", "ەسەپتىك اقشا ءپىشىمى" },
            { "type.nu.arabext", "ءۇندى-اراب ساندارىنىڭ كەڭەيتىلگەن جۇيەسى" },
            { "type.nu.armnlow", "كىشى ارىپپەن بەرىلگەن ارميان ساندارى" },
            { "type.nu.greklow", "كىشى ارىپپەن بەرىلگەن گرەك ساندارى" },
            { "type.nu.hanidec", "قىتاي وندىق ساندارى" },
            { "type.nu.hansfin", "قارجى سالاسىنداعى جەڭىلدەتىلگەن قىتاي ساندارى" },
            { "type.nu.hantfin", "قارجى سالاسىنداعى ءداستۇرلى قىتاي ساندارى" },
            { "type.nu.jpanfin", "قارجى سالاسىنداعى جاپون ساندارى" },
            { "type.nu.mathdbl", "ماتەماتيكالىق قوس سىزىقتى ساندار" },
            { "type.nu.mymrpao", "ميانمار پاو ساندارى" },
            { "type.nu.tamldec", "تاميل ساندارى" },
            { "type.ca.buddhist", "بۋددا كۇنتىزبەسى" },
            { "type.ca.ethiopic", "ەفيوپيا كۇنتىزبەسى" },
            { "type.ca.japanese", "جاپون كۇنتىزبەسى" },
            { "type.cf.standard", "ستاندارتتى اقشا ءپىشىمى" },
            { "type.co.searchjl", "كورەي ءتىلىنىڭ باستاپقى داۋىسسىزى بويىنشا ىزدەۋ" },
            { "type.co.standard", "ستاندارتتى سۇرىپتاۋ رەتى" },
            { "type.ms.uksystem", "بريتانيالىق ولشەمدەر جۇيەسى" },
            { "type.ms.ussystem", "امەريكالىق ولشەمدەر جۇيەسى" },
            { "type.nu.fullwide", "تولىق ەندى ساندار" },
            { "type.nu.lanatham", "تاي تحام تحام ساندارى" },
            { "type.nu.mathbold", "ماتەماتيكالىق قالىڭ قارىپتى ساندار" },
            { "type.nu.mathmono", "ەنى بەكىتىلگەن ماتەماتيكالىق ساندار" },
            { "type.nu.mathsanb", "ماتەماتيكالىق قالىڭ قارىپتى سانسەريف ساندار" },
            { "type.nu.mathsans", "ماتەماتيكالىق سانسەريف ساندار" },
            { "type.nu.mymrepka", "ميانمار شىعىس پحو كارەن ساندارى" },
            { "type.nu.mymrshan", "ميانمار شان ساندارى" },
            { "type.nu.mymrtlng", "ميانمار تاي لايڭ ساندارى" },
            { "type.nu.outlined", "سىزىلعان ساندار" },
            { "type.nu.romanlow", "كىشى ارىپپەن بەرىلگەن ريم ساندارى" },
            { "type.ca.gregorian", "گرەگورياندىق كۇنتىزبە" },
            { "type.co.phonebook", "تەلەفون كىتاپشاسىنىڭ سۇرىپتاۋ رەتى" },
            { "type.co.dictionary", "سوزدىك بويىنشا سۇرىپتاۋ رەتى" },
            { "type.co.traditional", "ءداستۇرلى سۇرىپتاۋ رەتى" },
            { "type.ca.islamic-rgsa", "يسلام كۇنتىزبەسى (ساۋد ارابياسى، جاڭا اي)" },
            { "type.ca.islamic-tbla", "يسلام كۇنتىزبەسى (كەستەلىك، استرونوميالىق ءداۋىر)" },
            { "type.ca.islamic-civil", "يسلام كۇنتىزبەسى (كەستەلىك، ازاماتتىق ءداۋىر)" },
            { "ListCompositionPattern", "{0}، {1}" },
            { "type.ca.islamic-umalqura", "يسلام كۇنتىزبەسى (ۋمم ءال-قۇرا)" },
            { "type.ca.ethiopic-amete-alem", "ەفيوپيانىڭ امەتە-الەم كۇنتىزبەسى" },
        };
        return data;
    }
}
