/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.notebooks.visualization.InlaysChangedListener;
import com.intellij.notebooks.visualization.UpdateContext;
import com.intellij.notebooks.visualization.inlay.JupyterBoundsChangeHandler;
import com.intellij.notebooks.visualization.ui.NotebookEditorKt;
import com.intellij.notebooks.visualization.ui.UpdateManagerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.UserDataHolder;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JH\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u000b2\b\b\u0002\u0010\u0017\u001a\u00020\u000b2!\u0010\u0018\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\b\u0012\u0004\u0012\u0002H\u00150\u0019\u00a2\u0006\u0002\u0010\u001cJ>\u0010\u001d\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u001e\u001a\u00020\t2!\u0010\u0018\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\b\u0012\u0004\u0012\u0002H\u00150\u0019H\u0002\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020!H\u0002J\b\u0010#\u001a\u00020!H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006$"}, d2={"Lcom/intellij/notebooks/visualization/ui/UpdateManager;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "updateCtx", "Lcom/intellij/notebooks/visualization/UpdateContext;", "editorIsProcessingDocument", "", "postponedUpdates", "", "changedListener", "Lcom/intellij/notebooks/visualization/InlaysChangedListener;", "getChangedListener", "()Lcom/intellij/notebooks/visualization/InlaysChangedListener;", "setChangedListener", "(Lcom/intellij/notebooks/visualization/InlaysChangedListener;)V", "update", "T", "force", "keepScrollingPositon", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "(ZZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "updateImpl", "newCtx", "(Lcom/intellij/notebooks/visualization/UpdateContext;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "finalizeChanges", "", "inlaysChanged", "dispose", "intellij.notebooks.visualization"})
public final class UpdateManager
implements Disposable {
    @NotNull
    private final EditorImpl editor;
    @Nullable
    private UpdateContext updateCtx;
    private boolean editorIsProcessingDocument;
    @NotNull
    private List<UpdateContext> postponedUpdates;
    @Nullable
    private InlaysChangedListener changedListener;

    public UpdateManager(@NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        this.postponedUpdates = new ArrayList();
        this.editor.getDocument().addDocumentListener((DocumentListener)new BulkAwareDocumentListener.Simple(){

            public void beforeDocumentChange(Document document) {
                Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                editorIsProcessingDocument = true;
            }

            /*
             * WARNING - void declaration
             */
            public void afterDocumentChange(Document document) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                editorIsProcessingDocument = false;
                Iterable iterable = postponedUpdates;
                UpdateManager updateManager = this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    UpdateContext it = (UpdateContext)element$iv;
                    boolean bl = false;
                    it.applyUpdates((Editor)updateManager.getEditor());
                }
                postponedUpdates.clear();
                this.finalizeChanges();
            }
        }, (Disposable)this);
        UpdateManagerKt.access$getUPDATE_MANAGER_KEY$p().set((UserDataHolder)this.editor, (Object)this);
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    @Nullable
    public final InlaysChangedListener getChangedListener() {
        return this.changedListener;
    }

    public final void setChangedListener(@Nullable InlaysChangedListener inlaysChangedListener) {
        this.changedListener = inlaysChangedListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T update(boolean force, boolean keepScrollingPositon, @NotNull Function1<? super UpdateContext, ? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        UpdateContext ctx = this.updateCtx;
        if (ctx != null) {
            object = block.invoke((Object)ctx);
        } else {
            T t;
            UpdateContext newCtx;
            this.updateCtx = newCtx = new UpdateContext(force);
            try {
                t = keepScrollingPositon ? NotebookEditorKt.getNotebookEditor((Editor)this.editor).getEditorPositionKeeper().keepScrollingPositionWhile(() -> UpdateManager.update$lambda$0(this, newCtx, block)) : this.updateImpl(newCtx, block);
            }
            finally {
                this.updateCtx = null;
            }
            object = t;
        }
        return (T)object;
    }

    public static /* synthetic */ Object update$default(UpdateManager updateManager, boolean bl, boolean bl2, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return updateManager.update(bl, bl2, function1);
    }

    private final <T> T updateImpl(UpdateContext newCtx, Function1<? super UpdateContext, ? extends T> block) {
        JupyterBoundsChangeHandler jupyterBoundsChangeHandler = JupyterBoundsChangeHandler.Companion.get((Editor)this.editor);
        jupyterBoundsChangeHandler.postponeUpdates();
        Object r = block.invoke((Object)newCtx);
        this.updateCtx = null;
        if (this.editorIsProcessingDocument) {
            this.postponedUpdates.add(newCtx);
        } else {
            newCtx.applyUpdates((Editor)this.editor);
            this.finalizeChanges();
        }
        return (T)r;
    }

    private final void finalizeChanges() {
        this.inlaysChanged();
        JupyterBoundsChangeHandler jupyterBoundsChangeHandler = JupyterBoundsChangeHandler.Companion.get((Editor)this.editor);
        jupyterBoundsChangeHandler.boundsChanged();
        jupyterBoundsChangeHandler.performPostponed();
    }

    private final void inlaysChanged() {
        block0: {
            InlaysChangedListener inlaysChangedListener = this.changedListener;
            if (inlaysChangedListener == null) break block0;
            inlaysChangedListener.inlaysChanged();
        }
    }

    public void dispose() {
    }

    private static final Object update$lambda$0(UpdateManager this$0, UpdateContext $newCtx, Function1 $block) {
        return this$0.updateImpl($newCtx, $block);
    }
}

