/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.remote;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.FileDownloadingAdapter;
import com.intellij.openapi.vfs.impl.http.FileDownloadingListener;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteContentProvider;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import com.intellij.openapi.vfs.impl.http.RemoteFileManager;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.JsonSchemaCatalogEntry;
import com.jetbrains.jsonSchema.JsonSchemaCatalogProjectConfiguration;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonCachedValues;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import com.jetbrains.jsonSchema.remote.JsonSchemaCatalogExclusion;
import com.jetbrains.jsonSchema.remote.JsonSchemaRemoteContentProvider;
import java.nio.file.FileSystems;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class JsonSchemaCatalogManager {
    static final String DEFAULT_CATALOG = "http://schemastore.org/api/json/catalog.json";
    static final String DEFAULT_CATALOG_HTTPS = "https://schemastore.org/api/json/catalog.json";
    private static final Set<String> SCHEMA_URL_PREFIXES_WITH_TOO_MANY_VARIANTS = Set.of("https://raw.githubusercontent.com/microsoft/azure-pipelines-vscode/");
    @NotNull
    private final Project myProject;
    @NotNull
    private final JsonSchemaRemoteContentProvider myRemoteContentProvider;
    @Nullable
    private VirtualFile myCatalog;
    @NotNull
    private final ConcurrentMap<VirtualFile, String> myResolvedMappings;
    private static final String NO_CACHE = "$_$_WS_NO_CACHE_$_$";
    private static final String EMPTY = "$_$_WS_EMPTY_$_$";
    private VirtualFile myTestSchemaStoreFile;
    private final Map<Runnable, FileDownloadingAdapter> myDownloadingAdapters;

    public JsonSchemaCatalogManager(@NotNull Project project) {
        if (project == null) {
            JsonSchemaCatalogManager.$$$reportNull$$$0(0);
        }
        this.myCatalog = null;
        this.myResolvedMappings = ContainerUtil.createConcurrentSoftMap();
        this.myDownloadingAdapters = CollectionFactory.createConcurrentWeakMap();
        this.myProject = project;
        this.myRemoteContentProvider = new JsonSchemaRemoteContentProvider();
    }

    public void startUpdates() {
        JsonSchemaCatalogProjectConfiguration.getInstance(this.myProject).addChangeHandler(() -> {
            this.update();
            JsonSchemaService.Impl.get(this.myProject).reset();
        });
        RemoteFileManager instance = RemoteFileManager.getInstance();
        instance.addRemoteContentProvider((RemoteContentProvider)this.myRemoteContentProvider);
        this.update();
    }

    private void update() {
        Application application = ApplicationManager.getApplication();
        if (application != null && application.isUnitTestMode()) {
            this.myCatalog = this.myTestSchemaStoreFile;
            return;
        }
        this.myCatalog = !JsonFileResolver.isRemoteEnabled(this.myProject) ? null : JsonFileResolver.urlToFile(DEFAULT_CATALOG);
    }

    @TestOnly
    public void registerTestSchemaStoreFile(@NotNull VirtualFile testSchemaStoreFile, @NotNull Disposable testDisposable) {
        if (testSchemaStoreFile == null) {
            JsonSchemaCatalogManager.$$$reportNull$$$0(1);
        }
        if (testDisposable == null) {
            JsonSchemaCatalogManager.$$$reportNull$$$0(2);
        }
        this.myTestSchemaStoreFile = testSchemaStoreFile;
        Disposer.register((Disposable)testDisposable, () -> {
            this.myTestSchemaStoreFile = null;
            this.update();
        });
        this.update();
    }

    @Nullable
    public VirtualFile getSchemaFileForFile(@NotNull VirtualFile file) {
        if (file == null) {
            JsonSchemaCatalogManager.$$$reportNull$$$0(3);
        }
        if (!JsonSchemaCatalogProjectConfiguration.getInstance(this.myProject).isCatalogEnabled()) {
            return null;
        }
        if (JsonSchemaCatalogExclusion.EP_NAME.findFirstSafe(exclusion -> exclusion.isExcluded(file)) != null) {
            return null;
        }
        String schemaUrl = (String)this.myResolvedMappings.get(file);
        if (EMPTY.equals(schemaUrl)) {
            return null;
        }
        if (schemaUrl == null && this.myCatalog != null) {
            schemaUrl = JsonSchemaCatalogManager.resolveSchemaFile(file, this.myCatalog, this.myProject);
            if (NO_CACHE.equals(schemaUrl)) {
                return null;
            }
            this.myResolvedMappings.put(file, StringUtil.notNullize((String)schemaUrl, (String)EMPTY));
        }
        if (schemaUrl == null || JsonSchemaCatalogManager.isIgnoredAsHavingTooManyVariants(schemaUrl)) {
            return null;
        }
        return JsonFileResolver.resolveSchemaByReference(file, schemaUrl);
    }

    private static boolean isIgnoredAsHavingTooManyVariants(@NotNull String schemaUrl) {
        if (schemaUrl == null) {
            JsonSchemaCatalogManager.$$$reportNull$$$0(4);
        }
        return ContainerUtil.exists(SCHEMA_URL_PREFIXES_WITH_TOO_MANY_VARIANTS, prefix -> schemaUrl.startsWith((String)prefix));
    }

    public List<JsonSchemaCatalogEntry> getAllCatalogEntries() {
        if (this.myCatalog != null) {
            List<JsonSchemaCatalogEntry> catalog = JsonCachedValues.getSchemaCatalog(this.myCatalog, this.myProject);
            return catalog == null ? ContainerUtil.emptyList() : catalog;
        }
        return ContainerUtil.emptyList();
    }

    public void registerCatalogUpdateCallback(final @NotNull Runnable callback) {
        RemoteFileInfo info;
        if (callback == null) {
            JsonSchemaCatalogManager.$$$reportNull$$$0(5);
        }
        if (this.myCatalog instanceof HttpVirtualFile && (info = ((HttpVirtualFile)this.myCatalog).getFileInfo()) != null) {
            FileDownloadingAdapter adapter = new FileDownloadingAdapter(){

                public void fileDownloaded(@NotNull VirtualFile localFile) {
                    if (localFile == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    callback.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localFile", "com/jetbrains/jsonSchema/remote/JsonSchemaCatalogManager$1", "fileDownloaded"));
                }
            };
            this.myDownloadingAdapters.put(callback, adapter);
            info.addDownloadingListener((FileDownloadingListener)adapter);
        }
    }

    public void unregisterCatalogUpdateCallback(@NotNull Runnable callback) {
        RemoteFileInfo info;
        if (callback == null) {
            JsonSchemaCatalogManager.$$$reportNull$$$0(6);
        }
        if (!this.myDownloadingAdapters.containsKey(callback)) {
            return;
        }
        if (this.myCatalog instanceof HttpVirtualFile && (info = ((HttpVirtualFile)this.myCatalog).getFileInfo()) != null) {
            info.removeDownloadingListener((FileDownloadingListener)this.myDownloadingAdapters.get(callback));
        }
    }

    public void triggerUpdateCatalog(Project project) {
        JsonFileResolver.startFetchingHttpFileIfNeeded(this.myCatalog, project);
    }

    @Nullable
    private static String resolveSchemaFile(@NotNull VirtualFile file, @NotNull VirtualFile catalogFile, @NotNull Project project) {
        String fileName;
        String fileRelativePathStr;
        if (file == null) {
            JsonSchemaCatalogManager.$$$reportNull$$$0(7);
        }
        if (catalogFile == null) {
            JsonSchemaCatalogManager.$$$reportNull$$$0(8);
        }
        if (project == null) {
            JsonSchemaCatalogManager.$$$reportNull$$$0(9);
        }
        JsonFileResolver.startFetchingHttpFileIfNeeded(catalogFile, project);
        List<JsonSchemaCatalogEntry> schemaCatalog = JsonCachedValues.getSchemaCatalog(catalogFile, project);
        if (schemaCatalog == null) {
            return catalogFile instanceof HttpVirtualFile ? NO_CACHE : null;
        }
        List fileMatchers = ContainerUtil.map(schemaCatalog, entry -> new FileMatcher((JsonSchemaCatalogEntry)entry));
        String url = JsonSchemaCatalogManager.findMatchedUrl(fileMatchers, fileRelativePathStr = JsonSchemaCatalogManager.getRelativePath(file, project));
        if (url == null && !(fileName = file.getName()).equals(fileRelativePathStr)) {
            url = JsonSchemaCatalogManager.findMatchedUrl(fileMatchers, fileName);
        }
        return url;
    }

    @Nullable
    private static String findMatchedUrl(@NotNull List<FileMatcher> matchers, @Nullable String filePath) {
        Path path;
        if (matchers == null) {
            JsonSchemaCatalogManager.$$$reportNull$$$0(10);
        }
        if (filePath == null) {
            return null;
        }
        try {
            path = Paths.get(filePath, new String[0]);
        }
        catch (InvalidPathException e) {
            return null;
        }
        for (FileMatcher matcher : matchers) {
            if (!matcher.matches(path)) continue;
            return matcher.myEntry.getUrl();
        }
        return null;
    }

    @Nullable
    private static String getRelativePath(@NotNull VirtualFile file, @NotNull Project project) {
        VirtualFile contentRoot;
        Object basePath;
        if (file == null) {
            JsonSchemaCatalogManager.$$$reportNull$$$0(11);
        }
        if (project == null) {
            JsonSchemaCatalogManager.$$$reportNull$$$0(12);
        }
        if ((basePath = project.getBasePath()) != null) {
            basePath = StringUtil.trimEnd((String)basePath, (char)'/') + "/";
            String filePath = file.getPath();
            if (filePath.startsWith((String)basePath)) {
                return filePath.substring(((String)basePath).length());
            }
        }
        return (contentRoot = (VirtualFile)ReadAction.compute(() -> {
            if (project.isDisposed() || !file.isValid()) {
                return null;
            }
            return ProjectFileIndex.getInstance((Project)project).getContentRootForFile(file, false);
        })) != null ? VfsUtilCore.findRelativePath((VirtualFile)contentRoot, (VirtualFile)file, (char)'/') : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testSchemaStoreFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDisposable";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaUrl";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catalogFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchers";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/remote/JsonSchemaCatalogManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "registerTestSchemaStoreFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getSchemaFileForFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isIgnoredAsHavingTooManyVariants";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "registerCatalogUpdateCallback";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterCatalogUpdateCallback";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveSchemaFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "findMatchedUrl";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getRelativePath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class FileMatcher {
        private final JsonSchemaCatalogEntry myEntry;
        private PathMatcher myMatcher;

        private FileMatcher(@NotNull JsonSchemaCatalogEntry entry) {
            if (entry == null) {
                FileMatcher.$$$reportNull$$$0(0);
            }
            this.myEntry = entry;
        }

        private boolean matches(@NotNull Path filePath) {
            if (filePath == null) {
                FileMatcher.$$$reportNull$$$0(1);
            }
            if (this.myMatcher == null) {
                this.myMatcher = FileMatcher.buildPathMatcher(this.myEntry.getFileMasks());
            }
            return this.myMatcher.matches(filePath);
        }

        @NotNull
        private static PathMatcher buildPathMatcher(@NotNull Collection<String> fileMasks) {
            List refinedFileMasks;
            if (fileMasks == null) {
                FileMatcher.$$$reportNull$$$0(2);
            }
            if ((refinedFileMasks = ContainerUtil.map(fileMasks, fileMask -> StringUtil.trimStart((String)fileMask, (String)"**/"))).size() == 1) {
                PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + (String)ContainerUtil.getFirstItem((List)refinedFileMasks));
                if (pathMatcher == null) {
                    FileMatcher.$$$reportNull$$$0(3);
                }
                return pathMatcher;
            }
            if (!refinedFileMasks.isEmpty()) {
                PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:{" + StringUtil.join((Collection)refinedFileMasks, (String)",") + "}");
                if (pathMatcher == null) {
                    FileMatcher.$$$reportNull$$$0(4);
                }
                return pathMatcher;
            }
            PathMatcher pathMatcher = path -> false;
            if (pathMatcher == null) {
                FileMatcher.$$$reportNull$$$0(5);
            }
            return pathMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileMasks";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/remote/JsonSchemaCatalogManager$FileMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/remote/JsonSchemaCatalogManager$FileMatcher";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildPathMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "buildPathMatcher";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

