/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.manage;

import com.intellij.commandInterface.command.Argument;
import com.intellij.commandInterface.command.ArgumentType;
import com.intellij.commandInterface.command.Help;
import com.intellij.commandInterface.command.Option;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DjangoOptionInfo {
    private static final String INT_TYPE = "int";
    private static final String CHOICES_TYPE = "choices";
    @XStreamAsAttribute
    @XStreamAlias(value="help")
    private String myHelp = "";
    @XStreamAsAttribute
    @XStreamAlias(value="numberOfArgs")
    private int myNumberOfArgs;
    @XStreamAsAttribute
    @XStreamAlias(value="type")
    @Nullable
    private String myType;
    @XStreamAsAttribute
    @XStreamImplicit(itemFieldName="choices")
    private String @Nullable [] myChoices;
    @XStreamAsAttribute
    @XStreamImplicit(itemFieldName="longNames")
    private String @Nullable [] myLongNames;
    @XStreamAsAttribute
    @XStreamImplicit(itemFieldName="shortNames")
    private String @Nullable [] myShortNames;

    DjangoOptionInfo() {
    }

    @NotNull
    Option createOption() {
        Pair<Integer, Argument> argumentAndQuantity;
        if (this.myNumberOfArgs == 0) {
            argumentAndQuantity = null;
        } else {
            assert (StringUtil.isNotEmpty((String)this.myType)) : "There are " + this.myNumberOfArgs + " args, but no type for " + Arrays.toString(this.myShortNames) + ", " + Arrays.toString(this.myLongNames);
            argumentAndQuantity = this.createArgumentAndQuantityForType(this.myType);
        }
        return new Option(argumentAndQuantity, new Help(this.myHelp), DjangoOptionInfo.emptyIfNull(this.myShortNames), DjangoOptionInfo.emptyIfNull(this.myLongNames));
    }

    @NotNull
    private static Collection<String> emptyIfNull(String @Nullable [] args) {
        List<String> list = args != null ? Arrays.asList(args) : Collections.emptyList();
        if (list == null) {
            DjangoOptionInfo.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    private Pair<Integer, Argument> createArgumentAndQuantityForType(@NotNull String type) {
        Argument optionArgumentInfo;
        if (type == null) {
            DjangoOptionInfo.$$$reportNull$$$0(1);
        }
        if (type.equals(INT_TYPE)) {
            optionArgumentInfo = new Argument(new Help(this.myHelp), ArgumentType.INTEGER);
        } else if (type.equals(CHOICES_TYPE)) {
            assert (this.myChoices != null) : "Choices type selected, but no choices provided";
            optionArgumentInfo = new Argument(new Help(this.myHelp), Pair.create(Arrays.asList(this.myChoices), (Object)true));
        } else {
            optionArgumentInfo = new Argument(new Help(this.myHelp), ArgumentType.STRING);
        }
        Pair pair = Pair.create((Object)this.myNumberOfArgs, (Object)optionArgumentInfo);
        if (pair == null) {
            DjangoOptionInfo.$$$reportNull$$$0(2);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/manage/DjangoOptionInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyIfNull";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/manage/DjangoOptionInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createArgumentAndQuantityForType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createArgumentAndQuantityForType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

