/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.api.layout.SharedIndexLocation;
import com.intellij.indexing.shared.platform.api.layout.SharedStubIndexLocation;
import com.intellij.indexing.shared.platform.impl.SharedIndexExtension;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.LanguageStubDescriptor;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.StubElementRegistryService;
import com.intellij.psi.stubs.StubForwardIndexExternalizer;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.IndexInfrastructureVersionBase;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.io.DataEnumerator;
import com.intellij.util.io.DataEnumeratorEx;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.InMemoryEnumerator;
import com.intellij.util.io.UnmodifiableEnumeratorWrapper;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubSharedIndexExtension
implements SharedIndexExtension<Integer, SerializedStubTree> {
    private static final Logger LOG = Logger.getInstance(StubSharedIndexExtension.class);
    private volatile StubUpdatingIndex myStubUpdatingIndex;
    private volatile SerializationManagerEx mySerializationManager;
    private volatile UsageTrackingEnumerator<String> myIndexIdEnumerator;
    private volatile StubBuilderVersionFilter myStubBuilderVersionFilter;
    private volatile boolean myStoreStubIndexKeysEnumerator = false;
    private volatile SharedStubIndexLocation indexRoot;

    @Override
    public void openResources(@NotNull SharedIndexLocation<Integer, SerializedStubTree> indexRoot, boolean readOnly, @NotNull SharedIndexInfrastructureVersion chunkVersion) {
        if (indexRoot == null) {
            StubSharedIndexExtension.$$$reportNull$$$0(0);
        }
        if (chunkVersion == null) {
            StubSharedIndexExtension.$$$reportNull$$$0(1);
        }
        this.indexRoot = (SharedStubIndexLocation)indexRoot;
        this.mySerializationManager = this.indexRoot.createSerializationManager(readOnly);
        UsageTrackingEnumerator<String> stubIndexKeyEnumerator = this.indexRoot.tryLoadStubIndexKeyEnumerator();
        if (stubIndexKeyEnumerator != null) {
            this.myStoreStubIndexKeysEnumerator = false;
            this.myIndexIdEnumerator = stubIndexKeyEnumerator;
        } else {
            this.myStoreStubIndexKeysEnumerator = true;
            this.myIndexIdEnumerator = StubSharedIndexExtension.createFreshStubIndexKeyEnumerator();
        }
        this.myStubUpdatingIndex = new StubUpdatingIndex((StubForwardIndexExternalizer)new StubExternalizerToStableBinary((DataEnumerator<String>)this.myIndexIdEnumerator), this.mySerializationManager);
        boolean prebuilt = indexRoot.isPrebuilt();
        this.myStubBuilderVersionFilter = readOnly ? new StubBuilderVersionFilter(chunkVersion, prebuilt) : null;
    }

    @Override
    public boolean acceptsInputFile(@NotNull IndexedFile file) {
        if (file == null) {
            StubSharedIndexExtension.$$$reportNull$$$0(2);
        }
        return this.myStubBuilderVersionFilter.acceptsFileType(file.getFileType());
    }

    @Override
    public void closeResources() {
        SerializationManagerEx serializationManagerEx;
        boolean storeStubIndexKeysEnumeratorToPath = this.myStoreStubIndexKeysEnumerator;
        if (storeStubIndexKeysEnumeratorToPath) {
            try {
                this.myIndexIdEnumerator.saveActuallyUsedValues(this.indexRoot);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Can't store stubIndexKey enumerator to " + storeStubIndexKeysEnumeratorToPath, e);
            }
        }
        if ((serializationManagerEx = this.mySerializationManager) instanceof Disposable) {
            Disposable disposable = (Disposable)serializationManagerEx;
            Disposer.dispose((Disposable)disposable);
        }
    }

    @Override
    @NotNull
    public FileBasedIndexExtension<Integer, SerializedStubTree> getFileBasedIndexExtension() {
        StubUpdatingIndex stubUpdatingIndex = this.myStubUpdatingIndex;
        if (stubUpdatingIndex == null) {
            StubSharedIndexExtension.$$$reportNull$$$0(3);
        }
        return stubUpdatingIndex;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @NotNull
    private static UsageTrackingEnumerator<String> createFreshStubIndexKeyEnumerator() {
        List<String> allStubIndexKeyNames = ID.getRegisteredIds().stream().filter(id -> id instanceof StubIndexKey).map(IndexId::getName).sorted().toList();
        UsageTrackingEnumerator<String> usageTrackingEnumerator = UsageTrackingEnumerator.createFromValues(allStubIndexKeyNames);
        if (usageTrackingEnumerator == null) {
            StubSharedIndexExtension.$$$reportNull$$$0(4);
        }
        return usageTrackingEnumerator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexRoot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunkVersion";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/impl/StubSharedIndexExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/impl/StubSharedIndexExtension";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileBasedIndexExtension";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createFreshStubIndexKeyEnumerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "openResources";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "acceptsInputFile";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    public static class UsageTrackingEnumerator<Data>
    implements DataEnumeratorEx<Data> {
        private final InMemoryEnumerator<Data> enumerator = new InMemoryEnumerator();
        private final UnmodifiableEnumeratorWrapper<Data> unmodifiableWrapper = new UnmodifiableEnumeratorWrapper(this.enumerator);
        private final IntSet actuallyUsedIds = new IntOpenHashSet();

        private UsageTrackingEnumerator(Iterable<com.intellij.openapi.util.Pair<Integer, Data>> idsAndValues) {
            for (com.intellij.openapi.util.Pair<Integer, Data> pair : idsAndValues) {
                int id = (Integer)pair.first;
                Object value = pair.second;
                this.enumerator.registerValueWithGivenId(id, value, false);
            }
        }

        public synchronized int enumerate(@Nullable Data value) throws IOException {
            int id = this.unmodifiableWrapper.tryEnumerate(value);
            this.actuallyUsedIds.add(id);
            return id;
        }

        public synchronized int tryEnumerate(@Nullable Data value) throws IOException {
            int id = this.unmodifiableWrapper.tryEnumerate(value);
            if (id != 0) {
                this.actuallyUsedIds.add(id);
            }
            return id;
        }

        @Nullable
        public synchronized Data valueOf(int id) throws IOException {
            return (Data)this.unmodifiableWrapper.valueOf(id);
        }

        public void saveActuallyUsedValues(@NotNull SharedStubIndexLocation indexLocation) throws IOException {
            if (indexLocation == null) {
                UsageTrackingEnumerator.$$$reportNull$$$0(0);
            }
            List<Pair<Integer, String>> csvLines = this.actuallyUsedIds.intStream().sorted().mapToObj(id -> new Pair((Object)id, (Object)String.valueOf(this.enumerator.valueOf(id)))).toList();
            indexLocation.saveActuallyUsedStubIndexNames(csvLines);
        }

        public static UsageTrackingEnumerator<String> createFromLegacyTextFile(@NotNull Path stubIndexTxtPath) throws IOException {
            if (stubIndexTxtPath == null) {
                UsageTrackingEnumerator.$$$reportNull$$$0(1);
            }
            List<String> values = Files.readAllLines(stubIndexTxtPath);
            return UsageTrackingEnumerator.createFromValues(values);
        }

        public static UsageTrackingEnumerator<String> createFromCsvFile(@NotNull Path stubIndexCsvPath) throws IOException {
            if (stubIndexCsvPath == null) {
                UsageTrackingEnumerator.$$$reportNull$$$0(2);
            }
            List<String> values = Files.readAllLines(stubIndexCsvPath);
            List idsAndValues = ContainerUtil.map(values, line -> {
                int separatorIndex = line.indexOf(44);
                int id = Integer.parseInt(line.substring(0, separatorIndex));
                String value = line.substring(separatorIndex + 1);
                return new com.intellij.openapi.util.Pair((Object)id, (Object)value);
            });
            return new UsageTrackingEnumerator<String>(idsAndValues);
        }

        public static UsageTrackingEnumerator<String> createFromValues(@NotNull List<String> valuesKnownInAdvance) {
            if (valuesKnownInAdvance == null) {
                UsageTrackingEnumerator.$$$reportNull$$$0(3);
            }
            ArrayList idsAndValues = new ArrayList();
            int id = 1;
            for (String value : valuesKnownInAdvance) {
                idsAndValues.add(new com.intellij.openapi.util.Pair((Object)id, (Object)value));
                ++id;
            }
            return new UsageTrackingEnumerator<String>(idsAndValues);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indexLocation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stubIndexTxtPath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stubIndexCsvPath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valuesKnownInAdvance";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/indexing/shared/platform/impl/StubSharedIndexExtension$UsageTrackingEnumerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "saveActuallyUsedValues";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createFromLegacyTextFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createFromCsvFile";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createFromValues";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class StubExternalizerToStableBinary
    extends StubForwardIndexExternalizer<Void> {
        @NotNull
        private final DataEnumerator<String> indexIdEnumerator;

        public StubExternalizerToStableBinary(@NotNull DataEnumerator<String> indexIdEnumerator) {
            if (indexIdEnumerator == null) {
                StubExternalizerToStableBinary.$$$reportNull$$$0(0);
            }
            super(true);
            this.indexIdEnumerator = indexIdEnumerator;
        }

        protected void writeStubIndexKey(@NotNull DataOutput out, @NotNull StubIndexKey key, Void unused) throws IOException {
            if (out == null) {
                StubExternalizerToStableBinary.$$$reportNull$$$0(1);
            }
            if (key == null) {
                StubExternalizerToStableBinary.$$$reportNull$$$0(2);
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)this.indexIdEnumerator.enumerate((Object)key.getName()));
        }

        protected ID<?, ?> readStubIndexKey(@NotNull DataInput input, Void unused) throws IOException {
            int indexId;
            String name;
            if (input == null) {
                StubExternalizerToStableBinary.$$$reportNull$$$0(3);
            }
            if ((name = (String)this.indexIdEnumerator.valueOf(indexId = DataInputOutputUtil.readINT((DataInput)input))) == null) {
                throw new IOException("index name can't be found for indexId(=" + indexId + ")");
            }
            ID id = ID.findByName((String)name);
            if (!(id instanceof StubIndexKey)) {
                LOG.warn("id with name `" + name + "`, enumerated id " + indexId + " is not " + (id == null ? "found" : "a StubIndexKey"));
                return null;
            }
            return id;
        }

        protected Void createStubIndexKeySerializationState(@NotNull DataOutput out, @NotNull Set<StubIndexKey<?, ?>> set) {
            if (out == null) {
                StubExternalizerToStableBinary.$$$reportNull$$$0(4);
            }
            if (set == null) {
                StubExternalizerToStableBinary.$$$reportNull$$$0(5);
            }
            return null;
        }

        protected Void createStubIndexKeySerializationState(@NotNull DataInput input, int stubIndexKeyCount) {
            if (input == null) {
                StubExternalizerToStableBinary.$$$reportNull$$$0(6);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indexIdEnumerator";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "set";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/indexing/shared/platform/impl/StubSharedIndexExtension$StubExternalizerToStableBinary";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeStubIndexKey";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "readStubIndexKey";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createStubIndexKeySerializationState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class StubBuilderVersionFilter {
        @NotNull
        private final Map<String, String> myVersions;
        @NotNull
        private final Map<FileType, Boolean> myResolutionMap;
        @NotNull
        private final SortedMap<String, String> myBinaryStubFileBuilderVersions;
        private final boolean myPrebuilt;

        private StubBuilderVersionFilter(@NotNull SharedIndexInfrastructureVersion chunkVersion, boolean prebuilt) {
            if (chunkVersion == null) {
                StubBuilderVersionFilter.$$$reportNull$$$0(0);
            }
            this.myVersions = chunkVersion.getStubFileElementTypeVersions();
            this.myBinaryStubFileBuilderVersions = chunkVersion.getCompositeBinaryStubFileBuilderVersions();
            this.myPrebuilt = prebuilt;
            this.myResolutionMap = ConcurrentFactoryMap.createMap(this::doVersionsMatch);
        }

        private boolean doVersionsMatch(@NotNull FileType fileType) {
            if (fileType == null) {
                StubBuilderVersionFilter.$$$reportNull$$$0(1);
            }
            if (fileType instanceof LanguageFileType) {
                return this.doLanguageFileTypeVersionsMatch((LanguageFileType)fileType);
            }
            return this.doBinaryFileTypeVersionsMatch(fileType);
        }

        private boolean doLanguageFileTypeVersionsMatch(@NotNull LanguageFileType fileType) {
            if (fileType == null) {
                StubBuilderVersionFilter.$$$reportNull$$$0(2);
            }
            Language language = fileType.getLanguage();
            if (this.myPrebuilt && StubBuilderVersionFilter.isJsOrDialect(language)) {
                return true;
            }
            LanguageStubDescriptor languageStubDescriptor = StubElementRegistryService.getInstance().getStubDescriptor(language);
            if (languageStubDescriptor == null) {
                return true;
            }
            String key = IndexInfrastructureVersionBase.getStubFileElementTypeKey((LanguageStubDescriptor)languageStubDescriptor);
            int version = IndexInfrastructureVersionBase.getStubFileElementBaseVersion((LanguageStubDescriptor)languageStubDescriptor);
            return String.valueOf(version).equals(this.myVersions.get(key));
        }

        private boolean doBinaryFileTypeVersionsMatch(@NotNull FileType fileType) {
            BinaryFileStubBuilder builder;
            if (fileType == null) {
                StubBuilderVersionFilter.$$$reportNull$$$0(3);
            }
            if (!((builder = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType)) instanceof BinaryFileStubBuilder.CompositeBinaryFileStubBuilder)) {
                return true;
            }
            String version = IndexInfrastructureVersionBase.getBinaryFileStubBuilderVersion((BinaryFileStubBuilder.CompositeBinaryFileStubBuilder)((BinaryFileStubBuilder.CompositeBinaryFileStubBuilder)builder));
            return version.equals(this.myBinaryStubFileBuilderVersions.get(fileType.getName()));
        }

        boolean acceptsFileType(@NotNull FileType fileType) {
            if (fileType == null) {
                StubBuilderVersionFilter.$$$reportNull$$$0(4);
            }
            return this.myResolutionMap.get(fileType);
        }

        private static boolean isJsOrDialect(@NotNull Language language) {
            if (language == null) {
                StubBuilderVersionFilter.$$$reportNull$$$0(5);
            }
            while (language != null) {
                if (language.getID().equals("JavaScript")) {
                    return true;
                }
                language = language.getBaseLanguage();
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chunkVersion";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/indexing/shared/platform/impl/StubSharedIndexExtension$StubBuilderVersionFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doVersionsMatch";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doLanguageFileTypeVersionsMatch";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doBinaryFileTypeVersionsMatch";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "acceptsFileType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isJsOrDialect";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

