/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.ChangeListData;
import org.jetbrains.idea.perforce.ClientVersion;
import org.jetbrains.idea.perforce.ServerVersion;
import org.jetbrains.idea.perforce.changesBrowser.FileChange;
import org.jetbrains.idea.perforce.perforce.P4Revision;

public class OutputMessageParser {
    private static final Logger LOG = Logger.getInstance(OutputMessageParser.class);
    protected LinkedList<String> myLines = new LinkedList();
    private String myDepotPath;
    protected String myCurrentLine;
    private boolean myIsBranched = false;
    private String myBranch = null;
    private final ProgressIndicator myProgressIndicator;
    public static final DateTimeFormatter NEW_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss", Locale.US);
    public static final DateTimeFormatter OLD_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy/MM/dd", Locale.US);
    @NonNls
    private static final String CLIENT_PREFIX = "Client";
    private static final String FILE_PREFIX = "...";
    protected final String myOutput;
    @NonNls
    private static final String LOG_REGEX = "(... #)(.*)( change )(.*)( )(.*)( on )(.*)( by )(.*)(@)(.*)( \\()(.*)(\\))";
    public static final Pattern LOG_PATTERN = Pattern.compile("(... #)(.*)( change )(.*)( )(.*)( on )(.*)( by )(.*)(@)(.*)( \\()(.*)(\\))");
    public static final Pattern DEPOT_PATTERN = Pattern.compile("(//)(.*)");
    @NonNls
    public static final Pattern SERVER_VERSION_PATTERN = Pattern.compile("(.*\\/.*\\/)(.*)(\\.)(\\d+)([^\\d]*\\/.* \\(.*\\/.*\\/.*\\))");
    @NonNls
    public static final Pattern CLIENT_VERSION_PATTERN = Pattern.compile("(.*/.*/)(.*)(\\.)(\\d+)[^\\d]*/(.*) (\\(.*/.*/.*\\)).");
    @NonNls
    private static final String BRANCH_FROM_PREFIX = "... ... branch from ";
    @NonNls
    private static final String AFFECTED_FILES_PREFIX = "Affected files ...";
    @NonNls
    private static final String SHELVED_FILES_PREFIX = "Shelved files ...";
    @NonNls
    private static final String BRANCH_PREFIX = "Branch";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OutputMessageParser(String output) {
        this.myOutput = output;
        this.myProgressIndicator = ApplicationManager.getApplication() != null ? ProgressManager.getInstance().getProgressIndicator() : null;
        BufferedReader reader = null;
        try {
            String line;
            reader = new LineNumberReader(new StringReader(output));
            while ((line = ((LineNumberReader)reader).readLine()) != null) {
                if (line.isEmpty()) continue;
                this.myLines.add(line);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    public static List<P4Revision> processLogOutput(String output, boolean newDateFormat) throws DateTimeParseException {
        P4Revision revision;
        ArrayList<P4Revision> result = new ArrayList<P4Revision>();
        OutputMessageParser parser = new OutputMessageParser(output);
        while ((revision = parser.readNextRevision(newDateFormat)) != null) {
            result.add(revision);
        }
        return result;
    }

    @Nullable
    private P4Revision readNextRevision(boolean newDateFormat) throws DateTimeParseException {
        if (this.myLines.isEmpty()) {
            return null;
        }
        this.myCurrentLine = this.myLines.remove(0);
        Matcher logMatcher = LOG_PATTERN.matcher(this.myCurrentLine);
        if (logMatcher.matches() && this.myDepotPath != null) {
            String dateString = logMatcher.group(8);
            Date date = OutputMessageParser.parseDate(newDateFormat, dateString);
            P4Revision result = new P4Revision(this.myDepotPath, Long.parseLong(logMatcher.group(2)), Long.parseLong(logMatcher.group(4)), logMatcher.group(6), date, logMatcher.group(10), logMatcher.group(12), logMatcher.group(14), this.myIsBranched);
            StringBuffer messages = new StringBuffer();
            this.readMessages(messages);
            result.setDescription(messages.toString());
            return result;
        }
        Matcher depotMatcher = DEPOT_PATTERN.matcher(this.myCurrentLine);
        if (depotMatcher.matches()) {
            this.myDepotPath = this.myCurrentLine;
            return this.readNextRevision(newDateFormat);
        }
        if (this.myCurrentLine.startsWith(BRANCH_FROM_PREFIX)) {
            this.myIsBranched = true;
            this.myBranch = this.myCurrentLine;
        }
        return this.readNextRevision(newDateFormat);
    }

    private static Date parseDate(boolean newDateFormat, String dateString) throws DateTimeParseException {
        TemporalAccessor parsed;
        try {
            parsed = (newDateFormat ? NEW_DATE_FORMAT : OLD_DATE_FORMAT).parse(dateString);
        }
        catch (DateTimeParseException e) {
            parsed = OLD_DATE_FORMAT.parse(dateString);
        }
        if (!parsed.isSupported(ChronoField.HOUR_OF_DAY)) {
            parsed = LocalDate.from(parsed).atStartOfDay();
        }
        return Date.from(LocalDateTime.from(parsed).atZone(ZoneId.systemDefault()).toInstant());
    }

    private void readMessages(StringBuffer result) {
        if (this.myBranch != null) {
            result.append("[");
            result.append(this.myBranch);
            result.append("]");
            this.myBranch = null;
        }
        while (!this.myLines.isEmpty()) {
            String line = this.myLines.get(0);
            if (!line.startsWith("\t")) {
                return;
            }
            this.myLines.remove(0);
            line = line.substring(1).trim();
            if (!result.isEmpty()) {
                result.append("\n");
            }
            result.append(line);
        }
    }

    protected void skip(String s) {
        if (this.myCurrentLine.startsWith(s)) {
            this.myCurrentLine = this.myCurrentLine.substring(s.length()).trim();
        }
    }

    @Nullable
    protected String readTo(String s) {
        int position = this.myCurrentLine.indexOf(s);
        if (position < 0) {
            return null;
        }
        String result = this.myCurrentLine.substring(0, position).trim();
        this.myCurrentLine = this.myCurrentLine.substring(position).trim();
        return result;
    }

    public static List<ChangeListData> processChangesOutput(String output) {
        ChangeListData change;
        ArrayList<ChangeListData> result = new ArrayList<ChangeListData>();
        OutputMessageParser parser = new OutputMessageParser(output);
        while ((change = parser.readNextChange(new ChangeReadingPolicy(ChangeReadingPolicy.CHANGE_PATTERN, 6, 4))) != null) {
            result.add(change);
        }
        return result;
    }

    @Nullable
    private ChangeListData readNextChange(ChangeReadingPolicy changePattern) {
        if (this.myLines.isEmpty()) {
            return null;
        }
        this.myCurrentLine = this.myLines.remove(0);
        Matcher matcher = changePattern.getPattern().matcher(this.myCurrentLine);
        if (matcher.matches()) {
            String number = matcher.group(2);
            long revisionNumber = Long.parseLong(number);
            String date = matcher.group(changePattern.getDateGroup());
            String user = matcher.group(changePattern.getUserGroup());
            String client = matcher.group(changePattern.getUserGroup() + 2);
            ChangeListData result = new ChangeListData();
            result.CLIENT = client;
            result.USER = user;
            result.DATE = date;
            result.NUMBER = revisionNumber;
            StringBuffer messages = new StringBuffer();
            this.readMessages(messages);
            result.DESCRIPTION = messages.toString();
            return result;
        }
        return this.readNextChange(changePattern);
    }

    public static List<String> processClientsOutput(String output) {
        ArrayList<String> result = new ArrayList<String>();
        OutputMessageParser parser = new OutputMessageParser(output);
        while (!parser.myLines.isEmpty()) {
            parser.myCurrentLine = parser.myLines.remove(0);
            if (!parser.myCurrentLine.startsWith(CLIENT_PREFIX)) continue;
            parser.skip(CLIENT_PREFIX);
            result.add(parser.readTo(" "));
        }
        return result;
    }

    public static List<String> processUsersOutput(String output) {
        ArrayList<String> result = new ArrayList<String>();
        OutputMessageParser parser = new OutputMessageParser(output);
        while (!parser.myLines.isEmpty()) {
            parser.myCurrentLine = parser.myLines.remove(0);
            result.add(parser.readTo("<"));
        }
        return result;
    }

    public static Map<ChangeListData, List<FileChange>> processMultiDescriptionOutput(String output, boolean shelved) {
        LinkedHashMap<ChangeListData, List<FileChange>> result = new LinkedHashMap<ChangeListData, List<FileChange>>();
        OutputMessageParser parser = new OutputMessageParser(output);
        while (!parser.myLines.isEmpty()) {
            ChangeListData data = parser.loadChangeListDescription();
            if (data == null) continue;
            result.put(data, parser.processSingleDescriptionOutput(shelved ? SHELVED_FILES_PREFIX : AFFECTED_FILES_PREFIX));
        }
        return result;
    }

    private List<FileChange> processSingleDescriptionOutput(String prefix) {
        ArrayList<FileChange> result = new ArrayList<FileChange>();
        while (!this.myLines.isEmpty()) {
            this.myCurrentLine = this.myLines.removeFirst();
            if (!this.myCurrentLine.startsWith(prefix)) continue;
        }
        while (!this.myLines.isEmpty() && this.myLines.getFirst().startsWith(FILE_PREFIX)) {
            this.myCurrentLine = this.myLines.removeFirst();
            result.add(this.createFileChange());
        }
        return result;
    }

    public static ServerVersion parseServerVersion(String str) {
        Matcher matcher = SERVER_VERSION_PATTERN.matcher(str);
        if (!matcher.matches()) {
            return new ServerVersion(-1L, -1L);
        }
        String year = matcher.group(2);
        String version = matcher.group(4);
        try {
            return new ServerVersion(Long.parseLong(year), Long.parseLong(version));
        }
        catch (NumberFormatException e) {
            return new ServerVersion(-1L, -1L);
        }
    }

    public static ClientVersion parseClientVersion(String str) {
        long versionLong;
        long yearLong;
        Matcher matcher = CLIENT_VERSION_PATTERN.matcher(str);
        if (!matcher.matches()) {
            return ClientVersion.UNKNOWN;
        }
        String year = matcher.group(2);
        String version = matcher.group(4);
        String build = matcher.group(5);
        try {
            yearLong = Long.parseLong(year);
            versionLong = Long.parseLong(version);
        }
        catch (NumberFormatException e) {
            return ClientVersion.UNKNOWN;
        }
        try {
            return new ClientVersion(yearLong, versionLong, Long.parseLong(build));
        }
        catch (NumberFormatException e) {
            return new ClientVersion(yearLong, versionLong, -1L);
        }
    }

    @NotNull
    private FileChange createFileChange() {
        if (this.myProgressIndicator != null && this.myProgressIndicator.isCanceled()) {
            throw new ProcessCanceledException();
        }
        this.myCurrentLine = this.myCurrentLine.substring(FILE_PREFIX.length()).trim();
        String repositoryFilePath = this.readTo("#");
        this.skip("#");
        String fileRev = this.readTo(" ");
        String type = this.myCurrentLine.trim();
        File file = new File(repositoryFilePath);
        long revision = fileRev != null && !"none".equals(fileRev) ? Long.parseLong(fileRev) : -1L;
        return new FileChange(repositoryFilePath, file, revision, type);
    }

    public static List<String> processBranchesOutput(String output) {
        String branch;
        ArrayList<String> result = new ArrayList<String>();
        OutputMessageParser parser = new OutputMessageParser(output);
        while ((branch = parser.readNextBranch()) != null) {
            result.add(branch);
        }
        return result;
    }

    @Nullable
    private String readNextBranch() {
        String[] strings;
        if (this.myLines.isEmpty()) {
            return null;
        }
        this.myCurrentLine = this.myLines.remove(0);
        if (this.myCurrentLine != null && (strings = this.myCurrentLine.split(" ")).length > 2 && strings[0].equals(BRANCH_PREFIX)) {
            return strings[1];
        }
        return null;
    }

    @Nullable
    ChangeListData loadChangeListDescription() {
        return this.readNextChange(new ChangeReadingPolicy(ChangeReadingPolicy.CHANGE_DESCRIPTION_PATTERN, 4, 8));
    }

    private static class ChangeReadingPolicy {
        @NonNls
        private static final String CHANGE_REGEX = "(Change )(.*)( on )(.*)( by )(.*)(@)(.*)";
        public static final Pattern CHANGE_PATTERN = Pattern.compile("(Change )(.*)( on )(.*)( by )(.*)(@)(.*)");
        @NonNls
        private static final String CHANGE_DESCRIPTION_REGEX = "(Change )(.*)( by )(.*)(@)(.*)( on )(.*)";
        public static final Pattern CHANGE_DESCRIPTION_PATTERN = Pattern.compile("(Change )(.*)( by )(.*)(@)(.*)( on )(.*)");
        private final Pattern myPattern;
        private final int myUserGroup;
        private final int myDateGroupGroup;

        ChangeReadingPolicy(Pattern pattern, int userGroup, int dateGroupGroup) {
            this.myPattern = pattern;
            this.myUserGroup = userGroup;
            this.myDateGroupGroup = dateGroupGroup;
        }

        public Pattern getPattern() {
            return this.myPattern;
        }

        public int getUserGroup() {
            return this.myUserGroup;
        }

        public int getDateGroup() {
            return this.myDateGroupGroup;
        }
    }
}

