/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.providers.vscode;

import com.intellij.ide.startup.importSettings.db.KnownKeymaps;
import com.intellij.ide.startup.importSettings.db.KnownLafs;
import com.intellij.ide.startup.importSettings.db.WindowsEnvVariables;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.transfer.backend.db.KnownColorSchemes;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.GeneralSettingsParser;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.KeyBindingsParser;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.PluginParser;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.StateDatabaseParser;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.StorageParser;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vscode/VSCodeSettingsProcessor;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "willDetectAtLeastSomething", "", "isInstanceRecentEnough", "getProcessedSettings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "Companion", "intellij.ide.startup.importSettings"})
public final class VSCodeSettingsProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope scope;
    private static final String homeDirectory = System.getProperty("user.home");
    @NotNull
    private static final String vsCodeHome = SystemInfo.isMac ? homeDirectory + "/Library/Application Support/Code" : (SystemInfo.isWindows ? WindowsEnvVariables.INSTANCE.getApplicationData() + "/Code" : homeDirectory + "/.config/Code");
    @NotNull
    private static final File storageFile = new File(vsCodeHome + "/storage.json");
    @NotNull
    private static final File keyBindingsFile = new File(vsCodeHome + "/User/keybindings.json");
    @NotNull
    private static final File generalSettingsFile = new File(vsCodeHome + "/User/settings.json");
    @NotNull
    private static final File pluginsDirectory = new File(homeDirectory + "/.vscode/extensions");
    @NotNull
    private static final File database = new File(vsCodeHome + "/User/globalStorage/state.vscdb");
    private static final Duration timeAfterLastModificationToConsiderTheInstanceRecent = Duration.ofHours(8760L);

    public VSCodeSettingsProcessor(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.scope = scope;
    }

    public final boolean willDetectAtLeastSomething() {
        if (generalSettingsFile.exists()) {
            return true;
        }
        if (!pluginsDirectory.exists() || !pluginsDirectory.isDirectory()) {
            return false;
        }
        File[] fileArray = pluginsDirectory.listFiles();
        if (fileArray == null) {
            return false;
        }
        for (File pluginDirEntry : fileArray) {
            if (!pluginDirEntry.isDirectory()) continue;
            return true;
        }
        return false;
    }

    public final boolean isInstanceRecentEnough() {
        try {
            File fileToCheck = database;
            if (fileToCheck.exists()) {
                FileTime time = Files.getLastModifiedTime(fileToCheck.toPath(), new LinkOption[0]);
                return time.toInstant().compareTo(Instant.now().minus(timeAfterLastModificationToConsiderTheInstanceRecent)) > 0;
            }
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @NotNull
    public final Settings getProcessedSettings() {
        Settings settings = Companion.getDefaultSettings();
        if (keyBindingsFile.exists()) {
            new KeyBindingsParser(settings).process(keyBindingsFile);
        }
        if (pluginsDirectory.exists()) {
            new PluginParser(settings).process(pluginsDirectory);
        }
        if (storageFile.exists()) {
            new StorageParser(settings).process(storageFile);
        }
        if (generalSettingsFile.exists()) {
            new GeneralSettingsParser(settings).process(generalSettingsFile);
        }
        if (database.exists()) {
            new StateDatabaseParser(this.scope, settings).process(database);
        }
        return settings;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0017\u001a\u00020\u0018R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0014\u0010\u0015\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u0018\u0010\u0019\u001a\n \u0006*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vscode/VSCodeSettingsProcessor$Companion;", "", "<init>", "()V", "homeDirectory", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "vsCodeHome", "getVsCodeHome$intellij_ide_startup_importSettings", "()Ljava/lang/String;", "storageFile", "Ljava/io/File;", "getStorageFile$intellij_ide_startup_importSettings", "()Ljava/io/File;", "keyBindingsFile", "getKeyBindingsFile$intellij_ide_startup_importSettings", "generalSettingsFile", "getGeneralSettingsFile$intellij_ide_startup_importSettings", "pluginsDirectory", "getPluginsDirectory$intellij_ide_startup_importSettings", "database", "getDatabase$intellij_ide_startup_importSettings", "getDefaultSettings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "timeAfterLastModificationToConsiderTheInstanceRecent", "Ljava/time/Duration;", "Ljava/time/Duration;", "intellij.ide.startup.importSettings"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getVsCodeHome$intellij_ide_startup_importSettings() {
            return vsCodeHome;
        }

        @NotNull
        public final File getStorageFile$intellij_ide_startup_importSettings() {
            return storageFile;
        }

        @NotNull
        public final File getKeyBindingsFile$intellij_ide_startup_importSettings() {
            return keyBindingsFile;
        }

        @NotNull
        public final File getGeneralSettingsFile$intellij_ide_startup_importSettings() {
            return generalSettingsFile;
        }

        @NotNull
        public final File getPluginsDirectory$intellij_ide_startup_importSettings() {
            return pluginsDirectory;
        }

        @NotNull
        public final File getDatabase$intellij_ide_startup_importSettings() {
            return database;
        }

        @NotNull
        public final Settings getDefaultSettings() {
            return new Settings(null, KnownLafs.INSTANCE.getDarcula(), KnownColorSchemes.INSTANCE.getDarcula(), SystemInfoRt.isMac ? KnownKeymaps.INSTANCE.getVSCodeMac() : KnownKeymaps.INSTANCE.getVSCode(), null, 17, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

