/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.action;

import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointUtil;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.BackgroundTaskBundle;
import com.intellij.plugins.watcher.config.BackgroundTaskConsumer;
import com.intellij.plugins.watcher.config.BackgroundTaskSuppressor;
import com.intellij.plugins.watcher.config.ui.NewWatcherDialog;
import com.intellij.plugins.watcher.model.ApplicationTasksOptions;
import com.intellij.plugins.watcher.model.ProjectTasksOptions;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.NonOpaquePanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FwEditorNotificationProvider
implements EditorNotificationProvider {
    FwEditorNotificationProvider(final @NotNull Project project) {
        if (project == null) {
            FwEditorNotificationProvider.$$$reportNull$$$0(0);
        }
        BackgroundTaskConsumer.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<BackgroundTaskConsumer>(){

            public void extensionAdded(@NotNull BackgroundTaskConsumer extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                EditorNotifications.getInstance((Project)project).updateAllNotifications();
            }

            public void extensionRemoved(@NotNull BackgroundTaskConsumer extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                EditorNotifications.getInstance((Project)project).updateNotifications((EditorNotificationProvider)FwEditorNotificationProvider.this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/plugins/watcher/action/FwEditorNotificationProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, ExtensionPointUtil.createExtensionDisposable((Object)this, (ExtensionPoint)EP_NAME.getPoint((AreaInstance)project)));
    }

    @Nullable
    public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile vFile) {
        if (project == null) {
            FwEditorNotificationProvider.$$$reportNull$$$0(1);
        }
        if (vFile == null) {
            FwEditorNotificationProvider.$$$reportNull$$$0(2);
        }
        if (!vFile.isInLocalFileSystem()) {
            return null;
        }
        if (!ProjectFileIndex.getInstance((Project)project).isInContent(vFile)) {
            return null;
        }
        PsiFile file = PsiManager.getInstance((Project)project).findFile(vFile);
        if (file == null) {
            return null;
        }
        List taskConsumers = BackgroundTaskConsumer.EP_NAME.getExtensionList();
        if (taskConsumers.isEmpty()) {
            return null;
        }
        ArrayList<BackgroundTaskConsumer> toSuggest = new ArrayList<BackgroundTaskConsumer>();
        for (BackgroundTaskConsumer taskConsumer : taskConsumers) {
            if (!taskConsumer.isAvailable(file)) continue;
            TaskOptions options = taskConsumer.getOptionsTemplate();
            if (ProjectTasksOptions.getInstance(file.getProject()).isSuppressedTaskName(options.getName()) || ProjectTasksOptions.getInstance(file.getProject()).containWatcherWithFileType(options.getFileType()) || ProjectTasksOptions.getInstance(file.getProject()).hasWatcherWithName(options.getName()) || BackgroundTaskSuppressor.checkSuppress(file, options)) continue;
            toSuggest.add(taskConsumer);
        }
        return __ -> {
            if (toSuggest.isEmpty()) {
                return null;
            }
            if (toSuggest.size() == 1) {
                return new FwPanel(project, file, (BackgroundTaskConsumer)toSuggest.get(0));
            }
            JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
            for (BackgroundTaskConsumer options : toSuggest) {
                panel2.add((Component)((Object)new FwPanel(project, file, options)));
            }
            return panel2;
        };
    }

    private static void addFileWatcher(@NotNull Project project, @NotNull PsiFile file, @NotNull BackgroundTaskConsumer taskConsumer) {
        if (project == null) {
            FwEditorNotificationProvider.$$$reportNull$$$0(3);
        }
        if (file == null) {
            FwEditorNotificationProvider.$$$reportNull$$$0(4);
        }
        if (taskConsumer == null) {
            FwEditorNotificationProvider.$$$reportNull$$$0(5);
        }
        TaskOptions options = taskConsumer.getOptionsTemplate();
        TaskOptions lastOptions = ApplicationTasksOptions.getInstance().getLastEditedWatcherWithName(options.getName());
        taskConsumer.additionalConfiguration(project, file, options);
        taskConsumer.configureWithLastOptions(options, lastOptions);
        NewWatcherDialog dialog = new NewWatcherDialog(project, options, BackgroundTaskBundle.message("dialog.title.new.file.watcher", new Object[0]));
        if (!dialog.showAndGet()) {
            return;
        }
        TaskOptions newOptions = dialog.getTaskOptions();
        ApplicationTasksOptions.getInstance().addOrUpdate(Collections.singletonList(Pair.create((Object)newOptions, (Object)true)));
        ProjectTasksOptions.getInstance(project).addTask(newOptions, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskConsumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/plugins/watcher/action/FwEditorNotificationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectNotificationData";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addFileWatcher";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FwPanel
    extends EditorNotificationPanel {
        FwPanel(final @NotNull Project project, @NotNull PsiFile file, @NotNull BackgroundTaskConsumer taskConsumer) {
            if (project == null) {
                FwPanel.$$$reportNull$$$0(0);
            }
            if (file == null) {
                FwPanel.$$$reportNull$$$0(1);
            }
            if (taskConsumer == null) {
                FwPanel.$$$reportNull$$$0(2);
            }
            super(EditorColors.GUTTER_BACKGROUND, EditorNotificationPanel.Status.Info);
            String fileWatcherLinkText = BackgroundTaskBundle.message("editor.notification.question.text.part.that.becomes.link.to.settings", new Object[0]);
            HoverHyperlinkLabel fileWatcherLink = new HoverHyperlinkLabel(fileWatcherLinkText);
            fileWatcherLink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

                protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ShowSettingsUtil.getInstance().showSettingsDialog(project, BackgroundTaskBundle.message("settings.name", new Object[0]));
                    EditorNotifications.getInstance((Project)project).updateAllNotifications();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/plugins/watcher/action/FwEditorNotificationProvider$FwPanel$1", "hyperlinkActivated"));
                }
            });
            NonOpaquePanel questionPanel = new NonOpaquePanel((LayoutManager)new HorizontalLayout(0));
            String message = taskConsumer.getConsumeMessage();
            int linkIndex = message.indexOf(fileWatcherLinkText);
            if (linkIndex < 0) {
                questionPanel.add((Component)new JBLabel(message));
            } else {
                questionPanel.add((Component)new JBLabel(message.substring(0, linkIndex)));
                questionPanel.add((Component)fileWatcherLink);
                questionPanel.add((Component)new JBLabel(message.substring(linkIndex + fileWatcherLinkText.length())));
            }
            this.add((Component)questionPanel, "West");
            this.createActionLabel(BackgroundTaskBundle.message("enable.file.watcher.editor.notification.link.label.yes", new Object[0]), () -> {
                FwEditorNotificationProvider.addFileWatcher(project, file, taskConsumer);
                EditorNotifications.getInstance((Project)project).updateAllNotifications();
            }, false);
            this.createActionLabel(BackgroundTaskBundle.message("enable.file.watcher.editor.notification.link.label.no", new Object[0]), () -> {
                ProjectTasksOptions.getInstance(project).suppressTaskName(taskConsumer.getOptionsTemplate().getName());
                EditorNotifications.getInstance((Project)project).updateAllNotifications();
            }, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "taskConsumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/plugins/watcher/action/FwEditorNotificationProvider$FwPanel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

