/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.validation;

import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.actions.validate.ValidateXmlHandler;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.util.UriOrFile;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.thaiopensource.validate.rng.RngProperty;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;
import org.intellij.plugins.relaxNG.RelaxngBundle;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.model.descriptors.RngElementDescriptor;
import org.intellij.plugins.relaxNG.validation.MessageViewHelper;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RngValidateHandler
implements ValidateXmlHandler {
    private static final Key<NewErrorTreeViewPanel> KEY = Key.create((String)"VALIDATING");

    @Override
    public void doValidate(XmlFile file) {
        XmlFile schema = RngValidateHandler.getRngSchema(file);
        if (schema == null) {
            return;
        }
        VirtualFile instanceFile = file.getVirtualFile();
        VirtualFile schemaFile = schema.getVirtualFile();
        if (instanceFile == null || schemaFile == null) {
            return;
        }
        RngValidateHandler.doRun(file.getProject(), instanceFile, schemaFile);
    }

    @Override
    public boolean isAvailable(XmlFile file) {
        return RngValidateHandler.getRngSchema(file) != null;
    }

    @Nullable
    private static XmlFile getRngSchema(XmlFile file) {
        RngElementDescriptor descriptor = RngValidateHandler.getRootDescriptor((PsiFile)file);
        if (descriptor == null) {
            return null;
        }
        PsiElement element = descriptor.getDeclaration();
        XmlFile schema = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)element, XmlFile.class);
        if (schema == null) {
            return null;
        }
        return schema;
    }

    private static RngElementDescriptor getRootDescriptor(PsiFile file) {
        try {
            XmlElementDescriptor descriptor;
            if (file instanceof XmlFile && (descriptor = ((XmlFile)file).getDocument().getRootTag().getDescriptor()) instanceof RngElementDescriptor) {
                return (RngElementDescriptor)descriptor;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    private static void doRun(Project project2, VirtualFile instanceFile, VirtualFile schemaFile) {
        RngValidateHandler.saveFiles(instanceFile, schemaFile);
        MessageViewHelper helper = new MessageViewHelper(project2, RelaxngBundle.message("relaxng.message-viewer.tab-title.validate-relax-ng", new Object[0]), KEY);
        helper.openMessageView(() -> RngValidateHandler.doRun(project2, instanceFile, schemaFile));
        final Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> ApplicationManager.getApplication().runReadAction(() -> {
            MessageViewHelper.ErrorHandler eh = helper.new MessageViewHelper.ErrorHandler();
            RngValidateHandler.doValidation(instanceFile, schemaFile, eh);
            SwingUtilities.invokeLater(() -> {
                if (!eh.hadErrorOrWarning()) {
                    SwingUtilities.invokeLater(() -> {
                        helper.close();
                        WindowManager.getInstance().getStatusBar(project2).setInfo(XmlBundle.message((String)"xml.validate.no.errors.detected.status.message", (Object[])new Object[0]));
                    });
                }
            });
        }));
        helper.setProcessController(new NewErrorTreeViewPanel.ProcessController(){

            public void stopProcess() {
                future.cancel(true);
            }

            public boolean isProcessStopped() {
                return future.isDone();
            }
        });
    }

    private static void doValidation(VirtualFile instanceFile, VirtualFile schemaFile, ErrorHandler eh) {
        block7: {
            SchemaReader sr = FileTypeRegistry.getInstance().isFileOfType(schemaFile, RncFileType.getInstance()) ? CompactSchemaReader.getInstance() : new AutoSchemaReader();
            PropertyMapBuilder properties = new PropertyMapBuilder();
            ValidateProperty.ERROR_HANDLER.put(properties, eh);
            RngProperty.CHECK_ID_IDREF.add(properties);
            try {
                String schemaPath = VfsUtilCore.fixIDEAUrl((String)schemaFile.getUrl());
                try {
                    ValidationDriver driver = new ValidationDriver(properties.toPropertyMap(), sr);
                    InputSource in = ValidationDriver.uriOrFileInputSource(schemaPath);
                    in.setEncoding(schemaFile.getCharset().name());
                    if (!driver.loadSchema(in)) break block7;
                    String path = VfsUtilCore.fixIDEAUrl((String)instanceFile.getUrl());
                    try {
                        driver.validate(ValidationDriver.uriOrFileInputSource(path));
                    }
                    catch (IOException e1) {
                        eh.fatalError(new SAXParseException(e1.getMessage(), null, UriOrFile.fileToUri(path), -1, -1, e1));
                    }
                }
                catch (SAXParseException e1) {
                    eh.fatalError(e1);
                }
                catch (IOException e1) {
                    eh.fatalError(new SAXParseException(e1.getMessage(), null, UriOrFile.fileToUri(schemaPath), -1, -1, e1));
                }
            }
            catch (MalformedURLException | SAXException e1) {
                Logger.getInstance((String)RngValidateHandler.class.getName()).error((Throwable)e1);
            }
        }
    }

    public static void saveFiles(VirtualFile ... files) {
        FileDocumentManager mgr = FileDocumentManager.getInstance();
        for (VirtualFile f : files) {
            Document document = mgr.getDocument(f);
            if (document == null) continue;
            mgr.saveDocument(document);
        }
    }
}

