/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.qml.documentation;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.navigation.UtilKt;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.javascript.documentation.JSDocSimpleInfoPrinter;
import com.intellij.lang.javascript.index.JSItemPresentation;
import com.intellij.lang.qml.QmlCommonIcons;
import com.intellij.model.Pointer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.platform.backend.documentation.DocumentationContent;
import com.intellij.platform.backend.documentation.DocumentationResult;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.platform.backend.presentation.TargetPresentationBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointersKt;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/lang/qml/documentation/QmlElementDocumentationTarget;", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "targetElement", "Lcom/intellij/psi/PsiElement;", "sourceElement", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)V", "pointer", "Lcom/intellij/lang/qml/documentation/QmlElementDocumentationTarget$QmlElementDocumentationTargetPointer;", "createPointer", "Lcom/intellij/model/Pointer;", "computePresentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "computeDocumentation", "Lcom/intellij/platform/backend/documentation/DocumentationResult;", "QmlElementDocumentationTargetPointer", "intellij.qml.common"})
@SourceDebugExtension(value={"SMAP\nQmlElementDocumentationTarget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QmlElementDocumentationTarget.kt\ncom/intellij/lang/qml/documentation/QmlElementDocumentationTarget\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1#2:65\n*E\n"})
public final class QmlElementDocumentationTarget
implements DocumentationTarget {
    @NotNull
    private final PsiElement targetElement;
    @Nullable
    private final PsiElement sourceElement;
    @NotNull
    private final QmlElementDocumentationTargetPointer pointer;

    public QmlElementDocumentationTarget(@NotNull PsiElement targetElement, @Nullable PsiElement sourceElement) {
        Intrinsics.checkNotNullParameter((Object)targetElement, (String)"targetElement");
        this.targetElement = targetElement;
        this.sourceElement = sourceElement;
        Project project = this.targetElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PsiElement psiElement = this.sourceElement;
        this.pointer = new QmlElementDocumentationTargetPointer(project, (Pointer<? extends PsiElement>)((Pointer)SmartPointersKt.createSmartPointer((PsiElement)this.targetElement)), (Pointer<PsiElement>)((Pointer)(psiElement != null ? SmartPointersKt.createSmartPointer((PsiElement)psiElement) : null)));
    }

    @NotNull
    public Pointer<? extends DocumentationTarget> createPointer() {
        return this.pointer;
    }

    @NotNull
    public TargetPresentation computePresentation() {
        TextAttributes textAttributes;
        Color color;
        TargetPresentationBuilder targetPresentationBuilder;
        String string;
        String presentableText;
        Project project = this.targetElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiFile psiFile = this.targetElement.getContainingFile();
        VirtualFile file = psiFile != null ? psiFile.getVirtualFile() : null;
        String string2 = this.targetElement.getText();
        if (string2 == null) {
            string2 = presentableText = "";
        }
        if (this.targetElement.getContainingFile() == null) {
            string = "";
        } else {
            String string3 = JSItemPresentation.getFileName((PsiFile)this.targetElement.getContainingFile(), (boolean)true, (boolean)true, (boolean)false);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFileName(...)");
        }
        String rawLocation = string;
        rawLocation = StringUtil.trimEnd((String)StringUtil.trimStart((String)rawLocation, (String)"("), (String)")");
        String string4 = JSDocSimpleInfoPrinter.getLocationWithEllipsis((String)rawLocation, (int)40);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getLocationWithEllipsis(...)");
        String location = string4;
        TargetPresentationBuilder targetPresentationBuilder2 = TargetPresentation.Companion.builder(presentableText);
        VirtualFile virtualFile = file;
        if (virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile;
            targetPresentationBuilder = targetPresentationBuilder2;
            boolean bl = false;
            color = VfsPresentationUtil.getFileBackgroundColor((Project)project2, (VirtualFile)file);
            targetPresentationBuilder2 = targetPresentationBuilder;
        } else {
            color = null;
        }
        TargetPresentationBuilder targetPresentationBuilder3 = targetPresentationBuilder2.backgroundColor(color).icon(this.targetElement.getIcon(3));
        String string5 = null;
        VirtualFile virtualFile3 = file;
        if (virtualFile3 != null) {
            VirtualFile it = virtualFile3;
            String string6 = string5;
            targetPresentationBuilder = targetPresentationBuilder3;
            boolean bl = false;
            TextAttributes textAttributes2 = UtilKt.fileStatusAttributes((Project)project2, (VirtualFile)file);
            targetPresentationBuilder3 = targetPresentationBuilder;
            string5 = string6;
            textAttributes = textAttributes2;
        } else {
            textAttributes = null;
        }
        TargetPresentation targetPresentation = targetPresentationBuilder3.containerText(string5, textAttributes).locationText(location, QmlCommonIcons.Qml).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    @Nullable
    public DocumentationResult computeDocumentation() {
        DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement((PsiElement)this.targetElement, (PsiElement)this.sourceElement);
        Intrinsics.checkNotNullExpressionValue((Object)documentationProvider, (String)"getProviderFromElement(...)");
        DocumentationProvider provider = documentationProvider;
        String string = provider.generateDoc(this.targetElement, this.sourceElement);
        if (string == null) {
            return null;
        }
        String html = string;
        DocumentationContent documentationContent = DocumentationContent.content((String)html);
        Intrinsics.checkNotNullExpressionValue((Object)documentationContent, (String)"content(...)");
        return (DocumentationResult)DocumentationResult.Companion.documentation(documentationContent);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0001\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/lang/qml/documentation/QmlElementDocumentationTarget$QmlElementDocumentationTargetPointer;", "Lcom/intellij/model/Pointer;", "Lcom/intellij/lang/qml/documentation/QmlElementDocumentationTarget;", "project", "Lcom/intellij/openapi/project/Project;", "targetPointer", "Lcom/intellij/psi/PsiElement;", "sourcePointer", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/model/Pointer;Lcom/intellij/model/Pointer;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "dereference", "intellij.qml.common"})
    public static final class QmlElementDocumentationTargetPointer
    implements Pointer<QmlElementDocumentationTarget> {
        @NotNull
        private final Project project;
        @NotNull
        private final Pointer<? extends PsiElement> targetPointer;
        @Nullable
        private final Pointer<PsiElement> sourcePointer;

        public QmlElementDocumentationTargetPointer(@NotNull Project project, @NotNull Pointer<? extends PsiElement> targetPointer, @Nullable Pointer<PsiElement> sourcePointer) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(targetPointer, (String)"targetPointer");
            this.project = project;
            this.targetPointer = targetPointer;
            this.sourcePointer = sourcePointer;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @Nullable
        public QmlElementDocumentationTarget dereference() {
            PsiElement psiElement = (PsiElement)this.targetPointer.dereference();
            if (psiElement == null) {
                return null;
            }
            PsiElement element = psiElement;
            Pointer<PsiElement> pointer = this.sourcePointer;
            return new QmlElementDocumentationTarget(element, (PsiElement)(pointer != null ? (PsiElement)pointer.dereference() : null));
        }
    }
}

