/*
 * Decompiled with CFR 0.152.
 */
package git4idea.diff;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.vcs.log.Hash;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.index.GitIndexUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitSubmodule;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u000f2\u00020\u0001:\u0003\r\u000e\u000fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgit4idea/diff/GitSubmoduleContentRevision;", "Lcom/intellij/openapi/vcs/changes/ContentRevision;", "submodule", "Lgit4idea/repo/GitRepository;", "revisionNumber", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "<init>", "(Lgit4idea/repo/GitRepository;Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;)V", "getSubmodule", "()Lgit4idea/repo/GitRepository;", "getFile", "Lcom/intellij/openapi/vcs/FilePath;", "getRevisionNumber", "Committed", "Current", "Companion", "intellij.vcs.git"})
public abstract class GitSubmoduleContentRevision
implements ContentRevision {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GitRepository submodule;
    @NotNull
    private final VcsRevisionNumber revisionNumber;

    public GitSubmoduleContentRevision(@NotNull GitRepository submodule, @NotNull VcsRevisionNumber revisionNumber) {
        Intrinsics.checkNotNullParameter((Object)submodule, (String)"submodule");
        Intrinsics.checkNotNullParameter((Object)revisionNumber, (String)"revisionNumber");
        this.submodule = submodule;
        this.revisionNumber = revisionNumber;
    }

    @NotNull
    public final GitRepository getSubmodule() {
        return this.submodule;
    }

    @NotNull
    public FilePath getFile() {
        FilePath filePath = VcsUtil.getFilePath((String)this.submodule.getRoot().getPath(), (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        return filePath;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        return this.revisionNumber;
    }

    @JvmStatic
    @NotNull
    public static final ContentRevision createRevision(@NotNull GitSubmodule submodule, @NotNull VcsRevisionNumber revisionNumber) {
        return Companion.createRevision(submodule, revisionNumber);
    }

    @JvmStatic
    @NotNull
    public static final ContentRevision createCurrentRevision(@NotNull GitRepository submodule) {
        return Companion.createCurrentRevision(submodule);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lgit4idea/diff/GitSubmoduleContentRevision$Committed;", "Lgit4idea/diff/GitSubmoduleContentRevision;", "parentRepo", "Lgit4idea/repo/GitRepository;", "submodule", "revisionNumber", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "<init>", "(Lgit4idea/repo/GitRepository;Lgit4idea/repo/GitRepository;Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;)V", "getContent", "", "intellij.vcs.git"})
    private static final class Committed
    extends GitSubmoduleContentRevision {
        @NotNull
        private final GitRepository parentRepo;

        public Committed(@NotNull GitRepository parentRepo, @NotNull GitRepository submodule, @NotNull VcsRevisionNumber revisionNumber) {
            Intrinsics.checkNotNullParameter((Object)parentRepo, (String)"parentRepo");
            Intrinsics.checkNotNullParameter((Object)submodule, (String)"submodule");
            Intrinsics.checkNotNullParameter((Object)revisionNumber, (String)"revisionNumber");
            super(submodule, revisionNumber);
            this.parentRepo = parentRepo;
        }

        @Nullable
        public String getContent() {
            Hash hash = GitIndexUtil.loadSubmoduleHashAt(this.getSubmodule(), this.parentRepo, this.getRevisionNumber());
            return hash != null ? hash.asString() : null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lgit4idea/diff/GitSubmoduleContentRevision$Companion;", "", "<init>", "()V", "createRevision", "Lcom/intellij/openapi/vcs/changes/ContentRevision;", "submodule", "Lgit4idea/repo/GitSubmodule;", "revisionNumber", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "createCurrentRevision", "Lgit4idea/repo/GitRepository;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ContentRevision createRevision(@NotNull GitSubmodule submodule, @NotNull VcsRevisionNumber revisionNumber) {
            Intrinsics.checkNotNullParameter((Object)submodule, (String)"submodule");
            Intrinsics.checkNotNullParameter((Object)revisionNumber, (String)"revisionNumber");
            return new Committed(submodule.getParent(), submodule.getRepository(), revisionNumber);
        }

        @JvmStatic
        @NotNull
        public final ContentRevision createCurrentRevision(@NotNull GitRepository submodule) {
            Intrinsics.checkNotNullParameter((Object)submodule, (String)"submodule");
            VcsRevisionNumber vcsRevisionNumber = VcsRevisionNumber.NULL;
            Intrinsics.checkNotNullExpressionValue((Object)vcsRevisionNumber, (String)"NULL");
            return new Current(submodule, vcsRevisionNumber);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\n"}, d2={"Lgit4idea/diff/GitSubmoduleContentRevision$Current;", "Lgit4idea/diff/GitSubmoduleContentRevision;", "submodule", "Lgit4idea/repo/GitRepository;", "revisionNumber", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "<init>", "(Lgit4idea/repo/GitRepository;Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;)V", "getContent", "", "intellij.vcs.git"})
    private static final class Current
    extends GitSubmoduleContentRevision {
        public Current(@NotNull GitRepository submodule, @NotNull VcsRevisionNumber revisionNumber) {
            Intrinsics.checkNotNullParameter((Object)submodule, (String)"submodule");
            Intrinsics.checkNotNullParameter((Object)revisionNumber, (String)"revisionNumber");
            super(submodule, revisionNumber);
        }

        @Nullable
        public String getContent() {
            return this.getSubmodule().getCurrentRevision();
        }
    }
}

