/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.ui.clone.model;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.async.CoroutineUtilKt;
import com.intellij.collaboration.auth.Account;
import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.dvcs.ui.CloneDvcsValidationUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import git4idea.checkout.GitCheckoutProvider;
import git4idea.commands.Git;
import git4idea.commands.GitShallowCloneOptions;
import git4idea.ui.GitShallowCloneViewModel;
import java.lang.invoke.LambdaMetafactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.GitLabApi;
import org.jetbrains.plugins.gitlab.api.GitLabApiManager;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabAccount;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabAccountManager;
import org.jetbrains.plugins.gitlab.authentication.ui.GitLabAccountsDetailsProvider;
import org.jetbrains.plugins.gitlab.ui.clone.GitLabCloneListItem;
import org.jetbrains.plugins.gitlab.ui.clone.model.GitLabCloneRepositoriesListViewModel;
import org.jetbrains.plugins.gitlab.ui.clone.model.GitLabCloneRepositoriesListViewModelImpl;
import org.jetbrains.plugins.gitlab.ui.clone.model.GitLabCloneRepositoriesViewModel;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 72\u00020\u0001:\u00017B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010-\u001a\u00020+2\u0006\u0010.\u001a\u00020\u0017H\u0016J\u0010\u0010/\u001a\u00020+2\u0006\u00100\u001a\u00020\u0017H\u0016J\u0010\u00101\u001a\u00020+2\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020+2\u0006\u00105\u001a\u00020\u0017H\u0002J\b\u00106\u001a\u00020+H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u00068"}, d2={"Lorg/jetbrains/plugins/gitlab/ui/clone/model/GitLabCloneRepositoriesViewModelImpl;", "Lorg/jetbrains/plugins/gitlab/ui/clone/model/GitLabCloneRepositoriesViewModel;", "project", "Lcom/intellij/openapi/project/Project;", "parentCs", "Lkotlinx/coroutines/CoroutineScope;", "accountManager", "Lorg/jetbrains/plugins/gitlab/authentication/accounts/GitLabAccountManager;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lorg/jetbrains/plugins/gitlab/authentication/accounts/GitLabAccountManager;)V", "apiManager", "Lorg/jetbrains/plugins/gitlab/api/GitLabApiManager;", "vcsNotifier", "Lcom/intellij/openapi/vcs/VcsNotifier;", "cs", "listVm", "Lorg/jetbrains/plugins/gitlab/ui/clone/model/GitLabCloneRepositoriesListViewModel;", "getListVm", "()Lorg/jetbrains/plugins/gitlab/ui/clone/model/GitLabCloneRepositoriesListViewModel;", "selectedItem", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lorg/jetbrains/plugins/gitlab/ui/clone/GitLabCloneListItem;", "_searchValue", "", "searchValue", "Lkotlinx/coroutines/flow/SharedFlow;", "Lorg/jetbrains/plugins/gitlab/ui/clone/model/GitLabCloneRepositoriesViewModel$SearchModel;", "getSearchValue", "()Lkotlinx/coroutines/flow/SharedFlow;", "_selectedUrl", "Lkotlinx/coroutines/flow/StateFlow;", "selectedUrl", "getSelectedUrl", "directoryPath", "shallowCloneVm", "Lgit4idea/ui/GitShallowCloneViewModel;", "getShallowCloneVm", "()Lgit4idea/ui/GitShallowCloneViewModel;", "accountDetailsProvider", "Lorg/jetbrains/plugins/gitlab/authentication/ui/GitLabAccountsDetailsProvider;", "getAccountDetailsProvider", "()Lorg/jetbrains/plugins/gitlab/authentication/ui/GitLabAccountsDetailsProvider;", "selectItem", "", "item", "setSearchValue", "text", "setDirectoryPath", "path", "doClone", "checkoutListener", "Lcom/intellij/openapi/vcs/CheckoutProvider$Listener;", "notifyCreateDirectoryFailed", "message", "notifyDestinationNotFound", "Companion", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabCloneRepositoriesViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabCloneRepositoriesViewModel.kt\norg/jetbrains/plugins/gitlab/ui/clone/model/GitLabCloneRepositoriesViewModelImpl\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,167:1\n40#2,3:168\n25#3:171\n25#3:172\n*S KotlinDebug\n*F\n+ 1 GitLabCloneRepositoriesViewModel.kt\norg/jetbrains/plugins/gitlab/ui/clone/model/GitLabCloneRepositoriesViewModelImpl\n*L\n59#1:168,3\n146#1:171\n155#1:172\n*E\n"})
public final class GitLabCloneRepositoriesViewModelImpl
implements GitLabCloneRepositoriesViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final GitLabAccountManager accountManager;
    @NotNull
    private final GitLabApiManager apiManager;
    @NotNull
    private final VcsNotifier vcsNotifier;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final GitLabCloneRepositoriesListViewModel listVm;
    @NotNull
    private final MutableStateFlow<GitLabCloneListItem> selectedItem;
    @NotNull
    private final MutableStateFlow<String> _searchValue;
    @NotNull
    private final SharedFlow<GitLabCloneRepositoriesViewModel.SearchModel> searchValue;
    @NotNull
    private final StateFlow<String> _selectedUrl;
    @NotNull
    private final SharedFlow<String> selectedUrl;
    @NotNull
    private final MutableStateFlow<String> directoryPath;
    @NotNull
    private final GitShallowCloneViewModel shallowCloneVm;
    @NotNull
    private final GitLabAccountsDetailsProvider accountDetailsProvider;
    @NotNull
    private static final String CLONE_UNABLE_TO_CREATE_DESTINATION_DIRECTORY = "gitlab.clone.unable.to.create.destination.directory";
    @NotNull
    private static final String CLONE_UNABLE_TO_FIND_DESTINATION_DIRECTORY = "gitlab.clone.unable.to.find.destination.directory";

    public GitLabCloneRepositoriesViewModelImpl(@NotNull Project project, @NotNull CoroutineScope parentCs, @NotNull GitLabAccountManager accountManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentCs, (String)"parentCs");
        Intrinsics.checkNotNullParameter((Object)accountManager, (String)"accountManager");
        this.project = project;
        this.accountManager = accountManager;
        boolean $i$f$service = false;
        Class<GitLabApiManager> serviceClass$iv = GitLabApiManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        this.apiManager = (GitLabApiManager)object;
        VcsNotifier vcsNotifier = VcsNotifier.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)vcsNotifier, (String)"getInstance(...)");
        this.vcsNotifier = vcsNotifier;
        String string = this.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.cs = CoroutineScopeKt.childScope$default((CoroutineScope)parentCs, (String)string, null, (boolean)false, (int)6, null);
        this.listVm = new GitLabCloneRepositoriesListViewModelImpl(this.cs, this.accountManager);
        this.selectedItem = StateFlowKt.MutableStateFlow(null);
        this._searchValue = StateFlowKt.MutableStateFlow((Object)"");
        this.searchValue = (SharedFlow)CoroutineUtilKt.mapState((StateFlow)((StateFlow)this._searchValue), (CoroutineScope)this.cs, GitLabCloneRepositoriesViewModelImpl::searchValue$lambda$0);
        this._selectedUrl = FlowKt.stateIn((Flow)FlowKt.combine((Flow)((Flow)this.getSearchValue()), (Flow)((Flow)this.selectedItem), (Function3)((Function3)new Function3<GitLabCloneRepositoriesViewModel.SearchModel, GitLabCloneListItem, Continuation<? super String>, Object>(null){
            int label;
            /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        GitLabCloneRepositoriesViewModel.SearchModel searchValue = (GitLabCloneRepositoriesViewModel.SearchModel)this.L$0;
                        GitLabCloneListItem selectedItem = (GitLabCloneListItem)this.L$1;
                        return searchValue instanceof GitLabCloneRepositoriesViewModel.SearchModel.Url ? ((GitLabCloneRepositoriesViewModel.SearchModel.Url)searchValue).getUrl() : (selectedItem != null && selectedItem instanceof GitLabCloneListItem.Repository ? ((GitLabCloneListItem.Repository)selectedItem).getProject().getHttpUrlToRepo() : null);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(GitLabCloneRepositoriesViewModel.SearchModel p1, GitLabCloneListItem p2, Continuation<? super String> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                var4_4.L$1 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this.cs, (SharingStarted)SharingStarted.Companion.getEagerly(), null);
        this.selectedUrl = (SharedFlow)this._selectedUrl;
        this.directoryPath = StateFlowKt.MutableStateFlow((Object)"");
        this.shallowCloneVm = new GitShallowCloneViewModel();
        this.accountDetailsProvider = new GitLabAccountsDetailsProvider(this.cs, this.accountManager, (Function2<? super GitLabAccount, ? super Continuation<? super GitLabApi>, ? extends Object>)((Function2)new Function2<GitLabAccount, Continuation<? super GitLabApi>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ GitLabCloneRepositoriesViewModelImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        account = (GitLabAccount)this.L$0;
                        this.L$0 = account;
                        this.label = 1;
                        v0 = GitLabCloneRepositoriesViewModelImpl.access$getAccountManager$p(this.this$0).findCredentials((Account)account, (Continuation)this);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        account = (GitLabAccount)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        v1 = (String)v0;
                        if (v1 == null) {
                            return null;
                        }
                        token = v1;
                        return GitLabCloneRepositoriesViewModelImpl.access$getApiManager$p(this.this$0).getClient(account.getServer(), (Function0<String>)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(java.lang.String ), ()Ljava/lang/String;)((String)token));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(GitLabAccount p1, Continuation<? super GitLabApi> p2) {
                return (this.create((Object)((Object)p1), p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final String invokeSuspend$lambda$0(String $token) {
                return $token;
            }
        }));
    }

    @Override
    @NotNull
    public GitLabCloneRepositoriesListViewModel getListVm() {
        return this.listVm;
    }

    @Override
    @NotNull
    public SharedFlow<GitLabCloneRepositoriesViewModel.SearchModel> getSearchValue() {
        return this.searchValue;
    }

    @Override
    @NotNull
    public SharedFlow<String> getSelectedUrl() {
        return this.selectedUrl;
    }

    @Override
    @NotNull
    public GitShallowCloneViewModel getShallowCloneVm() {
        return this.shallowCloneVm;
    }

    @Override
    @NotNull
    public GitLabAccountsDetailsProvider getAccountDetailsProvider() {
        return this.accountDetailsProvider;
    }

    @Override
    public void selectItem(@Nullable GitLabCloneListItem item) {
        this.selectedItem.setValue((Object)item);
    }

    @Override
    public void setSearchValue(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this._searchValue.setValue((Object)text2);
    }

    @Override
    public void setDirectoryPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.directoryPath.setValue((Object)path);
    }

    @Override
    public void doClone(@NotNull CheckoutProvider.Listener checkoutListener) {
        Intrinsics.checkNotNullParameter((Object)checkoutListener, (String)"checkoutListener");
        String string = (String)this._selectedUrl.getValue();
        if (string == null) {
            throw new IllegalStateException("Clone button is enabled when repository is not selected".toString());
        }
        String selectedUrl = string;
        String directoryPath = (String)this.directoryPath.getValue();
        Path parent = Paths.get(directoryPath, new String[0]).toAbsolutePath().getParent();
        ValidationInfo destinationValidation = CloneDvcsValidationUtils.createDestination((String)((Object)parent).toString());
        if (destinationValidation != null) {
            String string2 = destinationValidation.message;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message");
            this.notifyCreateDirectoryFailed(string2);
            return;
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem lfs = localFileSystem;
        VirtualFile destinationParent = lfs.findFileByIoFile(parent.toFile());
        if (destinationParent == null) {
            destinationParent = lfs.refreshAndFindFileByIoFile(parent.toFile());
        }
        if (destinationParent == null) {
            this.notifyDestinationNotFound();
            return;
        }
        String directoryName = ((Object)Paths.get(directoryPath, new String[0]).getFileName()).toString();
        String parentDirectory = ((Object)parent.toAbsolutePath()).toString();
        GitCheckoutProvider.clone((Project)this.project, (Git)Git.getInstance(), (CheckoutProvider.Listener)checkoutListener, (VirtualFile)destinationParent, (String)selectedUrl, (String)directoryName, (String)parentDirectory, (GitShallowCloneOptions)this.getShallowCloneVm().getShallowCloneOptions());
    }

    private final void notifyCreateDirectoryFailed(String message) {
        GitLabCloneRepositoriesViewModelImpl $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(GitLabCloneRepositoriesViewModelImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        String[] stringArray = new String[]{message};
        logger.error(CollaborationToolsBundle.message((String)"clone.dialog.error.unable.to.create.destination.directory", (Object[])new Object[0]), stringArray);
        this.vcsNotifier.notifyError(CLONE_UNABLE_TO_CREATE_DESTINATION_DIRECTORY, CollaborationToolsBundle.message((String)"clone.dialog.clone.failed", (Object[])new Object[0]), CollaborationToolsBundle.message((String)"clone.dialog.error.unable.to.find.destination.directory", (Object[])new Object[0]));
    }

    private final void notifyDestinationNotFound() {
        GitLabCloneRepositoriesViewModelImpl $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(GitLabCloneRepositoriesViewModelImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.error(CollaborationToolsBundle.message((String)"clone.dialog.error.destination.not.exist", (Object[])new Object[0]));
        this.vcsNotifier.notifyError(CLONE_UNABLE_TO_FIND_DESTINATION_DIRECTORY, CollaborationToolsBundle.message((String)"clone.dialog.clone.failed", (Object[])new Object[0]), CollaborationToolsBundle.message((String)"clone.dialog.error.unable.to.find.destination.directory", (Object[])new Object[0]));
    }

    private static final GitLabCloneRepositoriesViewModel.SearchModel searchValue$lambda$0(String text2) {
        GitLabCloneRepositoriesViewModel.SearchModel searchModel;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        try {
            new URL(text2);
            searchModel = new GitLabCloneRepositoriesViewModel.SearchModel.Url(text2);
        }
        catch (MalformedURLException malformedURLException) {
            searchModel = GitLabCloneRepositoriesViewModel.SearchModel.Text.INSTANCE;
        }
        return searchModel;
    }

    public static final /* synthetic */ GitLabAccountManager access$getAccountManager$p(GitLabCloneRepositoriesViewModelImpl $this) {
        return $this.accountManager;
    }

    public static final /* synthetic */ GitLabApiManager access$getApiManager$p(GitLabCloneRepositoriesViewModelImpl $this) {
        return $this.apiManager;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/gitlab/ui/clone/model/GitLabCloneRepositoriesViewModelImpl$Companion;", "", "<init>", "()V", "CLONE_UNABLE_TO_CREATE_DESTINATION_DIRECTORY", "", "CLONE_UNABLE_TO_FIND_DESTINATION_DIRECTORY", "intellij.vcs.gitlab"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

