/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.util.ExecutionErrorDialog;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.python.remoteInterpreter.PythonRemoteInterpreterBundle;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.remote.PyRemoteSdkWithoutSudo;
import com.jetbrains.python.run.PythonTask;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PySshProjectSynchronizerHelpers {
    private static final String FIND_BEST_PLACE_PYCHARM_HELPER_SCRIPT = "pycharm/_jb_find_best_place.py";
    private static final String CREATE_FOLDER_PYCHARM_HELPER_SCRIPT = "pycharm/_jb_create_folder.py";
    private static final Logger LOG = Logger.getInstance(PySshProjectSynchronizerHelpers.class);

    private PySshProjectSynchronizerHelpers() {
    }

    @Nullable
    static MyServerRootAndFolder getInitialServerWorkDirAndBestProjectPath(@NotNull Sdk sdk, @NotNull Module module) {
        String output;
        if (sdk == null) {
            PySshProjectSynchronizerHelpers.$$$reportNull$$$0(0);
        }
        if (module == null) {
            PySshProjectSynchronizerHelpers.$$$reportNull$$$0(1);
        }
        if ((output = PySshProjectSynchronizerHelpers.executeScript(sdk, module, FIND_BEST_PLACE_PYCHARM_HELPER_SCRIPT, module.getProject().getName())) == null) {
            return null;
        }
        return new MyServerRootAndFolder(output);
    }

    @Nullable
    static String createRemoteFolder(@NotNull Sdk sdk, @NotNull Module module, @NotNull String path2) {
        if (sdk == null) {
            PySshProjectSynchronizerHelpers.$$$reportNull$$$0(2);
        }
        if (module == null) {
            PySshProjectSynchronizerHelpers.$$$reportNull$$$0(3);
        }
        if (path2 == null) {
            PySshProjectSynchronizerHelpers.$$$reportNull$$$0(4);
        }
        return PySshProjectSynchronizerHelpers.executeScript(sdk, module, CREATE_FOLDER_PYCHARM_HELPER_SCRIPT, path2);
    }

    @Nullable
    private static String executeScript(@NotNull Sdk sdk, @NotNull Module module, @NotNull String script, String ... arguments) {
        if (sdk == null) {
            PySshProjectSynchronizerHelpers.$$$reportNull$$$0(5);
        }
        if (module == null) {
            PySshProjectSynchronizerHelpers.$$$reportNull$$$0(6);
        }
        if (script == null) {
            PySshProjectSynchronizerHelpers.$$$reportNull$$$0(7);
        }
        if (arguments == null) {
            PySshProjectSynchronizerHelpers.$$$reportNull$$$0(8);
        }
        PyRemoteSdkWithoutSudo decoratedSdk = new PyRemoteSdkWithoutSudo(sdk);
        PythonTask task = new PythonTask(module, PythonRemoteInterpreterBundle.message("python.ssh.project.synchronizer.please.wait", new Object[0]), (Sdk)decoratedSdk);
        task.setRunnerScript(PythonHelpersLocator.findPathStringInHelpers((String)script));
        task.setParameters(Arrays.asList(arguments));
        try {
            return task.runNoConsole();
        }
        catch (ExecutionException e) {
            ExecutionErrorDialog.show((ExecutionException)e, (String)PythonRemoteInterpreterBundle.message("ssh.execute.script.error.checking.remote.side", new Object[0]), (Project)module.getProject());
            LOG.warn((Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/remoteInterpreter/PySshProjectSynchronizerHelpers";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInitialServerWorkDirAndBestProjectPath";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createRemoteFolder";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "executeScript";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class MyServerRootAndFolder {
        @NotNull
        final String myServerRootPath;
        @NotNull
        final String myServerProjectFolder;

        MyServerRootAndFolder(@NotNull String bestPlaceHelperOutput) {
            if (bestPlaceHelperOutput == null) {
                MyServerRootAndFolder.$$$reportNull$$$0(0);
            }
            String[] rootAndFolder = bestPlaceHelperOutput.split("\n");
            assert (rootAndFolder.length == 2) : String.format("Junk returned %s", StringUtil.join((String[])rootAndFolder, (String)"\n"));
            this.myServerRootPath = rootAndFolder[0];
            this.myServerProjectFolder = rootAndFolder[1];
        }

        MyServerRootAndFolder(@NotNull String serverRootPath, @NotNull String serverProjectFolder) {
            if (serverRootPath == null) {
                MyServerRootAndFolder.$$$reportNull$$$0(1);
            }
            if (serverProjectFolder == null) {
                MyServerRootAndFolder.$$$reportNull$$$0(2);
            }
            this.myServerRootPath = serverRootPath;
            this.myServerProjectFolder = serverProjectFolder;
        }

        @NotNull
        String getFullPath() {
            String string = this.myServerRootPath.trim() + "/" + this.myServerProjectFolder;
            if (string == null) {
                MyServerRootAndFolder.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bestPlaceHelperOutput";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serverRootPath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serverProjectFolder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/python/remoteInterpreter/PySshProjectSynchronizerHelpers$MyServerRootAndFolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/python/remoteInterpreter/PySshProjectSynchronizerHelpers$MyServerRootAndFolder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFullPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

