/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.cli.model;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.Device;
import com.github.dockerjava.api.model.DeviceRequest;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.InternetProtocol;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.LogConfig;
import com.github.dockerjava.api.model.LxcConf;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.RestartPolicy;
import com.github.dockerjava.api.model.Ulimit;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.ValueTransfer;
import com.intellij.docker.agent.cli.model.CliParserBase;
import com.intellij.docker.agent.cli.model.DockerRunCliParser;
import com.intellij.docker.agent.cli.model.DockerRunCliParserBase;
import com.intellij.docker.agent.fix.FixedBindParser;
import com.intellij.docker.agent.settings.DockerDeviceRequest;
import com.intellij.docker.agent.settings.DockerPortSpec;
import com.intellij.docker.agent.util.InternalUtilsKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002`aB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J!\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020#2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020&2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020(2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020&2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00020&2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020&2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020-2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001a\u0010.\u001a\f0/R\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u00102\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020-2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u0002042\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020\u0002062\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\u00020-2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020\u00020-2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001a\u00109\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030:2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00020-2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00020-2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00020@2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00020&2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00020&2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010C\u001a\b\u0012\u0004\u0012\u00020\u0002042\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010D\u001a\b\u0012\u0004\u0012\u00020\u0002042\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001a\u0010E\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030F2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001c\u0010I\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020J0F2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001a\u0010K\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030F2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00020-2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001c\u0010Q\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020R0F2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00020&2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00020V2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00020X2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u0002042\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010[\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00020]2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010^\u001a\b\u0012\u0004\u0012\u00020\u00020&2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006b"}, d2={"Lcom/intellij/docker/agent/cli/model/DockerRunCliParser;", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase;", "Lcom/github/dockerjava/api/command/CreateContainerCmd;", "<init>", "()V", "parse", "", "cmd", "optionsLine", "", "", "(Lcom/github/dockerjava/api/command/CreateContainerCmd;[Ljava/lang/String;)V", "name", "Lcom/intellij/docker/agent/cli/model/CliParserBase$SingleValueHandler;", "option", "Lorg/apache/commons/cli/Option;", "hostname", "user", "memory", "Lcom/intellij/docker/agent/cli/model/CliParserBase$MemoryOptionHandler;", "memorySwap", "memorySwappiness", "shmSize", "mount", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase$MountOptionHandler;", "kernelMemory", "memoryReservation", "cpusetCpus", "cpuShares", "Lcom/intellij/docker/agent/cli/model/CliParserBase$IntegerOptionHandler;", "cpuPeriod", "Lcom/intellij/docker/agent/cli/model/CliParserBase$LongOptionHandler;", "cpuQuota", "cpusetMems", "cpus", "Lcom/intellij/docker/agent/cli/model/CliParserBase$DoubleOptionHandler;", "blkioWeight", "oomKillDisable", "Lcom/intellij/docker/agent/cli/model/CliParserBase$BooleanOptionHandler;", "attach", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase$AttachOptionHandler;", "detach", "tty", "interactive", "env", "Lcom/intellij/docker/agent/cli/model/CliParserBase$ListHandler;", "envFile", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase$EnvFileListHandler;", "entrypoint", "workingDir", "expose", "addHost", "Lcom/intellij/docker/agent/cli/model/CliParserBase$StringListHandler;", "label", "Lcom/intellij/docker/agent/cli/model/CliParserBase$LabelListHandler;", "securityOpt", "volume", "link", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase$LinkOptionHandler;", "lxcConf", "logDriver", "logOpt", "macAddress", "publish", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase$PortBindingOptionHandler;", "publishAll", "privileged", "dns", "dnsSearch", "volumesFrom", "Lcom/intellij/docker/agent/cli/model/CliParserBase$MappedListHandler;", "cidfile", "platform", "capAdd", "Lcom/github/dockerjava/api/model/Capability;", "capDrop", "restart", "network", "networkAlias", "ip", "ip6", "device", "Lcom/github/dockerjava/api/model/Device;", "runtime", "rm", "ipc", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase$IPCOptionHandler;", "ulimit", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase$UlimitOptionHandler;", "groupAdd", "cgroupParent", "sysctl", "gpus", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase$GpuDeviceRequestHandler;", "init", "userns", "ExposeHandler", "Companion", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\nDockerRunCliParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerRunCliParser.kt\ncom/intellij/docker/agent/cli/model/DockerRunCliParser\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,548:1\n37#2:549\n36#2,3:550\n37#2:585\n36#2,3:586\n108#3:553\n80#3,29:554\n216#4,2:583\n*S KotlinDebug\n*F\n+ 1 DockerRunCliParser.kt\ncom/intellij/docker/agent/cli/model/DockerRunCliParser\n*L\n267#1:549\n267#1:550,3\n458#1:585\n458#1:586,3\n269#1:553\n269#1:554,29\n321#1:583,2\n*E\n"})
public final class DockerRunCliParser
extends DockerRunCliParserBase<CreateContainerCmd> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void parse(@NotNull CreateContainerCmd cmd, @NotNull String[] optionsLine) throws ApiTaskException {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)optionsLine, (String)"optionsLine");
        try {
            super.doParse(cmd, optionsLine, false);
        }
        catch (ParseException e) {
            throw new ApiTaskException((Exception)((Object)e));
        }
        catch (CliParserBase.IllegalOptionException e) {
            throw new ApiTaskException(e);
        }
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> name(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.name$lambda$0(name.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> hostname(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.hostname$lambda$1(hostname.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> user(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.user$lambda$2(user.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> memory(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MemoryOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.memory$lambda$4(DockerRunCliParser::memory$lambda$3, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> memorySwap(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MemoryOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.memorySwap$lambda$6(DockerRunCliParser::memorySwap$lambda$5, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> memorySwappiness(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MemoryOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.memorySwappiness$lambda$8(DockerRunCliParser::memorySwappiness$lambda$7, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> shmSize(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MemoryOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.shmSize$lambda$10(DockerRunCliParser::shmSize$lambda$9, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected DockerRunCliParserBase.MountOptionHandler<CreateContainerCmd> mount(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new DockerRunCliParserBase.MountOptionHandler<CreateContainerCmd>(option, DockerRunCliParser::mount$lambda$11);
    }

    @Override
    @NotNull
    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> kernelMemory(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MemoryOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.kernelMemory$lambda$13(DockerRunCliParser::kernelMemory$lambda$12, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> memoryReservation(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MemoryOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.memoryReservation$lambda$15(DockerRunCliParser::memoryReservation$lambda$14, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> cpusetCpus(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.cpusetCpus$lambda$17(DockerRunCliParser::cpusetCpus$lambda$16, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.IntegerOptionHandler<CreateContainerCmd> cpuShares(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.IntegerOptionHandler<Object>(option, (BiConsumer<Object, Integer>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> DockerRunCliParser.cpuShares$lambda$19(DockerRunCliParser::cpuShares$lambda$18, arg_0, arg_1)));
    }

    @Override
    @NotNull
    protected CliParserBase.LongOptionHandler<CreateContainerCmd> cpuPeriod(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.LongOptionHandler<Object>(option, (BiConsumer<Object, Long>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> DockerRunCliParser.cpuPeriod$lambda$21(DockerRunCliParser::cpuPeriod$lambda$20, arg_0, arg_1)));
    }

    @Override
    @NotNull
    protected CliParserBase.LongOptionHandler<CreateContainerCmd> cpuQuota(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.LongOptionHandler<Object>(option, (BiConsumer<Object, Long>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> DockerRunCliParser.cpuQuota$lambda$23(DockerRunCliParser::cpuQuota$lambda$22, arg_0, arg_1)));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> cpusetMems(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.cpusetMems$lambda$25(DockerRunCliParser::cpusetMems$lambda$24, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.DoubleOptionHandler<CreateContainerCmd> cpus(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.DoubleOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.cpus$lambda$27(DockerRunCliParser::cpus$lambda$26, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.IntegerOptionHandler<CreateContainerCmd> blkioWeight(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.IntegerOptionHandler<Object>(option, (BiConsumer<Object, Integer>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> DockerRunCliParser.blkioWeight$lambda$29(DockerRunCliParser::blkioWeight$lambda$28, arg_0, arg_1)));
    }

    @Override
    @NotNull
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> oomKillDisable(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.BooleanOptionHandlerImpl<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.oomKillDisable$lambda$31(DockerRunCliParser::oomKillDisable$lambda$30, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected DockerRunCliParserBase.AttachOptionHandler<CreateContainerCmd> attach(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new DockerRunCliParserBase.AttachOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.attach$lambda$32(attach.1.INSTANCE, arg_0, arg_1), (arg_0, arg_1) -> DockerRunCliParser.attach$lambda$33(attach.2.INSTANCE, arg_0, arg_1), (arg_0, arg_1) -> DockerRunCliParser.attach$lambda$34(attach.3.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> detach(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.BooleanOptionHandler<CreateContainerCmd>(option){

            protected void handleBooleanValue(boolean value) {
                block0: {
                    CreateContainerCmd createContainerCmd;
                    if (!value || (createContainerCmd = ((CreateContainerCmd)this.getCmd()).withAttachStdin(false)) == null || (createContainerCmd = createContainerCmd.withAttachStdout(false)) == null) break block0;
                    createContainerCmd.withAttachStderr(false);
                }
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> tty(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.BooleanOptionHandlerImpl<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.tty$lambda$35(tty.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> interactive(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.BooleanOptionHandler<CreateContainerCmd>(option){

            protected void handleBooleanValue(boolean value) {
                ((CreateContainerCmd)this.getCmd()).withStdinOpen(value);
                ((CreateContainerCmd)this.getCmd()).withAttachStdin(value);
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.ListHandler<CreateContainerCmd> env(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MappedListHandler<Object, String>(option, String.class, arg_0 -> DockerRunCliParser.env$lambda$36((Function1)new Function1<String, String>((Object)Companion){

            public final String invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$appendSystemValueIfFound((Companion)this.receiver, p0);
            }
        }, arg_0), (arg_0, arg_1) -> DockerRunCliParser.env$lambda$37((Function2)new Function2<CreateContainerCmd, String[], Unit>((Object)Companion){

            public final void invoke(CreateContainerCmd p0, String[] p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$appendToCmdEnvironment((Companion)this.receiver, p0, p1);
            }
        }, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected DockerRunCliParserBase.EnvFileListHandler envFile(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new DockerRunCliParserBase.EnvFileListHandler(this, option){
            final /* synthetic */ Option $option;
            {
                this.$option = $option;
                super($receiver, $option);
            }

            protected void handleEnvFile(String optionValue, File file) {
                Intrinsics.checkNotNullParameter((Object)optionValue, (String)"optionValue");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                String[] envVars = null;
                try {
                    Stream<String> stream = Files.lines(file.toPath());
                    Intrinsics.checkNotNullExpressionValue(stream, (String)"lines(...)");
                    Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)StreamsKt.asSequence(stream), envFile.1::handleEnvFile$lambda$1), envFile.1::handleEnvFile$lambda$2), (Function1)((Function1)new Function1<String, String>((Object)DockerRunCliParser.Companion){

                        public final String invoke(String p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            return com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$appendSystemValueIfFound((Companion)this.receiver, p0);
                        }
                    })));
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    envVars = thisCollection$iv.toArray(new String[0]);
                }
                catch (IOException e) {
                    throw new CliParserBase.IllegalOptionException(this.$option, optionValue, e);
                }
                CMD CMD = this.getCmd();
                Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$appendToCmdEnvironment(DockerRunCliParser.Companion, (CreateContainerCmd)CMD, envVars);
            }

            private static final String handleEnvFile$lambda$1(String obj) {
                Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
                String $this$trim$iv = obj;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            }

            private static final boolean handleEnvFile$lambda$2(String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return !(((CharSequence)text).length() == 0) && !StringsKt.startsWith$default((String)text, (String)"#", (boolean)false, (int)2, null);
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> entrypoint(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.entrypoint$lambda$39(DockerRunCliParser::entrypoint$lambda$38, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> workingDir(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.workingDir$lambda$40(workingDir.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.ListHandler<CreateContainerCmd> expose(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new ExposeHandler(option);
    }

    @Override
    @NotNull
    protected CliParserBase.StringListHandler<CreateContainerCmd> addHost(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.StringListHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.addHost$lambda$42(DockerRunCliParser::addHost$lambda$41, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.LabelListHandler<CreateContainerCmd> label(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.LabelListHandlerImpl<Object>(option, arg_0 -> DockerRunCliParser.label$lambda$43(label.1.INSTANCE, arg_0), (arg_0, arg_1) -> DockerRunCliParser.label$lambda$44(label.2.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.ListHandler<CreateContainerCmd> securityOpt(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.StringListHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.securityOpt$lambda$46(DockerRunCliParser::securityOpt$lambda$45, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.ListHandler<CreateContainerCmd> volume(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.ListHandler<CreateContainerCmd>(option){

            protected void handleValueList(String[] values) {
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                List volumes = new ArrayList<E>();
                List binds = new ArrayList<E>();
                for (String value : values) {
                    boolean bl;
                    if (!StringsKt.contains$default((CharSequence)value, (CharSequence)":", (boolean)false, (int)2, null)) {
                        bl = volumes.add(new Volume(value));
                        continue;
                    }
                    Bind bind = FixedBindParser.parse(value);
                    Intrinsics.checkNotNullExpressionValue((Object)bind, (String)"parse(...)");
                    bl = binds.add(bind);
                }
                if (!volumes.isEmpty()) {
                    ((CreateContainerCmd)this.getCmd()).withVolumes(volumes);
                }
                if (!binds.isEmpty()) {
                    CMD CMD = this.getCmd();
                    Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                    com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$findOrCreateHostConfig(DockerRunCliParser.Companion, (CreateContainerCmd)CMD).withBinds(binds);
                }
            }
        };
    }

    @Override
    @NotNull
    protected DockerRunCliParserBase.LinkOptionHandler<CreateContainerCmd, ?> link(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        BiConsumer<CreateContainerCmd, List<Link>> biConsumer = DockerRunCliParser::link$lambda$47;
        return new DockerRunCliParserBase.LinkOptionHandler<CreateContainerCmd, Link>(option, biConsumer){

            protected Link createLink(String name2, String alias) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
                return new Link(name2, alias);
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.ListHandler<CreateContainerCmd> lxcConf(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MappedListHandler<Object, LxcConf>(option, LxcConf.class, arg_0 -> DockerRunCliParser.lxcConf$lambda$50(option, arg_0), (arg_0, arg_1) -> DockerRunCliParser.lxcConf$lambda$52(DockerRunCliParser::lxcConf$lambda$51, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> logDriver(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.SingleValueHandler<CreateContainerCmd>(option){

            protected void handleEachValue(String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Collection $this$toTypedArray$iv = (Collection)logDriver.EntriesMappings.entries$0;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                for (LogConfig.LoggingType loggingType : thisCollection$iv.toArray(new LogConfig.LoggingType[0])) {
                    if (!Intrinsics.areEqual((Object)loggingType.getType(), (Object)value)) continue;
                    CMD CMD = this.getCmd();
                    Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                    com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$getOrCreateLogConfig(DockerRunCliParser.Companion, (CreateContainerCmd)CMD).setType(loggingType);
                    return;
                }
                throw new CliParserBase.IllegalOptionException(this.getOption(), value);
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.ListHandler<CreateContainerCmd> logOpt(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.ListHandler<CreateContainerCmd>(option){

            /*
             * WARNING - void declaration
             */
            protected void handleValueList(String[] values) {
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                for (String value : values) {
                    int endIndex$iv$iv;
                    int startIndex$iv$iv;
                    CharSequence $this$trim$iv$iv;
                    void $this$toTypedArray$iv;
                    CMD CMD = this.getCmd();
                    Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                    LogConfig logConfig = com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$getOrCreateLogConfig(DockerRunCliParser.Companion, (CreateContainerCmd)CMD);
                    Map logOptions = logConfig.getConfig();
                    if (logOptions == null) {
                        logOptions = new HashMap<K, V>();
                        logConfig.setConfig(logOptions);
                    }
                    Object object = value;
                    Object object2 = new Regex("=");
                    int n = 2;
                    object = object2.split((CharSequence)object, n);
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    String[] parts = thisCollection$iv.toArray(new String[0]);
                    if (parts.length == 2) {
                        object = logOptions;
                        String $this$trim$iv = parts[0];
                        boolean $i$f$trim = false;
                        CharSequence $this$trim$iv$iv2 = $this$trim$iv;
                        boolean $i$f$trim2 = false;
                        int startIndex$iv$iv2 = 0;
                        int endIndex$iv$iv2 = $this$trim$iv$iv2.length() - 1;
                        boolean startFound$iv$iv = false;
                        while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                            boolean match$iv$iv;
                            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv2 : endIndex$iv$iv2;
                            char it = $this$trim$iv$iv2.charAt(index$iv$iv);
                            boolean bl = false;
                            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                            if (!startFound$iv$iv) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv = true;
                                    continue;
                                }
                                ++startIndex$iv$iv2;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv2;
                        }
                        object2 = ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString();
                        String $this$trim$iv2 = parts[1];
                        boolean $i$f$trim3 = false;
                        $this$trim$iv$iv = $this$trim$iv2;
                        boolean $i$f$trim4 = false;
                        startIndex$iv$iv = 0;
                        endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                        boolean startFound$iv$iv2 = false;
                        while (startIndex$iv$iv <= endIndex$iv$iv) {
                            boolean match$iv$iv;
                            int index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv : endIndex$iv$iv;
                            char it = $this$trim$iv$iv.charAt(index$iv$iv);
                            boolean bl = false;
                            boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                            if (!startFound$iv$iv2) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv2 = true;
                                    continue;
                                }
                                ++startIndex$iv$iv;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv;
                        }
                    } else {
                        throw new CliParserBase.IllegalOptionException(this.getOption(), value);
                    }
                    String string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    object.put(object2, string);
                }
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> macAddress(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.macAddress$lambda$53(macAddress.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected DockerRunCliParserBase.PortBindingOptionHandler<CreateContainerCmd> publish(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new DockerRunCliParserBase.PortBindingOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.publish$lambda$56(DockerRunCliParser::publish$lambda$55, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> publishAll(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.BooleanOptionHandlerImpl<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.publishAll$lambda$58(DockerRunCliParser::publishAll$lambda$57, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> privileged(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.BooleanOptionHandlerImpl<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.privileged$lambda$60(DockerRunCliParser::privileged$lambda$59, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.StringListHandler<CreateContainerCmd> dns(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.StringListHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.dns$lambda$62(DockerRunCliParser::dns$lambda$61, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.StringListHandler<CreateContainerCmd> dnsSearch(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.StringListHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.dnsSearch$lambda$64(DockerRunCliParser::dnsSearch$lambda$63, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.MappedListHandler<CreateContainerCmd, ?> volumesFrom(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MappedListHandler<Object, VolumesFrom>(option, VolumesFrom.class, arg_0 -> DockerRunCliParser.volumesFrom$lambda$65(volumesFrom.1.INSTANCE, arg_0), (arg_0, arg_1) -> DockerRunCliParser.volumesFrom$lambda$67(DockerRunCliParser::volumesFrom$lambda$66, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> cidfile(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.cidfile$lambda$69(DockerRunCliParser::cidfile$lambda$68, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> platform(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.platform$lambda$70(platform.1.INSTANCE, arg_0, arg_1));
    }

    @NotNull
    protected CliParserBase.MappedListHandler<CreateContainerCmd, Capability> capAdd(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MappedListHandler<Object, Capability>(option, Capability.class, arg_0 -> DockerRunCliParser.capAdd$lambda$72(DockerRunCliParser::capAdd$lambda$71, arg_0), (arg_0, arg_1) -> DockerRunCliParser.capAdd$lambda$74(DockerRunCliParser::capAdd$lambda$73, arg_0, arg_1));
    }

    @NotNull
    protected CliParserBase.MappedListHandler<CreateContainerCmd, ?> capDrop(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MappedListHandler<Object, Capability>(option, Capability.class, arg_0 -> DockerRunCliParser.capDrop$lambda$76(DockerRunCliParser::capDrop$lambda$75, arg_0), (arg_0, arg_1) -> DockerRunCliParser.capDrop$lambda$78(DockerRunCliParser::capDrop$lambda$77, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> restart(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.restart$lambda$80(DockerRunCliParser::restart$lambda$79, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> network(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.SingleValueHandler<CreateContainerCmd>(option){

            protected void handleEachValue(String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                if (StringsKt.equals((String)"none", (String)value, (boolean)true)) {
                    v0 = ((CreateContainerCmd)this.getCmd()).withNetworkDisabled(true);
                } else {
                    CMD CMD = this.getCmd();
                    Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                    v0 = com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$findOrCreateHostConfig(DockerRunCliParser.Companion, (CreateContainerCmd)CMD).withNetworkMode(value);
                }
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.ListHandler<CreateContainerCmd> networkAlias(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.StringListHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.networkAlias$lambda$82(DockerRunCliParser::networkAlias$lambda$81, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> ip(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.ip$lambda$83(ip.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> ip6(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.ip6$lambda$84(ip6.1.INSTANCE, arg_0, arg_1));
    }

    @NotNull
    protected CliParserBase.MappedListHandler<CreateContainerCmd, Device> device(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MappedListHandler<Object, Device>(option, Device.class, arg_0 -> DockerRunCliParser.device$lambda$86(DockerRunCliParser::device$lambda$85, arg_0), (arg_0, arg_1) -> DockerRunCliParser.device$lambda$88(DockerRunCliParser::device$lambda$87, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> runtime(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.runtime$lambda$90(DockerRunCliParser::runtime$lambda$89, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> rm(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.BooleanOptionHandler<CreateContainerCmd>(option){

            protected void handleBooleanValue(boolean value) {
                CMD CMD = this.getCmd();
                Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$findOrCreateHostConfig(DockerRunCliParser.Companion, (CreateContainerCmd)CMD).withAutoRemove(value);
            }
        };
    }

    @Override
    @NotNull
    protected DockerRunCliParserBase.IPCOptionHandler<CreateContainerCmd> ipc(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new DockerRunCliParserBase.IPCOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.ipc$lambda$92(DockerRunCliParser::ipc$lambda$91, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected DockerRunCliParserBase.UlimitOptionHandler<CreateContainerCmd> ulimit(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new DockerRunCliParserBase.UlimitOptionHandler<CreateContainerCmd>(option){

            private final Ulimit toApiLimit(DockerRunCliParserBase.UlimitOptionHandler.CliUlimit limit) {
                return new Ulimit(limit.getName(), limit.getSoft(), limit.getHard());
            }

            /*
             * WARNING - void declaration
             */
            protected void handleUlimits(List<DockerRunCliParserBase.UlimitOptionHandler.CliUlimit> limits) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(limits, (String)"limits");
                Iterable $this$map$iv = limits;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    DockerRunCliParserBase.UlimitOptionHandler.CliUlimit cliUlimit = (DockerRunCliParserBase.UlimitOptionHandler.CliUlimit)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.toApiLimit((DockerRunCliParserBase.UlimitOptionHandler.CliUlimit)p0));
                }
                List apiLimits = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                CMD CMD = this.getCmd();
                Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$findOrCreateHostConfig(DockerRunCliParser.Companion, (CreateContainerCmd)CMD).withUlimits(apiLimits);
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.StringListHandler<CreateContainerCmd> groupAdd(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.StringListHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.groupAdd$lambda$94(DockerRunCliParser::groupAdd$lambda$93, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> cgroupParent(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.cgroupParent$lambda$96(DockerRunCliParser::cgroupParent$lambda$95, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> sysctl(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.sysctl$lambda$98((arg_0, arg_1) -> DockerRunCliParser.sysctl$lambda$97(option, arg_0, arg_1), arg_0, arg_1));
    }

    @Override
    @NotNull
    protected DockerRunCliParserBase.GpuDeviceRequestHandler<CreateContainerCmd> gpus(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new DockerRunCliParserBase.GpuDeviceRequestHandler<CreateContainerCmd>(option){

            protected void handleDeviceRequest(String value, DockerDeviceRequest dto) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
                    CMD CMD = this.getCmd();
                    Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                    HostConfig hostConfig = com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$findOrCreateHostConfig(DockerRunCliParser.Companion, (CreateContainerCmd)CMD);
                    if (hostConfig.getDeviceRequests() == null) {
                        hostConfig.withDeviceRequests((List<DeviceRequest>)new ArrayList<E>());
                    }
                    List<DeviceRequest> list2 = hostConfig.getDeviceRequests();
                    if (list2 == null) break block1;
                    list2.add(new DeviceRequest().withDriver(dto.getDriver()).withCount(dto.getCount()).withCapabilities(dto.getCapabilities()).withOptions(dto.getOptions()).withDeviceIds(dto.getDeviceIds()));
                }
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> init(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.BooleanOptionHandler<CreateContainerCmd>(option){

            protected void handleBooleanValue(boolean value) {
                CMD CMD = this.getCmd();
                Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$findOrCreateHostConfig(DockerRunCliParser.Companion, (CreateContainerCmd)CMD).withInit(true);
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> userns(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.userns$lambda$100(DockerRunCliParser::userns$lambda$99, arg_0, arg_1));
    }

    private static final void name$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void hostname$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void user$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit memory$lambda$3(CreateContainerCmd cmd, Long value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withMemory(value);
        return Unit.INSTANCE;
    }

    private static final void memory$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit memorySwap$lambda$5(CreateContainerCmd cmd, Long value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withMemorySwap(value);
        return Unit.INSTANCE;
    }

    private static final void memorySwap$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit memorySwappiness$lambda$7(CreateContainerCmd cmd, Long value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withMemorySwappiness(value);
        return Unit.INSTANCE;
    }

    private static final void memorySwappiness$lambda$8(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit shmSize$lambda$9(CreateContainerCmd cmd, Long size) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withShmSize(size);
        return Unit.INSTANCE;
    }

    private static final void shmSize$lambda$10(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void mount$lambda$11(CreateContainerCmd cmd, List mounts) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withMounts(mounts);
    }

    private static final Unit kernelMemory$lambda$12(CreateContainerCmd cmd, Long size) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withKernelMemory(size);
        return Unit.INSTANCE;
    }

    private static final void kernelMemory$lambda$13(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit memoryReservation$lambda$14(CreateContainerCmd cmd, Long size) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withMemoryReservation(size);
        return Unit.INSTANCE;
    }

    private static final void memoryReservation$lambda$15(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit cpusetCpus$lambda$16(CreateContainerCmd cmd, String value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withCpusetCpus(value);
        return Unit.INSTANCE;
    }

    private static final void cpusetCpus$lambda$17(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit cpuShares$lambda$18(CreateContainerCmd cmd, Integer value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withCpuShares(value);
        return Unit.INSTANCE;
    }

    private static final void cpuShares$lambda$19(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit cpuPeriod$lambda$20(CreateContainerCmd cmd, Long value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withCpuPeriod(value);
        return Unit.INSTANCE;
    }

    private static final void cpuPeriod$lambda$21(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit cpuQuota$lambda$22(CreateContainerCmd cmd, Long quota) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withCpuQuota(quota);
        return Unit.INSTANCE;
    }

    private static final void cpuQuota$lambda$23(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit cpusetMems$lambda$24(CreateContainerCmd cmd, String value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withCpusetMems(value);
        return Unit.INSTANCE;
    }

    private static final void cpusetMems$lambda$25(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit cpus$lambda$26(CreateContainerCmd cmd, double ratio) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        if (ratio < 0.0) {
            throw new CliParserBase.IllegalOptionException("'--cpus' value should not be negative");
        }
        int DEFAULT_PERIOD = 100000;
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withCpuPeriod(Long.valueOf(DEFAULT_PERIOD)).withCpuQuota(Long.valueOf((int)(ratio * (double)DEFAULT_PERIOD)));
        return Unit.INSTANCE;
    }

    private static final void cpus$lambda$27(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit blkioWeight$lambda$28(CreateContainerCmd cmd, Integer value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withBlkioWeight(value);
        return Unit.INSTANCE;
    }

    private static final void blkioWeight$lambda$29(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit oomKillDisable$lambda$30(CreateContainerCmd cmd, Boolean value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withOomKillDisable(value);
        return Unit.INSTANCE;
    }

    private static final void oomKillDisable$lambda$31(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void attach$lambda$32(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void attach$lambda$33(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void attach$lambda$34(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void tty$lambda$35(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final String env$lambda$36(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final void env$lambda$37(Function2 $tmp0, Object p0, String[] p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final Unit entrypoint$lambda$38(CreateContainerCmd obj, String entrypoint) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        String[] stringArray = new String[]{entrypoint};
        obj.withEntrypoint(stringArray);
        return Unit.INSTANCE;
    }

    private static final void entrypoint$lambda$39(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void workingDir$lambda$40(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit addHost$lambda$41(CreateContainerCmd cmd, String[] values) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withExtraHosts(Arrays.copyOf(values, values.length));
        return Unit.INSTANCE;
    }

    private static final void addHost$lambda$42(Function2 $tmp0, Object p0, String[] p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final Map label$lambda$43(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    private static final void label$lambda$44(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit securityOpt$lambda$45(CreateContainerCmd cmd, String[] values) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withSecurityOpts(new ArrayList(CollectionsKt.listOf((Object[])Arrays.copyOf(values, values.length))));
        return Unit.INSTANCE;
    }

    private static final void securityOpt$lambda$46(Function2 $tmp0, Object p0, String[] p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final void link$lambda$47(CreateContainerCmd cmd, List value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withLinks(value);
    }

    private static final LxcConf lxcConf$lambda$50(Option $option, String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        CharSequence charSequence = source;
        Regex regex = new Regex("=");
        int n = 2;
        Collection $this$toTypedArray$iv = regex.split(charSequence, n);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] parts = thisCollection$iv.toArray(new String[0]);
        if (parts.length == 2) {
            boolean match$iv$iv;
            char it;
            int index$iv$iv;
            String $this$trim$iv = parts[0];
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            $this$trim$iv = parts[1];
            String string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            $i$f$trim = false;
            $this$trim$iv$iv = $this$trim$iv;
            $i$f$trim2 = false;
            startIndex$iv$iv = 0;
            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String string2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            String string3 = string;
            return new LxcConf(string3, string2);
        }
        throw new CliParserBase.IllegalOptionException($option, source);
    }

    private static final Unit lxcConf$lambda$51(CreateContainerCmd cmd, LxcConf[] value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withLxcConf(value);
        return Unit.INSTANCE;
    }

    private static final void lxcConf$lambda$52(Function2 $tmp0, Object p0, LxcConf[] p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final void macAddress$lambda$53(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit publish$lambda$55(CreateContainerCmd cmd, DockerPortSpec[] specs) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)specs, (String)"specs");
        Ports ports = new Ports();
        for (DockerPortSpec nextSpec : specs) {
            Map<ExposedPort, Ports.Binding> bindings;
            Map<ExposedPort, Ports.Binding> $this$forEach$iv = bindings = nextSpec.toNativeMap(ExposeHandler.Companion.getNewExposedPort(), Ports.Binding::new);
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<ExposedPort, Ports.Binding>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ExposedPort, Ports.Binding> element$iv;
                Map.Entry<ExposedPort, Ports.Binding> entry = element$iv = iterator.next();
                boolean bl = false;
                ExposedPort port = entry.getKey();
                Ports.Binding binding = entry.getValue();
                ports.bind(port, binding);
            }
        }
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withPortBindings(ports);
        return Unit.INSTANCE;
    }

    private static final void publish$lambda$56(Function2 $tmp0, Object p0, DockerPortSpec[] p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final Unit publishAll$lambda$57(CreateContainerCmd cmd, Boolean value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withPublishAllPorts(value);
        return Unit.INSTANCE;
    }

    private static final void publishAll$lambda$58(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit privileged$lambda$59(CreateContainerCmd cmd, Boolean value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withPrivileged(value);
        return Unit.INSTANCE;
    }

    private static final void privileged$lambda$60(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit dns$lambda$61(CreateContainerCmd cmd, String[] value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withDns(Arrays.copyOf(value, value.length));
        return Unit.INSTANCE;
    }

    private static final void dns$lambda$62(Function2 $tmp0, Object p0, String[] p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final Unit dnsSearch$lambda$63(CreateContainerCmd cmd, String[] value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withDnsSearch(Arrays.copyOf(value, value.length));
        return Unit.INSTANCE;
    }

    private static final void dnsSearch$lambda$64(Function2 $tmp0, Object p0, String[] p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final VolumesFrom volumesFrom$lambda$65(Function1 $tmp0, Object p0) {
        return (VolumesFrom)$tmp0.invoke(p0);
    }

    private static final Unit volumesFrom$lambda$66(CreateContainerCmd cmd, VolumesFrom[] value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withVolumesFrom(Arrays.copyOf(value, value.length));
        return Unit.INSTANCE;
    }

    private static final void volumesFrom$lambda$67(Function2 $tmp0, Object p0, VolumesFrom[] p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final Unit cidfile$lambda$68(CreateContainerCmd cmd, String value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withContainerIDFile(value);
        return Unit.INSTANCE;
    }

    private static final void cidfile$lambda$69(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void platform$lambda$70(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Capability capAdd$lambda$71(String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return Capability.valueOf(name2);
    }

    private static final Capability capAdd$lambda$72(Function1 $tmp0, Object p0) {
        return (Capability)((Object)$tmp0.invoke(p0));
    }

    private static final Unit capAdd$lambda$73(CreateContainerCmd cmd, Capability[] cap) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)cap, (String)"cap");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withCapAdd(Arrays.copyOf(cap, cap.length));
        return Unit.INSTANCE;
    }

    private static final void capAdd$lambda$74(Function2 $tmp0, Object p0, Capability[] p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final Capability capDrop$lambda$75(String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return Capability.valueOf(name2);
    }

    private static final Capability capDrop$lambda$76(Function1 $tmp0, Object p0) {
        return (Capability)((Object)$tmp0.invoke(p0));
    }

    private static final Unit capDrop$lambda$77(CreateContainerCmd cmd, Capability[] cap) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)cap, (String)"cap");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withCapDrop(Arrays.copyOf(cap, cap.length));
        return Unit.INSTANCE;
    }

    private static final void capDrop$lambda$78(Function2 $tmp0, Object p0, Capability[] p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final Unit restart$lambda$79(CreateContainerCmd cmd, String restart) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withRestartPolicy(RestartPolicy.parse(restart));
        return Unit.INSTANCE;
    }

    private static final void restart$lambda$80(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit networkAlias$lambda$81(CreateContainerCmd obj, String[] aliases) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)aliases, (String)"aliases");
        obj.withAliases(Arrays.copyOf(aliases, aliases.length));
        return Unit.INSTANCE;
    }

    private static final void networkAlias$lambda$82(Function2 $tmp0, Object p0, String[] p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final void ip$lambda$83(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void ip6$lambda$84(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Device device$lambda$85(String deviceStr) {
        Intrinsics.checkNotNullParameter((Object)deviceStr, (String)"deviceStr");
        return Device.parse(deviceStr);
    }

    private static final Device device$lambda$86(Function1 $tmp0, Object p0) {
        return (Device)$tmp0.invoke(p0);
    }

    private static final Unit device$lambda$87(CreateContainerCmd cmd, Device[] devices) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)devices, (String)"devices");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withDevices(Arrays.copyOf(devices, devices.length));
        return Unit.INSTANCE;
    }

    private static final void device$lambda$88(Function2 $tmp0, Object p0, Device[] p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final Unit runtime$lambda$89(CreateContainerCmd cmd, String value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withRuntime(value);
        return Unit.INSTANCE;
    }

    private static final void runtime$lambda$90(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit ipc$lambda$91(CreateContainerCmd cmd, String ipcMode) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withIpcMode(ipcMode);
        return Unit.INSTANCE;
    }

    private static final void ipc$lambda$92(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit groupAdd$lambda$93(CreateContainerCmd cmd, String[] value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withGroupAdd(CollectionsKt.listOf((Object[])Arrays.copyOf(value, value.length)));
        return Unit.INSTANCE;
    }

    private static final void groupAdd$lambda$94(Function2 $tmp0, Object p0, String[] p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final Unit cgroupParent$lambda$95(CreateContainerCmd cmd, String value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withCgroupParent(value);
        return Unit.INSTANCE;
    }

    private static final void cgroupParent$lambda$96(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit sysctl$lambda$97(Option $option, CreateContainerCmd cmd, String keyValuePair) {
        void $this$toTypedArray$iv;
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        CharSequence charSequence = keyValuePair;
        if (charSequence == null || charSequence.length() == 0) {
            throw new CliParserBase.IllegalOptionException($option, keyValuePair);
        }
        Object object = keyValuePair;
        Regex regex = new Regex("=");
        int n = 2;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] parts = thisCollection$iv.toArray(new String[0]);
        if (parts.length != 2) {
            throw new CliParserBase.IllegalOptionException($option, keyValuePair);
        }
        HostConfig hostConfig = DockerRunCliParser.Companion.findOrCreateHostConfig(cmd);
        Map allSysctls = hostConfig.getSysctls();
        if (allSysctls == null) {
            allSysctls = new HashMap();
            hostConfig.withSysctls(allSysctls);
        }
        allSysctls.put(parts[0], parts[1]);
        return Unit.INSTANCE;
    }

    private static final void sysctl$lambda$98(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit userns$lambda$99(CreateContainerCmd cmd, String value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withUsernsMode(value);
        return Unit.INSTANCE;
    }

    private static final void userns$lambda$100(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J#\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0002\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/agent/cli/model/DockerRunCliParser$Companion;", "", "<init>", "()V", "appendSystemValueIfFound", "", "varDeclaration", "appendToCmdEnvironment", "", "cmd", "Lcom/github/dockerjava/api/command/CreateContainerCmd;", "env", "", "(Lcom/github/dockerjava/api/command/CreateContainerCmd;[Ljava/lang/String;)V", "getOrCreateLogConfig", "Lcom/github/dockerjava/api/model/LogConfig;", "findOrCreateHostConfig", "Lcom/github/dockerjava/api/model/HostConfig;", "intellij.clouds.docker.agent"})
    @SourceDebugExtension(value={"SMAP\nDockerRunCliParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerRunCliParser.kt\ncom/intellij/docker/agent/cli/model/DockerRunCliParser$Companion\n+ 2 ValueTransfer.kt\ncom/intellij/docker/agent/ValueTransfer$CombiningListTransfer$Companion\n*L\n1#1,548:1\n48#2,4:549\n*S KotlinDebug\n*F\n+ 1 DockerRunCliParser.kt\ncom/intellij/docker/agent/cli/model/DockerRunCliParser$Companion\n*L\n519#1:549,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String appendSystemValueIfFound(String varDeclaration) {
            Object object;
            if (!StringsKt.contains$default((CharSequence)varDeclaration, (CharSequence)"=", (boolean)false, (int)2, null)) {
                String localSystemValue;
                String string = InternalUtilsKt.nullize(System.getenv(varDeclaration));
                if (string == null) {
                    string = InternalUtilsKt.nullize(System.getProperty(varDeclaration));
                }
                object = (localSystemValue = string) != null ? varDeclaration + "=" + localSystemValue : varDeclaration;
            } else {
                object = varDeclaration;
            }
            return object;
        }

        private final void appendToCmdEnvironment(CreateContainerCmd cmd, String[] env2) {
            ValueTransfer.CombiningListTransfer.Companion this_$iv = ValueTransfer.CombiningListTransfer.Companion;
            boolean $i$f$mergeArrays = false;
            new ValueTransfer.CombiningListTransfer((Function1)new Function1<String[], List<? extends String>>(env2){
                final /* synthetic */ String[] $env$inlined;
                {
                    this.$env$inlined = stringArray;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final List invoke(Object it) {
                    String[] it2 = (String[])it;
                    boolean bl = false;
                    Object[] objectArray = this.$env$inlined;
                    return objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
                }
            }, (Function1)new Function1<CreateContainerCmd, List<? extends String>>(){

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final List invoke(Object it) {
                    CreateContainerCmd p0 = (CreateContainerCmd)it;
                    boolean bl = false;
                    Object[] objectArray = p0.getEnv();
                    return objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
                }
            }, (Function2)new Function2<CreateContainerCmd, List<? extends String>, Object>(){

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                public final Object invoke(Object trg, List list2) {
                    void array;
                    Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
                    Collection $this$toTypedArray$iv = list2;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    CreateContainerCmd target2 = (CreateContainerCmd)trg;
                    boolean bl = false;
                    CreateContainerCmd createContainerCmd = target2.withEnv((String[])Arrays.copyOf(array, ((void)array).length));
                    Intrinsics.checkNotNullExpressionValue((Object)createContainerCmd, (String)"withEnv(...)");
                    return createContainerCmd;
                }
            }).transferFromTo(env2, cmd);
        }

        private final LogConfig getOrCreateLogConfig(CreateContainerCmd cmd) {
            HostConfig hostConfig = this.findOrCreateHostConfig(cmd);
            LogConfig result2 = hostConfig.getLogConfig();
            if (result2 == null) {
                result2 = new LogConfig();
            }
            hostConfig.withLogConfig(result2);
            return result2;
        }

        private final HostConfig findOrCreateHostConfig(CreateContainerCmd cmd) {
            HostConfig result2 = cmd.getHostConfig();
            if (result2 == null) {
                result2 = new HostConfig();
                cmd.withHostConfig(result2);
            }
            return result2;
        }

        public static final /* synthetic */ String access$appendSystemValueIfFound(Companion $this, String varDeclaration) {
            return $this.appendSystemValueIfFound(varDeclaration);
        }

        public static final /* synthetic */ void access$appendToCmdEnvironment(Companion $this, CreateContainerCmd cmd, String[] env2) {
            $this.appendToCmdEnvironment(cmd, env2);
        }

        public static final /* synthetic */ LogConfig access$getOrCreateLogConfig(Companion $this, CreateContainerCmd cmd) {
            return $this.getOrCreateLogConfig(cmd);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \t2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001:\u0001\tB\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lcom/intellij/docker/agent/cli/model/DockerRunCliParser$ExposeHandler;", "Lcom/intellij/docker/agent/cli/model/CliParserBase$MappedListHandler;", "Lcom/github/dockerjava/api/command/CreateContainerCmd;", "", "Lcom/github/dockerjava/api/model/ExposedPort;", "option", "Lorg/apache/commons/cli/Option;", "<init>", "(Lorg/apache/commons/cli/Option;)V", "Companion", "intellij.clouds.docker.agent"})
    private static final class ExposeHandler
    extends CliParserBase.MappedListHandler<CreateContainerCmd, ExposedPort[]> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final BiFunction<String, Integer, ExposedPort> newExposedPort = ExposeHandler::newExposedPort$lambda$1;

        public ExposeHandler(@NotNull Option option) {
            Intrinsics.checkNotNullParameter((Object)option, (String)"option");
            super(option, ExposedPort[].class, arg_0 -> ExposeHandler._init_$lambda$0(option, arg_0), (arg_0, arg_1) -> Companion.access$applyToCmd(Companion, arg_0, arg_1));
        }

        private static final ExposedPort[] _init_$lambda$0(Option $option, String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return ExposeHandler.Companion.parseFromString($option, text);
        }

        private static final ExposedPort newExposedPort$lambda$1(String protocol, int port) {
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            String string = protocol.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            return new ExposedPort(port, InternetProtocol.valueOf(string));
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000bJ)\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0005H\u0002\u00a2\u0006\u0002\u0010\u0011R#\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00060\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/docker/agent/cli/model/DockerRunCliParser$ExposeHandler$Companion;", "", "<init>", "()V", "parseFromString", "", "Lcom/github/dockerjava/api/model/ExposedPort;", "option", "Lorg/apache/commons/cli/Option;", "text", "", "(Lorg/apache/commons/cli/Option;Ljava/lang/String;)[Lcom/github/dockerjava/api/model/ExposedPort;", "applyToCmd", "", "cmd", "Lcom/github/dockerjava/api/command/CreateContainerCmd;", "parsedArray", "(Lcom/github/dockerjava/api/command/CreateContainerCmd;[[Lcom/github/dockerjava/api/model/ExposedPort;)V", "newExposedPort", "Ljava/util/function/BiFunction;", "", "getNewExposedPort", "()Ljava/util/function/BiFunction;", "intellij.clouds.docker.agent"})
        @SourceDebugExtension(value={"SMAP\nDockerRunCliParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerRunCliParser.kt\ncom/intellij/docker/agent/cli/model/DockerRunCliParser$ExposeHandler$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,548:1\n37#2:549\n36#2,3:550\n37#2:559\n36#2,3:560\n10065#3:553\n10487#3,5:554\n*S KotlinDebug\n*F\n+ 1 DockerRunCliParser.kt\ncom/intellij/docker/agent/cli/model/DockerRunCliParser$ExposeHandler$Companion\n*L\n197#1:549\n197#1:550,3\n205#1:559\n205#1:560,3\n205#1:553\n205#1:554,5\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            private final ExposedPort[] parseFromString(Option option, String text) {
                try {
                    Collection $this$toTypedArray$iv = DockerPortSpec.ContainerPortsSpec.Companion.fromString(text).toNativeList(this.getNewExposedPort());
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    return thisCollection$iv.toArray(new ExposedPort[0]);
                }
                catch (IllegalArgumentException e) {
                    throw new CliParserBase.IllegalOptionException(option, text, e);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void applyToCmd(CreateContainerCmd cmd, ExposedPort[][] parsedArray) {
                void $this$toTypedArray$iv;
                void $this$flatMapTo$iv$iv;
                Object $this$flatMap$iv = (Object[])parsedArray;
                boolean $i$f$flatMap = false;
                Object[] objectArray = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (void element$iv$iv : $this$flatMapTo$iv$iv) {
                    Object[] it = (ExposedPort[])element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = ArraysKt.toList((Object[])it);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                ExposedPort[] flattenedPorts = thisCollection$iv.toArray(new ExposedPort[0]);
                cmd.withExposedPorts(Arrays.copyOf(flattenedPorts, flattenedPorts.length));
            }

            @NotNull
            public final BiFunction<String, Integer, ExposedPort> getNewExposedPort() {
                return newExposedPort;
            }

            public static final /* synthetic */ void access$applyToCmd(Companion $this, CreateContainerCmd cmd, ExposedPort[][] parsedArray) {
                $this.applyToCmd(cmd, parsedArray);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

