/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.maven;

import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.java.BuildFileProviderBase;
import com.intellij.packageChecker.java.JavaPackageUtilKt;
import com.intellij.packageChecker.maven.MavenBuildFileProviderKt;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.security.package.Package;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J0\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u00152\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\"\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J$\u0010\u0019\u001a\u0004\u0018\u00010\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lcom/intellij/packageChecker/maven/MavenBuildFileProvider;", "Lcom/intellij/packageChecker/java/BuildFileProviderBase;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "id", "", "getId", "()Ljava/lang/String;", "supports", "", "file", "Lcom/intellij/psi/PsiFile;", "importedPackages", "", "Lorg/jetbrains/security/package/Package;", "module", "Lcom/intellij/openapi/module/Module;", "getModule", "getRoots", "", "pkgs", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "versionFallback", "unifiedDependency", "Lcom/intellij/buildsystem/model/unified/UnifiedDependency;", "moduleScript", "intellij.packageChecker.maven"})
@SourceDebugExtension(value={"SMAP\nMavenBuildFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenBuildFileProvider.kt\ncom/intellij/packageChecker/maven/MavenBuildFileProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,101:1\n1611#2,9:102\n1863#2:111\n1864#2:113\n1620#2:114\n1611#2,9:115\n1863#2:124\n1864#2:126\n1620#2:127\n1#3:112\n1#3:125\n25#4:128\n*S KotlinDebug\n*F\n+ 1 MavenBuildFileProvider.kt\ncom/intellij/packageChecker/maven/MavenBuildFileProvider\n*L\n33#1:102,9\n33#1:111\n33#1:113\n33#1:114\n42#1:115,9\n42#1:124\n42#1:126\n42#1:127\n33#1:112\n42#1:125\n51#1:128\n*E\n"})
public final class MavenBuildFileProvider
extends BuildFileProviderBase {
    @NotNull
    private final String id;

    public MavenBuildFileProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.id = "maven";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public boolean supports(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return MavenDomUtil.isProjectFile((PsiFile)file) && MavenDomUtil.INSTANCE.findContainingMavenizedModule(file) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Package> importedPackages(@NotNull PsiFile file) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MavenProject mavenProject = MavenProjectsManager.getInstance((Project)this.getProject()).findProject(file.getVirtualFile());
        if (mavenProject == null) {
            return CollectionsKt.emptyList();
        }
        MavenProject findProject = mavenProject;
        List dependencies = findProject.getDependencies();
        Iterable $this$mapNotNull$iv = dependencies;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Package it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MavenArtifact mavenArtifact = (MavenArtifact)element$iv$iv;
            boolean bl2 = false;
            ProgressManager.checkCanceled();
            if (MavenBuildFileProviderKt.createPackage(mavenArtifact) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Package> importedPackages(@NotNull Module module) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        MavenProject mavenProject = MavenProjectsManager.getInstance((Project)this.getProject()).findProject(module);
        if (mavenProject == null) {
            return CollectionsKt.emptyList();
        }
        MavenProject findProject = mavenProject;
        List dependencies = findProject.getDependencies();
        Iterable $this$mapNotNull$iv = dependencies;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Package it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MavenArtifact it = (MavenArtifact)element$iv$iv;
            boolean bl2 = false;
            ProgressManager.checkCanceled();
            if (MavenBuildFileProviderKt.createPackage(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public Module getModule(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Module module = MavenDomUtil.INSTANCE.findContainingMavenizedModule(file);
        if (module == null) {
            MavenBuildFileProvider $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(MavenBuildFileProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Not a Maven module by file: " + file.getName());
        }
        return module;
    }

    @Override
    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return MavenUtil.isMavenModule((Module)module);
    }

    @Override
    @NotNull
    public Map<Package, List<Package>> getRoots(@NotNull PsiFile file, @NotNull List<Package> pkgs2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(pkgs2, (String)"pkgs");
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return MapsKt.emptyMap();
        }
        VirtualFile virtualFile2 = virtualFile;
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"getInstance(...)");
        MavenProjectsManager manager = mavenProjectsManager;
        MavenProject mavenProject = manager.findProject(virtualFile2);
        if (mavenProject == null) {
            return MapsKt.emptyMap();
        }
        MavenProject mavenProject2 = mavenProject;
        return this.getRoots(mavenProject2);
    }

    @Override
    @NotNull
    public Map<Package, List<Package>> getRoots(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"getInstance(...)");
        MavenProjectsManager manager = mavenProjectsManager;
        MavenProject mavenProject = manager.findProject(module);
        if (mavenProject == null) {
            return MapsKt.emptyMap();
        }
        MavenProject mavenProject2 = mavenProject;
        return this.getRoots(mavenProject2);
    }

    private final Map<Package, List<Package>> getRoots(MavenProject mavenProject) {
        List dependencyTree = mavenProject.getDependencyTree();
        return JavaPackageUtilKt.rootDependencies(dependencyTree, MavenBuildFileProvider::getRoots$lambda$2, MavenBuildFileProvider::getRoots$lambda$3);
    }

    @Override
    @Nullable
    protected String versionFallback(@Nullable PsiFile file, @NotNull Module module, @NotNull UnifiedDependency unifiedDependency) {
        MavenArtifact mavenArtifact;
        Object v2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)unifiedDependency, (String)"unifiedDependency");
            MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)this.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"getInstance(...)");
            MavenProjectsManager manager = mavenProjectsManager;
            MavenProject mavenProject = manager.findProject(module);
            if (mavenProject == null) {
                return null;
            }
            MavenProject mavenProject2 = mavenProject;
            List dependencyTree = mavenProject2.getDependencyTree();
            Iterable iterable = dependencyTree;
            for (Object t : iterable) {
                MavenArtifactNode it = (MavenArtifactNode)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getArtifact().getGroupId(), (Object)unifiedDependency.getCoordinates().getGroupId()) && Intrinsics.areEqual((Object)it.getArtifact().getArtifactId(), (Object)unifiedDependency.getCoordinates().getArtifactId()))) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        MavenArtifactNode mavenArtifactNode = v2;
        return mavenArtifactNode != null && (mavenArtifact = mavenArtifactNode.getArtifact()) != null ? mavenArtifact.getVersion() : null;
    }

    @Override
    @Nullable
    public PsiFile moduleScript(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        MavenProject mavenProject = MavenProjectsManager.getInstance((Project)this.getProject()).findProject(module);
        if (mavenProject == null) {
            return null;
        }
        MavenProject findProject = mavenProject;
        if (this.getProject().isDisposed() || !findProject.getFile().isValid()) {
            return null;
        }
        return PsiManager.getInstance((Project)this.getProject()).findFile(findProject.getFile());
    }

    private static final Package getRoots$lambda$2(MavenArtifactNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MavenArtifact mavenArtifact = it.getArtifact();
        Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact, (String)"getArtifact(...)");
        return MavenBuildFileProviderKt.createPackage(mavenArtifact);
    }

    private static final List getRoots$lambda$3(MavenArtifactNode it) {
        Object object = it;
        if (object == null || (object = object.getDependencies()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }
}

