/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.MysqlBaseJdbcHelper;
import java.sql.Connection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemJdbcHelper
extends MysqlBaseJdbcHelper {
    public MemJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("MEMSQL", version, connection);
    }

    public MemJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return MemJdbcHelper.extractVersion(version);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection) {
        return new MemJdbcHelper(version, connection);
    }

    @Override
    public boolean supportsEscape() {
        return false;
    }

    @Override
    public char getEscapeChar() {
        return '\\';
    }

    @Override
    @NotNull
    protected String getCharsToEscape() {
        return "%_\\";
    }

    @NotNull
    protected static MemJdbcHelper create(@Nullable Connection delegate, @Nullable String versionStr) {
        String version = MemJdbcHelper.extractVersion(versionStr);
        return new MemJdbcHelper(version, delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }
}

