/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.FileResolverByContentKt;
import com.intellij.javascript.debugger.JSCachingFileFinderKt;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinderKt;
import com.intellij.javascript.debugger.locationResolving.JSFileUrlMappings;
import com.intellij.javascript.debugger.locationResolving.SearchAccuracy;
import com.intellij.javascript.debugger.locationResolving.SearchResult;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.AsarFileFinder;
import com.intellij.util.io.AsarFileSystem;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J:\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00192\u0006\u0010\u001a\u001a\u00020\rJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\tJ\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001f\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/javascript/debugger/JSCachingFileFinder;", "", "delegate", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "<init>", "(Lcom/intellij/javascript/debugger/DebuggableFileFinder;)V", "getDelegate", "()Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "fileMappings", "Lcom/intellij/javascript/debugger/locationResolving/JSFileUrlMappings;", "asarFileFinder", "Lcom/intellij/util/io/AsarFileFinder;", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "Lcom/intellij/util/Url;", "project", "Lcom/intellij/openapi/project/Project;", "findByName", "", "sourceContent", "", "script", "Lorg/jetbrains/debugger/Script;", "getRemoteUrls", "", "file", "setFileMappings", "", "map", "findNavigatable", "Lcom/intellij/pom/Navigatable;", "getAsarFs", "Lcom/intellij/util/io/AsarFileSystem;", "path", "getAsarFs$intellij_javascript_debugger", "intellij.javascript.debugger"})
@SourceDebugExtension(value={"SMAP\nJSCachingFileFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSCachingFileFinder.kt\ncom/intellij/javascript/debugger/JSCachingFileFinder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,146:1\n1#2:147\n12567#3,2:148\n*S KotlinDebug\n*F\n+ 1 JSCachingFileFinder.kt\ncom/intellij/javascript/debugger/JSCachingFileFinder\n*L\n29#1:148,2\n*E\n"})
public final class JSCachingFileFinder {
    @NotNull
    private final DebuggableFileFinder delegate;
    @NotNull
    private volatile JSFileUrlMappings fileMappings;
    @NotNull
    private final AsarFileFinder asarFileFinder;

    public JSCachingFileFinder(@NotNull DebuggableFileFinder delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        this.fileMappings = new JSFileUrlMappings();
        this.asarFileFinder = new AsarFileFinder();
    }

    @NotNull
    public final DebuggableFileFinder getDelegate() {
        return this.delegate;
    }

    @Nullable
    public final VirtualFile findFile(@NotNull Url url, @NotNull Project project, boolean findByName, @Nullable String sourceContent, @Nullable Script script) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile virtualFile = this.asarFileFinder.findFileIfAsar(url, project);
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            return it;
        }
        return this.fileMappings.findFile(url, sourceContent, findByName, script, (Function0<SearchResult>)((Function0)() -> JSCachingFileFinder.findFile$lambda$4(this, url, project, sourceContent, findByName, script)));
    }

    public static /* synthetic */ VirtualFile findFile$default(JSCachingFileFinder jSCachingFileFinder, Url url, Project project, boolean bl, String string, Script script, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            script = null;
        }
        return jSCachingFileFinder.findFile(url, project, bl, string, script);
    }

    @NotNull
    public final List<Url> getRemoteUrls(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.fileMappings.findUrls(file, (Function0<? extends List<? extends Url>>)((Function0)() -> JSCachingFileFinder.getRemoteUrls$lambda$5(this, file)));
    }

    public final void setFileMappings(@NotNull JSFileUrlMappings map) {
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        this.fileMappings = map;
    }

    @Nullable
    public final Navigatable findNavigatable(@NotNull Url url, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Navigatable navigatable = this.delegate.findNavigatable(url, project);
        if (navigatable == null) {
            navigatable = (Navigatable)JsFileUtil.createNavigatable(project, JSCachingFileFinder.findFile$default(this, url, project, true, null, null, 24, null));
        }
        return navigatable;
    }

    @Nullable
    public final AsarFileSystem getAsarFs$intellij_javascript_debugger(@NotNull String path, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.asarFileFinder.getAsarFs(path, project);
    }

    private static final SearchResult findFile$lambda$4(JSCachingFileFinder this$0, Url $url, Project $project, String $sourceContent, boolean $findByName, Script $script) {
        VirtualFile result = null;
        result = this$0.delegate.findFile($url, $project);
        VirtualFile virtualFile = result;
        if (virtualFile != null) {
            Boolean bl;
            VirtualFile notNullResult = virtualFile;
            boolean bl2 = false;
            Url[] urlArray = $script;
            if ($script != null && (urlArray = urlArray.getSourceMap()) != null && (urlArray = urlArray.getSources()) != null) {
                boolean bl3;
                block11: {
                    Url[] $this$any$iv = urlArray;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        Url element$iv;
                        Url it = element$iv = $this$any$iv[i];
                        boolean bl4 = false;
                        if (!Urls.INSTANCE.equalsIgnoreParameters(it, notNullResult)) continue;
                        bl3 = true;
                        break block11;
                    }
                    bl3 = false;
                }
                bl = bl3;
            } else {
                bl = null;
            }
            virtualFile = bl;
            if (bl != null) {
                boolean it = virtualFile.booleanValue();
                boolean bl5 = false;
                if (it) {
                    return new SearchResult(result, SearchAccuracy.BY_URL);
                }
            }
        }
        SearchAccuracy accuracy = SearchAccuracy.BY_CONTENT;
        if (result == null && $sourceContent != null) {
            result = FileResolverByContentKt.resolveFileBySourceUrl($project, $url, $sourceContent);
        }
        if (result == null) {
            result = this$0.delegate.guessFile($url, $project);
            accuracy = SearchAccuracy.BY_URL;
        }
        if (result == null && $sourceContent == null) {
            result = FileResolverByContentKt.resolveFileBySourceUrl($project, $url, null);
            accuracy = SearchAccuracy.BY_URL;
        }
        if (result == null && this$0.delegate.searchesByName() && $findByName) {
            result = RemoteDebuggingFileFinderKt.findByName($url, $project);
            accuracy = SearchAccuracy.BY_NAME;
        }
        if (result != null && ($script != null && !JSCachingFileFinderKt.isFileMatchingScript(result, (Script)$script) || $sourceContent != null && !JSCachingFileFinderKt.isFileMatchingContent(result, $sourceContent, $project, $url))) {
            result = null;
        }
        return new SearchResult(result, accuracy);
    }

    private static final List getRemoteUrls$lambda$5(JSCachingFileFinder this$0, VirtualFile $file) {
        return this$0.delegate.getRemoteUrls($file);
    }
}

