/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.dataSource.LinkedDataSourceHelper;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.template.StatelessParametersHolder;
import com.intellij.database.dataSource.url.template.UrlEditorModel;
import com.intellij.database.dialects.oracle.model.OraDbLink;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/oracle/OraLinkedDataSourceHelper;", "Lcom/intellij/database/dataSource/LinkedDataSourceHelper;", "<init>", "()V", "getLinkedDataSourceKind", "Lcom/intellij/database/model/ObjectKind;", "createLinkedDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "link", "Lcom/intellij/database/model/DasObject;", "linkDs", "project", "Lcom/intellij/openapi/project/Project;", "intellij.database.dialects.oracle.ex"})
@SourceDebugExtension(value={"SMAP\nOraLinkedDataSourceHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraLinkedDataSourceHelper.kt\ncom/intellij/database/dialects/oracle/OraLinkedDataSourceHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,35:1\n295#2,2:36\n*S KotlinDebug\n*F\n+ 1 OraLinkedDataSourceHelper.kt\ncom/intellij/database/dialects/oracle/OraLinkedDataSourceHelper\n*L\n22#1:36,2\n*E\n"})
public final class OraLinkedDataSourceHelper
extends LinkedDataSourceHelper {
    @Override
    @NotNull
    public ObjectKind getLinkedDataSourceKind() {
        ObjectKind objectKind = ObjectKind.DB_LINK;
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"DB_LINK");
        return objectKind;
    }

    @Override
    @NotNull
    public LocalDataSource createLinkedDataSource(@NotNull DasObject link, @NotNull LocalDataSource linkDs, @NotNull Project project) {
        LocalDataSource ds;
        block6: {
            Intrinsics.checkNotNullParameter((Object)link, (String)"link");
            Intrinsics.checkNotNullParameter((Object)linkDs, (String)"linkDs");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            LocalDataSource localDataSource = super.createLinkedDataSource(link, linkDs, project);
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"createLinkedDataSource(...)");
            ds = localDataSource;
            OraDbLink oraDbLink = link instanceof OraDbLink ? (OraDbLink)link : null;
            if (oraDbLink == null) {
                return ds;
            }
            OraDbLink dbLink = oraDbLink;
            Object object = linkDs.getDatabaseDriver();
            UrlEditorModel model = new UrlEditorModel(object != null && (object = object.getJDBCUrlParsers()) != null ? (Collection)object : (Collection)CollectionsKt.emptyList());
            String string = linkDs.getUrl();
            if (string == null) {
                string = "";
            }
            model.setUrl(string);
            model.commit(true);
            String string2 = dbLink.getRemoteDatabaseString();
            if (string2 != null) {
                Object v7;
                String connectString;
                block5: {
                    connectString = string2;
                    boolean bl = false;
                    Collection<String> collection = model.getParameterNames();
                    Intrinsics.checkNotNullExpressionValue(collection, (String)"getParameterNames(...)");
                    Iterable $this$firstOrNull$iv = collection;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        StatelessParametersHolder.ParameterInfo parameterInfo = model.getParameterInfo(it);
                        if (!Intrinsics.areEqual((Object)(parameterInfo != null ? parameterInfo.getType() : null), (Object)"identifier")) continue;
                        v7 = element$iv;
                        break block5;
                    }
                    v7 = null;
                }
                String string3 = v7;
                if (string3 != null) {
                    String idKey = string3;
                    boolean bl = false;
                    model.setParameter(idKey, connectString);
                }
            }
            model.commit(true);
            ds.setUrl(model.getUrl());
            String string4 = dbLink.getConnectUserName();
            if (string4 == null) break block6;
            String userName = string4;
            boolean bl = false;
            LocalDataSource.setUsername(ds, userName);
        }
        return ds;
    }
}

