/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.snowflake;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SFlakeDialect
extends AbstractDatabaseDialect {
    private SFlakeDialect() {
        super(new TypeHelper.SFlakeTypeHelper());
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(@NotNull DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (builder == null) {
            SFlakeDialect.$$$reportNull$$$0(0);
        }
        if (identifier == null) {
            SFlakeDialect.$$$reportNull$$$0(1);
        }
        if (qualifier == null) {
            SFlakeDialect.$$$reportNull$$$0(2);
        }
        DasObject schema = DasUtil.getSchemaObject(qualifier);
        DasObject catalog = DasUtil.getCatalogObject(qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName(schema), catalog, DasUtil.getName(catalog), null, null);
        if (ddlBuilder == null) {
            SFlakeDialect.$$$reportNull$$$0(3);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.SNOWFLAKE;
        if (dbms == null) {
            SFlakeDialect.$$$reportNull$$$0(4);
        }
        return dbms;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "Snowflake";
    }

    @Override
    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        boolean isDb;
        if (path == null) {
            SFlakeDialect.$$$reportNull$$$0(5);
        }
        ObjectPath cur = path.getCurrent();
        boolean bl = isDb = cur.kind == ObjectKind.DATABASE;
        if (!isDb && cur.kind != ObjectKind.SCHEMA) {
            return null;
        }
        DdlBuilder builder = new DdlBuilder().withDialect(this).quoteIdentifiers(true);
        builder.keywords("use", isDb ? "database" : "schema").space();
        if (!isDb && cur.parent != null) {
            builder.identifier(cur.parent.name).symbol(".");
        }
        builder.identifier(cur.name);
        return builder.getStatement();
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DatabaseConnectionCore connection2) throws SQLException {
        String schema;
        String db;
        if (connection2 == null) {
            SFlakeDialect.$$$reportNull$$$0(6);
        }
        try {
            db = connection2.getRemoteConnection().getCatalog();
            schema = connection2.getRemoteConnection().getSchema();
        }
        catch (RemoteException e) {
            ExceptionUtil.rethrow((Throwable)RemoteUtil.unwrap((Throwable)e));
            return null;
        }
        if (StringUtil.isEmpty((String)db)) {
            return null;
        }
        ObjectPath dbPath = ObjectPath.create(db, ObjectKind.DATABASE);
        if (StringUtil.isEmpty((String)schema)) {
            return SearchPath.of(dbPath);
        }
        ObjectPath scPath = dbPath.append(schema, ObjectKind.SCHEMA);
        if ("PUBLIC".equals(schema)) {
            return SearchPath.of(scPath);
        }
        return SearchPath.of(Arrays.asList(scPath, dbPath.append("PUBLIC", ObjectKind.SCHEMA)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/snowflake/SFlakeDialect";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/snowflake/SFlakeDialect";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

