/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring.extractFunction;

import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ModelUtil;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.refactoring.extractFunction.RefInfo;
import com.intellij.sql.refactoring.extractFunction.SqlDelegatingParameterInfo;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionInfo;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableParameterInfo;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0007\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\b\u001a\u00020\t\u001a \u0010\n\u001a\u00020\u000b*\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000b0\u000eH\u0002\u001a\u0016\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\t0\u0011*\u00020\u0013\u001a\n\u0010\u0014\u001a\u00020\u0015*\u00020\u0013\"!\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"!\u0010\u0005\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00060\u00060\u0001\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"REF_INFO", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/sql/refactoring/extractFunction/RefInfo;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "PARAM_OCCURRENCE", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractableParameterInfo;", "copy", "name", "", "processReferences", "", "Lcom/intellij/sql/psi/SqlExpression;", "action", "Lkotlin/Function1;", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "analyzeConflicts", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionInfo;", "createBuilder", "Lcom/intellij/database/util/DdlBuilder;", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlExtractableCodeInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlExtractableCodeInfo.kt\ncom/intellij/sql/refactoring/extractFunction/SqlExtractableCodeInfoKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,206:1\n1557#2:207\n1628#2,3:208\n1557#2:211\n1628#2,3:212\n*S KotlinDebug\n*F\n+ 1 SqlExtractableCodeInfo.kt\ncom/intellij/sql/refactoring/extractFunction/SqlExtractableCodeInfoKt\n*L\n184#1:207\n184#1:208,3\n190#1:211\n190#1:212,3\n*E\n"})
public final class SqlExtractableCodeInfoKt {
    @NotNull
    private static final Key<RefInfo> REF_INFO;
    @NotNull
    private static final Key<SqlExtractableParameterInfo> PARAM_OCCURRENCE;

    @NotNull
    public static final SqlExtractableParameterInfo copy(@NotNull SqlExtractableParameterInfo $this$copy, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return new SqlDelegatingParameterInfo($this$copy.getOriginal(), name2);
    }

    private static final void processReferences(SqlExpression $this$processReferences, Function1<? super SqlReferenceExpression, Unit> action) {
        $this$processReferences.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(action){
            final /* synthetic */ Function1<SqlReferenceExpression, Unit> $action;
            {
                this.$action = $action;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof SqlReferenceExpression) {
                    this.$action.invoke((Object)element);
                } else {
                    super.visitElement(element);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MultiMap<PsiElement, String> analyzeConflicts(@NotNull SqlExtractFunctionInfo $this$analyzeConflicts) {
        Iterable<? extends DasArgument> it;
        Collection collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$analyzeConflicts, (String)"<this>");
        MultiMap conflicts = new MultiMap();
        String string = SqlExtractableCodeInfoKt.createBuilder($this$analyzeConflicts).identifier($this$analyzeConflicts.getName(), ObjectKind.ROUTINE).getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatement(...)");
        String name2 = string;
        SqlExpression sqlExpression = SqlPsiElementFactory.createExpressionFromText(name2 + "()", $this$analyzeConflicts.getCodeInfo().getDialect(), (PsiElement)$this$analyzeConflicts.getCodeInfo().getContainer());
        Intrinsics.checkNotNull((Object)sqlExpression, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlFunctionCallExpression");
        SqlFunctionCallExpression call = (SqlFunctionCallExpression)sqlExpression;
        Iterable $this$map$iv = $this$analyzeConflicts.getParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SqlExtractableParameterInfo sqlExtractableParameterInfo = (SqlExtractableParameterInfo)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDasType());
        }
        List newSignature = (List)destination$iv$iv;
        Object[] objectArray = call.getNameElement();
        if (objectArray == null || (objectArray = objectArray.multiResolve(true)) == null) {
            objectArray = ResolveResult.EMPTY_ARRAY;
        }
        Iterator iterator = ArrayIteratorKt.iterator((Object[])objectArray);
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv2;
            Iterable<? extends DasArgument> $this$map$iv2;
            DasObject target2;
            ResolveResult result2 = (ResolveResult)iterator.next();
            if (!result2.isValidResult()) continue;
            PsiElement element = result2.getElement();
            DasObject dasObject = SqlImplUtil.unwrapPsiToObject(element);
            if (dasObject == null) {
                dasObject = element;
            }
            if (!((target2 = dasObject) instanceof DasRoutine)) continue;
            Intrinsics.checkNotNullExpressionValue(((DasRoutine)target2).getArguments(), (String)"getArguments(...)");
            boolean $i$f$map2 = false;
            it = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it2;
                DasArgument dasArgument = (DasArgument)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it2.getDasType());
            }
            List existingSignature = (List)destination$iv$iv2;
            if (!Intrinsics.areEqual((Object)existingSignature, (Object)newSignature)) continue;
            String identity = ModelUtil.calculateRoutineIdentityByType(((DasRoutine)target2).getName(), existingSignature, null);
            conflicts.putValue((Object)element, (Object)("New function might conflict with " + identity));
        }
        return conflicts;
    }

    @NotNull
    public static final DdlBuilder createBuilder(@NotNull SqlExtractFunctionInfo $this$createBuilder) {
        Intrinsics.checkNotNullParameter((Object)$this$createBuilder, (String)"<this>");
        SqlLanguageDialectEx dialect = $this$createBuilder.getCodeInfo().getDialect();
        DdlBuilder ddlBuilder = new DdlBuilder().configureBuilder($this$createBuilder.getCodeInfo().getProject(), dialect).withDialect(dialect.getDatabaseDialect()).suppressQuoteIdentifiers(true);
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"suppressQuoteIdentifiers(...)");
        return ddlBuilder;
    }

    public static final /* synthetic */ void access$processReferences(SqlExpression $receiver, Function1 action) {
        SqlExtractableCodeInfoKt.processReferences($receiver, (Function1<? super SqlReferenceExpression, Unit>)action);
    }

    public static final /* synthetic */ Key access$getREF_INFO$p() {
        return REF_INFO;
    }

    public static final /* synthetic */ Key access$getPARAM_OCCURRENCE$p() {
        return PARAM_OCCURRENCE;
    }

    static {
        Key key2 = Key.create((String)"REF_INFO");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        REF_INFO = key2;
        Key key3 = Key.create((String)"PARAM_OCCURRENCE");
        Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"create(...)");
        PARAM_OCCURRENCE = key3;
    }
}

