/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssExpression;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.browse.ColorDeclarationType;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssInspectionsUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class CssOverwrittenPropertiesInspection
extends CssBaseInspection {
    private static final RemoveOverwrittenPropertyQuickfix[] OVERWRITTEN_PROPERTY_QUICKFIX = new RemoveOverwrittenPropertyQuickfix[]{new RemoveOverwrittenPropertyQuickfix()};
    private static final Set<String> PROPERTIES_ALLOWING_DUPLICATES = Set.of("src", "composes");

    @NotNull
    @NonNls
    public String getShortName() {
        return "CssOverwrittenProperties";
    }

    private static Map<String, List<CssDeclaration>> getPropertiesMap(CssBlock block) {
        CssRuleset[] nestedRulesets;
        CssDeclaration[] blockDeclarations;
        HashMap<String, List<CssDeclaration>> name2decls = new HashMap<String, List<CssDeclaration>>();
        for (CssDeclaration decl : blockDeclarations = block.getDeclarations()) {
            if (!CssInspectionsUtil.isPureCssPropertyName(decl.getPropertyNameElement())) continue;
            if (decl.isShorthandProperty()) {
                String[] names;
                for (String name : names = decl.expandShorthandProperty()) {
                    CssOverwrittenPropertiesInspection.updateDecls(name2decls, name, decl);
                }
                continue;
            }
            Object propertyName = CssDescriptorsUtil.getCanonicalPropertyName(decl);
            if (decl.isHack()) {
                propertyName = "*" + (String)propertyName;
            }
            CssOverwrittenPropertiesInspection.updateDecls(name2decls, (String)propertyName, decl);
        }
        for (CssRuleset nestedRuleset : nestedRulesets = block.getRulesets()) {
            CssBlock nestedBlock;
            CssSelector[] selectors = nestedRuleset.getSelectors();
            if (!CssOverwrittenPropertiesInspection.isSameLevelSelector(selectors) || (nestedBlock = nestedRuleset.getBlock()) == null) continue;
            Map<String, List<CssDeclaration>> nestedName2decls = CssOverwrittenPropertiesInspection.getPropertiesMap(nestedBlock);
            for (String name : nestedName2decls.keySet()) {
                nestedName2decls.get(name).forEach(declaration -> CssOverwrittenPropertiesInspection.updateDecls(name2decls, name, declaration));
            }
        }
        return name2decls;
    }

    private static boolean isSameLevelSelector(CssSelector[] selectors) {
        for (CssSelector selector : selectors) {
            CssSimpleSelector[] simpleSelectors = selector.getSimpleSelectors();
            if (simpleSelectors.length != 1 || !simpleSelectors[0].getText().equals("&") && !simpleSelectors[0].getText().equals(":is(&)")) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            CssOverwrittenPropertiesInspection.$$$reportNull$$$0(0);
        }
        return new CssElementVisitor(){

            @Override
            public void visitCssBlock(CssBlock block) {
                super.visitCssBlock(block);
                Map<String, List<CssDeclaration>> name2decls = CssOverwrittenPropertiesInspection.getPropertiesMap(block);
                for (String propertyName : name2decls.keySet()) {
                    List<CssDeclaration> decls;
                    if (PROPERTIES_ALLOWING_DUPLICATES.contains(propertyName) || (decls = name2decls.get(propertyName)).size() <= 1) continue;
                    for (int i = 1; i < decls.size(); ++i) {
                        String messageId;
                        CssDeclaration duplicateProperty;
                        String duplicatePropertyName;
                        String duplicatedDeclaration;
                        String currName;
                        CssDeclaration prev = decls.get(i - 1);
                        CssDeclaration curr = decls.get(i);
                        boolean prevIsShorthand = prev.isShorthandProperty();
                        int prevShorthandPropNum = -1;
                        if (prevIsShorthand) {
                            String[] properties = prev.expandShorthandProperty();
                            Map<String, String> expandedValues = CssPropertyUtil.getExpandedShorthandValues(prev, properties);
                            prevShorthandPropNum = expandedValues.size();
                        }
                        boolean currIsShorthand = curr.isShorthandProperty();
                        String prevPropName = CssDescriptorsUtil.getCanonicalPropertyName(prev);
                        String currPropName = curr.getPropertyName();
                        boolean prevPropertyIsOverwritten = !prev.isImportant() || curr.isImportant();
                        boolean problem = false;
                        if (CssOverwrittenPropertiesInspection.isOverwrittenValues(propertyName, prev, curr)) {
                            if (prevIsShorthand) {
                                if (currIsShorthand) {
                                    currName = CssDescriptorsUtil.getCanonicalPropertyName(curr);
                                    if (!(currName.contains("left") || currName.contains("right") || currName.contains("top") || currName.contains("bottom"))) {
                                        problem = true;
                                    }
                                } else if (prevShorthandPropNum == 1) {
                                    problem = true;
                                }
                            } else {
                                problem = true;
                            }
                            if (!problem) continue;
                            String messageForPreviousProperty = prevPropertyIsOverwritten ? CssBundle.message("css.overwritten.properties.message", prevPropName) : CssBundle.message("css.overwriting.properties.message", prevPropName, currPropName);
                            holder.registerProblem((PsiElement)prev, messageForPreviousProperty, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])(isOnTheFly ? OVERWRITTEN_PROPERTY_QUICKFIX : LocalQuickFix.EMPTY_ARRAY));
                            if (prevIsShorthand) {
                                String[] properties;
                                for (String property : properties = prev.expandShorthandProperty()) {
                                    name2decls.get(property).remove(prev);
                                }
                            }
                            if (i != decls.size() - 1 && !prevIsShorthand) continue;
                            String messageForCurrentProperty = prevPropertyIsOverwritten ? CssBundle.message("css.overwriting.properties.message", currPropName, prevPropName) : CssBundle.message("css.overwritten.properties.message", currPropName);
                            holder.registerProblem((PsiElement)curr, messageForCurrentProperty, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])(isOnTheFly ? OVERWRITTEN_PROPERTY_QUICKFIX : LocalQuickFix.EMPTY_ARRAY));
                            continue;
                        }
                        if (!CssOverwrittenPropertiesInspection.hasEqualValues(propertyName, prev, curr) || currIsShorthand && prevIsShorthand && ((currName = CssDescriptorsUtil.getCanonicalPropertyName(curr)).contains("left") || currName.contains("right") || currName.contains("top") || currName.contains("bottom"))) continue;
                        if (!prevIsShorthand && currIsShorthand) {
                            duplicatedDeclaration = currPropName;
                            duplicatePropertyName = prevPropName;
                            duplicateProperty = prev;
                            messageId = "css.overwriting.properties.duplicated.message";
                        } else {
                            duplicatedDeclaration = prevPropertyIsOverwritten ? prevPropName : currPropName;
                            duplicatePropertyName = prevPropertyIsOverwritten ? currPropName : prevPropName;
                            duplicateProperty = prevPropertyIsOverwritten ? curr : prev;
                            messageId = "css.overwriting.properties.duplicates.message";
                        }
                        String message = CssBundle.message(messageId, duplicatePropertyName, duplicatedDeclaration);
                        holder.registerProblem((PsiElement)duplicateProperty, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])(isOnTheFly ? OVERWRITTEN_PROPERTY_QUICKFIX : LocalQuickFix.EMPTY_ARRAY));
                    }
                }
            }
        };
    }

    private static boolean hasEqualValues(@NotNull @NonNls String propertyName, @NotNull CssDeclaration decl1, @NotNull CssDeclaration decl2) {
        if (propertyName == null) {
            CssOverwrittenPropertiesInspection.$$$reportNull$$$0(1);
        }
        if (decl1 == null) {
            CssOverwrittenPropertiesInspection.$$$reportNull$$$0(2);
        }
        if (decl2 == null) {
            CssOverwrittenPropertiesInspection.$$$reportNull$$$0(3);
        }
        PsiElement[] value1 = CssOverwrittenPropertiesInspection.declarationValue(decl1, propertyName);
        PsiElement[] value2 = CssOverwrittenPropertiesInspection.declarationValue(decl2, propertyName);
        if (value1.length == 0 && value2.length == 0) {
            return false;
        }
        String stringValue1 = CssOverwrittenPropertiesInspection.joinedText(value1);
        String stringValue2 = CssOverwrittenPropertiesInspection.joinedText(value2);
        return stringValue2.equalsIgnoreCase(stringValue1);
    }

    private static boolean isOverwrittenValues(@NotNull @NonNls String propertyName, @NotNull CssDeclaration decl1, @NotNull CssDeclaration decl2) {
        if (propertyName == null) {
            CssOverwrittenPropertiesInspection.$$$reportNull$$$0(4);
        }
        if (decl1 == null) {
            CssOverwrittenPropertiesInspection.$$$reportNull$$$0(5);
        }
        if (decl2 == null) {
            CssOverwrittenPropertiesInspection.$$$reportNull$$$0(6);
        }
        if (decl1.isHack() ^ decl2.isHack()) {
            return false;
        }
        PsiElement[] value1 = CssOverwrittenPropertiesInspection.declarationValue(decl1, propertyName);
        PsiElement[] value2 = CssOverwrittenPropertiesInspection.declarationValue(decl2, propertyName);
        if (value1.length > 0 && value2.length > 0) {
            String stringValue2;
            String stringValue1;
            PsiElement psiElement;
            if (value1.length == 1 && value2.length == 1 && (psiElement = value1[0]) instanceof CssTerm) {
                CssTerm term1 = (CssTerm)psiElement;
                psiElement = value2[0];
                if (psiElement instanceof CssTerm) {
                    CssTerm term2 = (CssTerm)psiElement;
                    if (term1.getTermType() == CssTermTypes.COLOR && term2.getTermType() == CssTermTypes.COLOR) {
                        ColorDeclarationType color1Type = ColorDeclarationType.fromColorTerm(term1);
                        ColorDeclarationType color2Type = ColorDeclarationType.fromColorTerm(term2);
                        return !term1.getText().equalsIgnoreCase(term2.getText()) && color1Type.withAlphaChannel() == color2Type.withAlphaChannel();
                    }
                    if (term1.getTermType() == CssTermTypes.RECT && term2.getTermType() == CssTermTypes.RECT) {
                        boolean commaSeparatorInTerm1 = StringUtil.containsChar((String)term1.getText(), (char)',');
                        boolean commaSeparatorInTerm2 = StringUtil.containsChar((String)term2.getText(), (char)',');
                        return !term1.getText().equalsIgnoreCase(term2.getText()) && commaSeparatorInTerm1 == commaSeparatorInTerm2;
                    }
                    PsiElement firstTermChild = term1.getFirstChild();
                    PsiElement secondTermChild = term2.getFirstChild();
                    boolean bothTermsAreFunctions = firstTermChild instanceof CssFunction && secondTermChild instanceof CssFunction;
                    boolean oneOfTermsIsExpression = firstTermChild instanceof CssExpression ^ secondTermChild instanceof CssExpression;
                    String term1Text = term1.getText();
                    String term2Text = term2.getText();
                    return !term1Text.equalsIgnoreCase(term2Text) && !oneOfTermsIsExpression && (!CssPropertyUtil.isVendorSpecificElement(term1Text) && !CssPropertyUtil.isVendorSpecificElement(term2Text) || bothTermsAreFunctions && ((CssFunction)firstTermChild).getName().equalsIgnoreCase(((CssFunction)secondTermChild).getName()));
                }
            }
            return !(stringValue1 = CssOverwrittenPropertiesInspection.joinedText(value1)).equalsIgnoreCase(stringValue2 = CssOverwrittenPropertiesInspection.joinedText(value2)) && !CssPropertyUtil.isVendorSpecificElement(stringValue1) && !CssPropertyUtil.isVendorSpecificElement(stringValue2);
        }
        return false;
    }

    private static String joinedText(PsiElement[] elements) {
        StringBuilder builder = new StringBuilder();
        for (PsiElement element : elements) {
            builder.append(element.getText()).append(" ");
        }
        return builder.toString().trim();
    }

    private static PsiElement @NotNull [] declarationValue(CssDeclaration declaration, String propertyName) {
        if (declaration.isShorthandProperty()) {
            PsiElement[] value = declaration.getShorthandPsiValue(propertyName);
            if (value != null) {
                if (value == null) {
                    CssOverwrittenPropertiesInspection.$$$reportNull$$$0(7);
                }
                return value;
            }
        } else {
            CssTermList termList = declaration.getValue();
            if (termList != null) {
                PsiElement[] psiElementArray = termList.getChildren();
                if (psiElementArray == null) {
                    CssOverwrittenPropertiesInspection.$$$reportNull$$$0(8);
                }
                return psiElementArray;
            }
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            CssOverwrittenPropertiesInspection.$$$reportNull$$$0(9);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    private static void updateDecls(Map<String, List<CssDeclaration>> name2decls, String name, CssDeclaration decl) {
        List decls = name2decls.computeIfAbsent(name, k -> new ArrayList());
        decls.add(decl);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decl1";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decl2";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/CssOverwrittenPropertiesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/CssOverwrittenPropertiesInspection";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "declarationValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasEqualValues";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isOverwrittenValues";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    private static class RemoveOverwrittenPropertyQuickfix
    implements LocalQuickFix {
        private RemoveOverwrittenPropertyQuickfix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = CssBundle.message("css.overwritten.properties.fix.message", new Object[0]);
            if (string == null) {
                RemoveOverwrittenPropertyQuickfix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement myPsiElement;
            if (project == null) {
                RemoveOverwrittenPropertyQuickfix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemoveOverwrittenPropertyQuickfix.$$$reportNull$$$0(2);
            }
            if ((myPsiElement = descriptor.getPsiElement()) == null) {
                return;
            }
            CssDeclaration declaration = (CssDeclaration)PsiTreeUtil.getNonStrictParentOfType((PsiElement)myPsiElement, (Class[])new Class[]{CssDeclaration.class});
            CssBlock block = (CssBlock)PsiTreeUtil.getNonStrictParentOfType((PsiElement)myPsiElement, (Class[])new Class[]{CssBlock.class});
            if (declaration != null && block != null) {
                block.removeDeclaration(declaration);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/inspections/CssOverwrittenPropertiesInspection$RemoveOverwrittenPropertyQuickfix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/inspections/CssOverwrittenPropertiesInspection$RemoveOverwrittenPropertyQuickfix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

