/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.util.concurrency.Semaphore;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class InvokeAfterUpdateCallback {
    private static final Logger LOG = Logger.getInstance(InvokeAfterUpdateCallback.class);

    InvokeAfterUpdateCallback() {
    }

    @NotNull
    public static Callback create(@NotNull Project project, @NotNull InvokeAfterUpdateMode mode, @NotNull Runnable afterUpdate, @Nullable @Nls String title) {
        if (project == null) {
            InvokeAfterUpdateCallback.$$$reportNull$$$0(0);
        }
        if (mode == null) {
            InvokeAfterUpdateCallback.$$$reportNull$$$0(1);
        }
        if (afterUpdate == null) {
            InvokeAfterUpdateCallback.$$$reportNull$$$0(2);
        }
        if (mode.isSilent()) {
            return new SilentCallback(project, afterUpdate, mode.isCallbackOnAwt());
        }
        return new ProgressCallback(project, afterUpdate, mode.isSynchronous(), mode.isCancellable(), title);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "mode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "afterUpdate";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vcs/changes/InvokeAfterUpdateCallback";
        objectArray[2] = "create";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SilentCallback
    extends CallbackBase {
        private final boolean myCallbackOnAwt;

        SilentCallback(@NotNull Project project, @NotNull Runnable afterUpdate, boolean callbackOnAwt) {
            if (project == null) {
                SilentCallback.$$$reportNull$$$0(0);
            }
            if (afterUpdate == null) {
                SilentCallback.$$$reportNull$$$0(1);
            }
            super(project, afterUpdate);
            this.myCallbackOnAwt = callbackOnAwt;
        }

        @Override
        public void startProgress() {
        }

        @Override
        public void endProgress() {
            this.scheduleCallback();
        }

        @Override
        public void handleStoppedQueue() {
            this.scheduleCallback();
        }

        private void scheduleCallback() {
            if (this.myCallbackOnAwt) {
                ApplicationManager.getApplication().invokeLater(this::invokeCallback);
            } else {
                ApplicationManager.getApplication().executeOnPooledThread(this::invokeCallback);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "afterUpdate";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/InvokeAfterUpdateCallback$SilentCallback";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ProgressCallback
    extends CallbackBase {
        private final boolean mySynchronous;
        private final boolean myCanBeCancelled;
        @Nls
        private final String myTitle;
        @NotNull
        private final Semaphore mySemaphore;

        ProgressCallback(@NotNull Project project, @NotNull Runnable afterUpdate, boolean synchronous, boolean canBeCancelled, @Nullable @Nls String title) {
            if (project == null) {
                ProgressCallback.$$$reportNull$$$0(0);
            }
            if (afterUpdate == null) {
                ProgressCallback.$$$reportNull$$$0(1);
            }
            super(project, afterUpdate);
            this.mySemaphore = new Semaphore(1);
            this.mySynchronous = synchronous;
            this.myCanBeCancelled = canBeCancelled;
            this.myTitle = title;
        }

        @Override
        public void startProgress() {
            if (this.mySynchronous) {
                String dialogTitle = VcsBundle.message((String)"change.list.manager.wait.lists.synchronization.modal", (Object[])new Object[]{this.myTitle, this.myTitle != null ? 1 : 0});
                new ModalWaiter(this.myProject, dialogTitle, this.myCanBeCancelled).queue();
            } else {
                String progressTitle = VcsBundle.message((String)"change.list.manager.wait.lists.synchronization.background", (Object[])new Object[]{this.myTitle, this.myTitle != null ? 1 : 0});
                new BackgroundableWaiter(this.myProject, progressTitle, this.myCanBeCancelled).queue();
            }
        }

        @Override
        public void endProgress() {
            this.mySemaphore.up();
        }

        @Override
        public void handleStoppedQueue() {
            ApplicationManager.getApplication().invokeLater(this::invokeCallback);
        }

        private void awaitSemaphore(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                ProgressCallback.$$$reportNull$$$0(2);
            }
            indicator.setIndeterminate(true);
            indicator.setText2(VcsBundle.message((String)"commit.wait.util.synched.text", (Object[])new Object[0]));
            ProgressIndicatorUtils.awaitWithCheckCanceled((Semaphore)this.mySemaphore, (ProgressIndicator)indicator);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "afterUpdate";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/InvokeAfterUpdateCallback$ProgressCallback";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "awaitSemaphore";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class ModalWaiter
        extends Task.Modal {
            ModalWaiter(@NotNull @NlsContexts.DialogTitle Project project, String title, boolean canBeCancelled) {
                if (project == null) {
                    ModalWaiter.$$$reportNull$$$0(0);
                }
                if (title == null) {
                    ModalWaiter.$$$reportNull$$$0(1);
                }
                super(project, title, canBeCancelled);
                this.setCancelText(VcsBundle.message((String)"button.skip", (Object[])new Object[0]));
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    ModalWaiter.$$$reportNull$$$0(2);
                }
                ProgressCallback.this.awaitSemaphore(indicator);
            }

            public void onFinished() {
                ProgressCallback.this.invokeCallback();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "title";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/vcs/changes/InvokeAfterUpdateCallback$ProgressCallback$ModalWaiter";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private class BackgroundableWaiter
        extends Task.Backgroundable {
            BackgroundableWaiter(@NotNull @NlsContexts.ProgressTitle Project project, String title, boolean canBeCancelled) {
                if (project == null) {
                    BackgroundableWaiter.$$$reportNull$$$0(0);
                }
                if (title == null) {
                    BackgroundableWaiter.$$$reportNull$$$0(1);
                }
                super(project, title, canBeCancelled);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    BackgroundableWaiter.$$$reportNull$$$0(2);
                }
                ProgressCallback.this.awaitSemaphore(indicator);
            }

            public void onSuccess() {
                ProgressCallback.this.invokeCallback();
            }

            public boolean isHeadless() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "title";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/vcs/changes/InvokeAfterUpdateCallback$ProgressCallback$BackgroundableWaiter";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static abstract class CallbackBase
    implements Callback {
        protected final Project myProject;
        private final Runnable myAfterUpdate;

        CallbackBase(@NotNull Project project, @NotNull Runnable afterUpdate) {
            if (project == null) {
                CallbackBase.$$$reportNull$$$0(0);
            }
            if (afterUpdate == null) {
                CallbackBase.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myAfterUpdate = afterUpdate;
        }

        protected final void invokeCallback() {
            LOG.debug("changes update finished for project " + this.myProject.getName());
            if (!this.myProject.isDisposed()) {
                this.myAfterUpdate.run();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "afterUpdate";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/InvokeAfterUpdateCallback$CallbackBase";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface Callback {
        public void startProgress();

        public void endProgress();

        public void handleStoppedQueue();
    }
}

