/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLTokenTypes;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001aF\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u000326\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005\u001a\u001a\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\nH\u0002\u00a8\u0006\u000f"}, d2={"visitTopLevelKeyPairs", "", "tree", "Lcom/intellij/lang/LighterAST;", "visitor", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "key", "Lcom/intellij/lang/LighterASTNode;", "pair", "", "getKeyName", "keyPair", "intellij.yaml.backend"})
public final class AstUtilKt {
    public static final void visitTopLevelKeyPairs(@NotNull LighterAST tree, @NotNull Function2<? super CharSequence, ? super LighterASTNode, Boolean> visitor) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        LighterASTNode lighterASTNode = tree.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)lighterASTNode, (String)"getRoot(...)");
        LighterASTNode astRoot = lighterASTNode;
        for (LighterASTNode child : tree.getChildren(astRoot)) {
            if (!Intrinsics.areEqual((Object)child.getTokenType(), (Object)YAMLElementTypes.DOCUMENT)) continue;
            for (LighterASTNode mapping : tree.getChildren(child)) {
                if (!Intrinsics.areEqual((Object)mapping.getTokenType(), (Object)YAMLElementTypes.MAPPING)) continue;
                for (LighterASTNode keyPair : tree.getChildren(mapping)) {
                    CharSequence keyName;
                    if (!Intrinsics.areEqual((Object)keyPair.getTokenType(), (Object)YAMLElementTypes.KEY_VALUE_PAIR)) continue;
                    Intrinsics.checkNotNull((Object)keyPair);
                    if (AstUtilKt.getKeyName(tree, keyPair) == null || ((Boolean)visitor.invoke((Object)keyName, (Object)keyPair)).booleanValue()) continue;
                    return;
                }
            }
        }
    }

    private static final CharSequence getKeyName(LighterAST tree, LighterASTNode keyPair) {
        List list = tree.getChildren(keyPair);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
        Object object = CollectionsKt.firstOrNull((List)list);
        LighterASTTokenNode lighterASTTokenNode = object instanceof LighterASTTokenNode ? (LighterASTTokenNode)object : null;
        if (lighterASTTokenNode == null) {
            return null;
        }
        LighterASTTokenNode key = lighterASTTokenNode;
        if (Intrinsics.areEqual((Object)key.getTokenType(), (Object)YAMLTokenTypes.SCALAR_KEY)) {
            return key.getText();
        }
        return null;
    }
}

