/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.memory;

import com.oracle.truffle.api.memory.ByteArraySupport;

final class ReversedByteArraySupport
extends ByteArraySupport {
    final ByteArraySupport access;

    ReversedByteArraySupport(ByteArraySupport access) {
        this.access = access;
    }

    @Override
    public byte getByte(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        return this.access.getByte(buffer, byteOffset);
    }

    @Override
    public byte getByte(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        return this.access.getByte(buffer, byteOffset);
    }

    @Override
    public void putByte(byte[] buffer, int byteOffset, byte value2) throws IndexOutOfBoundsException {
        this.access.putByte(buffer, byteOffset, value2);
    }

    @Override
    public void putByte(byte[] buffer, long byteOffset, byte value2) throws IndexOutOfBoundsException {
        this.access.putByte(buffer, byteOffset, value2);
    }

    @Override
    public short getShort(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        return Short.reverseBytes(this.access.getShort(buffer, byteOffset));
    }

    @Override
    public short getShort(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        return Short.reverseBytes(this.access.getShort(buffer, byteOffset));
    }

    @Override
    public void putShort(byte[] buffer, int byteOffset, short value2) throws IndexOutOfBoundsException {
        this.access.putShort(buffer, byteOffset, Short.reverseBytes(value2));
    }

    @Override
    public void putShort(byte[] buffer, long byteOffset, short value2) throws IndexOutOfBoundsException {
        this.access.putShort(buffer, byteOffset, Short.reverseBytes(value2));
    }

    @Override
    public int getInt(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        return Integer.reverseBytes(this.access.getInt(buffer, byteOffset));
    }

    @Override
    public int getInt(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        return Integer.reverseBytes(this.access.getInt(buffer, byteOffset));
    }

    @Override
    public void putInt(byte[] buffer, int byteOffset, int value2) throws IndexOutOfBoundsException {
        this.access.putInt(buffer, byteOffset, Integer.reverseBytes(value2));
    }

    @Override
    public void putInt(byte[] buffer, long byteOffset, int value2) throws IndexOutOfBoundsException {
        this.access.putInt(buffer, byteOffset, Integer.reverseBytes(value2));
    }

    @Override
    public long getLong(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        return Long.reverseBytes(this.access.getLong(buffer, byteOffset));
    }

    @Override
    public long getLong(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        return Long.reverseBytes(this.access.getLong(buffer, byteOffset));
    }

    @Override
    public void putLong(byte[] buffer, int byteOffset, long value2) throws IndexOutOfBoundsException {
        this.access.putLong(buffer, byteOffset, Long.reverseBytes(value2));
    }

    @Override
    public void putLong(byte[] buffer, long byteOffset, long value2) throws IndexOutOfBoundsException {
        this.access.putLong(buffer, byteOffset, Long.reverseBytes(value2));
    }

    @Override
    public float getFloat(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        return Float.intBitsToFloat(Integer.reverseBytes(this.access.getInt(buffer, byteOffset)));
    }

    @Override
    public float getFloat(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        return Float.intBitsToFloat(Integer.reverseBytes(this.access.getInt(buffer, byteOffset)));
    }

    @Override
    public void putFloat(byte[] buffer, int byteOffset, float value2) throws IndexOutOfBoundsException {
        this.access.putInt(buffer, byteOffset, Integer.reverseBytes(Float.floatToIntBits(value2)));
    }

    @Override
    public void putFloat(byte[] buffer, long byteOffset, float value2) throws IndexOutOfBoundsException {
        this.access.putInt(buffer, byteOffset, Integer.reverseBytes(Float.floatToIntBits(value2)));
    }

    @Override
    public double getDouble(byte[] buffer, int byteOffset) throws IndexOutOfBoundsException {
        return Double.longBitsToDouble(Long.reverseBytes(this.access.getLong(buffer, byteOffset)));
    }

    @Override
    public double getDouble(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        return Double.longBitsToDouble(Long.reverseBytes(this.access.getLong(buffer, byteOffset)));
    }

    @Override
    public void putDouble(byte[] buffer, int byteOffset, double value2) throws IndexOutOfBoundsException {
        this.access.putLong(buffer, byteOffset, Long.reverseBytes(Double.doubleToLongBits(value2)));
    }

    @Override
    public void putDouble(byte[] buffer, long byteOffset, double value2) throws IndexOutOfBoundsException {
        this.access.putLong(buffer, byteOffset, Long.reverseBytes(Double.doubleToLongBits(value2)));
    }

    @Override
    public byte getByteVolatile(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        return this.access.getByte(buffer, byteOffset);
    }

    @Override
    public void putByteVolatile(byte[] buffer, long byteOffset, byte value2) throws IndexOutOfBoundsException {
        this.access.putByteVolatile(buffer, byteOffset, value2);
    }

    @Override
    public short getShortVolatile(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        return Short.reverseBytes(this.access.getShortVolatile(buffer, byteOffset));
    }

    @Override
    public void putShortVolatile(byte[] buffer, long byteOffset, short value2) throws IndexOutOfBoundsException {
        this.access.putShortVolatile(buffer, byteOffset, Short.reverseBytes(value2));
    }

    @Override
    public int getIntVolatile(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        return Integer.reverseBytes(this.access.getIntVolatile(buffer, byteOffset));
    }

    @Override
    public void putIntVolatile(byte[] buffer, long byteOffset, int value2) throws IndexOutOfBoundsException {
        this.access.putIntVolatile(buffer, byteOffset, Integer.reverseBytes(value2));
    }

    @Override
    public long getLongVolatile(byte[] buffer, long byteOffset) throws IndexOutOfBoundsException {
        return Long.reverseBytes(this.access.getLongVolatile(buffer, byteOffset));
    }

    @Override
    public void putLongVolatile(byte[] buffer, long byteOffset, long value2) throws IndexOutOfBoundsException {
        this.access.putLongVolatile(buffer, byteOffset, Long.reverseBytes(value2));
    }

    @Override
    public byte getAndAddByte(byte[] buffer, long byteOffset, byte delta) throws IndexOutOfBoundsException {
        return this.access.getAndAddByte(buffer, byteOffset, delta);
    }

    @Override
    public short getAndAddShort(byte[] buffer, long byteOffset, short delta) throws IndexOutOfBoundsException {
        return Short.reverseBytes(this.access.getAndAddShort(buffer, byteOffset, Short.reverseBytes(delta)));
    }

    @Override
    public int getAndAddInt(byte[] buffer, long byteOffset, int delta) throws IndexOutOfBoundsException {
        return Integer.reverseBytes(this.access.getAndAddInt(buffer, byteOffset, Integer.reverseBytes(delta)));
    }

    @Override
    public long getAndAddLong(byte[] buffer, long byteOffset, long delta) throws IndexOutOfBoundsException {
        return Long.reverseBytes(this.access.getAndAddLong(buffer, byteOffset, Long.reverseBytes(delta)));
    }

    @Override
    public byte getAndBitwiseAndByte(byte[] buffer, long byteOffset, byte mask) throws IndexOutOfBoundsException {
        return this.access.getAndBitwiseAndByte(buffer, byteOffset, mask);
    }

    @Override
    public short getAndBitwiseAndShort(byte[] buffer, long byteOffset, short mask) throws IndexOutOfBoundsException {
        return Short.reverseBytes(this.access.getAndBitwiseAndShort(buffer, byteOffset, Short.reverseBytes(mask)));
    }

    @Override
    public int getAndBitwiseAndInt(byte[] buffer, long byteOffset, int mask) throws IndexOutOfBoundsException {
        return Integer.reverseBytes(this.access.getAndBitwiseAndInt(buffer, byteOffset, Integer.reverseBytes(mask)));
    }

    @Override
    public long getAndBitwiseAndLong(byte[] buffer, long byteOffset, long mask) throws IndexOutOfBoundsException {
        return Long.reverseBytes(this.access.getAndBitwiseAndLong(buffer, byteOffset, Long.reverseBytes(mask)));
    }

    @Override
    public byte getAndBitwiseOrByte(byte[] buffer, long byteOffset, byte mask) throws IndexOutOfBoundsException {
        return this.access.getAndBitwiseOrByte(buffer, byteOffset, mask);
    }

    @Override
    public short getAndBitwiseOrShort(byte[] buffer, long byteOffset, short mask) throws IndexOutOfBoundsException {
        return Short.reverseBytes(this.access.getAndBitwiseOrShort(buffer, byteOffset, Short.reverseBytes(mask)));
    }

    @Override
    public int getAndBitwiseOrInt(byte[] buffer, long byteOffset, int mask) throws IndexOutOfBoundsException {
        return Integer.reverseBytes(this.access.getAndBitwiseOrInt(buffer, byteOffset, Integer.reverseBytes(mask)));
    }

    @Override
    public long getAndBitwiseOrLong(byte[] buffer, long byteOffset, long mask) throws IndexOutOfBoundsException {
        return Long.reverseBytes(this.access.getAndBitwiseOrLong(buffer, byteOffset, Long.reverseBytes(mask)));
    }

    @Override
    public byte getAndBitwiseXorByte(byte[] buffer, long byteOffset, byte mask) throws IndexOutOfBoundsException {
        return this.access.getAndBitwiseXorByte(buffer, byteOffset, mask);
    }

    @Override
    public short getAndBitwiseXorShort(byte[] buffer, long byteOffset, short mask) throws IndexOutOfBoundsException {
        return Short.reverseBytes(this.access.getAndBitwiseXorShort(buffer, byteOffset, Short.reverseBytes(mask)));
    }

    @Override
    public int getAndBitwiseXorInt(byte[] buffer, long byteOffset, int mask) throws IndexOutOfBoundsException {
        return Integer.reverseBytes(this.access.getAndBitwiseXorInt(buffer, byteOffset, Integer.reverseBytes(mask)));
    }

    @Override
    public long getAndBitwiseXorLong(byte[] buffer, long byteOffset, long mask) throws IndexOutOfBoundsException {
        return Long.reverseBytes(this.access.getAndBitwiseXorLong(buffer, byteOffset, Long.reverseBytes(mask)));
    }

    @Override
    public byte getAndSetByte(byte[] buffer, long byteOffset, byte newValue) throws IndexOutOfBoundsException {
        return this.access.getAndSetByte(buffer, byteOffset, newValue);
    }

    @Override
    public short getAndSetShort(byte[] buffer, long byteOffset, short newValue) throws IndexOutOfBoundsException {
        return Short.reverseBytes(this.access.getAndSetShort(buffer, byteOffset, Short.reverseBytes(newValue)));
    }

    @Override
    public int getAndSetInt(byte[] buffer, long byteOffset, int newValue) throws IndexOutOfBoundsException {
        return Integer.reverseBytes(this.access.getAndSetInt(buffer, byteOffset, Integer.reverseBytes(newValue)));
    }

    @Override
    public long getAndSetLong(byte[] buffer, long byteOffset, long newValue) throws IndexOutOfBoundsException {
        return Long.reverseBytes(this.access.getAndSetLong(buffer, byteOffset, Long.reverseBytes(newValue)));
    }

    @Override
    public byte compareAndExchangeByte(byte[] buffer, long byteOffset, byte expected, byte x) throws IndexOutOfBoundsException {
        return this.access.compareAndExchangeByte(buffer, byteOffset, expected, x);
    }

    @Override
    public short compareAndExchangeShort(byte[] buffer, long byteOffset, short expected, short x) throws IndexOutOfBoundsException {
        return Short.reverseBytes(this.access.compareAndExchangeShort(buffer, byteOffset, Short.reverseBytes(expected), Short.reverseBytes(x)));
    }

    @Override
    public int compareAndExchangeInt(byte[] buffer, long byteOffset, int expected, int x) throws IndexOutOfBoundsException {
        return Integer.reverseBytes(this.access.compareAndExchangeInt(buffer, byteOffset, Integer.reverseBytes(expected), Integer.reverseBytes(x)));
    }

    @Override
    public long compareAndExchangeLong(byte[] buffer, long byteOffset, long expected, long x) throws IndexOutOfBoundsException {
        return Long.reverseBytes(this.access.compareAndExchangeLong(buffer, byteOffset, Long.reverseBytes(expected), Long.reverseBytes(x)));
    }
}

