/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.amd.JSAmdModulesIndex;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.frameworks.gcl.JSGclModuleReference;
import com.intellij.lang.javascript.frameworks.gcl.JSGclReferenceContributor;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexedAccessType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptStringLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeofType;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSDestructuringPropertyReference;
import com.intellij.lang.javascript.psi.impl.JSFileBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSLiteralTextReference;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSScopeNamesCache;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSFunctionExpressionStub;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSLiteralExpressionStub;
import com.intellij.lang.javascript.psi.stubs.JSObjectLiteralExpressionStub;
import com.intellij.lang.javascript.psi.stubs.JSReturnStatementStub;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElementWithBackingItem;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionImpl;
import com.intellij.lang.javascript.psi.stubs.impl.StubTreeUtil;
import com.intellij.lang.javascript.psi.types.evaluable.JSReferenceType;
import com.intellij.lang.javascript.psi.types.evaluable.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptCompilerType;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSFindFirstResolveProcessor;
import com.intellij.lang.javascript.psi.util.JSMergeResolveProcessor;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.TypeScriptStubElementTypes;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSStubBasedPsiTreeUtil {
    static final TokenSet DECLARATIONS_TOKEN_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{JSElementTypes.FUNCTION_DECLARATIONS, JSElementTypes.FUNCTION_EXPRESSIONS, JSExtendedLanguagesTokenSetProvider.CLASSES, JSExtendedLanguagesTokenSetProvider.VARIABLES, JSExtendedLanguagesTokenSetProvider.MODULES, TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.DEFINITION_EXPRESSION, JSStubElementTypes.IMPORT_SPECIFIER, JSStubElementTypes.IMPORT_SPECIFIER_ALIAS, JSStubElementTypes.IMPORTED_BINDING, JSStubElementTypes.NAMESPACE_EXPORT, JSStubElementTypes.EXPORT_SPECIFIER, JSStubElementTypes.EXPORT_SPECIFIER_ALIAS, JSStubElementTypes.EXPORTED_DEFAULT_BINDING, TypeScriptStubElementTypes.TYPESCRIPT_IMPORT_STATEMENT, JSStubElementTypes.TYPESCRIPT_TYPE_ALIAS})});
    private static final TokenSet FUNCTIONS_TOKEN_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{JSElementTypes.FUNCTION_DECLARATIONS, JSElementTypes.FUNCTION_EXPRESSIONS});
    private static final TokenSet RETURN_STATEMENT_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.RETURN_STATEMENT});
    public static final Comparator<PsiElement> TEXT_OFFSET_COMPARATOR = (a, b) -> {
        if (a == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(116);
        }
        if (b == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(117);
        }
        if (a instanceof StubBasedPsiElementBase) {
            StubBasedPsiElementBase aStubElement = (StubBasedPsiElementBase)a;
            if (b instanceof StubBasedPsiElementBase) {
                StubBasedPsiElementBase bStubElement = (StubBasedPsiElementBase)b;
                StubElement aStub = aStubElement.getGreenStub();
                StubElement bStub = bStubElement.getGreenStub();
                if (aStub instanceof ObjectStubBase) {
                    ObjectStubBase aObjectStub = (ObjectStubBase)aStub;
                    if (bStub instanceof ObjectStubBase) {
                        ObjectStubBase bObjectStub = (ObjectStubBase)bStub;
                        return Integer.compare(aObjectStub.getStubId(), bObjectStub.getStubId());
                    }
                }
            }
        }
        return Integer.compare(a.getTextOffset(), b.getTextOffset());
    };
    private static final Predicate<PsiElement> IS_TARGET = element -> {
        boolean isImport = false;
        if (element instanceof JSVariable) {
            JSExpression initializer = JSDestructuringUtil.getNearestInitializerStubSafely((JSVariable)element);
            isImport = initializer instanceof JSCallExpression && ((JSCallExpression)initializer).isRequireCall() || element instanceof JSParameter && JSSymbolUtil.getParameterInitializationIfRequireArgument((JSParameter)element) != null;
        } else if (JSStubBasedPsiTreeUtil.isImportElement(element)) {
            isImport = true;
        } else if (element instanceof TypeScriptPropertySignature) {
            TypeScriptPropertySignature propertySignature = (TypeScriptPropertySignature)element;
            JSTypeDeclaration typeDeclaration = propertySignature.getTypeDeclaration();
            if (JSStubBasedPsiTreeUtil.isImportReference(typeDeclaration)) {
                isImport = true;
            } else {
                String referenceName;
                JSReferenceExpression localReference = JSStubBasedPsiTreeUtil.getTypeofLocalReference(typeDeclaration);
                if (localReference != null && (referenceName = localReference.getReferenceName()) != null && JSStubBasedPsiTreeUtil.isImportElement(JSStubBasedPsiTreeUtil.resolveLocally(referenceName, (PsiElement)localReference, false))) {
                    isImport = true;
                }
            }
        }
        if (isImport) {
            return false;
        }
        boolean isExport = false;
        if (element instanceof JSDefinitionExpression || element instanceof JSProperty && ((JSProperty)element).isShorthanded()) {
            String name = ((JSQualifiedNamedElement)element).getName();
            JSQualifiedName ns = ((JSElementBase)element).getJSNamespace().getQualifiedName();
            isExport = CommonJSUtil.isExportNamespace(ns) || name != null && CommonJSUtil.isExportNamespace(JSQualifiedNameImpl.create(name, ns));
        }
        return !isExport;
    };
    private static final Predicate<PsiElement> SEMANTIC_HIGHLIGHTING_STOP_AT = element -> {
        if (!IS_TARGET.test((PsiElement)element)) {
            return false;
        }
        return !(element instanceof JSProperty) || JSPsiImplUtils.getInitializerReference((JSProperty)element) == null;
    };
    private static final Predicate<PsiElement> SEMANTIC_HIGHLIGHTING_STOP_BEFORE = element -> element instanceof JSParameter && !TypeScriptPsiUtil.isFieldParameter((JSParameter)element);

    @Nullable
    public static PsiElement resolveLocally(@NotNull String name, @NotNull PsiElement context2) {
        if (name == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(1);
        }
        return JSStubBasedPsiTreeUtil.resolveLocally(name, context2, true);
    }

    @Nullable
    public static PsiElement resolveLocally(@NotNull String name, @NotNull PsiElement context2, boolean includeDefinitions) {
        if (name == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(3);
        }
        if (name.contains(".")) {
            return null;
        }
        JSFindFirstResolveProcessor processor = new JSFindFirstResolveProcessor(name, includeDefinitions);
        JSStubBasedPsiTreeUtil.processDeclarationsInScope(context2, processor, true);
        return processor.getResult();
    }

    @NotNull
    public static List<PsiElement> resolveLocallyWithMergedResults(@NotNull String name, @NotNull PsiElement context2) {
        if (name == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(5);
        }
        return JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(name, context2, false);
    }

    @NotNull
    public static List<PsiElement> resolveLocallyWithMergedResults(@NotNull String name, @NotNull PsiElement context2, boolean includeDefinitions) {
        if (name == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(6);
        }
        if (context2 == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(7);
        }
        if (name.contains(".")) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(8);
            }
            return list;
        }
        JSMergeResolveProcessor processor = new JSMergeResolveProcessor(name, includeDefinitions);
        JSStubBasedPsiTreeUtil.processDeclarationsInScope(context2, processor, true);
        List<PsiElement> list = processor.getResults();
        if (list == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    public static boolean processDeclarationsInScope(@NotNull PsiElement context2, @NotNull PsiScopeProcessor processor, boolean includeParentScopes) {
        if (context2 == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(11);
        }
        return JSDialectSpecificHandlersFactory.forElement(context2).getStubBasedScopeHandler().processDeclarationsInScope(context2, processor, includeParentScopes);
    }

    public static boolean hasStub(@NotNull PsiElement scope2) {
        if (scope2 == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(12);
        }
        return scope2 instanceof StubBasedPsiElementBase && ((StubBasedPsiElementBase)scope2).getStub() != null || scope2 instanceof PsiFileImpl && ((PsiFileImpl)scope2).getStubTree() != null;
    }

    public static boolean isStubBased(@NotNull PsiElement element) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(13);
        }
        return element instanceof StubBasedPsiElementBase && (((StubBasedPsiElementBase)element).getGreenStub() != null || ((StubBasedPsiElementBase)element).getElementType().shouldCreateStub(element.getNode()));
    }

    @NotNull
    public static Int2ObjectMap<Object> buildStubBasedNamesMap(@NotNull PsiElement scope2) {
        if (scope2 == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(14);
        }
        Int2ObjectOpenHashMap defs = new Int2ObjectOpenHashMap();
        ArrayList declarations = new ArrayList();
        JSStubBasedPsiTreeUtil.addDescendantsRecursively(scope2, DECLARATIONS_TOKEN_SET, JSExtendedLanguagesTokenSetProvider.SCOPE_ELEMENTS, scope2, null, declarations);
        for (PsiElement declaration : declarations) {
            String name = JSStubBasedPsiTreeUtil.extractNameIfAcceptable(declaration);
            if (name == null) continue;
            JSScopeNamesCache.addElementCompact((Int2ObjectMap<Object>)defs, (JSElement)declaration, name.hashCode());
        }
        Int2ObjectOpenHashMap int2ObjectOpenHashMap = defs;
        if (int2ObjectOpenHashMap == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(15);
        }
        return int2ObjectOpenHashMap;
    }

    @Nullable
    static String extractNameIfAcceptable(@NotNull PsiElement declaration) {
        if (declaration == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(16);
        }
        if (declaration instanceof JSDefinitionExpression) {
            JSDefinitionExpression definitionExpression = (JSDefinitionExpression)declaration;
            return definitionExpression.getNamespace() == null ? definitionExpression.getName() : null;
        }
        if (declaration instanceof JSNamedElement) {
            return declaration instanceof JSNamedExpression && !(declaration.getContext() instanceof ES6ExportDefaultAssignment) ? null : ((JSNamedElement)declaration).getName();
        }
        if (declaration instanceof ES6ImportExportSpecifier) {
            return ((ES6ImportExportSpecifier)declaration).getAlias() == null ? ((ES6ImportExportSpecifier)declaration).getDeclaredName() : null;
        }
        return null;
    }

    @Nullable
    public static PsiElement getContextOfType(@NotNull PsiElement element, @NotNull TokenSet types, boolean strict) {
        StubElement stub;
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(17);
        }
        if (types == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(18);
        }
        if (strict && element instanceof PsiFile) {
            return null;
        }
        if (strict) {
            element = element.getContext();
        }
        if (element == null) {
            return null;
        }
        if (element instanceof StubBasedPsiElementBase) {
            StubBasedPsiElementBase stubBase = (StubBasedPsiElementBase)element;
            v0 = stubBase.getStub();
        } else if (element instanceof PsiFileImpl) {
            PsiFileImpl psiFile = (PsiFileImpl)element;
            v0 = psiFile.getStub();
        } else {
            v0 = stub = null;
        }
        if (stub != null) {
            while (stub != null) {
                PsiElement psi = stub.getPsi();
                if (stub instanceof PsiFileStub) {
                    PsiFileStub fileStub = (PsiFileStub)stub;
                    return types.contains((IElementType)fileStub.getType()) ? psi : null;
                }
                if (types.contains((IElementType)stub.getStubType())) {
                    return psi;
                }
                stub = stub.getParentStub();
            }
        } else {
            if (element instanceof PsiFileImpl) {
                PsiFileImpl file = (PsiFileImpl)element;
                return types.contains((IElementType)file.getFileElementType()) ? file : null;
            }
            ASTNode node = element.getNode();
            while (node != null) {
                if (types.contains(node.getElementType())) {
                    return node.getPsi();
                }
                if (node instanceof FileASTNode) {
                    return null;
                }
                node = TreeUtil.findParent((ASTNode)node, (TokenSet)types);
            }
        }
        return null;
    }

    @Nullable
    public static PsiElement resolveReferenceLocally(@NotNull PsiPolyVariantReference reference, @Nullable String referenceName) {
        PsiFile file;
        PsiElement context2;
        if (reference == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(19);
        }
        if (referenceName == null) {
            return null;
        }
        PsiElement element = reference.getElement();
        PsiElement localElement = JSStubBasedPsiTreeUtil.resolveLocally(referenceName, element, false);
        if (localElement == null && (context2 = JSResolveUtil.getContext((PsiElement)(file = element.getContainingFile()))) != null) {
            localElement = JSStubBasedPsiTreeUtil.resolveLocally(referenceName, context2, false);
        }
        return localElement;
    }

    @NotNull
    public static <T extends PsiElement> Collection<T> findDescendants(@NotNull PsiElement element, @NotNull IStubElementType<?, T> elementType) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(20);
        }
        if (elementType == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(21);
        }
        return JSStubBasedPsiTreeUtil.findDescendants(element, TokenSet.create((IElementType[])new IElementType[]{elementType}));
    }

    @NotNull
    public static <T extends PsiElement> Collection<T> findDescendants(@NotNull PsiElement element, @NotNull TokenSet elements) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(22);
        }
        if (elements == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(23);
        }
        return JSStubBasedPsiTreeUtil.findDescendants(element, elements, TokenSet.EMPTY);
    }

    @NotNull
    public static <T extends PsiElement> List<T> findDescendants(@NotNull PsiElement element, @NotNull TokenSet elements, @NotNull TokenSet stopAt) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(24);
        }
        if (elements == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(25);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(26);
        }
        ArrayList result2 = new ArrayList();
        JSStubBasedPsiTreeUtil.addDescendantsRecursively(element, elements, stopAt, null, null, result2);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    private static <T extends PsiElement> void addDescendantsRecursively(@NotNull PsiElement container, @NotNull TokenSet targetElements, @NotNull TokenSet stopAt, @Nullable PsiElement context2, @Nullable IntRef outTargetElementsBeforeContext, Collection<T> out) {
        StubElement stub;
        if (container == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(28);
        }
        if (targetElements == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(29);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(30);
        }
        if (!(container instanceof PsiFileImpl || container instanceof StubBasedPsiElementBase || container instanceof LazyParseablePsiElement)) {
            return;
        }
        Object object = container instanceof PsiFileImpl ? ((PsiFileImpl)container).getStub() : (stub = container instanceof StubBasedPsiElementBase ? ((StubBasedPsiElementBase)container).getStub() : null);
        if (stub != null) {
            List stubs = stub.getChildrenStubs();
            for (StubElement child : stubs) {
                IStubElementType type2;
                PsiElement psi = child.getPsi();
                if (psi == context2 && outTargetElementsBeforeContext != null) {
                    outTargetElementsBeforeContext.set(out.size());
                }
                if (targetElements.contains((IElementType)(type2 = child.getStubType()))) {
                    out.add(psi);
                }
                if (stopAt.contains((IElementType)type2)) continue;
                JSStubBasedPsiTreeUtil.addDescendantsRecursively(psi, targetElements, stopAt, context2, outTargetElementsBeforeContext, out);
            }
        } else {
            JSStubBasedPsiTreeUtil.addDescendantsRecursively(container.getNode(), targetElements, stopAt, context2 != null ? context2.getNode() : null, outTargetElementsBeforeContext, out);
        }
    }

    private static <T extends PsiElement> void addDescendantsRecursively(@NotNull ASTNode container, @NotNull TokenSet targetElements, @NotNull TokenSet stopAt, @Nullable ASTNode context2, @Nullable IntRef outTargetElementsBeforeContext, Collection<T> out) {
        if (container == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(31);
        }
        if (targetElements == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(32);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(33);
        }
        for (ASTNode child = container.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type2;
            if (child == context2 && outTargetElementsBeforeContext != null) {
                outTargetElementsBeforeContext.set(out.size());
            }
            if (targetElements.contains(type2 = child.getElementType())) {
                out.add(child.getPsi());
            }
            if (stopAt.contains(type2)) continue;
            JSStubBasedPsiTreeUtil.addDescendantsRecursively(child, targetElements, stopAt, context2, outTargetElementsBeforeContext, out);
        }
    }

    @Nullable
    public static JSDocComment findDocComment(@NotNull PsiElement element) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(34);
        }
        JSDocComment candidate = null;
        if (!(element instanceof StubBasedPsiElementBase) || ((StubBasedPsiElementBase)element).getStub() == null) {
            PsiComment docComment = JSDocumentationUtils.findDocComment(element);
            if (docComment instanceof JSDocComment) {
                candidate = (JSDocComment)docComment;
            }
        } else {
            candidate = JSStubBasedPsiTreeUtil.findOwnDocCommentForStub((StubBasedPsiElementBase)element);
        }
        if (candidate != null && JSDocumentationUtils.mayRelateTo(candidate, element)) {
            return candidate;
        }
        return null;
    }

    @Nullable
    public static JSDocComment findOwnDocComment(@NotNull PsiElement element) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(35);
        }
        JSDocComment candidate = null;
        if (!(element instanceof StubBasedPsiElementBase) || ((StubBasedPsiElementBase)element).getStub() == null) {
            JSDocComment docComment = JSDocumentationUtils.findOwnDocComment(element);
            if (docComment != null) {
                candidate = docComment;
            }
        } else {
            candidate = JSStubBasedPsiTreeUtil.findOwnDocCommentForStub((StubBasedPsiElementBase)element);
        }
        if (candidate != null && JSDocumentationUtils.mayRelateTo(candidate, element)) {
            return candidate;
        }
        return null;
    }

    @Nullable
    private static JSDocComment findOwnDocCommentForStub(@NotNull StubBasedPsiElementBase<?> element) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(36);
        }
        if (element instanceof JSDefinitionExpression) {
            PsiElement prevSibling;
            PsiElement context2 = element.getContext();
            if (context2 != null && (prevSibling = JSStubBasedPsiTreeUtil.getPrevSibling(context2)) instanceof JSDocComment) {
                return (JSDocComment)prevSibling;
            }
            return null;
        }
        if (element instanceof JSVariable) {
            JSDocComment varChild = (JSDocComment)element.getStubOrPsiChild(JSStubElementTypes.DOC_COMMENT);
            if (varChild != null) {
                return varChild;
            }
            PsiElement context3 = element.getContext();
            if (context3 instanceof JSVarStatement && context3 instanceof StubBasedPsiElementBase) {
                element = (StubBasedPsiElementBase)context3;
            }
        }
        return (JSDocComment)element.getStubOrPsiChild(JSStubElementTypes.DOC_COMMENT);
    }

    @Nullable
    public static PsiElement getNextSibling(@NotNull PsiElement element) {
        StubBasedPsiElementBase stubBase;
        StubElement stub;
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(37);
        }
        if (element instanceof StubBasedPsiElementBase && (stub = (stubBase = (StubBasedPsiElementBase)element).getStub()) != null) {
            StubElement<?> nextSibling = StubTreeUtil.getNextSibling(stub);
            return nextSibling != null ? nextSibling.getPsi() : null;
        }
        return element.getNextSibling();
    }

    @Nullable
    public static PsiElement getPrevSibling(@NotNull PsiElement element) {
        StubBasedPsiElementBase stubBase;
        StubElement stub;
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(38);
        }
        if (element instanceof StubBasedPsiElementBase && (stub = (stubBase = (StubBasedPsiElementBase)element).getStub()) != null) {
            StubElement<?> prevSibling = StubTreeUtil.getPrevSibling(stub);
            return prevSibling != null ? prevSibling.getPsi() : null;
        }
        return element.getPrevSibling();
    }

    @NotNull
    public static <T extends JSExpression> Collection<T> findReturnedExpressions(@NotNull JSFunction function, Class<? extends T> ... classes) {
        if (function == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(39);
        }
        if (classes == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(40);
        }
        List<JSExpression> candidates = JSStubBasedPsiTreeUtil.findReturnedExpressions(function);
        Collection collection = candidates.stream().filter(c -> PsiTreeUtil.instanceOf((Object)c, (Class[])classes)).map(c -> c).collect(Collectors.toList());
        if (collection == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(41);
        }
        return collection;
    }

    @NotNull
    public static List<JSExpression> findReturnedExpressions(@NotNull JSFunction function) {
        if (function == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(42);
        }
        SmartList candidates = new SmartList();
        if (function instanceof StubBasedPsiElement && ((StubBasedPsiElement)function).getStub() != null) {
            List<Object> candidateParents = function.isShorthandArrowFunction() ? Collections.singletonList((StubBasedPsiElement)function) : JSStubBasedPsiTreeUtil.findDescendants(function, RETURN_STATEMENT_TOKEN_SET, FUNCTIONS_TOKEN_SET);
            for (StubBasedPsiElement stubBasedPsiElement : candidateParents) {
                StubElement<?> expressionStub;
                StubElement parentStub = stubBasedPsiElement.getStub();
                if (!(parentStub instanceof JSFunctionExpressionStub ? ((JSFunctionExpressionStub)parentStub).keepsShorthandArrowFunctionReturnedExpression() : parentStub instanceof JSReturnStatementStub && ((JSReturnStatementStub)parentStub).keepsReturnedExpressionStub()) || (expressionStub = StubTreeUtil.findChildStubByType(parentStub, JSExtendedLanguagesTokenSetProvider.EXPRESSIONS, false)) == null) continue;
                candidates.add((JSExpression)expressionStub.getPsi());
            }
        } else {
            JSExpression expression = JSPsiImplUtils.getReturnedExpressionIfShorthandArrowFunction(function);
            if ((expression = JSUtils.unparenthesize(expression)) != null) {
                candidates.add(expression);
            } else {
                function.acceptChildren(new JSRecursiveWalkingElementVisitor((List)candidates){
                    final /* synthetic */ List val$candidates;
                    {
                        this.val$candidates = list;
                    }

                    @Override
                    public boolean visitAsFunction(@NotNull JSFunction function) {
                        if (function == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return true;
                    }

                    @Override
                    public void visitJSReturnStatement(@NotNull JSReturnStatement node) {
                        JSExpression expression;
                        if (node == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if ((expression = node.getExpression()) != null) {
                            this.val$candidates.add(expression);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "function";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "node";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitAsFunction";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitJSReturnStatement";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        }
        SmartList smartList = candidates;
        if (smartList == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(43);
        }
        return smartList;
    }

    @Nullable
    public static PsiElement getStubOrPsiChild(@NotNull StubBasedPsiElementBase<?> element, @NotNull TokenSet filter) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(44);
        }
        if (filter == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(45);
        }
        return JSStubBasedPsiTreeUtil.getStubOrPsiChild(element, filter, TokenSet.EMPTY);
    }

    @Nullable
    public static PsiElement getStubOrPsiChild(@NotNull StubBasedPsiElementBase<?> element, @NotNull TokenSet filter, @NotNull TokenSet stopAt) {
        StubElement stub;
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(46);
        }
        if (filter == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(47);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(48);
        }
        if ((stub = element.getStub()) != null) {
            StubElement<?> child = StubTreeUtil.findDirectChild(stub, childStub -> {
                IStubElementType stubType = childStub.getStubType();
                return filter.contains((IElementType)stubType) || stopAt.contains((IElementType)stubType);
            });
            if (child != null) {
                return filter.contains((IElementType)child.getStubType()) ? child.getPsi() : null;
            }
        } else {
            for (ASTNode child = element.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
                IElementType elementType = child.getElementType();
                if (filter.contains(elementType)) {
                    return child.getPsi();
                }
                if (!stopAt.contains(elementType)) continue;
                return null;
            }
        }
        return null;
    }

    public static PsiElement @NotNull [] getChildrenByType(@NotNull PsiElement element, @NotNull TokenSet type2) {
        ASTNode node;
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(49);
        }
        if (type2 == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(50);
        }
        if (element instanceof JSFileBaseImpl || element instanceof JSStubElementImpl) {
            StubElement stub;
            if (element instanceof JSFileBaseImpl) {
                JSFileBaseImpl jsFileBase = (JSFileBaseImpl)element;
                v0 = jsFileBase.getStub();
            } else {
                v0 = stub = ((JSStubElementImpl)element).getStub();
            }
            if (stub != null) {
                PsiElement[] psiElementArray = stub.getChildrenByType(type2, JSElement.ARRAY_FACTORY);
                if (psiElementArray == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(51);
                }
                return psiElementArray;
            }
        }
        if ((node = element.getNode()) == null) {
            Logger.getInstance(JSStubBasedPsiTreeUtil.class).error(element.getClass().getName() + "#getNode() is null");
            if (PsiElement.EMPTY_ARRAY == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(52);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ASTNode[] children = node.getChildren(type2);
        PsiElement[] result2 = new PsiElement[children.length];
        for (int i = 0; i < children.length; ++i) {
            result2[i] = children[i].getPsi();
        }
        if (result2 == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(53);
        }
        return result2;
    }

    @NotNull
    public static PsiElement calculateMeaningfulElement(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(54);
        }
        return JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult, null);
    }

    @NotNull
    public static Collection<PsiElement> calculateMeaningfulElements(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(55);
        }
        return JSStubBasedPsiTreeUtil.calculateMeaningfulElements(resolveResult, null, x -> false, x -> false, false);
    }

    @NotNull
    public static PsiElement calculateMeaningfulElement(@NotNull PsiElement resolveResult, @Nullable Set<? super PsiElement> visited) {
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(56);
        }
        return JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult, visited, x -> false);
    }

    @NotNull
    public static PsiElement calculateMeaningfulElement(@NotNull PsiElement resolveResult, @Nullable Set<? super PsiElement> visited, @NotNull Predicate<? super PsiElement> stopAt) {
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(57);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(58);
        }
        return JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult, visited, stopAt, x -> false);
    }

    @NotNull
    public static PsiElement calculateMeaningfulElement(@NotNull PsiElement resolveResult, @Nullable Set<? super PsiElement> visited, @NotNull Predicate<? super PsiElement> stopAt, @NotNull Predicate<? super PsiElement> stopBefore) {
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(59);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(60);
        }
        if (stopBefore == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(61);
        }
        Collection<PsiElement> elements = JSStubBasedPsiTreeUtil.calculateMeaningfulElements(resolveResult, visited, stopAt, stopBefore, false);
        return JSStubBasedPsiTreeUtil.reduceToOneMeaningful(resolveResult, elements);
    }

    @NotNull
    private static PsiElement reduceToOneMeaningful(@NotNull PsiElement resolveResult, @NotNull Collection<PsiElement> allMeaningful) {
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(62);
        }
        if (allMeaningful == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(63);
        }
        if (allMeaningful.size() > 1) {
            PsiElement psiElement = resolveResult;
            if (psiElement == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(64);
            }
            return psiElement;
        }
        PsiElement item = (PsiElement)ContainerUtil.getFirstItem(allMeaningful);
        PsiElement psiElement = item == null ? resolveResult : item;
        if (psiElement == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(65);
        }
        return psiElement;
    }

    @NotNull
    public static Collection<PsiElement> calculateMeaningfulElements(@NotNull PsiElement resolveResult, @Nullable Set<? super PsiElement> visited, @NotNull Predicate<? super PsiElement> stopAt, @NotNull Predicate<? super PsiElement> stopBefore, boolean lightweightImprecise) {
        PsiElement localResolved;
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(66);
        }
        if (stopAt == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(67);
        }
        if (stopBefore == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(68);
        }
        if (stopAt.test((PsiElement)resolveResult)) {
            List list = ContainerUtil.createMaybeSingletonList((Object)resolveResult);
            if (list == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(69);
            }
            return list;
        }
        if (visited != null && !visited.add((PsiElement)resolveResult)) {
            List list = ContainerUtil.createMaybeSingletonList((Object)resolveResult);
            if (list == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(70);
            }
            return list;
        }
        String initializerReference = null;
        SmartList referencedElements = new SmartList();
        boolean referencedViaExportAssignment = false;
        if (resolveResult instanceof JSVariable) {
            PsiElement parent;
            JSExpression methodExpression;
            JSGclModuleReference reference;
            JSCallExpression callExpr;
            JSExpression initializer = ((JSVariable)resolveResult).getInitializerOrStub();
            if (initializer instanceof JSReferenceExpression) {
                JSReferenceExpression ref2 = (JSReferenceExpression)initializer;
                List resolved = lightweightImprecise ? ContainerUtil.createMaybeSingletonList((Object)JSStubBasedPsiTreeUtil.resolveReferenceLocally(ref2, ref2.getReferenceName())) : JSResolveResult.resolveReference(ref2);
                referencedElements.addAll(resolved);
            } else if (initializer instanceof JSCallExpression && ((JSCallExpression)initializer).isRequireCall()) {
                referencedElements.addAll(JSStubBasedPsiTreeUtil.getRequireCallReferencedElement((JSCallExpression)initializer));
            } else if (!lightweightImprecise && initializer instanceof JSCallExpression && JSGclReferenceContributor.isGoogRequireCall((callExpr = (JSCallExpression)initializer).getStubSafeMethodExpression())) {
                reference = JSGclReferenceContributor.getGclModuleReference(callExpr);
                if (reference != null) {
                    referencedElements.addAll(JSResolveResult.resolveReference(reference));
                }
            } else if (initializer instanceof JSCallExpression && (methodExpression = JSUtils.unparenthesize(((JSCallExpression)initializer).getStubSafeMethodExpression())) instanceof JSFunctionExpression) {
                Collection returnedExpressions = JSStubBasedPsiTreeUtil.findReturnedExpressions((JSFunctionExpression)methodExpression, JSFunctionExpression.class);
                referencedElements.addAll(returnedExpressions);
            }
            String initializerText = ((JSVariable)resolveResult).getLiteralOrReferenceInitializerText();
            if (initializerText != null && JSSymbolUtil.isValidPropertyName(initializerText)) {
                initializerReference = initializerText;
            }
            if ((parent = resolveResult.getParent()) instanceof JSDestructuringProperty && referencedElements.isEmpty() && (reference = parent.getReference()) instanceof JSDestructuringPropertyReference) {
                ref = (JSDestructuringPropertyReference)((Object)reference);
                List resolved = lightweightImprecise ? ContainerUtil.createMaybeSingletonList((Object)JSStubBasedPsiTreeUtil.resolveReferenceLocally((PsiPolyVariantReference)ref, ((JSDestructuringPropertyReference)((Object)ref)).getCanonicalText())) : JSResolveResult.resolveReference((PsiPolyVariantReference)ref);
                referencedElements.addAll(resolved);
            }
        } else if (resolveResult instanceof JSProperty) {
            if (((JSProperty)resolveResult).isGetProperty() && resolveResult instanceof JSFunction) {
                type = ((JSFunction)resolveResult).getReturnType();
                if (type instanceof JSRequireCallExpressionType) {
                    referencedElements.addAll(JSStubBasedPsiTreeUtil.resolveRequireCallReference(resolveResult, ((JSRequireCallExpressionType)type).resolveReferencedModule()));
                }
            } else {
                initializerReference = JSPsiImplUtils.getInitializerReference((JSProperty)resolveResult);
            }
        } else if (resolveResult instanceof JSDefinitionExpression) {
            initializerReference = JSPsiImplUtils.getInitializerReference((JSDefinitionExpression)resolveResult);
            type = ((JSDefinitionExpression)resolveResult).getJSType();
            if (type instanceof JSRequireCallExpressionType) {
                referencedElements.addAll(JSStubBasedPsiTreeUtil.resolveRequireCallReference(resolveResult, ((JSRequireCallExpressionType)type).resolveReferencedModule()));
            }
        } else if (resolveResult instanceof TypeScriptImportStatement) {
            Collection<? extends PsiElement> importElements = ((TypeScriptImportStatement)resolveResult).findReferencedElements();
            referencedElements.addAll(importElements);
        } else if (resolveResult instanceof ES6ImportExportSpecifierAlias) {
            PsiElement element = ((ES6ImportExportSpecifierAlias)resolveResult).findAliasedElement();
            ContainerUtil.addIfNotNull((Collection)referencedElements, (Object)element);
        } else if (resolveResult instanceof ES6ImportedExportedDefaultBinding) {
            Collection<PsiElement> elements = ((ES6ImportedExportedDefaultBinding)resolveResult).findReferencedElements();
            referencedElements.addAll(elements);
        } else if (resolveResult instanceof JSExportAssignment) {
            initializerReference = ((JSExportAssignment)resolveResult).getInitializerReference();
            if (initializerReference == null) {
                ContainerUtil.addIfNotNull((Collection)referencedElements, (Object)((JSExportAssignment)resolveResult).getStubSafeElement());
            }
            referencedViaExportAssignment = true;
        } else if (resolveResult instanceof ES6ImportExportSpecifier) {
            ResolveResult[] results = ES6PsiUtil.resolveSymbolForSpecifier((ES6ImportExportSpecifier)resolveResult);
            referencedElements.addAll(JSResolveUtil.getValidResults(results));
        } else if (resolveResult instanceof TypeScriptPropertySignature) {
            JSLiteralExpression literalExpression;
            TypeScriptStringLiteralType literalType;
            TypeScriptIndexedAccessType indexedAccessType;
            TypeScriptPropertySignature propertySignature = (TypeScriptPropertySignature)resolveResult;
            if (JSStubBasedPsiTreeUtil.isImportReference(propertySignature.getTypeDeclaration()) && (ref = propertySignature.getTypeDeclaration()) instanceof TypeScriptIndexedAccessType && (ref = (indexedAccessType = (TypeScriptIndexedAccessType)ref).getParameterTypeElement()) instanceof TypeScriptStringLiteralType && (ref = (literalType = (TypeScriptStringLiteralType)ref).getExpression()) instanceof JSLiteralExpression && (ref = (literalExpression = (JSLiteralExpression)ref).getReference()) instanceof JSLiteralTextReference) {
                JSLiteralTextReference literalTextReference = (JSLiteralTextReference)ref;
                ResolveResult[] results = literalTextReference.multiResolve(false);
                if (!JSResolveResult.isTooManyCandidatesResult(results)) {
                    referencedElements.addAll(JSResolveUtil.getValidResults(results));
                }
            } else {
                JSReferenceExpression localReference = JSStubBasedPsiTreeUtil.getTypeofLocalReference(propertySignature.getTypeDeclaration());
                if (localReference != null) {
                    initializerReference = localReference.getReferenceName();
                }
            }
        }
        if (!(initializerReference == null || !referencedElements.isEmpty() || (localResolved = JSStubBasedPsiTreeUtil.resolveLocally(initializerReference, resolveResult)) == null || referencedViaExportAssignment && localResolved instanceof TypeScriptFunction && TypeScriptPsiUtil.getAllOverloadSignatures((TypeScriptFunction)localResolved).size() != 1)) {
            ContainerUtil.addIfNotNull((Collection)referencedElements, (Object)localResolved);
        }
        if (referencedElements.isEmpty()) {
            List list = ContainerUtil.createMaybeSingletonList((Object)resolveResult);
            if (list == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(71);
            }
            return list;
        }
        SmartList result2 = new SmartList();
        for (PsiElement element : referencedElements) {
            if (visited == null) {
                visited = new HashSet<PsiElement>();
            }
            if (stopBefore.test((PsiElement)element)) {
                List list = ContainerUtil.createMaybeSingletonList((Object)resolveResult);
                if (list == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(72);
                }
                return list;
            }
            result2.addAll(JSStubBasedPsiTreeUtil.calculateMeaningfulElements(element, visited, stopAt, stopBefore, lightweightImprecise));
        }
        SmartList smartList = result2;
        if (smartList == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(73);
        }
        return smartList;
    }

    public static boolean isImportReference(@Nullable JSTypeDeclaration type2) {
        TypeScriptSingleType singleType;
        TypeScriptIndexedAccessType indexedAccessType;
        TypeScriptType typeScriptType;
        return type2 instanceof TypeScriptIndexedAccessType && (typeScriptType = (indexedAccessType = (TypeScriptIndexedAccessType)type2).getOwnerTypeElement()) instanceof TypeScriptSingleType && TypeScriptPsiUtil.isTypeofImport(singleType = (TypeScriptSingleType)typeScriptType);
    }

    @Nullable
    private static JSReferenceExpression getTypeofLocalReference(@Nullable JSTypeDeclaration type2) {
        if (!(type2 instanceof TypeScriptTypeofType)) {
            return null;
        }
        TypeScriptTypeofType typeofType = (TypeScriptTypeofType)type2;
        JSExpression jSExpression = typeofType.getExpression();
        if (!(jSExpression instanceof JSReferenceExpression)) {
            return null;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)jSExpression;
        return referenceExpression.getQualifier() == null ? referenceExpression : null;
    }

    private static boolean isImportElement(@Nullable PsiElement element) {
        return element instanceof TypeScriptImportStatement || element instanceof ES6ImportExportSpecifierAlias || element instanceof ES6ImportedExportedDefaultBinding || element instanceof JSExportAssignment;
    }

    @NotNull
    public static PsiElement calculateTargetElement(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(74);
        }
        return JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult, null, IS_TARGET);
    }

    @NotNull
    public static PsiElement calculateTargetElementForHighlighting(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(75);
        }
        return JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult, null, SEMANTIC_HIGHLIGHTING_STOP_AT, SEMANTIC_HIGHLIGHTING_STOP_BEFORE);
    }

    @NotNull
    private static Collection<PsiElement> getRequireCallReferencedElement(JSCallExpression initializer) {
        String referencePath;
        JSLiteralExpression argument = JSStubBasedPsiTreeUtil.findRequireCallArgument(initializer);
        String string = referencePath = argument != null ? argument.getSignificantValue() : null;
        if (referencePath == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(76);
            }
            return list;
        }
        return JSStubBasedPsiTreeUtil.resolveRequireCallReference((PsiElement)initializer, StringUtil.unquoteString((String)referencePath));
    }

    @NotNull
    private static Collection<PsiElement> resolveRequireCallReference(@NotNull PsiElement context2, @Nullable String unquotedModuleName) {
        if (context2 == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(77);
        }
        if (unquotedModuleName == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(78);
            }
            return list;
        }
        Collection<PsiElement> files = JSFileReferencesUtil.resolveModuleReference((PsiElement)context2.getContainingFile(), unquotedModuleName);
        if (files.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(79);
            }
            return list;
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (PsiElement element : files) {
            if (!(element instanceof JSFile)) {
                result2.add(element);
                continue;
            }
            JSFile file = (JSFile)element;
            SmartList candidates = new SmartList();
            if (JSAmdPsiUtil.isWithinAmdModule(context2)) {
                JSFunctionExpression defaultAmdModule = JSAmdModulesIndex.findDefaultAmdModule(file);
                if (defaultAmdModule != null) {
                    JSType returnType2 = defaultAmdModule.getReturnType();
                    if (returnType2 instanceof JSReferenceType) {
                        PsiElement sourceElement = returnType2.getSourceElement();
                        if (sourceElement == null) {
                            sourceElement = defaultAmdModule;
                        }
                        ContainerUtil.addIfNotNull((Collection)candidates, (Object)JSStubBasedPsiTreeUtil.resolveLocally(((JSReferenceType)returnType2).getReferenceName(), sourceElement));
                    } else {
                        candidates.addAll(JSStubBasedPsiTreeUtil.findReturnedExpressions(defaultAmdModule, JSExpression.class));
                    }
                }
            } else {
                candidates.addAll(JSResolveUtil.getExportedElements(file));
            }
            if (candidates.isEmpty()) {
                result2.add(file);
                continue;
            }
            result2.addAll((Collection<PsiElement>)candidates);
        }
        ArrayList<PsiElement> arrayList = result2;
        if (arrayList == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(80);
        }
        return arrayList;
    }

    @Nullable
    public static JSLiteralExpression findRequireCallArgument(@NotNull JSCallExpression callExpression) {
        Collection<JSLiteralExpression> expressions;
        if (callExpression == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(81);
        }
        return (expressions = JSStubBasedPsiTreeUtil.findDescendants((PsiElement)callExpression, JSStubElementTypes.LITERAL_EXPRESSION)).size() == 1 ? expressions.iterator().next() : null;
    }

    @Nullable
    public static PsiElement findAssociatedElement(@NotNull JSDocComment psiComment) {
        JSDefinitionExpression definitionExpression;
        if (psiComment == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(82);
        }
        PsiElement parent = psiComment.getContext();
        Object next = null;
        if (parent instanceof JSProperty || parent instanceof JSFunction || parent instanceof JSVariable) {
            next = parent;
        } else if (parent instanceof JSVarStatement) {
            JSVariable[] variables = ((JSVarStatement)parent).getStubSafeVariables();
            if (variables.length > 0) {
                next = variables[0];
            }
        } else {
            JSDocComment nextDoc;
            next = JSStubBasedPsiTreeUtil.getNextSibling((PsiElement)psiComment);
            while (next instanceof PsiWhiteSpace) {
                next = JSStubBasedPsiTreeUtil.getNextSibling(next);
            }
            if (next != null && (nextDoc = JSStubBasedPsiTreeUtil.findDocComment(next)) != null && nextDoc != psiComment) {
                next = null;
            }
        }
        if (next instanceof JSAssignmentExpression && (definitionExpression = ((JSAssignmentExpression)next).getDefinitionExpression()) != null) {
            next = definitionExpression;
        }
        return next;
    }

    @Nullable
    public static JSExpression findStubSafeChildExpression(StubBasedPsiElementBase<?> element) {
        StubElement stub = element.getStub();
        if (stub != null) {
            StubElement<?> expressionStub = StubTreeUtil.findChildStubByType(stub, JSExtendedLanguagesTokenSetProvider.EXPRESSIONS, true);
            return expressionStub != null ? (JSExpression)expressionStub.getPsi() : null;
        }
        ASTNode exprNode = element.getNode().findChildByType(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
        return exprNode != null ? (JSExpression)exprNode.getPsi() : null;
    }

    public static Stream<? extends PsiElement> getFileOrModuleChildrenStream(@NotNull PsiElement fileOrModule) {
        if (fileOrModule == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(83);
        }
        return JSStubBasedPsiTreeUtil.getFilteredFileOrModuleChildrenStream(fileOrModule, null, null);
    }

    @NotNull
    public static <T extends PsiElement> Stream<T> getFilteredFileOrModuleChildrenStream(@NotNull PsiElement fileOrModule, @Nullable TokenSet stubSearchFilter, @Nullable Class<T> psiSearchFilter) {
        if (fileOrModule == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(84);
        }
        Pair stubOrTree = null;
        StubElement stub = null;
        if (fileOrModule instanceof PsiFileImpl) {
            stubOrTree = ((PsiFileImpl)fileOrModule).getStubTreeOrFileElement();
            stub = stubOrTree.first != null ? ((StubTree)stubOrTree.first).getRoot() : null;
        } else if (fileOrModule instanceof JSStubElementImpl) {
            stub = ((JSStubElementImpl)fileOrModule).getGreenStub();
        }
        if (stub != null) {
            Stream<PsiElement> stream = stub.getChildrenStubs().stream().filter(el -> stubSearchFilter == null || stubSearchFilter.contains((IElementType)el.getStubType())).map(childStub -> childStub.getPsi());
            if (stream == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(85);
            }
            return stream;
        }
        JBIterable iterable = SyntaxTraverser.psiTraverser().children((Object)fileOrModule);
        if (psiSearchFilter != null) {
            iterable = iterable.filter(psiSearchFilter);
        }
        if (stubSearchFilter != null) {
            iterable = iterable.filter(el -> {
                ASTNode node = el.getNode();
                return node == null || stubSearchFilter.contains(node.getElementType());
            });
        }
        if (stubOrTree != null) {
            stubOrTree.getFirst();
        }
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(iterable.iterator(), 16);
        Stream stream = StreamSupport.stream(spliterator, false);
        if (stream == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(86);
        }
        return stream;
    }

    @NotNull
    public static Collection<JSFunctionWithSubstitutor> calculatePossibleFunctions(@NotNull PsiElement element, @Nullable PsiElement methodExpression, boolean includeRawSignatures) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(87);
        }
        return JSStubBasedPsiTreeUtil.calculatePossibleFunctions(element, methodExpression, null, includeRawSignatures, false);
    }

    @NotNull
    public static Collection<JSFunctionWithSubstitutor> calculatePossibleFunctions(@NotNull PsiElement element, @Nullable PsiElement methodExpression, @Nullable Set<PsiElement> visited, boolean includeRawSignatures, boolean lightweightImprecise) {
        Collection<JSImplicitElement> implicitElements;
        JSImplicitElementProvider implicitProvider;
        JSElementIndexingData data;
        PsiElement psiElement;
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(88);
        }
        if (element instanceof TypeScriptProxyImplicitElementWithBackingItem) {
            TypeScriptProxyImplicitElementWithBackingItem withBacking = (TypeScriptProxyImplicitElementWithBackingItem)element;
            psiElement = withBacking.getBackingElement();
        } else {
            TypeScriptProxyImplicitElement proxy;
            psiElement = element instanceof TypeScriptProxyImplicitElement && (proxy = (TypeScriptProxyImplicitElement)element).getJSType() instanceof TypeScriptCompilerType ? proxy.getExplicitElement() : element;
        }
        PsiElement originalElement = psiElement;
        boolean isTypeScript = DialectDetector.isTypeScript(originalElement);
        Collection<PsiElement> allMeaningful = JSStubBasedPsiTreeUtil.calculateMeaningfulElements(originalElement, visited, el -> {
            JSTypeDeclarationOwner declarationOwner;
            return isTypeScript && DialectDetector.isTypeScript(el) && el instanceof JSTypeDeclarationOwner && (declarationOwner = (JSTypeDeclarationOwner)el).getTypeElement() != null;
        }, x -> false, lightweightImprecise);
        PsiElement meaningful = JSStubBasedPsiTreeUtil.reduceToOneMeaningful(element, allMeaningful);
        if (meaningful instanceof JSFunctionItem) {
            TypeScriptFunction tsFunction;
            JSFunctionItem functionItem = (JSFunctionItem)meaningful;
            if (meaningful instanceof TypeScriptFunction && (tsFunction = (TypeScriptFunction)meaningful).isOverloadImplementation()) {
                List<TypeScriptFunction> overloads = tsFunction.getOverloadDeclarations();
                List list = ContainerUtil.map(overloads, JSPsiImplUtils.TO_FUNCTION_WITH_SUBSTITUTOR);
                if (list == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(89);
                }
                return list;
            }
            JSFunctionItem function = functionItem.isGetProperty() ? null : functionItem;
            Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply(function);
            if (collection == null) {
                JSStubBasedPsiTreeUtil.$$$reportNull$$$0(90);
            }
            return collection;
        }
        if (meaningful instanceof JSInitializerOwner) {
            JSInitializerOwner initOwner = (JSInitializerOwner)meaningful;
            if (!isTypeScript) {
                JSExpression initializer = initOwner.getInitializerOrStub();
                if (initializer instanceof JSFunctionItem) {
                    Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)((Object)initializer));
                    if (collection == null) {
                        JSStubBasedPsiTreeUtil.$$$reportNull$$$0(91);
                    }
                    return collection;
                }
                if (initializer instanceof ES6Class) {
                    Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply(((ES6Class)((Object)initializer)).getConstructor());
                    if (collection == null) {
                        JSStubBasedPsiTreeUtil.$$$reportNull$$$0(92);
                    }
                    return collection;
                }
            }
        }
        if (meaningful instanceof JSVariable) {
            JSVariable jsVariable = (JSVariable)meaningful;
            if ((!isTypeScript || jsVariable.getTypeElement() == null) && (initializer = JSPsiImplUtils.getRightmostInitializer(jsVariable)) instanceof JSFunctionItem) {
                Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)((Object)initializer));
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(93);
                }
                return collection;
            }
            JSFunctionExpression constructsFunction = JSPsiImplUtils.findConstructsFunction(meaningful);
            if (constructsFunction != null) {
                Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply(constructsFunction);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(94);
                }
                return collection;
            }
            if (isTypeScript && !lightweightImprecise) {
                Collection<JSFunctionWithSubstitutor> collection = TypeScriptSignatureChooser.calculatePossibleFunctionForVariable(jsVariable, methodExpression, visited, includeRawSignatures);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(95);
                }
                return collection;
            }
        } else if (meaningful instanceof JSField) {
            JSField jsField = (JSField)meaningful;
            if (isTypeScript && !lightweightImprecise) {
                Collection<JSFunctionWithSubstitutor> collection = TypeScriptSignatureChooser.calculatePossibleFunctionForVariable(jsField, methodExpression, visited, includeRawSignatures);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(96);
                }
                return collection;
            }
        } else if (meaningful instanceof JSProperty) {
            JSProperty jsProperty = (JSProperty)meaningful;
            JSFunction value = jsProperty.tryGetFunctionInitializer();
            if (value != null) {
                Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply(value);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(97);
                }
                return collection;
            }
        } else if (meaningful instanceof JSDefinitionExpression) {
            JSDefinitionExpression jsDefinitionExpression = (JSDefinitionExpression)meaningful;
            initializer = jsDefinitionExpression.getInitializerOrStub();
            if (initializer instanceof JSFunctionItem) {
                Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSFunctionItem)((Object)initializer));
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(98);
                }
                return collection;
            }
            JSFunctionExpression constructsFunction = JSPsiImplUtils.findConstructsFunction(meaningful);
            if (constructsFunction != null) {
                Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply(constructsFunction);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(99);
                }
                return collection;
            }
        } else if (meaningful instanceof JSImplicitElement) {
            PsiElement parent = meaningful.getParent();
            if (parent instanceof JSLiteralExpressionImpl) {
                JSFunction function;
                JSProperty jSProperty;
                JSObjectLiteralExpression nextArgument = null;
                JSLiteralExpressionStub stub = (JSLiteralExpressionStub)((JSLiteralExpressionImpl)parent).getStub();
                if (stub != null) {
                    StubElement<?> stubElement = StubTreeUtil.getNextSibling(stub);
                    if (stubElement instanceof JSObjectLiteralExpressionStub) {
                        nextArgument = (JSObjectLiteralExpression)((JSObjectLiteralExpressionStub)stubElement).getPsi();
                    }
                } else {
                    JSExpression[] arguments;
                    PsiElement psiElement2 = parent.getParent();
                    if (psiElement2 instanceof JSArgumentList && (arguments = ((JSArgumentList)psiElement2).getArguments()).length == 2 && arguments[0] == parent && arguments[1] instanceof JSObjectLiteralExpression) {
                        nextArgument = (JSObjectLiteralExpression)arguments[1];
                    }
                }
                if (nextArgument != null && (jSProperty = nextArgument.findProperty("construct")) != null && (function = jSProperty.tryGetFunctionInitializer()) != null) {
                    Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply(function);
                    if (collection == null) {
                        JSStubBasedPsiTreeUtil.$$$reportNull$$$0(100);
                    }
                    return collection;
                }
            } else if (parent instanceof JSDocComment) {
                JSFunctionExpression constructsFunction;
                PsiElement associatedElement = JSStubBasedPsiTreeUtil.findAssociatedElement((JSDocComment)parent);
                JSFunctionExpression jSFunctionExpression = constructsFunction = associatedElement != null ? JSPsiImplUtils.findConstructsFunction(associatedElement) : null;
                if (constructsFunction != null) {
                    Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply(constructsFunction);
                    if (collection == null) {
                        JSStubBasedPsiTreeUtil.$$$reportNull$$$0(101);
                    }
                    return collection;
                }
            }
        } else if (meaningful instanceof TypeScriptClass) {
            TypeScriptClass tsClass = (TypeScriptClass)meaningful;
            if (methodExpression != null || includeRawSignatures) {
                Collection<JSFunctionWithSubstitutor> collection = TypeScriptUtil.resolveConstructorFunctions(tsClass, methodExpression);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(102);
                }
                return collection;
            }
        } else {
            if (meaningful instanceof ES6Class) {
                Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply(((ES6Class)meaningful).getConstructor());
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(103);
                }
                return collection;
            }
            if (meaningful instanceof TypeScriptImportStatement) {
                TypeScriptImportStatement importStatement = (TypeScriptImportStatement)meaningful;
                if (visited != null && visited.contains(meaningful)) {
                    List<JSFunctionWithSubstitutor> list = Collections.emptyList();
                    if (list == null) {
                        JSStubBasedPsiTreeUtil.$$$reportNull$$$0(104);
                    }
                    return list;
                }
                ArrayList<JSFunctionWithSubstitutor> result2 = new ArrayList<JSFunctionWithSubstitutor>();
                HashSet<PsiElement> visitedReferenced = visited != null ? visited : new HashSet<PsiElement>();
                visitedReferenced.add(meaningful);
                for (PsiElement psiElement3 : importStatement.findReferencedElements()) {
                    result2.addAll(JSStubBasedPsiTreeUtil.calculatePossibleFunctions(psiElement3, methodExpression, visitedReferenced, includeRawSignatures, lightweightImprecise));
                }
                ArrayList<JSFunctionWithSubstitutor> arrayList = result2;
                if (arrayList == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(105);
                }
                return arrayList;
            }
        }
        if (meaningful instanceof JSImplicitElementProvider && (data = (implicitProvider = (JSImplicitElementProvider)meaningful).getIndexingData()) != null && (implicitElements = data.getImplicitElements()) != null) {
            for (JSImplicitElement implicitElement : implicitElements) {
                if (!(implicitElement instanceof JSImplicitFunctionImpl)) continue;
                Collection<JSFunctionWithSubstitutor> collection = JSPsiImplUtils.TO_FUNCTIONS_COLLECTION_WITH_SUBSTITUTOR.apply((JSImplicitFunctionImpl)implicitElement);
                if (collection == null) {
                    JSStubBasedPsiTreeUtil.$$$reportNull$$$0(106);
                }
                return collection;
            }
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(107);
        }
        return list;
    }

    public static <Key, Psi extends PsiElement> boolean processElementsForFile(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, @NotNull Project project, @NotNull PsiFile scope2, @NotNull Class<Psi> requiredClass, @NotNull Processor<? super Psi> processor) {
        if (indexKey == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(108);
        }
        if (key == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(109);
        }
        if (project == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(110);
        }
        if (scope2 == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(111);
        }
        if (requiredClass == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(112);
        }
        if (processor == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(113);
        }
        return StubIndex.getInstance().processElements(indexKey, key, project, GlobalSearchScope.fileScope((PsiFile)scope2), requiredClass, processor);
    }

    @Nullable
    public static <T, E extends Throwable> T forceAllowTreeLoading(@Nullable PsiFile psiFile, @NotNull ThrowableComputable<? extends T, E> computable) throws E {
        if (computable == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(114);
        }
        if (psiFile == null) {
            return (T)computable.compute();
        }
        return (T)AstLoadingFilter.forceAllowTreeLoading((PsiFile)psiFile, computable);
    }

    @Nullable
    public static PsiElement getParentOrNull(@NotNull PsiElement element) {
        if (element == null) {
            JSStubBasedPsiTreeUtil.$$$reportNull$$$0(115);
        }
        if (!(element instanceof StubBasedPsiElementBase)) {
            return element.getParent();
        }
        StubElement stub = ((StubBasedPsiElementBase)element).getStub();
        if (stub == null) {
            return element.getParent();
        }
        if (!(stub instanceof ObjectStubBase) || ((ObjectStubBase)stub).isDangling()) {
            return null;
        }
        return element.getContext();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 15, 27, 41, 43, 51, 52, 53, 64, 65, 69, 70, 71, 72, 73, 76, 78, 79, 80, 85, 86, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 27: 
            case 41: 
            case 43: 
            case 51: 
            case 52: 
            case 53: 
            case 64: 
            case 65: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 85: 
            case 86: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil";
                break;
            }
            case 11: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: 
            case 14: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 13: 
            case 17: 
            case 20: 
            case 22: 
            case 24: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 44: 
            case 46: 
            case 49: 
            case 87: 
            case 88: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 26: 
            case 30: 
            case 33: 
            case 48: 
            case 58: 
            case 60: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElements";
                break;
            }
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 62: 
            case 66: 
            case 74: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 61: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopBefore";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allMeaningful";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiComment";
                break;
            }
            case 83: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrModule";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredClass";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSStubBasedPsiTreeUtil";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocallyWithMergedResults";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "buildStubBasedNamesMap";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "findDescendants";
                break;
            }
            case 41: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "findReturnedExpressions";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenByType";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "reduceToOneMeaningful";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateMeaningfulElements";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequireCallReferencedElement";
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveRequireCallReference";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredFileOrModuleChildrenStream";
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "calculatePossibleFunctions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocally";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocallyWithMergedResults";
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 27: 
            case 41: 
            case 43: 
            case 51: 
            case 52: 
            case 53: 
            case 64: 
            case 65: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 85: 
            case 86: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInScope";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasStub";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isStubBased";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildStubBasedNamesMap";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "extractNameIfAcceptable";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getContextOfType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceLocally";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findDescendants";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addDescendantsRecursively";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findDocComment";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findOwnDocComment";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findOwnDocCommentForStub";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getNextSibling";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getPrevSibling";
                break;
            }
            case 39: 
            case 40: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findReturnedExpressions";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiChild";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenByType";
                break;
            }
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "calculateMeaningfulElement";
                break;
            }
            case 55: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "calculateMeaningfulElements";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "reduceToOneMeaningful";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "calculateTargetElement";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "calculateTargetElementForHighlighting";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "resolveRequireCallReference";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "findRequireCallArgument";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "findAssociatedElement";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getFileOrModuleChildrenStream";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredFileOrModuleChildrenStream";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "calculatePossibleFunctions";
                break;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "processElementsForFile";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "forceAllowTreeLoading";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "getParentOrNull";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "lambda$static$0";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 15, 27, 41, 43, 51, 52, 53, 64, 65, 69, 70, 71, 72, 73, 76, 78, 79, 80, 85, 86, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107 -> new IllegalStateException(string);
        };
    }
}

