/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.linter.LinterLanguageServiceClient;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceExecutor;
import com.intellij.lang.javascript.service.JSLanguageServiceInfoReporter;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceService;
import com.intellij.lang.javascript.service.JSLanguageServiceTracerUtilKt;
import com.intellij.lang.javascript.service.JSLanguageServiceUsagesCollector;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.util.ThreeState;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000 X2\u00020\u00012\u00020\u0002:\u0001XB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u00101\u001a\u000202H\u0014J\n\u00103\u001a\u0004\u0018\u00010*H\u0014J\u0010\u00104\u001a\u0004\u0018\u00010*H\u0094@\u00a2\u0006\u0002\u00105J\u000e\u00106\u001a\u000202H\u0082@\u00a2\u0006\u0002\u00105J\u0016\u00107\u001a\u0002082\u0006\u00109\u001a\u00020*H\u0094@\u00a2\u0006\u0002\u0010:J\u0010\u0010<\u001a\u0004\u0018\u00010*H\u0084@\u00a2\u0006\u0002\u00105J\u0010\u0010>\u001a\u0004\u0018\u00010*H\u0082@\u00a2\u0006\u0002\u00105J\b\u0010A\u001a\u000202H\u0014J\u000e\u0010B\u001a\u000202H\u0094@\u00a2\u0006\u0002\u00105J \u0010C\u001a\u0002022\u0006\u0010;\u001a\u00020*2\u000e\u0010D\u001a\n\u0018\u00010Ej\u0004\u0018\u0001`FH\u0002J\b\u0010G\u001a\u000208H\u0016J0\u0010H\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001HJ\u0018\u00010I\"\b\b\u0000\u0010J*\u00020K2\u0006\u0010L\u001a\u00020M2\f\u0010N\u001a\b\u0012\u0004\u0012\u0002HJ0OJ\u0018\u0010H\u001a\u0004\u0018\u00010P2\u0006\u0010L\u001a\u00020MH\u0096@\u00a2\u0006\u0002\u0010QJ\b\u0010R\u001a\u00020%H\u0014J\u0010\u0010S\u001a\u0002022\u0006\u0010&\u001a\u00020%H\u0007J\b\u0010T\u001a\u000208H\u0016J\n\u0010U\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010V\u001a\u000202H\u0014J\b\u0010W\u001a\u000202H\u0016R\u0010\u0010\u0007\u001a\u00020\u00048\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0018\u0010 \u001a\u0004\u0018\u00010!8\u0004X\u0085\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\"\u0010#R\u0012\u0010$\u001a\u00020%8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010&\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\u00020.X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0016\u0010;\u001a\u0004\u0018\u00010*8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0013\u0010?\u001a\u0004\u0018\u00010*8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010=\u00a8\u0006Y"}, d2={"Lcom/intellij/lang/javascript/service/JSLanguageServiceBase;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/lang/javascript/linter/LinterLanguageServiceClient;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myProject", "getProject", "()Lcom/intellij/openapi/project/Project;", "myFailCount", "Ljava/util/concurrent/atomic/AtomicLong;", "getMyFailCount", "()Ljava/util/concurrent/atomic/AtomicLong;", "debugName", "", "getDebugName", "()Ljava/lang/String;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "getCs", "()Lkotlinx/coroutines/CoroutineScope;", "myLifecycleSpan", "Lio/opentelemetry/api/trace/Span;", "getMyLifecycleSpan", "()Lio/opentelemetry/api/trace/Span;", "canStartProcessState", "Lcom/intellij/util/ThreeState;", "getCanStartProcessState", "()Lcom/intellij/util/ThreeState;", "setCanStartProcessState", "(Lcom/intellij/util/ThreeState;)V", "myProcessConnector", "Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue$ProcessConnector;", "getMyProcessConnector$annotations", "()V", "myDefaultReporter", "Lcom/intellij/lang/javascript/service/JSLanguageServiceInfoReporter;", "defaultReporter", "getDefaultReporter", "()Lcom/intellij/lang/javascript/service/JSLanguageServiceInfoReporter;", "myProcess", "Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue;", "myProcessInit", "Lkotlinx/coroutines/sync/Mutex;", "initializeOnceCalled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getInitializeOnceCalled", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "initializeOnce", "", "createLanguageServiceQueueBlocking", "createLanguageServiceQueue", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkAlive", "checkServiceQueueAlive", "", "serviceQueue", "(Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "process", "getProcess", "()Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue;", "computeProcessUnderLocks", "processIfCreated", "getProcessIfCreated", "restart", "terminateStartedProcessUnderLock", "disposeProcessSyncOrAsync", "onDisposed", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "checkCanUseService", "sendCommand", "Ljava/util/concurrent/CompletableFuture;", "T", "", "command", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceSimpleCommand;", "processor", "Lcom/intellij/lang/javascript/service/JSLanguageServiceCommandProcessor;", "Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue$CommandResult;", "(Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceSimpleCommand;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createDefaultReporter", "setDefaultReporter", "isServiceCreated", "getServiceCreationError", "resetState", "dispose", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSLanguageServiceBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSLanguageServiceBase.kt\ncom/intellij/lang/javascript/service/JSLanguageServiceBase\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Runnable.kt\nkotlinx/coroutines/RunnableKt\n*L\n1#1,296:1\n31#2,2:297\n116#3,10:299\n1#4:309\n13#5:310\n*S KotlinDebug\n*F\n+ 1 JSLanguageServiceBase.kt\ncom/intellij/lang/javascript/service/JSLanguageServiceBase\n*L\n49#1:297,2\n96#1:299,10\n206#1:310\n*E\n"})
public abstract class JSLanguageServiceBase
implements Disposable,
LinterLanguageServiceClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    protected final Project myProject;
    @NotNull
    private final AtomicLong myFailCount;
    @NotNull
    private final String debugName;
    @NotNull
    private final CoroutineScope cs;
    @Nullable
    private final Span myLifecycleSpan;
    @NotNull
    private volatile ThreeState canStartProcessState;
    @JvmField
    @Nullable
    protected final JSLanguageServiceQueue.ProcessConnector myProcessConnector;
    @JvmField
    @NotNull
    protected volatile JSLanguageServiceInfoReporter myDefaultReporter;
    @Nullable
    private volatile JSLanguageServiceQueue myProcess;
    @NotNull
    private final Mutex myProcessInit;
    @NotNull
    private final AtomicBoolean initializeOnceCalled;
    private static final long ALIVE_CHECK_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    public static final int ALIVE_CHECK_COUNT_LIMIT = 5;

    public JSLanguageServiceBase(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.myProject = project;
        this.myFailCount = new AtomicLong();
        String string = StringUtil.trimEnd((String)StringUtil.trimEnd((String)this.getClass().getSimpleName(), (String)"Service", (boolean)true), (String)"Language", (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimEnd(...)");
        this.debugName = string;
        ComponentManager $this$service$iv = (ComponentManager)this.myProject;
        boolean $i$f$service = false;
        Class<JSLanguageServiceService> serviceClass$iv = JSLanguageServiceService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.cs = CoroutineScopeKt.childScope$default((CoroutineScope)((JSLanguageServiceService)object).getCs(), (String)("Scope for " + this.debugName), null, (boolean)true, (int)2, null);
        this.myLifecycleSpan = JSLanguageServiceTracerUtilKt.createServerLifecycleSpanIfNeeded(this.getClass(), "Language Service Lifecycle");
        this.canStartProcessState = ThreeState.UNSURE;
        this.myDefaultReporter = this.createDefaultReporter();
        this.myProcessInit = MutexKt.Mutex((boolean)false);
        this.initializeOnceCalled = new AtomicBoolean(false);
    }

    @NotNull
    public final Project getProject() {
        return this.myProject;
    }

    @NotNull
    protected final AtomicLong getMyFailCount() {
        return this.myFailCount;
    }

    @NotNull
    protected final String getDebugName() {
        return this.debugName;
    }

    @NotNull
    protected final CoroutineScope getCs() {
        return this.cs;
    }

    @Nullable
    protected final Span getMyLifecycleSpan() {
        return this.myLifecycleSpan;
    }

    @NotNull
    public final ThreeState getCanStartProcessState() {
        return this.canStartProcessState;
    }

    public final void setCanStartProcessState(@NotNull ThreeState threeState) {
        Intrinsics.checkNotNullParameter((Object)threeState, (String)"<set-?>");
        this.canStartProcessState = threeState;
    }

    @Deprecated(message="API is not supported anymore")
    protected static /* synthetic */ void getMyProcessConnector$annotations() {
    }

    @NotNull
    public final JSLanguageServiceInfoReporter getDefaultReporter() {
        return this.myDefaultReporter;
    }

    @NotNull
    protected final AtomicBoolean getInitializeOnceCalled() {
        return this.initializeOnceCalled;
    }

    protected void initializeOnce() {
        JSLanguageServiceQueue.Holder.LOGGER.debug("Run initialize once");
        JSLanguageServiceUsagesCollector.triggerServiceFirstStart(this.myProject, this.getClass());
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ JSLanguageServiceBase this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
lbl6:
                        // 3 sources

                        while (kotlinx.coroutines.CoroutineScopeKt.isActive((CoroutineScope)$this$launch) && !this.this$0.getProject().isDisposed()) {
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = JSLanguageServiceBase.access$checkAlive(this.this$0, (Continuation)this);
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl18
                        }
                        break;
                    }
                    case 1: {
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        this.L$0 = $this$launch;
                        this.label = 2;
                        v1 = DelayKt.delay((long)JSLanguageServiceBase.Companion.getALIVE_CHECK_TIMEOUT(), (Continuation)((Continuation)this));
                        if (v1 != var3_2) ** GOTO lbl6
                        return var3_2;
                    }
                    case 2: {
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
                        ** GOTO lbl6
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    protected JSLanguageServiceQueue createLanguageServiceQueueBlocking() {
        throw new IllegalStateException("Implement createLanguageServiceQueue or createLanguageServiceQueueSuspending");
    }

    @Nullable
    protected Object createLanguageServiceQueue(@NotNull Continuation<? super JSLanguageServiceQueue> $completion) {
        return this.createLanguageServiceQueueBlocking();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object checkAlive(Continuation<? super Unit> $completion) {
        if (!($completion instanceof checkAlive.1)) ** GOTO lbl-1000
        var9_2 = $completion;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ JSLanguageServiceBase this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return JSLanguageServiceBase.access$checkAlive(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                JSLanguageServiceQueue.Holder.LOGGER.trace("Check alive is called");
                if (this.myProcess == null) ** GOTO lbl65
                $this$withLock_u24default$iv = this.myProcessInit;
                owner$iv = null;
                $i$f$withLock = false;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var10_4) {
                    return var10_4;
                }
                ** GOTO lbl33
            }
            case 1: {
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                this = (JSLanguageServiceBase)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 3 sources

                $i$a$-withLock$default-JSLanguageServiceBase$checkAlive$2 = false;
                process = this.myProcess;
                if (process == null) ** GOTO lbl58
                $continuation.L$0 = this;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.label = 2;
                v1 = this.checkServiceQueueAlive(process, (Continuation<? super Boolean>)$continuation);
                ** if (v1 != var10_4) goto lbl43
lbl42:
                // 1 sources

                return var10_4;
lbl43:
                // 1 sources

                ** GOTO lbl54
            }
            case 2: {
                $i$f$withLock = false;
                $i$a$-withLock$default-JSLanguageServiceBase$checkAlive$2 = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                this = (JSLanguageServiceBase)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl54:
                    // 2 sources

                    if (!((Boolean)v1).booleanValue()) {
                        BuildersKt.launch$default((CoroutineScope)this.cs, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                            Object L$0;
                            Object L$1;
                            int label;
                            final /* synthetic */ JSLanguageServiceBase this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object var1_1) {
                                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        JSLanguageServiceQueue.Holder.LOGGER.debug("Dispose by alive checker");
                                        var2_3 = JSLanguageServiceBase.access$getMyProcessInit$p(this.this$0);
                                        var4_4 = this.this$0;
                                        owner$iv = null;
                                        $i$f$withLock = false;
                                        this.L$0 = $this$withLock_u24default$iv;
                                        this.L$1 = var4_4;
                                        this.label = 1;
                                        v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                                        if (v0 == var8_2) {
                                            return var8_2;
                                        }
                                        ** GOTO lbl26
                                    }
                                    case 1: {
                                        $i$f$withLock = false;
                                        var4_4 = (JSLanguageServiceBase)this.L$1;
                                        owner$iv = null;
                                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl26:
                                        // 3 sources

                                        $i$a$-withLock$default-JSLanguageServiceBase$checkAlive$2$1$1 = false;
                                        this.L$0 = $this$withLock_u24default$iv;
                                        this.L$1 = null;
                                        this.label = 2;
                                        v1 = var4_4.terminateStartedProcessUnderLock((Continuation<? super Unit>)this);
                                        ** if (v1 != var8_2) goto lbl34
lbl33:
                                        // 1 sources

                                        return var8_2;
lbl34:
                                        // 1 sources

                                        ** GOTO lbl44
                                    }
                                    case 2: {
                                        $i$f$withLock = false;
                                        $i$a$-withLock$default-JSLanguageServiceBase$checkAlive$2$1$1 = false;
                                        owner$iv = null;
                                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
lbl44:
                                            // 2 sources

                                            var7_12 = Unit.INSTANCE;
                                        }
                                        catch (Throwable var6_11) {
                                            throw var6_11;
                                        }
                                        finally {
                                            $this$withLock_u24default$iv.unlock(owner$iv);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                    }
lbl58:
                    // 4 sources

                    var7_14 = Unit.INSTANCE;
                }
                catch (Throwable var5_12) {
                    throw var5_12;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
lbl65:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    protected Object checkServiceQueueAlive(@NotNull JSLanguageServiceQueue serviceQueue, @NotNull Continuation<? super Boolean> $completion) {
        return JSLanguageServiceBase.checkServiceQueueAlive$suspendImpl(this, serviceQueue, $completion);
    }

    static /* synthetic */ Object checkServiceQueueAlive$suspendImpl(JSLanguageServiceBase $this, JSLanguageServiceQueue serviceQueue, Continuation<? super Boolean> $completion) {
        JSLanguageServiceQueue.Holder.LOGGER.trace("Check alive process queue " + serviceQueue.hashCode());
        JSLanguageServiceExecutor.State state = serviceQueue.getState();
        if (!serviceQueue.isValid()) {
            $this.myFailCount.incrementAndGet();
            return Boxing.boxBoolean((boolean)false);
        }
        if (state == JSLanguageServiceExecutor.State.STARTED) {
            $this.myFailCount.set(0L);
        }
        return Boxing.boxBoolean((boolean)true);
    }

    @Nullable
    protected JSLanguageServiceQueue getProcess() {
        JSLanguageServiceQueue jSLanguageServiceQueue = this.myProcess;
        if (jSLanguageServiceQueue != null) {
            JSLanguageServiceQueue it = jSLanguageServiceQueue;
            boolean bl = false;
            return it;
        }
        return (JSLanguageServiceQueue)JSLanguageServiceTracerUtilKt.withServiceTraceSpan$default(this, "getProcess", null, () -> JSLanguageServiceBase._get_process_$lambda$2(this), 2, null);
    }

    @Nullable
    protected final Object getProcess(@NotNull Continuation<? super JSLanguageServiceQueue> $completion) {
        JSLanguageServiceQueue jSLanguageServiceQueue = this.myProcess;
        if (jSLanguageServiceQueue != null) {
            JSLanguageServiceQueue it = jSLanguageServiceQueue;
            boolean bl = false;
            return it;
        }
        return TimeoutKt.withTimeout((long)JSLanguageServiceUtil.getTimeout(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super JSLanguageServiceQueue>, Object>(this, null){
            int label;
            final /* synthetic */ JSLanguageServiceBase this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Deferred deferred2 = BuildersKt.async$default((CoroutineScope)this.this$0.getCs(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super JSLanguageServiceQueue>, Object>(this.this$0, null){
                            Object L$0;
                            Object L$1;
                            int label;
                            final /* synthetic */ JSLanguageServiceBase this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object var1_1) {
                                var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        var2_3 = JSLanguageServiceBase.access$getMyProcessInit$p(this.this$0);
                                        var4_4 = this.this$0;
                                        owner$iv = null;
                                        $i$f$withLock = false;
                                        this.L$0 = $this$withLock_u24default$iv;
                                        this.L$1 = var4_4;
                                        this.label = 1;
                                        v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                                        if (v0 == var12_2) {
                                            return var12_2;
                                        }
                                        ** GOTO lbl25
                                    }
                                    case 1: {
                                        $i$f$withLock = false;
                                        var4_4 = (JSLanguageServiceBase)this.L$1;
                                        owner$iv = null;
                                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl25:
                                        // 3 sources

                                        $i$a$-withLock$default-JSLanguageServiceBase$getProcess$3$deferred$1$1 = false;
                                        v1 = JSLanguageServiceBase.access$getMyProcess$p(var4_4);
                                        if (v1 == null) ** GOTO lbl35
                                        it = v1;
                                        $i$a$-let-JSLanguageServiceBase$getProcess$3$deferred$1$1$1 = false;
                                        var11_13 = it;
                                        $this$withLock_u24default$iv.unlock(owner$iv);
                                        return var11_13;
lbl35:
                                        // 2 sources

                                        this.L$0 = $this$withLock_u24default$iv;
                                        this.L$1 = var4_4;
                                        this.label = 2;
                                        v2 = JSLanguageServiceBase.access$computeProcessUnderLocks(var4_4, (Continuation)this);
                                        ** if (v2 != var12_2) goto lbl41
lbl40:
                                        // 1 sources

                                        return var12_2;
lbl41:
                                        // 1 sources

                                        ** GOTO lbl52
                                    }
                                    case 2: {
                                        $i$a$-withLock$default-JSLanguageServiceBase$getProcess$3$deferred$1$1 = false;
                                        $i$f$withLock = false;
                                        var4_4 = (JSLanguageServiceBase)this.L$1;
                                        owner$iv = null;
                                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v2 = $result;
lbl52:
                                            // 2 sources

                                            newProcess = (JSLanguageServiceQueue)v2;
                                            JSLanguageServiceBase.access$setMyProcess$p(var4_4, newProcess);
                                            var10_15 = newProcess;
                                        }
                                        catch (Throwable var6_10) {
                                            throw var6_10;
                                        }
                                        finally {
                                            $this$withLock_u24default$iv.unlock(owner$iv);
                                        }
                                        return var10_15;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super JSLanguageServiceQueue> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        this.label = 1;
                        Object object3 = deferred2.await((Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super JSLanguageServiceQueue> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object computeProcessUnderLocks(Continuation<? super JSLanguageServiceQueue> $completion) {
        if (!($completion instanceof computeProcessUnderLocks.1)) ** GOTO lbl-1000
        var8_2 = $completion;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ JSLanguageServiceBase this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return JSLanguageServiceBase.access$computeProcessUnderLocks(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                JSLanguageServiceQueue.Holder.LOGGER.debug("Run compute process under locks");
                if (this.myProject.isDisposed()) {
                    JSLanguageServiceQueue.Holder.LOGGER.debug("Project is disposed - stopping language service queue creation");
                    return null;
                }
                if (this.initializeOnceCalled.compareAndSet(false, true)) {
                    this.initializeOnce();
                }
                v0 = this.myLifecycleSpan;
                spanOrNull = v0 != null ? v0.makeCurrent() : null;
                var3_6 = (AutoCloseable)spanOrNull;
                var4_7 = null;
                (Scope)var3_6;
                $i$a$-use-JSLanguageServiceBase$computeProcessUnderLocks$2 = false;
                $continuation.L$0 = var3_6;
                $continuation.label = 1;
                v1 = this.createLanguageServiceQueue((Continuation<? super JSLanguageServiceQueue>)$continuation);
                ** if (v1 != var9_4) goto lbl32
lbl31:
                // 1 sources

                return var9_4;
lbl32:
                // 1 sources

                ** GOTO lbl41
            }
            case 1: {
                $i$a$-use-JSLanguageServiceBase$computeProcessUnderLocks$2 = false;
                var4_7 = null;
                var3_6 = (AutoCloseable)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl41:
                    // 2 sources

                    var5_12 = (JSLanguageServiceQueue)v1;
                    ** GOTO lbl51
                }
                catch (Throwable var6_10) {
                    var4_7 = var6_10;
                    throw var6_10;
                }
            }
            catch (Throwable var6_11) {
                throw var6_11;
            }
            {
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)var3_6, (Throwable)var4_7);
                }
lbl51:
                // 1 sources

                return var5_12;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final JSLanguageServiceQueue getProcessIfCreated() {
        return this.myProcess;
    }

    protected void restart() {
        this.resetState();
        BuildersKt.launch$default((CoroutineScope)this.cs, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ JSLanguageServiceBase this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = JSLanguageServiceBase.access$getMyProcessInit$p(this.this$0);
                        var4_4 = this.this$0;
                        owner$iv = null;
                        $i$f$withLock = false;
                        this.L$0 = $this$withLock_u24default$iv;
                        this.L$1 = var4_4;
                        this.label = 1;
                        v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                        if (v0 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl25
                    }
                    case 1: {
                        $i$f$withLock = false;
                        var4_4 = (JSLanguageServiceBase)this.L$1;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl25:
                        // 3 sources

                        $i$a$-withLock$default-JSLanguageServiceBase$restart$1$1 = false;
                        this.L$0 = $this$withLock_u24default$iv;
                        this.L$1 = null;
                        this.label = 2;
                        v1 = var4_4.terminateStartedProcessUnderLock((Continuation<? super Unit>)this);
                        ** if (v1 != var8_2) goto lbl33
lbl32:
                        // 1 sources

                        return var8_2;
lbl33:
                        // 1 sources

                        ** GOTO lbl43
                    }
                    case 2: {
                        $i$f$withLock = false;
                        $i$a$-withLock$default-JSLanguageServiceBase$restart$1$1 = false;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl43:
                            // 2 sources

                            var7_12 = Unit.INSTANCE;
                        }
                        catch (Throwable var6_11) {
                            throw var6_11;
                        }
                        finally {
                            $this$withLock_u24default$iv.unlock(owner$iv);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @Nullable
    protected Object terminateStartedProcessUnderLock(@NotNull Continuation<? super Unit> $completion) {
        return JSLanguageServiceBase.terminateStartedProcessUnderLock$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object terminateStartedProcessUnderLock$suspendImpl(JSLanguageServiceBase $this, Continuation<? super Unit> $completion) {
        JSLanguageServiceQueue process2 = $this.getProcessIfCreated();
        if (process2 != null) {
            if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
                String string = "Dispose queue %s with hashCode %s by terminateStartedProcess call.";
                Object[] objectArray = new Object[]{$this.debugName, Boxing.boxInt((int)process2.hashCode())};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                String message = string2;
                JSLanguageServiceQueue.Holder.LOGGER.debug(message, new Throwable());
            }
            $this.myProcess = null;
            $this.canStartProcessState = ThreeState.UNSURE;
            $this.disposeProcessSyncOrAsync(process2, () -> JSLanguageServiceBase.terminateStartedProcessUnderLock$lambda$5($this));
        }
        return Unit.INSTANCE;
    }

    private final void disposeProcessSyncOrAsync(JSLanguageServiceQueue process2, Runnable onDisposed) {
        boolean $i$f$Runnable = false;
        Runnable disposeAction = new Runnable(process2, onDisposed){
            final /* synthetic */ JSLanguageServiceQueue $process$inlined;
            final /* synthetic */ Runnable $onDisposed$inlined;
            {
                this.$process$inlined = jSLanguageServiceQueue;
                this.$onDisposed$inlined = runnable;
            }

            public final void run() {
                boolean bl = false;
                Disposer.dispose((Disposable)this.$process$inlined);
                if (this.$onDisposed$inlined != null) {
                    this.$onDisposed$inlined.run();
                }
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            disposeAction.run();
        } else {
            Future future = ApplicationManager.getApplication().executeOnPooledThread(disposeAction);
            Intrinsics.checkNotNull((Object)future);
        }
    }

    public boolean checkCanUseService() {
        return this.canStartProcessState != ThreeState.NO && this.myFailCount.get() < 5L;
    }

    @Nullable
    public final <T> CompletableFuture<T> sendCommand(@NotNull JSLanguageServiceSimpleCommand command, @NotNull JSLanguageServiceCommandProcessor<T> processor) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        JSLanguageServiceQueue jSLanguageServiceQueue = this.getProcess();
        return jSLanguageServiceQueue != null ? jSLanguageServiceQueue.execute(command, processor) : null;
    }

    @Nullable
    public Object sendCommand(@NotNull JSLanguageServiceSimpleCommand command, @NotNull Continuation<? super JSLanguageServiceQueue.CommandResult> $completion) {
        return JSLanguageServiceBase.sendCommand$suspendImpl(this, command, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object sendCommand$suspendImpl(JSLanguageServiceBase var0, JSLanguageServiceSimpleCommand var1_1, Continuation<? super JSLanguageServiceQueue.CommandResult> $completion) {
        if (!($completion instanceof sendCommand.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ JSLanguageServiceBase this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return JSLanguageServiceBase.sendCommand$suspendImpl(this.this$0, null, (Continuation<? super JSLanguageServiceQueue.CommandResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = command;
                $continuation.label = 1;
                v0 = $this.getProcess((Continuation<? super JSLanguageServiceQueue>)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                command = (JSLanguageServiceSimpleCommand)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                v1 = (JSLanguageServiceQueue)v0;
                if (v1 == null) break;
                $continuation.L$0 = null;
                $continuation.label = 2;
                v2 = JSLanguageServiceQueue.execute$default(v1, command, null, (Continuation)$continuation, 2, null);
                if (v2 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl33
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl33:
                // 2 sources

                return v2;
            }
        }
        return null;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    protected JSLanguageServiceInfoReporter createDefaultReporter() {
        String serviceDebugName = this.debugName;
        return new JSLanguageServiceInfoReporter(serviceDebugName){
            final /* synthetic */ String $serviceDebugName;
            {
                this.$serviceDebugName = $serviceDebugName;
            }

            public void logCurrentErrors(VirtualFile virtualFile, List<? extends JSAnnotationError> results) {
                Intrinsics.checkNotNullParameter(results, (String)"results");
            }

            public String getPresentableServiceName() {
                return this.$serviceDebugName;
            }

            public void startingError(String errorText) {
                Intrinsics.checkNotNullParameter((Object)errorText, (String)"errorText");
            }

            public void setProcess(String text) {
            }
        };
    }

    @TestOnly
    public final void setDefaultReporter(@NotNull JSLanguageServiceInfoReporter defaultReporter) {
        Intrinsics.checkNotNullParameter((Object)defaultReporter, (String)"defaultReporter");
        this.myDefaultReporter = defaultReporter;
    }

    @Override
    public boolean isServiceCreated() {
        return this.getProcessIfCreated() != null;
    }

    @Override
    @Nullable
    public String getServiceCreationError() {
        JSLanguageServiceQueue jSLanguageServiceQueue = this.getProcessIfCreated();
        return jSLanguageServiceQueue != null ? jSLanguageServiceQueue.getStartErrorMessage() : null;
    }

    protected void resetState() {
        this.myFailCount.set(0L);
        this.canStartProcessState = ThreeState.UNSURE;
    }

    public void dispose() {
        block1: {
            kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.cs, (String)"Language service is disposed", null, (int)2, null);
            JSLanguageServiceQueue process2 = this.getProcessIfCreated();
            if (process2 != null) {
                this.disposeProcessSyncOrAsync(process2, null);
            }
            Span span = this.myLifecycleSpan;
            if (span == null) break block1;
            span.end();
        }
    }

    private static final JSLanguageServiceQueue _get_process_$lambda$2(JSLanguageServiceBase this$0) {
        return (JSLanguageServiceQueue)com.intellij.openapi.progress.CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super JSLanguageServiceQueue>, Object>(this$0, null){
            int label;
            final /* synthetic */ JSLanguageServiceBase this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.getProcess((Continuation<? super JSLanguageServiceQueue>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super JSLanguageServiceQueue> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final void terminateStartedProcessUnderLock$lambda$5(JSLanguageServiceBase this$0) {
        if (!this$0.myProject.isDisposed()) {
            DaemonCodeAnalyzer.getInstance((Project)this$0.myProject).restart();
        }
    }

    public static final /* synthetic */ Object access$checkAlive(JSLanguageServiceBase $this, Continuation $completion) {
        return $this.checkAlive((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Mutex access$getMyProcessInit$p(JSLanguageServiceBase $this) {
        return $this.myProcessInit;
    }

    public static final /* synthetic */ JSLanguageServiceQueue access$getMyProcess$p(JSLanguageServiceBase $this) {
        return $this.myProcess;
    }

    public static final /* synthetic */ Object access$computeProcessUnderLocks(JSLanguageServiceBase $this, Continuation $completion) {
        return $this.computeProcessUnderLocks((Continuation<? super JSLanguageServiceQueue>)$completion);
    }

    public static final /* synthetic */ void access$setMyProcess$p(JSLanguageServiceBase $this, JSLanguageServiceQueue jSLanguageServiceQueue) {
        $this.myProcess = jSLanguageServiceQueue;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/lang/javascript/service/JSLanguageServiceBase$Companion;", "", "<init>", "()V", "ALIVE_CHECK_TIMEOUT", "", "getALIVE_CHECK_TIMEOUT", "()J", "ALIVE_CHECK_COUNT_LIMIT", "", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final long getALIVE_CHECK_TIMEOUT() {
            return ALIVE_CHECK_TIMEOUT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

