/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.description.Description;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.cell.JTreeCellReader;
import org.assertj.swing.core.MouseButton;
import org.assertj.swing.core.MouseClickInfo;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.ComponentPreconditions;
import org.assertj.swing.driver.JComponentDriver;
import org.assertj.swing.driver.JTreeChildrenShowUpCondition;
import org.assertj.swing.driver.JTreeClearSelectionTask;
import org.assertj.swing.driver.JTreeEditableQuery;
import org.assertj.swing.driver.JTreeExpandPathTask;
import org.assertj.swing.driver.JTreeLocation;
import org.assertj.swing.driver.JTreeMatchingPathQuery;
import org.assertj.swing.driver.JTreeNodeTextQuery;
import org.assertj.swing.driver.JTreePathFinder;
import org.assertj.swing.driver.JTreeToggleExpandStateTask;
import org.assertj.swing.driver.JTreeVerifySelectionTask;
import org.assertj.swing.driver.MultipleSelectionTemplate;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.edt.GuiQuery;
import org.assertj.swing.exception.ActionFailedException;
import org.assertj.swing.exception.LocationUnavailableException;
import org.assertj.swing.exception.WaitTimedOutError;
import org.assertj.swing.internal.annotation.InternalApi;
import org.assertj.swing.timing.Condition;
import org.assertj.swing.timing.Pause;
import org.assertj.swing.util.ArrayPreconditions;
import org.assertj.swing.util.Pair;
import org.assertj.swing.util.Platform;
import org.assertj.swing.util.Triple;

@InternalApi
public class JTreeDriver
extends JComponentDriver {
    private static final String EDITABLE_PROPERTY = "editable";
    private static final String SELECTION_PROPERTY = "selection";
    private final JTreeLocation location = new JTreeLocation();
    private final JTreePathFinder pathFinder = new JTreePathFinder();

    public JTreeDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void clickRow(@Nonnull JTree tree, int row) {
        Point p = this.scrollToRow(tree, row);
        this.robot.click((Component)tree, p);
    }

    @RunsInEDT
    public void clickRow(@Nonnull JTree tree, int row, @Nonnull MouseButton button2) {
        Preconditions.checkNotNull((Object)((Object)button2));
        this.clickRow(tree, row, button2, 1);
    }

    @RunsInEDT
    public void clickRow(@Nonnull JTree tree, int row, @Nonnull MouseClickInfo mouseClickInfo) {
        Preconditions.checkNotNull((Object)mouseClickInfo);
        this.clickRow(tree, row, mouseClickInfo.button(), mouseClickInfo.times());
    }

    @RunsInEDT
    private void clickRow(@Nonnull JTree tree, int row, @Nonnull MouseButton button2, int times) {
        Point p = this.scrollToRow(tree, row);
        this.robot.click(tree, p, button2, times);
    }

    @RunsInEDT
    public void doubleClickRow(@Nonnull JTree tree, int row) {
        Point p = this.scrollToRow(tree, row);
        this.doubleClick(tree, p);
    }

    @RunsInEDT
    public void rightClickRow(@Nonnull JTree tree, int row) {
        Point p = this.scrollToRow(tree, row);
        this.rightClick(tree, p);
    }

    @Nonnull
    @RunsInEDT
    private Point scrollToRow(@Nonnull JTree tree, int row) {
        Point p = (Point)JTreeDriver.scrollToRow((JTree)tree, (int)row, (JTreeLocation)this.location(), (boolean)false).second;
        this.robot.waitForIdle();
        return (Point)Preconditions.checkNotNull((Object)p);
    }

    @RunsInEDT
    public void clickPath(@Nonnull JTree tree, @Nonnull String path) {
        Point p = this.scrollToPath(tree, path);
        this.robot.click((Component)tree, p);
    }

    @RunsInEDT
    public void clickPath(@Nonnull JTree tree, @Nonnull String path, @Nonnull MouseButton button2) {
        Preconditions.checkNotNull((Object)((Object)button2));
        this.clickPath(tree, path, button2, 1);
    }

    @RunsInEDT
    public void clickPath(@Nonnull JTree tree, @Nonnull String path, @Nonnull MouseClickInfo mouseClickInfo) {
        Preconditions.checkNotNull((Object)mouseClickInfo);
        this.clickPath(tree, path, mouseClickInfo.button(), mouseClickInfo.times());
    }

    private void clickPath(@Nonnull JTree tree, @Nonnull String path, @Nonnull MouseButton button2, int times) {
        Point p = this.scrollToPath(tree, path);
        this.robot.click(tree, p, button2, times);
    }

    @RunsInEDT
    public void doubleClickPath(@Nonnull JTree tree, @Nonnull String path) {
        Point p = this.scrollToPath(tree, path);
        this.doubleClick(tree, p);
    }

    @Nonnull
    private Point scrollToPath(@Nonnull JTree tree, @Nonnull String path) {
        Point p = (Point)this.scrollToMatchingPath((JTree)tree, (String)path, (boolean)false).third;
        this.robot.waitForIdle();
        return (Point)Preconditions.checkNotNull((Object)p);
    }

    private void doubleClick(@Nonnull JTree tree, @Nonnull Point p) {
        this.robot.click(tree, p, MouseButton.LEFT_BUTTON, 2);
    }

    @RunsInEDT
    public void rightClickPath(@Nonnull JTree tree, @Nonnull String path) {
        Point p = this.scrollToPath(tree, path);
        this.rightClick(tree, p);
    }

    private void rightClick(@Nonnull JTree tree, @Nonnull Point p) {
        this.robot.click(tree, p, MouseButton.RIGHT_BUTTON, 1);
    }

    @RunsInEDT
    public void expandRow(@Nonnull JTree tree, int row) {
        Triple<Boolean, Point, Integer> info = JTreeDriver.scrollToRowAndGetToggleInfo(tree, row, this.location());
        this.robot.waitForIdle();
        if (((Boolean)info.first).booleanValue()) {
            return;
        }
        this.toggleCell(tree, (Point)Preconditions.checkNotNull((Object)info.second), (Integer)info.third);
    }

    @RunsInEDT
    public void collapseRow(@Nonnull JTree tree, int row) {
        Triple<Boolean, Point, Integer> info = JTreeDriver.scrollToRowAndGetToggleInfo(tree, row, this.location());
        this.robot.waitForIdle();
        if (!((Boolean)info.first).booleanValue()) {
            return;
        }
        this.toggleCell(tree, (Point)Preconditions.checkNotNull((Object)info.second), (Integer)info.third);
    }

    @RunsInEDT
    public void toggleRow(@Nonnull JTree tree, int row) {
        Triple<Boolean, Point, Integer> info = JTreeDriver.scrollToRowAndGetToggleInfo(tree, row, this.location());
        this.robot.waitForIdle();
        this.toggleCell(tree, (Point)Preconditions.checkNotNull((Object)info.second), (Integer)info.third);
    }

    @Nonnull
    @RunsInEDT
    private static Triple<Boolean, Point, Integer> scrollToRowAndGetToggleInfo(final @Nonnull JTree tree, final int row, final @Nonnull JTreeLocation location) {
        Triple<Boolean, Point, Integer> result = GuiActionRunner.execute(new GuiQuery<Triple<Boolean, Point, Integer>>(){

            @Override
            protected Triple<Boolean, Point, Integer> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(tree);
                Point p = JTreeDriver.scrollToVisible(tree, row, location);
                return Triple.of(tree.isExpanded(row), p, tree.getToggleClickCount());
            }
        });
        return (Triple)Preconditions.checkNotNull(result);
    }

    @RunsInEDT
    public void expandPath(@Nonnull JTree tree, @Nonnull String path) {
        Triple<Boolean, Point, Integer> info = JTreeDriver.scrollToMatchingPathAndGetToggleInfo(tree, path, this.pathFinder(), this.location());
        if (((Boolean)info.first).booleanValue()) {
            return;
        }
        this.toggleCell(tree, (Point)Preconditions.checkNotNull((Object)info.second), (Integer)info.third);
    }

    @RunsInEDT
    public void collapsePath(@Nonnull JTree tree, @Nonnull String path) {
        Triple<Boolean, Point, Integer> info = JTreeDriver.scrollToMatchingPathAndGetToggleInfo(tree, path, this.pathFinder(), this.location());
        if (!((Boolean)info.first).booleanValue()) {
            return;
        }
        this.toggleCell(tree, (Point)Preconditions.checkNotNull((Object)info.second), (Integer)info.third);
    }

    @Nonnull
    @RunsInEDT
    private static Triple<Boolean, Point, Integer> scrollToMatchingPathAndGetToggleInfo(final @Nonnull JTree tree, final @Nonnull String path, final @Nonnull JTreePathFinder pathFinder, final @Nonnull JTreeLocation location) {
        Triple<Boolean, Point, Integer> result = GuiActionRunner.execute(new GuiQuery<Triple<Boolean, Point, Integer>>(){

            @Override
            protected Triple<Boolean, Point, Integer> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(tree);
                TreePath matchingPath = JTreeMatchingPathQuery.matchingPathFor(tree, path, pathFinder);
                Point p = JTreeDriver.scrollToTreePath(tree, matchingPath, location);
                return Triple.of(tree.isExpanded(matchingPath), p, tree.getToggleClickCount());
            }
        });
        return (Triple)Preconditions.checkNotNull(result);
    }

    @RunsInEDT
    private void toggleCell(@Nonnull JTree tree, @Nonnull Point p, int toggleClickCount) {
        if (toggleClickCount == 0) {
            JTreeDriver.toggleRowThroughTreeUI(tree, p);
            this.robot.waitForIdle();
            return;
        }
        this.robot.click(tree, p, MouseButton.LEFT_BUTTON, toggleClickCount);
    }

    @RunsInEDT
    private static void toggleRowThroughTreeUI(@Nonnull JTree tree, @Nonnull Point p) {
        GuiActionRunner.execute(() -> {
            TreeUI treeUI = tree.getUI();
            if (!(treeUI instanceof BasicTreeUI)) {
                throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Can't toggle row for ", treeUI}));
            }
            JTreeToggleExpandStateTask.toggleExpandState(tree, p);
        });
    }

    @RunsInEDT
    public void selectRows(final @Nonnull JTree tree, final @Nonnull int[] rows) {
        ArrayPreconditions.checkNotNullOrEmpty(rows);
        this.clearSelection(tree);
        new MultipleSelectionTemplate(this.robot){

            @Override
            int elementCount() {
                return rows.length;
            }

            @Override
            void selectElement(int index) {
                JTreeDriver.this.selectRow(tree, rows[index]);
            }
        }.multiSelect();
    }

    @RunsInEDT
    public void unselectRows(final @Nonnull JTree tree, final @Nonnull int[] rows) {
        ArrayPreconditions.checkNotNullOrEmpty(rows);
        new MultipleSelectionTemplate(this.robot){

            @Override
            int elementCount() {
                return rows.length;
            }

            @Override
            void unselectElement(int index) {
                JTreeDriver.this.unselectRow(tree, rows[index]);
            }
        }.multiUnselect();
    }

    @RunsInEDT
    private void clearSelection(@Nonnull JTree tree) {
        JTreeClearSelectionTask.clearSelectionOf(tree);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    public void selectRow(@Nonnull JTree tree, int row) {
        this.scrollAndSelectRow(tree, row, true, false);
    }

    @RunsInEDT
    public void unselectRow(@Nonnull JTree tree, int row) {
        int key = Platform.controlOrCommandKey();
        this.robot.pressKeyWhileRunning(key, () -> this.scrollAndSelectRow(tree, row, false, false));
    }

    @RunsInEDT
    public void selectPaths(final @Nonnull JTree tree, final @Nonnull String[] paths) {
        Preconditions.checkNotNullOrEmpty((Object[])paths);
        this.clearSelection(tree);
        new MultipleSelectionTemplate(this.robot){

            @Override
            int elementCount() {
                return paths.length;
            }

            @Override
            void selectElement(int index) {
                JTreeDriver.this.selectPath(tree, (String)Preconditions.checkNotNull((Object)paths[index]));
            }
        }.multiSelect();
    }

    @RunsInEDT
    public void unselectPaths(final @Nonnull JTree tree, final @Nonnull String[] paths) {
        Preconditions.checkNotNullOrEmpty((Object[])paths);
        new MultipleSelectionTemplate(this.robot){

            @Override
            int elementCount() {
                return paths.length;
            }

            @Override
            void unselectElement(int index) {
                JTreeDriver.this.unselectPath(tree, (String)Preconditions.checkNotNull((Object)paths[index]));
            }
        }.multiUnselect();
    }

    @RunsInEDT
    public void selectPath(@Nonnull JTree tree, @Nonnull String path) {
        this.selectMatchingPath(tree, path, true, false);
    }

    @RunsInEDT
    public void unselectPath(@Nonnull JTree tree, @Nonnull String path) {
        int key = Platform.controlOrCommandKey();
        this.robot.pressKeyWhileRunning(key, () -> this.selectMatchingPath(tree, path, false, false));
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull JTree tree, int row) {
        Pair<Boolean, Point> info = JTreeDriver.scrollToRow(tree, row, this.location(), true);
        Point p = (Point)Preconditions.checkNotNull(info.second);
        return this.robot.showPopupMenu(tree, p);
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull JTree tree, @Nonnull String path) {
        Triple<TreePath, Boolean, Point> info = this.scrollToMatchingPath(tree, path, true);
        this.robot.waitForIdle();
        Point where = (Point)Preconditions.checkNotNull(info.third);
        return this.robot.showPopupMenu(tree, where);
    }

    @RunsInEDT
    public void drag(@Nonnull JTree tree, int row) {
        Point p = this.scrollAndSelectRow(tree, row, true, true);
        this.drag((Component)tree, p);
    }

    @Nonnull
    @RunsInEDT
    private Point scrollAndSelectRow(@Nonnull JTree tree, int row, boolean select, boolean singleSelectRequired) {
        Pair<Boolean, Point> info = JTreeDriver.scrollToRow(tree, row, this.location(), singleSelectRequired);
        Point p = (Point)Preconditions.checkNotNull(info.second);
        if ((Boolean)info.first != select) {
            this.robot.click((Component)tree, p);
        }
        return p;
    }

    @RunsInEDT
    public void drop(@Nonnull JTree tree, int row) {
        Pair<Boolean, Point> info = JTreeDriver.scrollToRow(tree, row, this.location(), true);
        this.drop((Component)tree, (Point)Preconditions.checkNotNull(info.second));
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Boolean, Point> scrollToRow(final @Nonnull JTree tree, final int row, final @Nonnull JTreeLocation location, final boolean singleSelectRequired) {
        Pair<Boolean, Point> result = GuiActionRunner.execute(new GuiQuery<Pair<Boolean, Point>>(){

            @Override
            protected Pair<Boolean, Point> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(tree);
                Point p = JTreeDriver.scrollToVisible(tree, row, location);
                boolean selected = (!singleSelectRequired || tree.getSelectionCount() == 1) && tree.isRowSelected(row);
                return Pair.of(selected, p);
            }
        });
        return (Pair)Preconditions.checkNotNull(result);
    }

    @Nonnull
    @RunsInCurrentThread
    private static Point scrollToVisible(@Nonnull JTree tree, int row, @Nonnull JTreeLocation location) {
        Pair<Rectangle, Point> boundsAndCoordinates = location.rowBoundsAndCoordinates(tree, row);
        tree.scrollRectToVisible((Rectangle)boundsAndCoordinates.first);
        return (Point)Preconditions.checkNotNull(boundsAndCoordinates.second);
    }

    @RunsInEDT
    public void drag(@Nonnull JTree tree, @Nonnull String path) {
        Point p = this.selectMatchingPath(tree, path, true, true);
        this.drag((Component)tree, p);
    }

    @Nonnull
    @RunsInEDT
    private Point selectMatchingPath(@Nonnull JTree tree, @Nonnull String path, boolean select, boolean singleSelectionRequired) {
        Triple<TreePath, Boolean, Point> info = this.scrollToMatchingPath(tree, path, singleSelectionRequired);
        this.robot.waitForIdle();
        Point where = (Point)Preconditions.checkNotNull(info.third);
        if ((Boolean)info.second != select) {
            this.robot.click((Component)tree, where);
        }
        return where;
    }

    @RunsInEDT
    public void drop(@Nonnull JTree tree, @Nonnull String path) {
        Point p = (Point)this.scrollToMatchingPath((JTree)tree, (String)path, (boolean)true).third;
        this.drop((Component)tree, (Point)Preconditions.checkNotNull((Object)p));
    }

    @Nonnull
    @RunsInEDT
    private Triple<TreePath, Boolean, Point> scrollToMatchingPath(@Nonnull JTree tree, @Nonnull String path, boolean singleSelectionRequired) {
        TreePath matchingPath = JTreeMatchingPathQuery.verifyJTreeIsReadyAndFindMatchingPath(tree, path, this.pathFinder());
        this.makeVisible(tree, matchingPath, false);
        Pair<Boolean, Point> info = JTreeDriver.scrollToPathToSelect(tree, matchingPath, this.location(), singleSelectionRequired);
        return Triple.of(matchingPath, info.first, info.second);
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Boolean, Point> scrollToPathToSelect(final @Nonnull JTree tree, final @Nonnull TreePath path, final @Nonnull JTreeLocation location, final boolean singleSelectionRequired) {
        Pair<Boolean, Point> result = GuiActionRunner.execute(new GuiQuery<Pair<Boolean, Point>>(){

            @Override
            protected Pair<Boolean, Point> executeInEDT() {
                boolean isSelected = (!singleSelectionRequired || tree.getSelectionCount() == 1) && tree.isPathSelected(path);
                return Pair.of(isSelected, JTreeDriver.scrollToTreePath(tree, path, location));
            }
        });
        return (Pair)Preconditions.checkNotNull(result);
    }

    @Nonnull
    @RunsInCurrentThread
    private static Point scrollToTreePath(@Nonnull JTree tree, @Nonnull TreePath path, @Nonnull JTreeLocation location) {
        Pair<Rectangle, Point> boundsAndCoordinates = location.pathBoundsAndCoordinates(tree, path);
        tree.scrollRectToVisible((Rectangle)boundsAndCoordinates.first);
        return (Point)Preconditions.checkNotNull(boundsAndCoordinates.second);
    }

    @RunsInEDT
    private boolean makeParentVisible(@Nonnull JTree tree, @Nonnull TreePath path) {
        boolean changed = this.makeVisible(tree, (TreePath)Preconditions.checkNotNull((Object)path.getParentPath()), true);
        if (changed) {
            this.robot.waitForIdle();
        }
        return changed;
    }

    @RunsInEDT
    private boolean makeVisible(@Nonnull JTree tree, @Nonnull TreePath path, boolean expandWhenFound) {
        boolean changed = false;
        if (path.getPathCount() > 1) {
            changed = this.makeParentVisible(tree, path);
        }
        if (!expandWhenFound) {
            return changed;
        }
        JTreeExpandPathTask.expandTreePath(tree, path);
        this.waitForChildrenToShowUp(tree, path);
        return true;
    }

    @RunsInEDT
    private void waitForChildrenToShowUp(@Nonnull JTree tree, @Nonnull TreePath path) {
        int timeout = this.robot.settings().timeoutToBeVisible();
        try {
            Pause.pause((Condition)JTreeChildrenShowUpCondition.untilChildrenShowUp(tree, path), (long)timeout);
        }
        catch (WaitTimedOutError e) {
            throw new LocationUnavailableException(e.getMessage());
        }
    }

    @RunsInEDT
    public void requireSelection(@Nonnull JTree tree, @Nonnull int[] rows) {
        Preconditions.checkNotNull((Object)rows);
        JTreeVerifySelectionTask.checkHasSelection(tree, rows, this.selectionProperty(tree));
    }

    @RunsInEDT
    public void requireSelection(@Nonnull JTree tree, @Nonnull String[] paths) {
        Preconditions.checkNotNull((Object)paths);
        JTreeVerifySelectionTask.checkHasSelection(tree, paths, this.pathFinder(), this.selectionProperty(tree));
    }

    @RunsInEDT
    public void requireNoSelection(@Nonnull JTree tree) {
        JTreeVerifySelectionTask.checkNoSelection(tree, this.selectionProperty(tree));
    }

    @Nonnull
    @RunsInEDT
    private Description selectionProperty(@Nonnull JTree tree) {
        return JTreeDriver.propertyName(tree, SELECTION_PROPERTY);
    }

    @RunsInEDT
    public void requireEditable(@Nonnull JTree tree) {
        this.assertEditable(tree, true);
    }

    @RunsInEDT
    public void requireNotEditable(@Nonnull JTree tree) {
        this.assertEditable(tree, false);
    }

    @RunsInEDT
    private void assertEditable(@Nonnull JTree tree, boolean editable) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)JTreeEditableQuery.isEditable(tree)).as(JTreeDriver.editableProperty(tree))).isEqualTo(editable);
    }

    @Nonnull
    @RunsInEDT
    private static Description editableProperty(@Nonnull JTree tree) {
        return JTreeDriver.propertyName(tree, EDITABLE_PROPERTY);
    }

    @Nonnull
    public String separator() {
        return this.pathFinder.separator();
    }

    public void replaceSeparator(@Nonnull String newSeparator) {
        this.pathFinder.replaceSeparator((String)Preconditions.checkNotNull((Object)newSeparator));
    }

    public void replaceCellReader(@Nonnull JTreeCellReader newCellReader) {
        this.pathFinder.replaceCellReader((JTreeCellReader)Preconditions.checkNotNull((Object)newCellReader));
    }

    @RunsInEDT
    public void checkRowInBounds(@Nonnull JTree tree, int row) {
        this.location.checkRowInBounds(tree, row);
    }

    @RunsInEDT
    public void checkPathExists(@Nonnull JTree tree, @Nonnull String path) {
        JTreeMatchingPathQuery.matchingPathFor(tree, path, this.pathFinder());
    }

    @Nullable
    @RunsInEDT
    public String nodeValue(@Nonnull JTree tree, @Nonnull String path) {
        return JTreeNodeTextQuery.nodeText(tree, path, this.pathFinder());
    }

    @Nullable
    public String nodeValue(@Nonnull JTree tree, int row) {
        return JTreeNodeTextQuery.nodeText(tree, row, this.location(), this.pathFinder());
    }

    @VisibleForTesting
    JTreeCellReader cellReader() {
        return this.pathFinder.cellReader();
    }

    @Nonnull
    private JTreeLocation location() {
        return this.location;
    }

    @Nonnull
    private JTreePathFinder pathFinder() {
        return this.pathFinder;
    }
}

