/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.config;

import ai.grazie.detector.ChainLanguageDetector;
import ai.grazie.detector.DetectedLanguage;
import ai.grazie.detector.LanguageDetector;
import ai.grazie.detector.heuristics.list.ListDetector;
import ai.grazie.detector.ngram.NgramDetector;
import ai.grazie.nlp.langs.Language;
import com.intellij.grazie.detection.ExtensionsKt;
import com.intellij.util.xmlb.annotations.Property;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lcom/intellij/grazie/config/DetectionContext;", "", "<init>", "()V", "State", "Local", "intellij.grazie.core"})
public final class DetectionContext {
    @NotNull
    public static final DetectionContext INSTANCE = new DetectionContext();

    private DetectionContext() {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001d\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bJ\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0006\u0010\u0015\u001a\u00020\u000eJ\u0015\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010\u0017\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001f"}, d2={"Lcom/intellij/grazie/config/DetectionContext$Local;", "", "counter", "Ljava/util/concurrent/ConcurrentHashMap;", "Lai/grazie/nlp/langs/Language;", "", "<init>", "(Ljava/util/concurrent/ConcurrentHashMap;)V", "getCounter", "()Ljava/util/concurrent/ConcurrentHashMap;", "getToNotify", "", "disabled", "update", "", "size", "wordsTotal", "details", "Lai/grazie/detector/ChainLanguageDetector$ChainDetectionResult;", "count", "lang", "clear", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "intellij.grazie.core"})
    @SourceDebugExtension(value={"SMAP\nDetectionContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DetectionContext.kt\ncom/intellij/grazie/config/DetectionContext$Local\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,95:1\n535#2:96\n520#2,6:97\n126#3:103\n153#3,3:104\n774#4:107\n865#4,2:108\n13989#5,14:110\n13989#5,14:124\n*S KotlinDebug\n*F\n+ 1 DetectionContext.kt\ncom/intellij/grazie/config/DetectionContext$Local\n*L\n45#1:96\n45#1:97,6\n47#1:103\n47#1:104,3\n49#1:107\n49#1:108,2\n69#1:110,14\n78#1:124,14\n*E\n"})
    public static final class Local {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ConcurrentHashMap<Language, Integer> counter;
        public static final int SCORE_SIZE = 100;
        public static final double NOTIFICATION_PROPORTION_THRESHOLD = 0.2;
        public static final int NOTIFICATION_TOTAL_THRESHOLD = 3;
        public static final double NGRAM_CONFIDENCE_THRESHOLD = 0.98;
        public static final double LIST_CONFIDENCE_THRESHOLD = 0.51;
        public static final int TEXT_SIZE_THRESHOLD = 40;
        public static final int WORDS_SIZE_THRESHOLD = 4;

        public Local(@NotNull ConcurrentHashMap<Language, Integer> counter) {
            Intrinsics.checkNotNullParameter(counter, (String)"counter");
            this.counter = counter;
        }

        public /* synthetic */ Local(ConcurrentHashMap concurrentHashMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                concurrentHashMap = new ConcurrentHashMap();
            }
            this(concurrentHashMap);
        }

        @NotNull
        public final ConcurrentHashMap<Language, Integer> getCounter() {
            return this.counter;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<Language> getToNotify(@NotNull Set<? extends Language> disabled) {
            void $this$filterTo$iv$iv;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map.Entry entry2;
            void $this$filterTo$iv$iv2;
            Intrinsics.checkNotNullParameter(disabled, (String)"disabled");
            Collection<Integer> collection = this.counter.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            int total = CollectionsKt.sumOfInt((Iterable)collection);
            Map $this$filter$iv = this.counter;
            boolean $i$f$filter = false;
            Map map = $this$filter$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                entry2 = element$iv$iv = iterator.next();
                boolean bl = false;
                int myTotal = ((Number)entry2.getValue()).intValue();
                if (!(myTotal > 3 && (double)myTotal / (double)total > 0.2)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                void it;
                entry2 = item$iv$iv;
                Object object = destination$iv$iv;
                boolean bl = false;
                object.add((Language)((Object)it.getKey()));
            }
            List filtered = (List)destination$iv$iv;
            Iterable $this$filter$iv2 = filtered;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Language it = (Language)((Object)element$iv$iv);
                boolean bl = false;
                if (!(it != Language.UNKNOWN && !disabled.contains((Object)it))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List langs = (List)destination$iv$iv2;
            return CollectionsKt.toSet((Iterable)langs);
        }

        public final void update(int size, int wordsTotal, @NotNull ChainLanguageDetector.ChainDetectionResult details) {
            double v$iv;
            Object e$iv;
            int i$iv;
            int lastIndex$iv;
            Object maxElem$iv;
            boolean $i$f$maxByOrNull;
            Object[] $this$maxByOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)details, (String)"details");
            LanguageDetector.DetectionResult result2 = details.getResult();
            Language language = result2.getPreferred();
            if (language == Language.UNKNOWN) {
                return;
            }
            if (size < 40) {
                return;
            }
            if (ExtensionsKt.getHasWhitespaces(language) && wordsTotal < 4) {
                return;
            }
            if (ListDetector.Companion.getSupported().contains((Object)language)) {
                Object object;
                Object[] listResult;
                Object[] objectArray = details.get(LanguageDetector.Type.List);
                if (objectArray == null || (objectArray = objectArray.getDetected()) == null) {
                    return;
                }
                $this$maxByOrNull$iv = listResult = objectArray;
                $i$f$maxByOrNull = false;
                if ($this$maxByOrNull$iv.length == 0) {
                    object = null;
                } else {
                    maxElem$iv = $this$maxByOrNull$iv[0];
                    lastIndex$iv = ArraysKt.getLastIndex((Object[])$this$maxByOrNull$iv);
                    if (lastIndex$iv == 0) {
                        object = maxElem$iv;
                    } else {
                        DetectedLanguage it = maxElem$iv;
                        boolean bl = false;
                        double maxValue$iv = it.getProbability();
                        i$iv = 1;
                        if (i$iv <= lastIndex$iv) {
                            while (true) {
                                Object it2 = e$iv = $this$maxByOrNull$iv[i$iv];
                                $i$a$-maxByOrNull-DetectionContext$Local$update$maxList$1 = false;
                                v$iv = ((DetectedLanguage)it2).getProbability();
                                if (Double.compare(maxValue$iv, v$iv) < 0) {
                                    maxElem$iv = e$iv;
                                    maxValue$iv = v$iv;
                                }
                                if (i$iv == lastIndex$iv) break;
                                ++i$iv;
                            }
                        }
                        object = maxElem$iv;
                    }
                }
                if (object == null) {
                    return;
                }
                Object maxList = object;
                if (((DetectedLanguage)maxList).getProbability() < 0.51 || ((DetectedLanguage)maxList).getLang() != result2.getPreferred()) {
                    return;
                }
            }
            if (NgramDetector.Companion.getSupported().contains((Object)language)) {
                DetectedLanguage[] ngramResult;
                LanguageDetector.DetectionResult detectionResult = details.get(LanguageDetector.Type.Ngram);
                Object object = ngramResult = detectionResult != null ? detectionResult.getDetected() : null;
                if (ngramResult != null) {
                    Object object2;
                    $this$maxByOrNull$iv = ngramResult;
                    $i$f$maxByOrNull = false;
                    if ($this$maxByOrNull$iv.length == 0) {
                        object2 = null;
                    } else {
                        maxElem$iv = $this$maxByOrNull$iv[0];
                        lastIndex$iv = ArraysKt.getLastIndex((Object[])$this$maxByOrNull$iv);
                        if (lastIndex$iv == 0) {
                            object2 = maxElem$iv;
                        } else {
                            Object it = maxElem$iv;
                            boolean bl = false;
                            double maxValue$iv = ((DetectedLanguage)it).getProbability();
                            i$iv = 1;
                            if (i$iv <= lastIndex$iv) {
                                while (true) {
                                    Object it3 = e$iv = $this$maxByOrNull$iv[i$iv];
                                    $i$a$-maxByOrNull-DetectionContext$Local$update$maxNgram$1 = false;
                                    v$iv = ((DetectedLanguage)it3).getProbability();
                                    if (Double.compare(maxValue$iv, v$iv) < 0) {
                                        maxElem$iv = e$iv;
                                        maxValue$iv = v$iv;
                                    }
                                    if (i$iv == lastIndex$iv) break;
                                    ++i$iv;
                                }
                            }
                            object2 = maxElem$iv;
                        }
                    }
                    if (object2 == null) {
                        return;
                    }
                    Object maxNgram = object2;
                    if (((DetectedLanguage)maxNgram).getProbability() < 0.98 || ((DetectedLanguage)maxNgram).getLang() != result2.getPreferred()) {
                        return;
                    }
                }
            }
            this.count(size, language);
        }

        private final void count(int size, Language lang) {
            ((Map)this.counter).put(lang, ((Number)this.counter.getOrDefault((Object)lang, 0)).intValue() + (size / 100 + 1));
        }

        public final void clear() {
            this.counter.clear();
        }

        @NotNull
        public final ConcurrentHashMap<Language, Integer> component1() {
            return this.counter;
        }

        @NotNull
        public final Local copy(@NotNull ConcurrentHashMap<Language, Integer> counter) {
            Intrinsics.checkNotNullParameter(counter, (String)"counter");
            return new Local(counter);
        }

        public static /* synthetic */ Local copy$default(Local local, ConcurrentHashMap concurrentHashMap, int n, Object object) {
            if ((n & 1) != 0) {
                concurrentHashMap = local.counter;
            }
            return local.copy(concurrentHashMap);
        }

        @NotNull
        public String toString() {
            return "Local(counter=" + this.counter + ")";
        }

        public int hashCode() {
            return this.counter.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Local)) {
                return false;
            }
            Local local = (Local)other;
            return Intrinsics.areEqual(this.counter, local.counter);
        }

        public Local() {
            this(null, 1, null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/grazie/config/DetectionContext$Local$Companion;", "", "<init>", "()V", "SCORE_SIZE", "", "NOTIFICATION_PROPORTION_THRESHOLD", "", "NOTIFICATION_TOTAL_THRESHOLD", "NGRAM_CONFIDENCE_THRESHOLD", "LIST_CONFIDENCE_THRESHOLD", "TEXT_SIZE_THRESHOLD", "WORDS_SIZE_THRESHOLD", "intellij.grazie.core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\t\u001a\u00020\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bJ\u0014\u0010\f\u001a\u00020\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/grazie/config/DetectionContext$State;", "", "disabled", "", "Lai/grazie/nlp/langs/Language;", "<init>", "(Ljava/util/Set;)V", "getDisabled", "()Ljava/util/Set;", "disable", "langs", "", "enable", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.grazie.core"})
    public static final class State {
        @Property
        @NotNull
        private final Set<Language> disabled;

        public State(@NotNull Set<? extends Language> disabled) {
            Intrinsics.checkNotNullParameter(disabled, (String)"disabled");
            this.disabled = disabled;
        }

        public /* synthetic */ State(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                set = new HashSet();
            }
            this(set);
        }

        @NotNull
        public final Set<Language> getDisabled() {
            return this.disabled;
        }

        @NotNull
        public final State disable(@NotNull Iterable<? extends Language> langs) {
            Intrinsics.checkNotNullParameter(langs, (String)"langs");
            return new State(SetsKt.plus(this.disabled, langs));
        }

        @NotNull
        public final State enable(@NotNull Iterable<? extends Language> langs) {
            Intrinsics.checkNotNullParameter(langs, (String)"langs");
            return new State(SetsKt.minus(this.disabled, langs));
        }

        @NotNull
        public final Set<Language> component1() {
            return this.disabled;
        }

        @NotNull
        public final State copy(@NotNull Set<? extends Language> disabled) {
            Intrinsics.checkNotNullParameter(disabled, (String)"disabled");
            return new State(disabled);
        }

        public static /* synthetic */ State copy$default(State state, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                set = state.disabled;
            }
            return state.copy(set);
        }

        @NotNull
        public String toString() {
            return "State(disabled=" + this.disabled + ")";
        }

        public int hashCode() {
            return ((Object)this.disabled).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            return Intrinsics.areEqual(this.disabled, state.disabled);
        }

        public State() {
            this(null, 1, null);
        }
    }
}

