/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.indentGuides;

import com.intellij.codeInsight.daemon.impl.IndentGuideRenderer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.FrontendIndentGuideHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.FrontendIndentGuideRenderResultCollector;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.FrontendIndentGuideRendererKt;
import java.awt.Graphics;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0014J \u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/indentGuides/FrontendIndentGuideRenderer;", "Lcom/intellij/codeInsight/daemon/impl/IndentGuideRenderer;", "<init>", "()V", "isSelected", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "endOffset", "", "off", "indentColumn", "paint", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "g", "Ljava/awt/Graphics;", "doPaint", "resultCollector", "Lcom/jetbrains/rdclient/daemon/highlighters/indentGuides/FrontendIndentGuideRenderResultCollector;", "doPaintInTest", "intellij.rd.client"})
public final class FrontendIndentGuideRenderer
extends IndentGuideRenderer {
    protected boolean isSelected(@NotNull Editor editor, int endOffset, int off, int indentColumn) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return IndentGuideRenderer.isCaretOnGuide((Editor)editor, (int)endOffset, (int)off, (int)indentColumn);
    }

    public void paint(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (!editor.getSettings().isIndentGuidesShown()) {
            return;
        }
        if (FrontendIndentGuideHighlighterModelHandler.Companion.getIndentLevel(highlighter) == null) {
            super.paint(editor, highlighter, g);
            return;
        }
        FrontendIndentGuideRenderResultCollector collector = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> FrontendIndentGuideRenderer.paint$lambda$0(this, g, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
        this.doPaint(editor, highlighter, collector);
    }

    private final void doPaint(Editor editor, RangeHighlighter highlighter, FrontendIndentGuideRenderResultCollector resultCollector) {
        Integer n = FrontendIndentGuideHighlighterModelHandler.Companion.getIndentLevel(highlighter);
        Intrinsics.checkNotNull((Object)n);
        int indentLevel = n;
        int startOffset = highlighter.getStartOffset();
        Document document = highlighter.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document doc = document;
        if (startOffset >= doc.getTextLength()) {
            return;
        }
        int endOffset = highlighter.getEndOffset();
        int startLine = doc.getLineNumber(startOffset);
        int endLine = doc.getLineNumber(endOffset);
        int off = editor.logicalPositionToOffset(new LogicalPosition(startLine, 0)) + indentLevel;
        int visualIndentLevel = editor.offsetToVisualPosition((int)off).column;
        int logicalIndentLevel = editor.offsetToLogicalPosition((int)off).column;
        Integer currentPartStartLine = startLine;
        for (int currentLine = startLine; currentLine < endLine; ++currentLine) {
            if (FrontendIndentGuideRendererKt.access$shouldRenderIndentGuideOnLine(editor, currentLine, logicalIndentLevel)) {
                Integer n2 = currentPartStartLine;
                if (n2 == null) {
                    n2 = currentLine - 1;
                }
                currentPartStartLine = n2;
                continue;
            }
            if (currentPartStartLine == null) continue;
            FrontendIndentGuideRenderer.doPaint$paint(editor, indentLevel, visualIndentLevel, resultCollector, off, endOffset, doc, currentPartStartLine, currentLine);
            currentPartStartLine = null;
        }
        if (currentPartStartLine == null) {
            return;
        }
        FrontendIndentGuideRenderer.doPaint$paint(editor, indentLevel, visualIndentLevel, resultCollector, off, endOffset, doc, currentPartStartLine, endLine);
    }

    @TestOnly
    public final void doPaintInTest(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull FrontendIndentGuideRenderResultCollector resultCollector) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)resultCollector, (String)"resultCollector");
        this.doPaint(editor, highlighter, resultCollector);
    }

    private static final void paint$lambda$0(FrontendIndentGuideRenderer this$0, Graphics $g, Editor editorParam, VisualPosition currentPartStartVisualPosition, VisualPosition currentPartEndVisualPosition, int off, int endOffset, Document doc) {
        Intrinsics.checkNotNullParameter((Object)editorParam, (String)"editorParam");
        Intrinsics.checkNotNullParameter((Object)currentPartStartVisualPosition, (String)"currentPartStartVisualPosition");
        Intrinsics.checkNotNullParameter((Object)currentPartEndVisualPosition, (String)"currentPartEndVisualPosition");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        this$0.paint(editorParam, currentPartStartVisualPosition, currentPartEndVisualPosition, off, endOffset, doc, $g);
    }

    private static final void doPaint$paint(Editor $editor, int indentLevel, int visualIndentLevel, FrontendIndentGuideRenderResultCollector $resultCollector, int off, int endOffset, Document doc, int startLine, int endLine) {
        int currentPartStartOffset = $editor.logicalPositionToOffset(new LogicalPosition(startLine, 0)) + indentLevel;
        VisualPosition currentPartStartVisualPosition = new VisualPosition($editor.offsetToVisualPosition((int)currentPartStartOffset).line, visualIndentLevel);
        int currentPartEndOffset = $editor.logicalPositionToOffset(new LogicalPosition(endLine, 0)) + indentLevel;
        VisualPosition currentPartEndVisualPosition = new VisualPosition($editor.offsetToVisualPosition((int)currentPartEndOffset).line, visualIndentLevel);
        $resultCollector.collect($editor, currentPartStartVisualPosition, currentPartEndVisualPosition, off, endOffset, doc);
    }
}

