/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.core.notification;

import com.intellij.ide.util.PropertiesComponentExKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.settingsSync.core.RestartReason;
import com.intellij.settingsSync.core.SettingsSyncBundle;
import com.intellij.settingsSync.core.notification.NotificationService;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0016\u0010\t\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0016\u0010\r\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a8\u0006\u000e\u00b2\u0006\n\u0010\u000f\u001a\u00020\u0010X\u008a\u008e\u0002"}, d2={"Lcom/intellij/settingsSync/core/notification/NotificationServiceImpl;", "Lcom/intellij/settingsSync/core/notification/NotificationService;", "<init>", "()V", "notifySateRestoreFailed", "", "notifyZipSizeExceed", "buildZipSizeExceedNotification", "Lcom/intellij/notification/Notification;", "notifyRestartNeeded", "reasons", "", "Lcom/intellij/settingsSync/core/RestartReason;", "buildRestartNeededNotification", "intellij.settingsSync.core", "showNotification", ""})
public final class NotificationServiceImpl
implements NotificationService {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

    @Override
    public void notifySateRestoreFailed() {
        Notification notification = NotificationGroupManager.getInstance().getNotificationGroup("settingsSync.errors").createNotification(SettingsSyncBundle.INSTANCE.message("sync.notification.git.state.restore.failed.title", new Object[0]), SettingsSyncBundle.INSTANCE.message("sync.notification.git.state.restore.failed.text", new Object[0]), NotificationType.ERROR);
        notification.notify(null);
    }

    @Override
    public void notifyZipSizeExceed() {
        Notification notification = this.buildZipSizeExceedNotification();
        if (notification == null) {
            return;
        }
        Notification notification2 = notification;
        notification2.notify(null);
    }

    private final Notification buildZipSizeExceedNotification() {
        ReadWriteProperty showNotification$delegate = PropertiesComponentExKt.propComponentProperty(null, (String)"sync.notification.zip.size.exceed.show", (boolean)true);
        if (!NotificationServiceImpl.buildZipSizeExceedNotification$lambda$0((ReadWriteProperty<Object, Boolean>)showNotification$delegate)) {
            return null;
        }
        Notification notification = NotificationGroupManager.getInstance().getNotificationGroup("settingsSync.errors").createNotification(SettingsSyncBundle.INSTANCE.message("sync.notification.size.exceed.title", new Object[0]), SettingsSyncBundle.INSTANCE.message("sync.notification.size.exceed.text", new Object[0]), NotificationType.ERROR);
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)SettingsSyncBundle.INSTANCE.message("sync.notification.do.not.ask.again", new Object[0]), () -> NotificationServiceImpl.buildZipSizeExceedNotification$lambda$2(showNotification$delegate)));
        return notification;
    }

    @Override
    public void notifyRestartNeeded(@NotNull Collection<? extends RestartReason> reasons) {
        Intrinsics.checkNotNullParameter(reasons, (String)"reasons");
        Notification notification = this.buildRestartNeededNotification(reasons);
        Object[] objectArray = new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()};
        notification.addAction((AnAction)NotificationAction.create((String)SettingsSyncBundle.INSTANCE.message("sync.restart.notification.action", objectArray), NotificationServiceImpl::notifyRestartNeeded$lambda$3));
        notification.notify(null);
    }

    private final Notification buildRestartNeededNotification(Collection<? extends RestartReason> reasons) {
        String message = reasons.isEmpty() ? "" : (reasons.size() == 1 ? ((RestartReason)CollectionsKt.first((Iterable)reasons)).getSingleReasonNotificationMessage() : NotificationServiceImpl.buildRestartNeededNotification$getMultiReasonRestartMessage(reasons));
        return NotificationGroupManager.getInstance().getNotificationGroup("settingsSync.errors").createNotification(SettingsSyncBundle.INSTANCE.message("sync.restart.notification.title", new Object[0]), message, NotificationType.INFORMATION);
    }

    private static final boolean buildZipSizeExceedNotification$lambda$0(ReadWriteProperty<Object, Boolean> $showNotification$delegate) {
        return (Boolean)$showNotification$delegate.getValue(null, $$delegatedProperties[0]);
    }

    private static final void buildZipSizeExceedNotification$lambda$1(ReadWriteProperty<Object, Boolean> $showNotification$delegate, boolean bl) {
        $showNotification$delegate.setValue(null, $$delegatedProperties[0], (Object)bl);
    }

    private static final void buildZipSizeExceedNotification$lambda$2(ReadWriteProperty $showNotification$delegate) {
        NotificationServiceImpl.buildZipSizeExceedNotification$lambda$1((ReadWriteProperty<Object, Boolean>)$showNotification$delegate, false);
    }

    private static final void notifyRestartNeeded$lambda$3(AnActionEvent it) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.intellij.openapi.application.ex.ApplicationEx");
        ApplicationEx app = (ApplicationEx)application;
        app.restart(true);
    }

    private static final String buildRestartNeededNotification$getMultiReasonRestartMessage(Collection<? extends RestartReason> $reasons) {
        StringBuilder message = new StringBuilder(SettingsSyncBundle.INSTANCE.message("sync.notification.restart.message.list.title", new Object[0])).append("<br/>");
        List sortedRestartReasons = CollectionsKt.sorted((Iterable)$reasons);
        Iterator iterator = ((Iterable)sortedRestartReasons).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int counter = n++;
            RestartReason reason = (RestartReason)iterator.next();
            message.append(reason.getMultiReasonNotificationListEntry(counter + 1));
            if (counter >= CollectionsKt.getLastIndex((List)sortedRestartReasons)) continue;
            message.append("<br/>");
        }
        String string = message.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl(NotificationServiceImpl.class, "showNotification", "<v#0>", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

