/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.actions;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobFunction;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateProjectOperation;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.navigator.CommonViewer;

public class OpenFolderAsProjectAction
extends Action {
    private final Collection<IFolder> folders;
    private final CommonViewer viewer;

    public OpenFolderAsProjectAction(Collection<IFolder> folder, CommonViewer viewer) {
        super(folder.size() > 1 ? WorkbenchNavigatorMessages.OpenProjectAction_OpenExistingProjects : WorkbenchNavigatorMessages.OpenProjectAction_OpenExistingProject);
        this.folders = folder;
        this.viewer = viewer;
        this.setDescription(WorkbenchNavigatorMessages.OpenProjectAction_OpenExistingProject_desc);
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT"));
    }

    public OpenFolderAsProjectAction(IFolder folder, CommonViewer viewer) {
        this(Collections.singleton(folder), viewer);
    }

    public void run() {
        LinkedList imported = new LinkedList();
        JobGroup group = new JobGroup(WorkbenchNavigatorMessages.OpenProjectAction_multiple, 0, this.folders.size());
        Job.getJobManager().addJobChangeListener((IJobChangeListener)new GroupFinishedListener(group, () -> this.reflectChanges(imported, this.folders.stream().map(IResource::getParent).distinct().toList())));
        for (IFolder folder : this.folders) {
            Job job = Job.create((String)NLS.bind((String)WorkbenchNavigatorMessages.OpenProjectAction_opening, (Object)folder.getName()), (IJobFunction)new ActualImport(folder, imported::add));
            job.setPriority(10);
            job.setJobGroup(group);
            job.schedule();
        }
    }

    private void reflectChanges(List<IProject> imported, List<IContainer> refreshed) {
        this.viewer.getTree().getDisplay().asyncExec(() -> {
            refreshed.forEach(arg_0 -> ((CommonViewer)this.viewer).refresh(arg_0));
            this.viewer.setSelection((ISelection)new StructuredSelection(imported));
        });
    }

    private static final class ActualImport
    implements IJobFunction {
        private final IFolder folder;
        private final Consumer<IProject> reflect;

        private ActualImport(IFolder folder, Consumer<IProject> reflect) {
            this.folder = folder;
            this.reflect = reflect;
        }

        public IStatus run(IProgressMonitor monitor) {
            IProject parentProject = this.folder.getProject();
            HashSet<IWorkingSet> parentWorkingSets = new HashSet<IWorkingSet>();
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            IWorkingSet[] iWorkingSetArray = workingSetManager.getWorkingSets();
            int n = iWorkingSetArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkingSet workingSet = iWorkingSetArray[n2];
                IAdaptable[] iAdaptableArray = workingSet.getElements();
                int n3 = iAdaptableArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAdaptable element = iAdaptableArray[n4];
                    if (parentProject.equals(Adapters.adapt((Object)element, IProject.class))) {
                        parentWorkingSets.add(workingSet);
                        break;
                    }
                    ++n4;
                }
                ++n2;
            }
            try {
                IProjectDescription desc = ResourcesPlugin.getWorkspace().loadProjectDescription(this.folder.getLocation().append(".project"));
                desc.setLocation(this.folder.getLocation());
                CreateProjectOperation operation = new CreateProjectOperation(desc, desc.getName());
                IStatus status = OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)operation, null, null);
                if (status.isOK()) {
                    IProject newProject = (IProject)operation.getAffectedObjects()[0];
                    workingSetManager.addToWorkingSets((IAdaptable)newProject, parentWorkingSets.toArray(new IWorkingSet[parentWorkingSets.size()]));
                    this.reflect.accept(newProject);
                    return Status.OK_STATUS;
                }
                return status;
            }
            catch (ExecutionException ex) {
                return Status.error((String)ex.getMessage(), (Throwable)ex);
            }
            catch (CoreException ex) {
                return ex.getStatus();
            }
        }
    }

    private static final class GroupFinishedListener
    extends JobChangeAdapter {
        private final JobGroup target;
        private final Runnable finalize;

        public GroupFinishedListener(JobGroup target, Runnable finalize) {
            this.target = target;
            this.finalize = finalize;
        }

        public void done(IJobChangeEvent event) {
            if (!this.target.equals(event.getJob().getJobGroup())) {
                return;
            }
            if (event.getJobGroupResult() == null) {
                return;
            }
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)this);
            this.finalize.run();
        }
    }
}

