/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateUtils.class);

    private CertificateUtils() {
    }

    public static boolean verifyCertificatesExist(String dockerCertPath) {
        String[] files = new String[]{"ca.pem", "cert.pem", "key.pem"};
        boolean result = true;
        for (String file : files) {
            File path = new File(dockerCertPath, file);
            result &= path.exists();
        }
        return result;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public static KeyStore createKeyStore(String keypem, String certpem) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, CertificateException, KeyStoreException {
        PrivateKey privateKey = CertificateUtils.loadPrivateKey(keypem);
        Objects.requireNonNull(privateKey);
        List<Certificate> privateCertificates = CertificateUtils.loadCertificates(certpem);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null);
        keyStore.setKeyEntry("docker", privateKey, "docker".toCharArray(), privateCertificates.toArray(new Certificate[privateCertificates.size()]));
        return keyStore;
    }

    public static List<Certificate> loadCertificates(String certpem) throws IOException, CertificateException {
        StringReader certReader = new StringReader(certpem);
        try (BufferedReader reader = new BufferedReader(certReader);){
            List<Certificate> list = CertificateUtils.loadCertificates(reader);
            return list;
        }
    }

    public static List<Certificate> loadCertificates(Reader reader) throws IOException, CertificateException {
        try (PEMParser pemParser = new PEMParser(reader);){
            Object certObj;
            ArrayList<Certificate> certificates = new ArrayList<Certificate>();
            JcaX509CertificateConverter certificateConverter = new JcaX509CertificateConverter().setProvider("BC");
            while ((certObj = pemParser.readObject()) != null) {
                if (!(certObj instanceof X509CertificateHolder)) continue;
                X509CertificateHolder certificateHolder = (X509CertificateHolder)certObj;
                certificates.add(certificateConverter.getCertificate(certificateHolder));
            }
            ArrayList<Certificate> arrayList = certificates;
            return arrayList;
        }
    }

    @CheckForNull
    public static PrivateKey loadPrivateKey(Reader reader) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        try (PEMParser pemParser = new PEMParser(reader);){
            Object readObject = pemParser.readObject();
            while (readObject != null) {
                PrivateKeyInfo privateKeyInfo = CertificateUtils.getPrivateKeyInfoOrNull(readObject);
                if (privateKeyInfo != null) {
                    PrivateKey privateKey = new JcaPEMKeyConverter().getPrivateKey(privateKeyInfo);
                    return privateKey;
                }
                readObject = pemParser.readObject();
            }
        }
        return null;
    }

    @CheckForNull
    private static PrivateKeyInfo getPrivateKeyInfoOrNull(Object pemObject) throws NoSuchAlgorithmException {
        PrivateKeyInfo privateKeyInfo = null;
        if (pemObject instanceof PEMKeyPair) {
            PEMKeyPair pemKeyPair = (PEMKeyPair)pemObject;
            privateKeyInfo = pemKeyPair.getPrivateKeyInfo();
        } else if (pemObject instanceof PrivateKeyInfo) {
            privateKeyInfo = (PrivateKeyInfo)pemObject;
        } else if (pemObject instanceof ASN1ObjectIdentifier) {
            ASN1ObjectIdentifier asn1ObjectIdentifier = (ASN1ObjectIdentifier)pemObject;
            LOG.trace("Ignoring asn1ObjectIdentifier {}", (Object)asn1ObjectIdentifier);
        } else {
            LOG.warn("Unknown object '{}' from PEMParser", pemObject);
        }
        return privateKeyInfo;
    }

    /*
     * Exception decompiling
     */
    @CheckForNull
    public static PrivateKey loadPrivateKey(String keypem) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static KeyStore createTrustStore(String capem) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        try (StringReader certReader = new StringReader(capem);){
            KeyStore keyStore = CertificateUtils.createTrustStore(certReader);
            return keyStore;
        }
    }

    public static KeyStore createTrustStore(Reader certReader) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        try (PEMParser pemParser = new PEMParser(certReader);){
            Object pemCert;
            KeyStore trustStore = KeyStore.getInstance("JKS");
            trustStore.load(null);
            int index = 1;
            while ((pemCert = pemParser.readObject()) != null) {
                X509Certificate caCertificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate((X509CertificateHolder)pemCert);
                trustStore.setCertificateEntry("ca-" + index, caCertificate);
                ++index;
            }
            KeyStore keyStore = trustStore;
            return keyStore;
        }
    }
}

