/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.java.BlockFactory;
import com.intellij.psi.formatter.java.ChildrenBlocksBuilder;
import com.intellij.psi.formatter.java.JavaFormatterUtil;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AnnotationInitializerBlocksBuilder {
    private final BlockFactory myFactory;
    private final ASTNode myNode;
    private final JavaCodeStyleSettings myJavaSettings;

    public AnnotationInitializerBlocksBuilder(ASTNode node, BlockFactory factory) {
        this.myNode = node;
        this.myFactory = factory;
        this.myJavaSettings = this.myFactory.getJavaSettings();
    }

    public List<Block> buildBlocks() {
        Wrap wrap = Wrap.createWrap((WrapType)JavaFormatterUtil.getWrapType(this.myJavaSettings.ANNOTATION_PARAMETER_WRAP), (boolean)false);
        Alignment alignment = this.myJavaSettings.ALIGN_MULTILINE_ANNOTATION_PARAMETERS ? Alignment.createAlignment() : null;
        ChildrenBlocksBuilder.Config config = new ChildrenBlocksBuilder.Config().setDefaultIndent(Indent.getContinuationWithoutFirstIndent()).setIndent(JavaTokenType.RPARENTH, Indent.getNoneIndent()).setIndent(JavaTokenType.LPARENTH, Indent.getNoneIndent()).setDefaultWrap(wrap).setNoWrap(JavaTokenType.COMMA).setNoWrap(JavaTokenType.RPARENTH).setNoWrap(JavaTokenType.LPARENTH).setDefaultAlignment(alignment).setNoAlignment(JavaTokenType.COMMA).setNoAlignment(JavaTokenType.LPARENTH).setNoAlignmentIf(JavaTokenType.RPARENTH, node -> {
            PsiElement prev = PsiTreeUtil.skipWhitespacesBackward((PsiElement)node.getPsi());
            if (prev == null) {
                return false;
            }
            return prev instanceof PsiNameValuePair && !PsiTreeUtil.hasErrorElements((PsiElement)prev);
        }).setNoAlignmentIf(JavaElementType.NAME_VALUE_PAIR, AnnotationInitializerBlocksBuilder::isSingleNameValuePair);
        return config.createBuilder().buildNodeChildBlocks(this.myNode, this.myFactory);
    }

    private static boolean isSingleNameValuePair(@NotNull ASTNode pairNode) {
        PsiElement prev;
        if (pairNode == null) {
            AnnotationInitializerBlocksBuilder.$$$reportNull$$$0(0);
        }
        if ((prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)pairNode.getPsi())) != null && prev.getNode().getElementType() != JavaTokenType.LPARENTH) {
            return false;
        }
        PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)pairNode.getPsi());
        return next == null || next.getNode().getElementType() == JavaTokenType.RPARENTH;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pairNode", "com/intellij/psi/formatter/java/AnnotationInitializerBlocksBuilder", "isSingleNameValuePair"));
    }
}

