/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.actions;

import com.intellij.hibernate.HibernateBundle;
import com.intellij.hibernate.facet.HibernateVersion;
import com.intellij.hibernate.util.HibernateUtil;
import com.intellij.jpa.facet.JpaConfigurationModel;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.util.UnitSettingMapConfigurable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JTable;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AssignNamingStrategiesAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AssignNamingStrategiesAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AssignNamingStrategiesAction.$$$reportNull$$$0(1);
        }
        PersistenceFacet facet = (PersistenceFacet)e.getData(PersistenceDataKeys.PERSISTENCE_FACET);
        e.getPresentation().setEnabledAndVisible(facet != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PersistenceFacet facet;
        if (e == null) {
            AssignNamingStrategiesAction.$$$reportNull$$$0(2);
        }
        if ((facet = (PersistenceFacet)e.getData(PersistenceDataKeys.PERSISTENCE_FACET)) == null) {
            return;
        }
        facet = JpaConfigurationModel.createModifiablePersistenceFacet((PersistenceFacet)facet);
        ShowSettingsUtil.getInstance().editConfigurable(facet.getModule().getProject(), (Configurable)new MyComponent(facet, e.getPresentation().getText()));
    }

    @NotNull
    private static ArrayList<String> findAllNamingStrategies(@NotNull Module module) {
        if (module == null) {
            AssignNamingStrategiesAction.$$$reportNull$$$0(3);
        }
        GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        HibernateVersion version = HibernateUtil.getHibernateVersion(module);
        ArrayList<String> nameList = new ArrayList<String>();
        for (String s : version.getNamingStrategies()) {
            PsiClass namingStrategyClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(s, searchScope);
            if (namingStrategyClass != null) {
                ClassInheritorsSearch.search((PsiClass)namingStrategyClass, (SearchScope)searchScope, (boolean)true, (boolean)true, (boolean)false).forEach(psiClass -> {
                    String name;
                    if (PsiClassUtil.isRunnableClass((PsiClass)psiClass, (boolean)false, (boolean)true) && !nameList.contains(name = psiClass.getQualifiedName())) {
                        nameList.add(name);
                    }
                    return true;
                });
            }
            Collections.sort(nameList);
        }
        ArrayList<String> arrayList = nameList;
        if (arrayList == null) {
            AssignNamingStrategiesAction.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/hibernate/actions/AssignNamingStrategiesAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/hibernate/actions/AssignNamingStrategiesAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllNamingStrategies";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findAllNamingStrategies";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }

    private static class MyComponent
    extends UnitSettingMapConfigurable<PersistenceFacet, String> {
        @Nls
        private final String myTitle;

        MyComponent(PersistenceFacet facet, @Nls String title) {
            super(facet);
            this.myTitle = title;
            this.getComponent().setPreferredSize((Dimension)new JBDimension(640, this.myView.getRowHeight() * 4 + 50));
        }

        protected UnitSettingMapConfigurable.MyRenderer createComboBoxTableRenderer() {
            ArrayList<String> nameList = AssignNamingStrategiesAction.findAllNamingStrategies(this.myFacet.getModule());
            nameList.add(0, "");
            return new UnitSettingMapConfigurable.MyRenderer(ArrayUtilRt.toStringArray(nameList)){

                public Object getCellEditorValue() {
                    return StringUtil.nullize((String)((String)super.getCellEditorValue()));
                }

                public String getTextFor(@NlsSafe @NotNull String value) {
                    if (value == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return StringUtil.isEmpty((String)value) ? HibernateBundle.message("hibernate.default.naming.strategy", new Object[0]) : value;
                }

                protected Icon getIconFor(@NotNull String value) {
                    if (value == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return StringUtil.isEmpty((String)value) ? EmptyIcon.ICON_16 : IconManager.getInstance().getPlatformIcon(PlatformIcons.Class);
                }

                protected void customizeComponent(@NlsSafe String value, JTable table, boolean isSelected) {
                    super.customizeComponent((Object)value, table, isSelected);
                    if (!isSelected && (value == null || value.isEmpty())) {
                        this.setForeground(UIUtil.getComboBoxDisabledForeground());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "value";
                    objectArray2[1] = "com/intellij/hibernate/actions/AssignNamingStrategiesAction$MyComponent$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getTextFor";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getIconFor";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        @NotNull
        protected String getValueColumnName() {
            String string = HibernateBundle.message("naming.strategy", new Object[0]);
            if (string == null) {
                MyComponent.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        protected String getSettingValue(PersistencePackage unit) {
            return this.myFacet.getNamingStrategy(unit);
        }

        protected void setSettingValue(PersistencePackage unit, String value) {
            JpaConfigurationModel.modifyConfiguration((PersistenceFacet)this.myFacet, facet -> facet.setNamingStrategy(unit, value));
        }

        @Nls
        public String getDisplayName() {
            return this.myTitle;
        }

        @Nullable
        public String getHelpTopic() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/actions/AssignNamingStrategiesAction$MyComponent", "getValueColumnName"));
        }
    }
}

