/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.completion.frontend.split;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.platform.completion.common.split.RpcCompletionService;
import com.intellij.platform.completion.common.split.protocol.RpcCompletionItem;
import com.intellij.platform.completion.common.split.protocol.RpcCompletionListOrder;
import com.intellij.platform.completion.common.split.protocol.RpcCompletionRequest;
import com.intellij.platform.completion.common.split.protocol.RpcCompletionResponseEvent;
import com.intellij.platform.completion.frontend.split.FrontendCompletionLoggerKt;
import com.intellij.platform.completion.frontend.split.FrontendCompletionProcessKt;
import com.intellij.platform.completion.frontend.split.FrontendCoroutineScopeServiceKt;
import com.intellij.platform.completion.frontend.split.FrontendLookupElement;
import fleet.rpc.core.RpcFlow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.sync.Semaphore;
import kotlinx.coroutines.sync.SemaphoreKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\u0006\u0010\u0018\u001a\u00020\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u0016H\u0002J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/platform/completion/frontend/split/FrontendCompletionProcess;", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "resultSet", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "<init>", "(Lcom/intellij/codeInsight/completion/CompletionParameters;Lcom/intellij/codeInsight/completion/CompletionResultSet;)V", "completionListOrder", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/platform/completion/common/split/protocol/RpcCompletionListOrder;", "result", "rpcRequest", "Lcom/intellij/platform/completion/common/split/protocol/RpcCompletionRequest;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "itemsReceivedSemaphore", "Lkotlinx/coroutines/sync/Semaphore;", "start", "", "scheduleBackendCompletion", "awaitAllItemsReceivedBlocking", "registerCancellationOn", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "processEvent", "event", "Lcom/intellij/platform/completion/common/split/protocol/RpcCompletionResponseEvent;", "processAdvertisement", "Lcom/intellij/platform/completion/common/split/protocol/RpcCompletionResponseEvent$Advertisement;", "onCompletionItemFinish", "processCompletionItems", "items", "Lcom/intellij/platform/completion/common/split/protocol/RpcCompletionResponseEvent$NewItems;", "intellij.platform.completion.frontend.split"})
@SourceDebugExtension(value={"SMAP\nFrontendCompletionProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendCompletionProcess.kt\ncom/intellij/platform/completion/frontend/split/FrontendCompletionProcess\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,195:1\n1563#2:196\n1634#2,3:197\n*S KotlinDebug\n*F\n+ 1 FrontendCompletionProcess.kt\ncom/intellij/platform/completion/frontend/split/FrontendCompletionProcess\n*L\n107#1:196\n107#1:197,3\n*E\n"})
public final class FrontendCompletionProcess {
    @NotNull
    private final AtomicReference<RpcCompletionListOrder> completionListOrder;
    @NotNull
    private final CompletionResultSet result;
    @NotNull
    private final RpcCompletionRequest rpcRequest;
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Semaphore itemsReceivedSemaphore;

    public FrontendCompletionProcess(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet resultSet) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        this.completionListOrder = new AtomicReference();
        CompletionResultSet completionResultSet = resultSet.withRelevanceSorter(FrontendCompletionProcessKt.access$frontendCompletionSorter(this.completionListOrder));
        Intrinsics.checkNotNullExpressionValue((Object)completionResultSet, (String)"withRelevanceSorter(...)");
        this.result = completionResultSet;
        this.rpcRequest = FrontendCompletionProcessKt.access$prepareCompletionRequest(parameters);
        Project project = parameters.getPosition().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        this.scope = FrontendCoroutineScopeServiceKt.frontendCompletionScope(this.project, "FrontendCompletionProcess " + this);
        this.itemsReceivedSemaphore = SemaphoreKt.Semaphore((int)1, (int)1);
    }

    public final void start() {
        FrontendCompletionLoggerKt.getFcLogger().info("Starting frontend completion process for request: " + this.rpcRequest);
        ProgressIndicator indicator = ProgressManager.getGlobalProgressIndicator();
        Intrinsics.checkNotNull((Object)indicator);
        this.registerCancellationOn(indicator);
        this.scheduleBackendCompletion();
    }

    private final void scheduleBackendCompletion() {
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ FrontendCompletionProcess this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = RpcCompletionService.Companion.getInstance((Continuation)this);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        rpcCompletionService = (RpcCompletionService)v0;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)rpcCompletionService);
                        this.label = 2;
                        v1 = rpcCompletionService.getResponse(FrontendCompletionProcess.access$getRpcRequest$p(this.this$0), (Continuation)this);
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl24
                    }
                    case 2: {
                        rpcCompletionService = (RpcCompletionService)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl24:
                        // 2 sources

                        response = (RpcFlow)v1;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)rpcCompletionService);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)response);
                        this.label = 3;
                        v2 = response.toFlow().collect(new FlowCollector(this.this$0){
                            final /* synthetic */ FrontendCompletionProcess this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public final Object emit(RpcCompletionResponseEvent event, Continuation<? super Unit> $completion) {
                                FrontendCompletionProcess.access$processEvent(this.this$0, event);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (v2 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl37
                    }
                    case 3: {
                        response = (RpcFlow)this.L$1;
                        rpcCompletionService = (RpcCompletionService)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl37:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void awaitAllItemsReceivedBlocking() {
        CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ FrontendCompletionProcess this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FrontendCompletionProcess.access$getItemsReceivedSemaphore$p(this.this$0).acquire((Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        FrontendCompletionLoggerKt.getFcLogger().info("All items are received: " + this.rpcRequest);
    }

    private final void registerCancellationOn(ProgressIndicator progressIndicator) {
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(progressIndicator, this, null){
            int label;
            final /* synthetic */ ProgressIndicator $progressIndicator;
            final /* synthetic */ FrontendCompletionProcess this$0;
            {
                this.$progressIndicator = $progressIndicator;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
lbl6:
                        // 3 sources

                        while (true) {
                            this.label = 1;
                            v0 = DelayKt.delay((long)50L, (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl15
                            break;
                        }
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        if (!this.$progressIndicator.isCanceled()) ** GOTO lbl6
                        FrontendCompletionLoggerKt.getFcLogger().info("Progress indicator canceled, cancelling frontend completion process for request: " + FrontendCompletionProcess.access$getRpcRequest$p(this.this$0));
                        CoroutineScopeKt.cancel$default((CoroutineScope)FrontendCompletionProcess.access$getScope$p(this.this$0), null, (int)1, null);
                        ** continue;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void processEvent(RpcCompletionResponseEvent event) {
        FrontendCompletionLoggerKt.getFcLogger().trace("Processing event: " + event + ", request: " + this.rpcRequest);
        RpcCompletionResponseEvent rpcCompletionResponseEvent = event;
        if (rpcCompletionResponseEvent instanceof RpcCompletionResponseEvent.NewItems) {
            this.processCompletionItems((RpcCompletionResponseEvent.NewItems)event);
        } else if (rpcCompletionResponseEvent instanceof RpcCompletionResponseEvent.Advertisement) {
            this.processAdvertisement((RpcCompletionResponseEvent.Advertisement)event);
        } else if (rpcCompletionResponseEvent instanceof RpcCompletionResponseEvent.CompletionItemsFinished) {
            this.onCompletionItemFinish();
        }
    }

    private final void processAdvertisement(RpcCompletionResponseEvent.Advertisement event) {
        this.result.addLookupAdvertisement(event.getMessage());
    }

    private final void onCompletionItemFinish() {
        this.itemsReceivedSemaphore.release();
    }

    /*
     * WARNING - void declaration
     */
    private final void processCompletionItems(RpcCompletionResponseEvent.NewItems items) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = items.getNewItems();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void item;
            RpcCompletionItem rpcCompletionItem = (RpcCompletionItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new FrontendLookupElement((RpcCompletionItem)item, this.project, this.rpcRequest));
        }
        List lookupElements = (List)destination$iv$iv;
        this.completionListOrder.set(items.getCompletionListOrder());
        this.result.addAllElements((Iterable)lookupElements);
    }

    public static final /* synthetic */ RpcCompletionRequest access$getRpcRequest$p(FrontendCompletionProcess $this) {
        return $this.rpcRequest;
    }

    public static final /* synthetic */ void access$processEvent(FrontendCompletionProcess $this, RpcCompletionResponseEvent event) {
        $this.processEvent(event);
    }

    public static final /* synthetic */ Semaphore access$getItemsReceivedSemaphore$p(FrontendCompletionProcess $this) {
        return $this.itemsReceivedSemaphore;
    }

    public static final /* synthetic */ CoroutineScope access$getScope$p(FrontendCompletionProcess $this) {
        return $this.scope;
    }
}

