/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.claude.listeners.server;

import com.intellij.code.provenance.core.events.utils.Path_utilsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/code/provenance/core/claude/listeners/server/ServerPortDumpService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "portFile", "Ljava/nio/file/Path;", "dumpServerPortToFile", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "Companion", "intellij.code.provenance.core.claude"})
@SourceDebugExtension(value={"SMAP\nServerPortDumpService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerPortDumpService.kt\ncom/intellij/code/provenance/core/claude/listeners/server/ServerPortDumpService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,68:1\n13#2:69\n*S KotlinDebug\n*F\n+ 1 ServerPortDumpService.kt\ncom/intellij/code/provenance/core/claude/listeners/server/ServerPortDumpService\n*L\n20#1:69\n*E\n"})
public final class ServerPortDumpService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private Path portFile;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String PORT_FILE_SUFFIX = "-provenance-port.txt";

    public ServerPortDumpService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Nullable
    public final Object dumpServerPortToFile(@NotNull Continuation<? super Unit> $completion) {
        if (ApplicationManager.getApplication().isUnitTestMode() && !Boolean.getBoolean("provenance.dump.port")) {
            LOG.info("Skipping server port dump in unit test mode");
            return Unit.INSTANCE;
        }
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ServerPortDumpService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        try {
                            void it;
                            Path path;
                            ServerPortDumpService.access$getLOG$cp().info("Waiting for BuiltInServerManager to start...");
                            BuiltInServerManager.Companion.getInstance().waitForStart();
                            int port = BuiltInServerManager.Companion.getInstance().getPort();
                            String pathHash = com.intellij.code.provenance.core.claude.listeners.server.ServerPortDumpService$Companion.access$computePathHash(ServerPortDumpService.Companion, ((Object)Path_utilsKt.getProjectDirectory((Project)ServerPortDumpService.access$getProject$p(this.this$0))).toString());
                            Path tempDir = Path.of(System.getProperty("java.io.tmpdir"), new String[0]);
                            String fileName = pathHash + "-provenance-port.txt";
                            Path path2 = path = tempDir.resolve(fileName);
                            ServerPortDumpService serverPortDumpService = this.this$0;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)it);
                            PathsKt.writeText$default((Path)it, (CharSequence)String.valueOf(port), null, (OpenOption[])new OpenOption[0], (int)2, null);
                            ServerPortDumpService.access$getLOG$cp().info("Server port information written to: " + ((Object)it.toAbsolutePath()).toString());
                            ServerPortDumpService.access$setPortFile$p(serverPortDumpService, path);
                        }
                        catch (Exception e) {
                            ServerPortDumpService.access$getLOG$cp().error("Failed to dump server port information", (Throwable)e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public void dispose() {
        block2: {
            Path path = this.portFile;
            if (path == null) break block2;
            Path it = path;
            boolean bl = false;
            try {
                Boolean bl2 = Files.deleteIfExists(it);
            }
            catch (Exception exception) {
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ Project access$getProject$p(ServerPortDumpService $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$setPortFile$p(ServerPortDumpService $this, Path path) {
        $this.portFile = path;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ServerPortDumpService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/code/provenance/core/claude/listeners/server/ServerPortDumpService$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "PORT_FILE_SUFFIX", "", "getInstance", "Lcom/intellij/code/provenance/core/claude/listeners/server/ServerPortDumpService;", "project", "Lcom/intellij/openapi/project/Project;", "computePathHash", "path", "intellij.code.provenance.core.claude"})
    @SourceDebugExtension(value={"SMAP\nServerPortDumpService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerPortDumpService.kt\ncom/intellij/code/provenance/core/claude/listeners/server/ServerPortDumpService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,68:1\n30#2,2:69\n*S KotlinDebug\n*F\n+ 1 ServerPortDumpService.kt\ncom/intellij/code/provenance/core/claude/listeners/server/ServerPortDumpService$Companion\n*L\n23#1:69,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ServerPortDumpService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ServerPortDumpService> serviceClass$iv = ServerPortDumpService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ServerPortDumpService)object;
        }

        private final String computePathHash(String path) {
            MessageDigest hash = MessageDigest.getInstance("MD5");
            byte[] byArray = path.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] hashBytes = hash.digest(byArray);
            Intrinsics.checkNotNull((Object)hashBytes);
            return ArraysKt.joinToString$default((byte[])hashBytes, (CharSequence)"", null, null, (int)0, null, Companion::computePathHash$lambda$0, (int)30, null);
        }

        private static final CharSequence computePathHash$lambda$0(byte it) {
            String string = "%02x";
            Object[] objectArray = new Object[]{it};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }

        public static final /* synthetic */ String access$computePathHash(Companion $this, String path) {
            return $this.computePathHash(path);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

