/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.transcoder.image;

import java.awt.image.BufferedImage;
import java.awt.image.SinglePixelPackedSampleModel;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.relocated.apache.batik.bridge.UserAgent;
import org.jetbrains.relocated.apache.batik.transcoder.TranscoderException;
import org.jetbrains.relocated.apache.batik.transcoder.TranscoderOutput;
import org.jetbrains.relocated.apache.batik.transcoder.TranscodingHints;
import org.jetbrains.relocated.apache.batik.transcoder.image.ImageTranscoder;
import org.jetbrains.relocated.apache.batik.transcoder.image.PNGTranscoder;
import org.jetbrains.relocated.apache.batik.transcoder.keys.StringKey;

public class TIFFTranscoder
extends ImageTranscoder {
    public static final TranscodingHints.Key KEY_FORCE_TRANSPARENT_WHITE = ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE;
    public static final TranscodingHints.Key KEY_COMPRESSION_METHOD = new StringKey();

    public TIFFTranscoder() {
        this.hints.put(KEY_FORCE_TRANSPARENT_WHITE, Boolean.FALSE);
    }

    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    @Override
    public BufferedImage createImage(int width2, int height) {
        return new BufferedImage(width2, height, 2);
    }

    private WriteAdapter getWriteAdapter(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            WriteAdapter adapter2 = (WriteAdapter)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return adapter2;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    @Override
    public void writeImage(BufferedImage img, TranscoderOutput output) throws TranscoderException {
        WriteAdapter adapter2;
        boolean forceTransparentWhite = false;
        if (this.hints.containsKey(PNGTranscoder.KEY_FORCE_TRANSPARENT_WHITE)) {
            forceTransparentWhite = (Boolean)this.hints.get(PNGTranscoder.KEY_FORCE_TRANSPARENT_WHITE);
        }
        if (forceTransparentWhite) {
            SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)img.getSampleModel();
            this.forceTransparentWhite(img, sppsm);
        }
        if ((adapter2 = this.getWriteAdapter("org.jetbrains.relocated.apache.batik.ext.awt.image.codec.tiff.TIFFTranscoderInternalCodecWriteAdapter")) == null) {
            adapter2 = this.getWriteAdapter("org.jetbrains.relocated.apache.batik.ext.awt.image.codec.imageio.TIFFTranscoderImageIOWriteAdapter");
        }
        if (adapter2 == null) {
            throw new TranscoderException("Could not write TIFF file because no WriteAdapter is availble");
        }
        adapter2.writeImage(this, img, output);
    }

    public static interface WriteAdapter {
        public void writeImage(TIFFTranscoder var1, BufferedImage var2, TranscoderOutput var3) throws TranscoderException;
    }
}

