/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="StatefulSetOrdinals describes the policy used for replica ordinal assignment in this StatefulSet.")
public class V1StatefulSetOrdinals {
    public static final String SERIALIZED_NAME_START = "start";
    @SerializedName(value="start")
    private Integer start;

    public V1StatefulSetOrdinals start(Integer start) {
        this.start = start;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="start is the number representing the first replica's index. It may be used to number replicas from an alternate index (eg: 1-indexed) over the default 0-indexed names, or to orchestrate progressive movement of replicas from one StatefulSet to another. If set, replica indices will be in the range:   [.spec.ordinals.start, .spec.ordinals.start + .spec.replicas). If unset, defaults to 0. Replica indices will be in the range:   [0, .spec.replicas).")
    public Integer getStart() {
        return this.start;
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1StatefulSetOrdinals v1StatefulSetOrdinals = (V1StatefulSetOrdinals)o;
        return Objects.equals(this.start, v1StatefulSetOrdinals.start);
    }

    public int hashCode() {
        return Objects.hash(this.start);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1StatefulSetOrdinals {\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

