/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.api;

import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.Pair;
import io.kubernetes.client.openapi.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0005H\u0002J\u0019\u0010\n\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0019\u0010\u0010\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\f\u00a2\u0006\u0002\u0010\rJ(\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u00a8\u0006\u001a"}, d2={"Lcom/intellij/kubernetes/api/ApiClientTools;", "", "<init>", "()V", "parameterToString", "", "param", "isJsonMime", "", "mime", "selectHeaderAccept", "accepts", "", "([Ljava/lang/String;)Ljava/lang/String;", "escapeString", "str", "selectHeaderContentType", "contentTypes", "buildUrl", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "serverAddress", "path", "queryParams", "", "Lio/kubernetes/client/openapi/Pair;", "intellij.clouds.kubernetes"})
public final class ApiClientTools {
    @NotNull
    public static final ApiClientTools INSTANCE = new ApiClientTools();

    private ApiClientTools() {
    }

    @NotNull
    public final String parameterToString(@Nullable Object param) {
        Object object = param;
        if (object == null) {
            return "";
        }
        if (object instanceof Date || object instanceof OffsetDateTime || object instanceof LocalDate) {
            String jsonStr = new JSON().serialize(param);
            Intrinsics.checkNotNull((Object)jsonStr);
            String string = jsonStr.substring(1, jsonStr.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        if (object instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (((CharSequence)b).length() > 0) {
                    b.append(",");
                }
                b.append(String.valueOf(o));
            }
            String string = b.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        return param.toString();
    }

    private final boolean isJsonMime(String mime) {
        CharSequence charSequence;
        String jsonMime = "(?i)^(application/json|[^;/ \t]+/[^;/ \t]+[+]json)[ \t]*(;.*)?$";
        return mime != null && (new Regex(jsonMime).matches(charSequence = (CharSequence)mime) || Intrinsics.areEqual((Object)mime, (Object)"*/*"));
    }

    @NotNull
    public final String selectHeaderAccept(@NotNull String[] accepts) {
        Intrinsics.checkNotNullParameter((Object)accepts, (String)"accepts");
        if (accepts.length == 0) {
            throw new RuntimeException();
        }
        int n = accepts.length;
        for (int i = 0; i < n; ++i) {
            String accept = accepts[i];
            if (!this.isJsonMime(accept)) continue;
            return accept;
        }
        String string = StringUtil.join((String[])accepts, (String)",");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        return string;
    }

    private final String escapeString(String str) {
        CharSequence charSequence;
        try {
            String string = URLEncoder.encode(str, "utf8");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
            charSequence = string;
            Regex regex = new Regex("\\+");
            String string2 = "%20";
            charSequence = regex.replace(charSequence, string2);
        }
        catch (UnsupportedEncodingException e) {
            charSequence = str;
        }
        return charSequence;
    }

    @NotNull
    public final String selectHeaderContentType(@NotNull String[] contentTypes) {
        Intrinsics.checkNotNullParameter((Object)contentTypes, (String)"contentTypes");
        if (contentTypes.length == 0 || Intrinsics.areEqual((Object)contentTypes[0], (Object)"*/*")) {
            return "application/json";
        }
        int n = contentTypes.length;
        for (int i = 0; i < n; ++i) {
            String contentType = contentTypes[i];
            if (!this.isJsonMime(contentType)) continue;
            return contentType;
        }
        return contentTypes[0];
    }

    @NotNull
    public final StringBuilder buildUrl(@NotNull String serverAddress, @NotNull String path, @NotNull List<Pair> queryParams) {
        Intrinsics.checkNotNullParameter((Object)serverAddress, (String)"serverAddress");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        StringBuilder url1 = new StringBuilder();
        url1.append(serverAddress).append(path);
        if (!queryParams.isEmpty()) {
            String prefix = StringsKt.contains$default((CharSequence)path, (CharSequence)"?", (boolean)false, (int)2, null) ? "&" : "?";
            for (Pair param : queryParams) {
                if (param.getValue() == null) continue;
                if (prefix != null) {
                    url1.append(prefix);
                    prefix = null;
                } else {
                    url1.append("&");
                }
                String value2 = this.parameterToString(param.getValue());
                String string = param.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                url1.append(this.escapeString(string)).append("=").append(this.escapeString(value2));
            }
        }
        return url1;
    }
}

