/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hive;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.hive.introspector.HiveIntrospector;
import com.intellij.database.dialects.hive.model.HiveFunction;
import com.intellij.database.dialects.hive.model.HiveFunctionBase;
import com.intellij.database.dialects.hive.model.HiveIndex;
import com.intellij.database.dialects.hive.model.HiveLikeColumn;
import com.intellij.database.dialects.hive.model.HiveMatView;
import com.intellij.database.dialects.hive.model.HiveSchema;
import com.intellij.database.dialects.hive.model.HiveTable;
import com.intellij.database.dialects.hive.model.HiveTableColumn;
import com.intellij.database.dialects.hivebase.model.properties.HiveTableColumnSortingOrder;
import com.intellij.database.dialects.hivebase.model.properties.HiveTableColumnType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.hive.HiveTypes;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.impl.SqlCreateFunctionStatementImpl;
import com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import com.intellij.sql.psi.stubs.elementStubs.SqlDefinitionStub;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J \u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001b\u0010\u001e\u001a\r\u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\u0002\b!2\u0006\u0010\"\u001a\u00020#H\u0002J$\u0010$\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00050&H\u0002J$\u0010(\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00050&H\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\b\u001a\u00020#H\u0002J \u0010,\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020-2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006."}, d2={"Lcom/intellij/database/dialects/hive/HiveObjectBuilder;", "Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "<init>", "()V", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/database/model/SqlObjectBuilder$Context;", "getCompactDefinition", "Lcom/intellij/openapi/util/TextRange;", "path", "Lcom/intellij/database/util/ObjectPath;", "text", "Lcom/intellij/database/model/properties/CompositeText;", "def", "Lcom/intellij/database/model/PsiObject;", "buildIndex", "Lcom/intellij/database/dialects/hive/model/HiveIndex;", "buildFunction", "Lcom/intellij/database/dialects/hive/model/HiveFunctionBase;", "buildMatView", "Lcom/intellij/database/dialects/hive/model/HiveMatView;", "buildLikeColumn", "Lcom/intellij/database/dialects/hive/model/HiveLikeColumn;", "buildTable", "Lcom/intellij/database/dialects/hive/model/HiveTable;", "findProperties", "", "Lcom/intellij/database/model/NameValue;", "Lorg/jetbrains/annotations/NotNull;", "el", "Lcom/intellij/psi/PsiElement;", "forEachColumnDef", "action", "Lkotlin/Function1;", "Lcom/intellij/sql/psi/SqlColumnDefinition;", "forEachColumnRef", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "findAndUnescapeString", "", "buildSchema", "Lcom/intellij/database/dialects/hive/model/HiveSchema;", "intellij.database.dialects.hive"})
@SourceDebugExtension(value={"SMAP\nHiveObjectBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HiveObjectBuilder.kt\ncom/intellij/database/dialects/hive/HiveObjectBuilder\n+ 2 SqlObjectBuilderImpl.kt\ncom/intellij/database/dialects/base/SqlObjectBuilderImpl\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,282:1\n625#2,5:283\n614#2,10:288\n625#2,5:298\n614#2,10:303\n625#2,5:313\n614#2,7:319\n614#2,10:326\n621#2,3:336\n615#2:339\n637#2:340\n625#2,5:341\n614#2,7:346\n614#2,10:353\n614#2,10:370\n614#2,10:380\n621#2,3:390\n615#2:393\n625#2,5:398\n614#2,10:403\n1#3:318\n1563#4:363\n1634#4,3:364\n1869#4,2:368\n455#5:367\n13805#6,2:394\n13805#6,2:396\n*S KotlinDebug\n*F\n+ 1 HiveObjectBuilder.kt\ncom/intellij/database/dialects/hive/HiveObjectBuilder\n*L\n61#1:283,5\n69#1:288,10\n87#1:298,5\n95#1:303,10\n113#1:313,5\n125#1:319,7\n140#1:326,10\n125#1:336,3\n125#1:339\n161#1:340\n161#1:341,5\n162#1:346,7\n168#1:353,10\n186#1:370,10\n193#1:380,10\n162#1:390,3\n162#1:393\n258#1:398,5\n269#1:403,10\n176#1:363\n176#1:364,3\n177#1:368,2\n177#1:367\n229#1:394,2\n238#1:396,2\n*E\n"})
public final class HiveObjectBuilder
extends SqlObjectBuilderImpl {
    public void build(@NotNull BasicModElement obj, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicModElement basicModElement = obj;
        if (basicModElement instanceof HiveSchema) {
            this.buildSchema((HiveSchema)obj, source, context);
        } else if (basicModElement instanceof HiveTable) {
            this.buildTable((HiveTable)obj, source, context);
        } else if (basicModElement instanceof HiveLikeColumn) {
            this.buildLikeColumn((HiveLikeColumn)obj, source, context);
        } else if (basicModElement instanceof HiveMatView) {
            this.buildMatView((HiveMatView)obj, source, context);
        } else if (basicModElement instanceof HiveFunctionBase) {
            this.buildFunction((HiveFunctionBase)obj, source, context);
        } else if (basicModElement instanceof HiveIndex) {
            this.buildIndex((HiveIndex)obj, source, context);
        } else {
            super.build(obj, source, context);
        }
    }

    @Nullable
    public TextRange getCompactDefinition(@NotNull ObjectPath path, @NotNull CompositeText text, @Nullable PsiObject def) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return Intrinsics.areEqual((Object)path.kind, (Object)ObjectKind.ROUTINE) ? TextRange.EMPTY_RANGE : super.getCompactDefinition(path, text, def);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildIndex(HiveIndex obj, DasObject source, SqlObjectBuilder.Context context) {
        HiveIndex stubbed;
        BasicElement basicElement;
        super.buildIndex((BasicModIndex)obj, source, context);
        if (context.isStubBuilder()) {
            return;
        }
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed2 = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof HiveIndex) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof HiveIndex)) {
                object = null;
            }
            basicElement = (BasicElement)((HiveIndex)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (HiveIndex)basicElement) != null) {
            obj.setType(stubbed.getType());
            obj.setIndexTableRef(stubbed.getIndexTableRef());
        } else {
            void this_$iv;
            String type = null;
            String indexTableName = null;
            SqlObjectBuilderImpl $i$f$stubbed2 = this;
            PsiElement el$iv = (PsiElement)(source instanceof SqlCreateIndexStatement ? (SqlCreateIndexStatement)source : null);
            boolean $i$f$forEachChild = false;
            void var10_12 = this_$iv;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement first2;
                PsiElement el = tmp$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)el), (Object)SqlCompositeElementTypes.SQL_CLAUSE) || el.getFirstChild() == null) continue;
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)first2);
                if (Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_AS)) {
                    type = this.findString(first2);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_IN)) continue;
                indexTableName = this.findString(first2);
            }
            obj.setType(type);
            obj.setIndexTableRef((BasicReference)BasicNameReference.create(indexTableName));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildFunction(HiveFunctionBase obj, DasObject source, SqlObjectBuilder.Context context) {
        block8: {
            void this_$iv;
            block7: {
                HiveFunctionBase stubbed;
                BasicElement basicElement;
                super.buildRoutine((BasicModRoutine)obj, source, context);
                SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
                DasObject $this$stubbed$iv = source;
                boolean $i$f$stubbed22 = false;
                DasObject dasObject = $this$stubbed$iv;
                if (dasObject instanceof HiveFunctionBase) {
                    basicElement = (BasicElement)$this$stubbed$iv;
                } else if (dasObject instanceof SqlStubbedElement) {
                    StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
                    SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
                    Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
                    if (!(object instanceof HiveFunctionBase)) {
                        object = null;
                    }
                    basicElement = (BasicElement)((HiveFunctionBase)object);
                } else {
                    basicElement = null;
                }
                if ((stubbed = (HiveFunctionBase)basicElement) == null) break block7;
                obj.setClassName(stubbed.getClassName());
                HiveFunction hiveFunction = obj instanceof HiveFunction ? (HiveFunction)obj : null;
                if (hiveFunction == null) break block8;
                HiveFunctionBase $i$f$stubbed22 = stubbed;
                HiveFunction hiveFunction2 = $i$f$stubbed22 instanceof HiveFunction ? (HiveFunction)$i$f$stubbed22 : null;
                hiveFunction.setTemporary(hiveFunction2 != null ? hiveFunction2.isTemporary() : false);
                break block8;
            }
            String className = null;
            boolean isTemporary = false;
            SqlObjectBuilderImpl $i$f$stubbed22 = this;
            PsiElement el$iv = (PsiElement)(source instanceof SqlCreateFunctionStatementImpl ? (SqlCreateFunctionStatementImpl)source : null);
            boolean $i$f$forEachChild = false;
            void var10_14 = this_$iv;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement el = tmp$iv$iv;
                boolean bl = false;
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)el);
                if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_CLAUSE)) {
                    if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)el.getFirstChild()), (Object)HiveTypes.HIVE_AS)) continue;
                    SqlStringLiteralExpression sqlStringLiteralExpression = (SqlStringLiteralExpression)PsiTreeUtil.getChildOfType((PsiElement)el, SqlStringLiteralExpression.class);
                    className = sqlStringLiteralExpression != null ? sqlStringLiteralExpression.getValue() : null;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_TEMPORARY)) continue;
                isTemporary = true;
            }
            obj.setClassName(className);
            HiveFunction hiveFunction = obj instanceof HiveFunction ? (HiveFunction)obj : null;
            if (hiveFunction == null) break block8;
            hiveFunction.setTemporary(isTemporary);
        }
    }

    private final void buildMatView(HiveMatView obj, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement((BasicModElement)obj, source, context);
        this.assignSources(obj, context, () -> HiveObjectBuilder.buildMatView$lambda$0(this, source));
    }

    /*
     * WARNING - void declaration
     */
    private final void buildLikeColumn(HiveLikeColumn obj, DasObject source, SqlObjectBuilder.Context context) {
        HiveLikeColumn stubbed;
        BasicElement basicElement;
        super.buildBasicElement((BasicModElement)obj, source, context);
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed2 = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof HiveLikeColumn) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof HiveLikeColumn)) {
                object = null;
            }
            basicElement = (BasicElement)((HiveLikeColumn)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (HiveLikeColumn)basicElement) != null) {
            obj.setComment(stubbed.getComment());
            if (stubbed instanceof HiveTableColumn && obj instanceof HiveTableColumn) {
                ((HiveTableColumn)obj).setType(((HiveTableColumn)stubbed).getType());
            }
        } else {
            String string;
            HiveLikeColumn hiveLikeColumn = obj;
            PsiElement psiElement = source instanceof PsiElement ? (PsiElement)source : null;
            IElementType iElementType = HiveTypes.HIVE_COMMENT_CLAUSE;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"HIVE_COMMENT_CLAUSE");
            PsiElement psiElement2 = this.findChild(psiElement, iElementType);
            if (psiElement2 != null) {
                void it;
                PsiElement $i$f$stubbed2 = psiElement2;
                HiveLikeColumn hiveLikeColumn2 = hiveLikeColumn;
                boolean bl = false;
                PsiElement psiElement3 = it.getFirstChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getFirstChild(...)");
                string = this.findAndUnescapeString(psiElement3);
                hiveLikeColumn = hiveLikeColumn2;
            } else {
                string = null;
            }
            hiveLikeColumn.setComment(string);
            if (obj instanceof HiveTableColumn) {
                void this_$iv;
                Ref.ObjectRef type = new Ref.ObjectRef();
                type.element = HiveTableColumnType.REGULAR;
                Ref.ObjectRef sorting = new Ref.ObjectRef();
                sorting.element = HiveTableColumnSortingOrder.NONE;
                SqlObjectBuilderImpl it = this;
                PsiElement el$iv = PsiTreeUtil.getParentOfType((PsiElement)(source instanceof PsiElement ? (PsiElement)source : null), SqlCreateTableStatement.class);
                boolean $i$f$forEachChild = false;
                void var10_16 = this_$iv;
                PsiElement psiElement4 = el$iv;
                PsiElement first$iv$iv = psiElement4 != null ? psiElement4.getFirstChild() : null;
                boolean $i$f$forEachSibling = false;
                for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    void this_$iv2;
                    IElementType iElementType2;
                    PsiElement el = tmp$iv$iv;
                    boolean bl = false;
                    PsiElement psiElement5 = el.getFirstChild();
                    Object object = iElementType2 = psiElement5 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement5) : null;
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)HiveTypes.HIVE_PARTITIONED)) {
                        this.forEachColumnDef(el, (Function1<? super SqlColumnDefinition, Unit>)((Function1)arg_0 -> HiveObjectBuilder.buildLikeColumn$lambda$1$0(obj, type, arg_0)));
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType2, (Object)HiveTypes.HIVE_CLUSTERED)) continue;
                    this.forEachColumnRef(el, (Function1<? super SqlReferenceExpression, Unit>)((Function1)arg_0 -> HiveObjectBuilder.buildLikeColumn$lambda$1$1(obj, type, arg_0)));
                    SqlObjectBuilderImpl sqlObjectBuilderImpl2 = this;
                    PsiElement el$iv2 = el;
                    boolean $i$f$forEachChild2 = false;
                    void var20_26 = this_$iv2;
                    PsiElement first$iv$iv2 = el$iv2.getFirstChild();
                    boolean $i$f$forEachSibling2 = false;
                    for (PsiElement tmp$iv$iv2 = first$iv$iv2; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                        PsiElement innerEl = tmp$iv$iv2;
                        boolean bl2 = false;
                        PsiElement psiElement6 = innerEl.getFirstChild();
                        if (!Intrinsics.areEqual((Object)(psiElement6 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement6) : null), (Object)HiveTypes.HIVE_SORTED)) continue;
                        this.forEachColumnRef(innerEl, (Function1<? super SqlReferenceExpression, Unit>)((Function1)arg_0 -> HiveObjectBuilder.buildLikeColumn$lambda$1$2$0(obj, sorting, arg_0)));
                    }
                }
                ((HiveTableColumn)obj).setType((HiveTableColumnType)((Object)type.element));
                ((HiveTableColumn)obj).setSorting((HiveTableColumnSortingOrder)((Object)sorting.element));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildTable(HiveTable obj, DasObject source, SqlObjectBuilder.Context context) {
        BasicElement basicElement;
        void $this$stubbedOrBuild$iv;
        void this_$iv;
        super.buildBasicElement((BasicModElement)obj, source, context);
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject dasObject = source;
        BasicElement tgt$iv = (BasicElement)obj;
        boolean $i$f$stubbedOrBuild = false;
        BasicElement basicElement2 = this_$iv;
        void $this$stubbed$iv$iv = $this$stubbedOrBuild$iv;
        boolean $i$f$stubbed = false;
        void var12_11 = $this$stubbed$iv$iv;
        if (var12_11 instanceof HiveTable) {
            basicElement = (BasicElement)$this$stubbed$iv$iv;
        } else if (var12_11 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv$iv).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof HiveTable)) {
                object = null;
            }
            basicElement = (BasicElement)((HiveTable)object);
        } else {
            basicElement = null;
        }
        BasicElement basicElement3 = basicElement;
        if (basicElement == null) {
            void this_$iv2;
            BasicElement basicElement4 = ((BasicObjectNode)tgt$iv).getMetaObject().newDataObject();
            if (basicElement4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.hive.model.HiveTable");
            }
            basicElement2 = (BasicElement)((HiveTable)basicElement4);
            HiveTable $this$buildTable_u24lambda_u240 = (HiveTable)basicElement2;
            boolean bl = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl2 = this;
            PsiElement el$iv = source instanceof PsiElement ? (PsiElement)source : null;
            boolean $i$f$forEachChild = false;
            void var19_18 = this_$iv2;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                SqlReferenceExpression sqlReferenceExpression;
                Object $this$map$iv;
                SqlReferenceList refList;
                PsiElement tmp$iv$iv2;
                boolean $i$f$forEachSibling22;
                PsiElement first$iv$iv2;
                SqlObjectBuilderImpl this_$iv3;
                boolean $i$f$forEachChild2;
                PsiElement el$iv2;
                IElementType iElementType;
                PsiElement el = tmp$iv$iv;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)el), (Object)HiveTypes.HIVE_EXTERNAL)) {
                    $this$buildTable_u24lambda_u240.setExternal(true);
                } else if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)el), (Object)HiveTypes.HIVE_TEMPORARY)) {
                    $this$buildTable_u24lambda_u240.setTemporary(true);
                }
                PsiElement psiElement2 = el.getFirstChild();
                Object object = iElementType = psiElement2 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement2) : null;
                if (Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_COMMENT)) {
                    PsiElement psiElement3 = el.getFirstChild();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getFirstChild(...)");
                    $this$buildTable_u24lambda_u240.setComment(this.findAndUnescapeString(psiElement3));
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_CLUSTERED)) {
                    SqlObjectBuilderImpl sqlObjectBuilderImpl3 = this;
                    el$iv2 = el;
                    $i$f$forEachChild2 = false;
                    void var29_28 = this_$iv3;
                    first$iv$iv2 = el$iv2.getFirstChild();
                    $i$f$forEachSibling22 = false;
                    for (tmp$iv$iv2 = first$iv$iv2; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                        PsiElement innerEl = tmp$iv$iv2;
                        boolean bl3 = false;
                        PsiElement psiElement4 = innerEl.getFirstChild();
                        if (!Intrinsics.areEqual((Object)(psiElement4 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement4) : null), (Object)HiveTypes.HIVE_INTO)) continue;
                        Integer n = this.findInt(innerEl);
                        $this$buildTable_u24lambda_u240.setBucketsNum(n != null ? n : 0);
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_SKEWED)) {
                    void $this$forEach$iv;
                    refList = (SqlReferenceList)PsiTreeUtil.getChildOfType((PsiElement)el, SqlReferenceList.class);
                    Object object2 = refList;
                    if (object2 != null && (object2 = object2.getReferenceList()) != null) {
                        void $this$mapTo$iv$iv;
                        $this$map$iv = (Iterable)object2;
                        boolean $i$f$map = false;
                        Iterable $i$f$forEachSibling22 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            sqlReferenceExpression = (SqlReferenceExpression)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl4 = false;
                            collection.add(it.getName());
                        }
                        List it = (List)destination$iv$iv;
                        boolean bl5 = false;
                        $this$buildTable_u24lambda_u240.setSkewedByColumns(it);
                    }
                    Object $this$childrenOfType$iv = el;
                    boolean $i$f$childrenOfType = false;
                    List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, SqlClause.class);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
                    $this$childrenOfType$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IElementType $i$f$mapTo;
                        SqlClause clause = (SqlClause)element$iv;
                        boolean bl6 = false;
                        PsiElement psiElement5 = clause.getFirstChild();
                        Object object3 = $i$f$mapTo = psiElement5 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement5) : null;
                        if (Intrinsics.areEqual((Object)$i$f$mapTo, (Object)HiveTypes.HIVE_ON)) {
                            if ((SqlClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)clause), SqlClause.class) != null) {
                                SqlClause it;
                                boolean bl7 = false;
                                $this$buildTable_u24lambda_u240.setSkewedByValues(it.getText());
                            }
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)$i$f$mapTo, (Object)HiveTypes.HIVE_STORED)) continue;
                        $this$buildTable_u24lambda_u240.setStoredAsDirectories(true);
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_ROW)) {
                    $this$buildTable_u24lambda_u240.setRowFormatSerde(this.findString(el.getFirstChild()));
                    refList = this;
                    el$iv2 = el;
                    $i$f$forEachChild2 = false;
                    $this$map$iv = this_$iv3;
                    first$iv$iv2 = el$iv2.getFirstChild();
                    $i$f$forEachSibling22 = false;
                    for (tmp$iv$iv2 = first$iv$iv2; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                        PsiElement it = tmp$iv$iv2;
                        boolean bl8 = false;
                        if (!(it instanceof SqlClause)) continue;
                        PsiElement psiElement6 = ((SqlClause)it).getFirstChild();
                        if (!Intrinsics.areEqual((Object)(psiElement6 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement6) : null), (Object)HiveTypes.HIVE_SERDEPROPERTIES)) continue;
                        $this$buildTable_u24lambda_u240.setSerdeProperties(this.findProperties(it));
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_STORED)) {
                    this_$iv3 = this;
                    el$iv2 = el;
                    $i$f$forEachChild2 = false;
                    SqlObjectBuilderImpl this_$iv$iv = this_$iv3;
                    first$iv$iv2 = el$iv2.getFirstChild();
                    $i$f$forEachSibling22 = false;
                    for (tmp$iv$iv2 = first$iv$iv2; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                        PsiElement first2;
                        PsiElement it = tmp$iv$iv2;
                        boolean bl9 = false;
                        if (!(it instanceof SqlClause)) continue;
                        PsiElement psiElement7 = first2 = ((SqlClause)it).getFirstChild();
                        Object object4 = sqlReferenceExpression = psiElement7 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement7) : null;
                        if (Intrinsics.areEqual((Object)sqlReferenceExpression, (Object)HiveTypes.HIVE_INPUTFORMAT)) {
                            $this$buildTable_u24lambda_u240.setInputFormat(this.findString(first2));
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)sqlReferenceExpression, (Object)HiveTypes.HIVE_OUTPUTFORMAT)) {
                            $this$buildTable_u24lambda_u240.setOutputFormat(this.findString(first2));
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)sqlReferenceExpression, (Object)HiveTypes.HIVE_OUTPUTDRIVER)) {
                            $this$buildTable_u24lambda_u240.setOutputDriver(this.findString(first2));
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)sqlReferenceExpression, (Object)HiveTypes.HIVE_INPUTDRIVER)) continue;
                        $this$buildTable_u24lambda_u240.setInputDriver(this.findString(first2));
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_LOCATION)) {
                    PsiElement psiElement8 = el.getFirstChild();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement8, (String)"getFirstChild(...)");
                    $this$buildTable_u24lambda_u240.setLocation(this.findAndUnescapeString(psiElement8));
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_TBLPROPERTIES)) continue;
                $this$buildTable_u24lambda_u240.setProperties(this.findProperties(el));
            }
            basicElement3 = basicElement2;
        }
        HiveTable stubbed = (HiveTable)basicElement3;
        obj.setComment(stubbed.getComment());
        obj.setExternal(stubbed.isExternal());
        obj.setTemporary(stubbed.isTemporary());
        obj.setBucketsNum(stubbed.getBucketsNum());
        obj.setSkewedByColumns(stubbed.getSkewedByColumns());
        obj.setSkewedByValues(stubbed.getSkewedByValues());
        obj.setStoredAsDirectories(stubbed.isStoredAsDirectories());
        obj.setRowFormatSerde(stubbed.getRowFormatSerde());
        obj.setSerdeProperties(stubbed.getSerdeProperties());
        obj.setInputFormat(stubbed.getInputFormat());
        obj.setOutputFormat(stubbed.getOutputFormat());
        obj.setInputDriver(stubbed.getInputDriver());
        obj.setOutputDriver(stubbed.getOutputDriver());
        obj.setLocation(stubbed.getLocation());
        obj.setProperties(stubbed.getProperties());
    }

    private final List<NameValue> findProperties(PsiElement el) {
        List properties;
        block1: {
            properties = new ArrayList();
            SqlSetAssignment[] sqlSetAssignmentArray = (SqlSetAssignment[])PsiTreeUtil.getChildrenOfType((PsiElement)el, SqlSetAssignment.class);
            if (sqlSetAssignmentArray == null) break block1;
            SqlSetAssignment[] $this$forEach$iv = sqlSetAssignmentArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                String value;
                SqlSetAssignment element$iv;
                SqlSetAssignment prop = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                SqlElement sqlElement = prop.getLValue();
                SqlStringLiteralExpression sqlStringLiteralExpression = sqlElement instanceof SqlStringLiteralExpression ? (SqlStringLiteralExpression)sqlElement : null;
                String key = sqlStringLiteralExpression != null ? sqlStringLiteralExpression.getValue() : null;
                SqlElement sqlElement2 = prop.getRValue();
                SqlStringLiteralExpression sqlStringLiteralExpression2 = sqlElement2 instanceof SqlStringLiteralExpression ? (SqlStringLiteralExpression)sqlElement2 : null;
                String string = value = sqlStringLiteralExpression2 != null ? sqlStringLiteralExpression2.getValue() : null;
                if (key == null || value == null || HiveIntrospector.Companion.getIGNORED_PROPERTIES().contains(key)) continue;
                properties.add(new NameValue(key, value));
            }
        }
        return properties;
    }

    private final void forEachColumnDef(PsiElement el, Function1<? super SqlColumnDefinition, Unit> action) {
        block1: {
            SqlColumnDefinition[] sqlColumnDefinitionArray = (SqlColumnDefinition[])PsiTreeUtil.getChildrenOfType((PsiElement)el, SqlColumnDefinition.class);
            if (sqlColumnDefinitionArray == null) break block1;
            SqlColumnDefinition[] $this$forEach$iv = sqlColumnDefinitionArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                SqlColumnDefinition element$iv;
                SqlColumnDefinition c = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)c);
                action.invoke((Object)c);
            }
        }
    }

    private final void forEachColumnRef(PsiElement el, Function1<? super SqlReferenceExpression, Unit> action) {
        SqlReferenceList refList = (SqlReferenceList)PsiTreeUtil.getChildOfType((PsiElement)el, SqlReferenceList.class);
        if (refList == null) {
            return;
        }
        for (SqlReferenceExpression ref : refList.getReferenceList()) {
            Intrinsics.checkNotNull((Object)ref);
            action.invoke((Object)ref);
        }
    }

    private final String findAndUnescapeString(PsiElement source) {
        SqlCompositeElementType sqlCompositeElementType = SqlElementTypes.SQL_STRING_LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_STRING_LITERAL");
        PsiElement psiElement = this.findSibling(source, (IElementType)sqlCompositeElementType);
        SqlStringLiteralExpressionImpl sqlStringLiteralExpressionImpl = psiElement instanceof SqlStringLiteralExpressionImpl ? (SqlStringLiteralExpressionImpl)psiElement : null;
        if (sqlStringLiteralExpressionImpl == null) {
            return null;
        }
        SqlStringLiteralExpressionImpl stringLiteral = sqlStringLiteralExpressionImpl;
        return StringUtil.unescapeChar((String)StringUtil.unescapeChar((String)StringUtil.unquoteString((String)stringLiteral.getText()), (char)'\"'), (char)'\'');
    }

    /*
     * WARNING - void declaration
     */
    private final void buildSchema(HiveSchema obj, DasObject source, SqlObjectBuilder.Context context) {
        HiveSchema stubbed;
        BasicElement basicElement;
        if (!context.isIntrospector()) {
            super.buildNamespace((BasicModNamespace)obj, source, context);
        }
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof HiveSchema) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof HiveSchema)) {
                object = null;
            }
            basicElement = (BasicElement)((HiveSchema)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (HiveSchema)basicElement) != null) {
            obj.setOwnerRef(stubbed.getOwnerRef());
            obj.setProperties(stubbed.getProperties());
            obj.setLocation(stubbed.getLocation());
            obj.setComment(stubbed.getComment());
        } else {
            void this_$iv;
            List<NameValue> properties = null;
            properties = CollectionsKt.emptyList();
            String location = null;
            String comment = null;
            dasObject = this;
            PsiElement el$iv = (PsiElement)(source instanceof SqlCreateStatement ? (SqlCreateStatement)source : null);
            boolean $i$f$forEachChild = false;
            void var11_12 = this_$iv;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                IElementType iElementType;
                PsiElement el = tmp$iv$iv;
                boolean bl = false;
                PsiElement psiElement2 = el.getFirstChild();
                Object object = iElementType = psiElement2 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement2) : null;
                if (Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_DBPROPERTIES)) {
                    properties = this.findProperties(el);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_LOCATION)) {
                    PsiElement psiElement3 = el.getFirstChild();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getFirstChild(...)");
                    location = this.findAndUnescapeString(psiElement3);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_COMMENT)) continue;
                PsiElement psiElement4 = el.getFirstChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"getFirstChild(...)");
                comment = this.findAndUnescapeString(psiElement4);
            }
            obj.setOwnerRef(null);
            obj.setProperties(properties);
            obj.setLocation(location);
            obj.setComment(comment);
        }
    }

    private static final CompositeText buildMatView$lambda$0(HiveObjectBuilder this$0, DasObject $source) {
        return (CompositeText)this$0.getViewQuery($source, CompositeText.Kind.ORIGINAL_TEXT);
    }

    private static final Unit buildLikeColumn$lambda$1$0(HiveLikeColumn $obj, Ref.ObjectRef $type, SqlColumnDefinition c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (StringsKt.equals((String)c.getName(), (String)((HiveTableColumn)$obj).getName(), (boolean)true)) {
            $type.element = HiveTableColumnType.PARTITIONING;
        }
        return Unit.INSTANCE;
    }

    private static final Unit buildLikeColumn$lambda$1$1(HiveLikeColumn $obj, Ref.ObjectRef $type, SqlReferenceExpression c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (StringsKt.equals((String)c.getName(), (String)((HiveTableColumn)$obj).getName(), (boolean)true)) {
            $type.element = HiveTableColumnType.CLUSTERING;
        }
        return Unit.INSTANCE;
    }

    private static final Unit buildLikeColumn$lambda$1$2$0(HiveLikeColumn $obj, Ref.ObjectRef $sorting, SqlReferenceExpression ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        if (StringsKt.equals((String)ref.getName(), (String)((HiveTableColumn)$obj).getName(), (boolean)true)) {
            PsiElement psiElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)((PsiElement)ref));
            HiveTableColumnSortingOrder s = Intrinsics.areEqual((Object)(psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null), (Object)HiveTypes.HIVE_DESC) ? HiveTableColumnSortingOrder.DESC : HiveTableColumnSortingOrder.ASC;
            $sorting.element = s;
        }
        return Unit.INSTANCE;
    }
}

