/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public final class GroovyResultOfObjectAllocationIgnoredInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.result.of.new.ref.is.ignored", args[0].equals(0) ? "()" : "[]");
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitNewExpression(@NotNull GrNewExpression newExpression) {
            if (newExpression == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitNewExpression(newExpression);
            GrCodeReferenceElement refElement = newExpression.getReferenceElement();
            if (refElement == null) {
                return;
            }
            PsiElement parent = newExpression.getParent();
            if (parent instanceof GrCodeBlock || parent instanceof GroovyFile) {
                if ((parent instanceof GrOpenBlock || parent instanceof GrClosableBlock) && ControlFlowUtils.openBlockCompletesWithStatement((GrCodeBlock)parent, newExpression)) {
                    return;
                }
                this.registerError((PsiElement)refElement, newExpression.getArrayCount());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyResultOfObjectAllocationIgnoredInspection$Visitor", "visitNewExpression"));
        }
    }
}

