/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.project.Project;
import com.intellij.spring.SpringApiBundle;
import org.jetbrains.annotations.NonNls;

public enum SpringSchemaVersion {
    SPRING_1_DTD(SpringApiBundle.message("create.spring.context.file.dtd.1.0", new Object[0]), "http://www.springframework.org/dtd/spring-beans.dtd", "spring-beans.1_0.xml"),
    SPRING_2_DTD(SpringApiBundle.message("create.spring.context.file.dtd.2.0", new Object[0]), "http://www.springframework.org/dtd/spring-beans-2.0.dtd", "spring-beans.2_0.xml"),
    SPRING_SCHEMA(SpringApiBundle.message("create.spring.context.file.schema.2.0", new Object[0]), "http://www.springframework.org/schema/beans", "spring-beans.schema.xml");

    private final String myName;
    private final String myNamespace;
    private final String myTemplateName;

    private SpringSchemaVersion(@NonNls String name, String namespace, String templateName) {
        this.myName = name;
        this.myNamespace = namespace;
        this.myTemplateName = templateName;
    }

    public String getName() {
        return this.myName;
    }

    public String getTemplateName() {
        return this.myTemplateName;
    }

    public FileTemplate getTemplate(Project project) {
        return FileTemplateManager.getInstance((Project)project).getJ2eeTemplate(this.myTemplateName);
    }

    public String getNamespace() {
        return this.myNamespace;
    }

    public String toString() {
        return this.getName();
    }
}

