/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.run;

import com.intellij.execution.Executor;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.application.JvmMainMethodRunConfigurationOptions;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.vmOptions.VMOption;
import com.intellij.ktor.KtorLibraryUtilKt;
import com.intellij.ktor.configurations.common.KtorPropertySearcherService;
import com.intellij.ktor.configurations.common.property.KtorCommonProperty;
import com.intellij.ktor.run.KtorCommandLineState;
import com.intellij.ktor.run.KtorRunConfigurationBean;
import com.intellij.ktor.run.KtorRunConfigurationFragmentEditor;
import com.intellij.ktor.run.KtorRunConfigurationOptions;
import com.intellij.ktor.run.options.completion.OptionsUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000bH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016R$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006%"}, d2={"Lcom/intellij/ktor/run/KtorRunConfiguration;", "Lcom/intellij/execution/application/ApplicationConfiguration;", "name", "", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;)V", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/execution/configurations/RunConfiguration;", "suggestedName", "getOptions", "Lcom/intellij/ktor/run/KtorRunConfigurationOptions;", "value", "", "ktorDevelopmentMode", "getKtorDevelopmentMode", "()Z", "setKtorDevelopmentMode", "(Z)V", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getKnownVMOptions", "", "Lcom/intellij/execution/vmOptions/VMOption;", "readExternal", "", "element", "Lorg/jdom/Element;", "writeExternal", "intellij.ktor"})
@SourceDebugExtension(value={"SMAP\nKtorRunConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorRunConfiguration.kt\ncom/intellij/ktor/run/KtorRunConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n1#2:127\n*E\n"})
public final class KtorRunConfiguration
extends ApplicationConfiguration {
    public KtorRunConfiguration(@NotNull String name, @NotNull Project project, @NotNull ConfigurationFactory factory) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        super(name, project, factory);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditor settingsEditor;
        if (Registry.Companion.is("ide.new.run.config", true)) {
            settingsEditor = (SettingsEditor)new KtorRunConfigurationFragmentEditor(this);
        } else {
            SettingsEditor settingsEditor2 = super.getConfigurationEditor();
            settingsEditor = settingsEditor2;
            Intrinsics.checkNotNullExpressionValue((Object)settingsEditor2, (String)"getConfigurationEditor(...)");
        }
        return settingsEditor;
    }

    @Nullable
    public String suggestedName() {
        String string;
        String string2 = this.getOptions().getMainClassName();
        if (string2 != null) {
            String p0 = string2;
            boolean bl = false;
            string = JavaExecutionUtil.getPresentableClassName((String)p0);
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    protected KtorRunConfigurationOptions getOptions() {
        JvmMainMethodRunConfigurationOptions jvmMainMethodRunConfigurationOptions = super.getOptions();
        Intrinsics.checkNotNull((Object)jvmMainMethodRunConfigurationOptions, (String)"null cannot be cast to non-null type com.intellij.ktor.run.KtorRunConfigurationOptions");
        return (KtorRunConfigurationOptions)jvmMainMethodRunConfigurationOptions;
    }

    public final boolean getKtorDevelopmentMode() {
        return this.getOptions().getKtorDevelopmentMode();
    }

    public final void setKtorDevelopmentMode(boolean value) {
        this.getOptions().setKtorDevelopmentMode(value);
    }

    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        KtorCommandLineState state = new KtorCommandLineState(this, env);
        JavaRunConfigurationModule module = (JavaRunConfigurationModule)this.getConfigurationModule();
        state.setConsoleBuilder(TextConsoleBuilderFactory.getInstance().createBuilder(this.getProject(), module.getSearchScope()));
        return (RunProfileState)state;
    }

    @NotNull
    public List<VMOption> getKnownVMOptions() {
        List baseOptions = super.getKnownVMOptions();
        Module module = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        if (module == null || !KtorLibraryUtilKt.hasKtorConfiguration(module)) {
            Intrinsics.checkNotNull((Object)baseOptions);
            return baseOptions;
        }
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtorPropertySearcherService propertySearcherService = KtorPropertySearcherService.Companion.getInstance(project);
        Sequence options = SequencesKt.map(propertySearcherService.getUniqKeys(module), KtorRunConfiguration::getKnownVMOptions$lambda$0);
        Intrinsics.checkNotNull((Object)baseOptions);
        return CollectionsKt.plus((Collection)baseOptions, (Sequence)options);
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.readExternal(element);
        KtorRunConfigurationBean config = new KtorRunConfigurationBean(null, null, null, null, false, null, false, false, null, 511, null);
        XmlSerializer.deserializeInto((Object)config, (Element)element);
        KtorRunConfigurationBean.Companion.syncOldState(config, this);
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.writeExternal(element);
        KtorRunConfigurationBean config = KtorRunConfigurationBean.Companion.toBean(this);
        XmlSerializer.serializeInto((Object)config, (Element)element);
    }

    private static final VMOption getKnownVMOptions$lambda$0(KtorCommonProperty it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return OptionsUtilsKt.toVmOptions(it);
    }
}

