/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.roles;

import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceListener;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.util.xml.ElementPresentationManager;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class PersistenceClassRoleImpl
implements PersistenceClassRole {
    private final PersistenceClassRoleEnum myType;
    private final PersistenceListener myEntityListener;
    private final PersistenceFacet myFacet;
    private final PersistentObject myObject;
    private final PersistencePackage myUnit;

    public PersistenceClassRoleImpl(PersistenceClassRoleEnum type, PersistenceFacet facet, PersistencePackage unit, PersistentObject object) {
        this.myFacet = facet;
        this.myUnit = unit;
        this.myType = type;
        this.myObject = object;
        this.myEntityListener = null;
    }

    public PersistenceClassRoleImpl(PersistenceClassRoleEnum type, PersistenceFacet facet, PersistencePackage unit, PersistenceListener entityListener) {
        this.myFacet = facet;
        this.myUnit = unit;
        this.myType = type;
        this.myEntityListener = entityListener;
        this.myObject = null;
    }

    @Override
    public PersistenceClassRoleEnum getType() {
        return this.myType;
    }

    @Override
    public String getTitle() {
        return ElementPresentationManager.getTypeNameForObject((Object)(this.myObject == null ? this.myEntityListener : this.myObject));
    }

    @Override
    public Icon getIcon() {
        return ElementPresentationManager.getIcon((Object)(this.myObject == null ? this.myEntityListener : this.myObject));
    }

    @Override
    public PersistenceFacet getFacet() {
        return this.myFacet;
    }

    @Override
    public PersistencePackage getPersistenceUnit() {
        return this.myUnit;
    }

    @Override
    @Nullable
    public PersistentObject getPersistentObject() {
        return this.myObject;
    }

    @Override
    @Nullable
    public PersistenceListener getEntityListener() {
        return this.myEntityListener;
    }
}

